/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXPanel;

public class JXImagePanel
extends JXPanel {
    private static final Logger LOG = Logger.getLogger(JXImagePanel.class.getName());
    private static final String TEXT = "<html><i><b>Click here<br>to set the image</b></i></html>";
    private Image img;
    private boolean editable = false;
    private MouseHandler mhandler = new MouseHandler();
    private Dimension preferredSize;
    private Style style = Style.CENTERED;

    public JXImagePanel() {
    }

    public JXImagePanel(URL imageUrl) {
        try {
            this.setImage(ImageIO.read(imageUrl));
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "", e);
        }
    }

    public void setImage(Image image) {
        if (image != this.img) {
            Image oldImage = this.img;
            this.img = image;
            this.firePropertyChange("image", oldImage, this.img);
            this.invalidate();
            this.repaint();
        }
    }

    public Image getImage() {
        return this.img;
    }

    public void setEditable(boolean editable) {
        if (editable != this.editable) {
            if (this.editable) {
                this.removeMouseListener(this.mhandler);
            }
            this.editable = editable;
            if (this.editable) {
                this.addMouseListener(this.mhandler);
            }
            this.setToolTipText(editable ? TEXT : "");
            this.firePropertyChange("editable", !editable, editable);
            this.repaint();
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setStyle(Style s) {
        if (this.style != s) {
            Style oldStyle = this.style;
            this.style = s;
            this.firePropertyChange("style", (Object)oldStyle, (Object)s);
            this.repaint();
        }
    }

    public Style getStyle() {
        return this.style;
    }

    public void setPreferredSize(Dimension pref) {
        this.preferredSize = pref;
        super.setPreferredSize(pref);
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize == null && this.img != null) {
            int width = this.img.getWidth(null);
            int height = this.img.getHeight(null);
            if (width == -1 || height == -1) {
                return super.getPreferredSize();
            }
            return new Dimension(width, height);
        }
        return super.getPreferredSize();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.img != null) {
            int imgWidth = this.img.getWidth(null);
            int imgHeight = this.img.getHeight(null);
            if (imgWidth == -1 || imgHeight == -1) {
                return;
            }
            Insets insets = this.getInsets();
            int pw = this.getWidth() - insets.left - insets.right;
            int ph = this.getHeight() - insets.top - insets.bottom;
            switch (this.style) {
                case CENTERED: {
                    Rectangle clipRect = g2.getClipBounds();
                    int imageX = (pw - imgWidth) / 2 + insets.left;
                    int imageY = (ph - imgHeight) / 2 + insets.top;
                    Rectangle r = SwingUtilities.computeIntersection(imageX, imageY, imgWidth, imgHeight, clipRect);
                    if (r.x == 0 && r.y == 0 && (r.width == 0 || r.height == 0)) {
                        return;
                    }
                    clipRect = r;
                    int txClipX = clipRect.x - imageX;
                    int txClipY = clipRect.y - imageY;
                    int txClipW = clipRect.width;
                    int txClipH = clipRect.height;
                    g2.drawImage(this.img, clipRect.x, clipRect.y, clipRect.x + clipRect.width, clipRect.y + clipRect.height, txClipX, txClipY, txClipX + txClipW, txClipY + txClipH, null);
                    break;
                }
                case TILED: 
                case SCALED: {
                    g2.drawImage(this.img, insets.left, insets.top, pw, ph, null);
                    break;
                }
                case SCALED_KEEP_ASPECT_RATIO: {
                    int h;
                    float ratio;
                    int w;
                    if (imgWidth - pw > imgHeight - ph) {
                        w = pw;
                        ratio = (float)w / (float)imgWidth;
                        h = (int)((float)imgHeight * ratio);
                    } else {
                        h = ph;
                        ratio = (float)h / (float)imgHeight;
                        w = (int)((float)imgWidth * ratio);
                    }
                    int x = (pw - w) / 2 + insets.left;
                    int y = (ph - h) / 2 + insets.top;
                    g2.drawImage(this.img, x, y, w, h, null);
                    break;
                }
                default: {
                    LOG.fine("unimplemented");
                    g2.drawImage(this.img, insets.left, insets.top, this);
                }
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private Cursor oldCursor;
        private JFileChooser chooser;

        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            int retVal;
            if (this.chooser == null) {
                this.chooser = new JFileChooser();
            }
            if ((retVal = this.chooser.showOpenDialog(JXImagePanel.this)) == 0) {
                File file = this.chooser.getSelectedFile();
                try {
                    JXImagePanel.this.setImage(new ImageIcon(file.toURI().toURL()).getImage());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }

        public void mouseEntered(MouseEvent evt) {
            if (this.oldCursor == null) {
                this.oldCursor = JXImagePanel.this.getCursor();
                JXImagePanel.this.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        public void mouseExited(MouseEvent evt) {
            if (this.oldCursor != null) {
                JXImagePanel.this.setCursor(this.oldCursor);
                this.oldCursor = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        CENTERED,
        TILED,
        SCALED,
        SCALED_KEEP_ASPECT_RATIO;

    }
}

