/*
 * Decompiled with CFR 0.152.
 */
package tr.view.contexts;

import java.awt.EventQueue;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.appl.InitialAction;
import tr.model.Data;
import tr.model.DataLookup;
import tr.view.WindowUtils;
import tr.view.contexts.screen.ContextsTopComponent;

public class ContextsAction
extends CallableSystemAction
implements InitialAction {
    public ContextsAction() {
        this.enableDisable();
        Lookup.Result r = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        r.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                ContextsAction.this.enableDisable();
            }
        });
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ContextsAction");
    }

    protected String iconResource() {
        return "au/com/thinkingrock/tr/resource/icons/Context.png";
    }

    private void enableDisable() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        this.setEnabled(data != null);
    }

    public String getID() {
        return "contexts";
    }

    public void performAction() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Data data = (Data)DataLookup.instance().lookup(Data.class);
                if (data == null) {
                    return;
                }
                WindowUtils.closeWindows();
                ContextsTopComponent tc = ContextsTopComponent.findInstance();
                Mode mode = WindowManager.getDefault().findMode("Setup");
                if (mode != null) {
                    mode.dockInto((TopComponent)tc);
                }
                tc.open();
                tc.requestActive();
            }
        });
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.contexts");
    }
}

