/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.util.Date;
import java.util.TimeZone;
import net.fortuna.ical4j.model.Iso8601;
import net.fortuna.ical4j.util.TimeZones;

public class Time
extends Iso8601 {
    private static final long serialVersionUID = -8401010870773304348L;
    private static final String DEFAULT_PATTERN = "HHmmss";
    private static final String UTC_PATTERN = "HHmmss'Z'";

    public Time(TimeZone timezone) {
        super(TimeZones.isUtc(timezone) ? UTC_PATTERN : DEFAULT_PATTERN, 0);
        this.getFormat().setTimeZone(timezone);
    }

    public Time(long time, TimeZone timezone) {
        super(time, TimeZones.isUtc(timezone) ? UTC_PATTERN : DEFAULT_PATTERN, 0);
        this.getFormat().setTimeZone(timezone);
    }

    public Time(Date time, TimeZone timezone) {
        super(time.getTime(), TimeZones.isUtc(timezone) ? UTC_PATTERN : DEFAULT_PATTERN, 0);
        this.getFormat().setTimeZone(timezone);
    }

    public final boolean isUtc() {
        return TimeZones.isUtc(this.getFormat().getTimeZone());
    }
}

