/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.content;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.w3c.dom.Element;
import writer2latex.latex.Context;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.util.Config;
import writer2latex.util.ExportNameCollection;

public class FieldConverter
extends ConverterHelper {
    private ExportNameCollection targets = new ExportNameCollection(true);
    private ExportNameCollection refnames = new ExportNameCollection(true);
    private ExportNameCollection bookmarknames = new ExportNameCollection(true);
    private ExportNameCollection seqrefnames = new ExportNameCollection(true);
    private boolean bUsesPageCount = false;

    public FieldConverter(Config config, ConverterPalette converterPalette) {
        super(config, converterPalette);
    }

    public void appendDeclarations(LaTeXDocumentPortion laTeXDocumentPortion, LaTeXDocumentPortion laTeXDocumentPortion2) {
        if (this.bUsesPageCount) {
            laTeXDocumentPortion.append("\\usepackage{lastpage}").nl();
        }
        if (this.config.useHyperref()) {
            laTeXDocumentPortion.append("\\usepackage{hyperref}").nl();
            laTeXDocumentPortion.append("\\hypersetup{");
            if (this.config.getBackend() == 2) {
                laTeXDocumentPortion.append("pdftex, ");
            } else if (this.config.getBackend() == 1) {
                laTeXDocumentPortion.append("dvips, ");
            }
            laTeXDocumentPortion.append("colorlinks=true, linkcolor=blue, filecolor=blue, pagecolor=blue, urlcolor=blue");
            if (this.config.getBackend() == 2) {
                laTeXDocumentPortion.append(this.createPdfMeta("pdftitle", this.palette.getMetaData().getTitle())).append(this.createPdfMeta("pdfauthor", this.palette.getMetaData().getCreator())).append(this.createPdfMeta("pdfsubject", this.palette.getMetaData().getSubject())).append(this.createPdfMeta("pdfkeywords", this.palette.getMetaData().getKeywords()));
            }
            laTeXDocumentPortion.append("}").nl();
        }
    }

    public void addSequenceName(String string) {
        this.seqrefnames.addName(this.urlDecode(string));
    }

    public void handleSequence(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        this.palette.getInlineCv().traversePCDATA(element, laTeXDocumentPortion, context);
        String string = element.getAttribute("text:ref-name");
        if (string != null && this.seqrefnames.containsName(string)) {
            laTeXDocumentPortion.append("\\label{seq:" + this.seqrefnames.getExportName(string) + "}");
        }
    }

    public void handleSequenceRef(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        String string = element.getAttribute("text:reference-format");
        String string2 = element.getAttribute("text:ref-name");
        if ("page".equals(string) && string2 != null) {
            laTeXDocumentPortion.append("\\pageref{seq:" + this.seqrefnames.getExportName(string2) + "}");
        } else {
            this.palette.getInlineCv().traversePCDATA(element, laTeXDocumentPortion, context);
        }
    }

    public void addReferenceName(String string) {
        this.refnames.addName(this.urlDecode(string));
    }

    public void handleReferenceMark(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        String string = element.getAttribute("text:name");
        if (string != null) {
            laTeXDocumentPortion.append("\\label{ref:" + this.refnames.getExportName(string) + "}");
        }
    }

    public void handleReferenceRef(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        String string = element.getAttribute("text:reference-format");
        String string2 = element.getAttribute("text:ref-name");
        if ("page".equals(string) && string2 != null) {
            laTeXDocumentPortion.append("\\pageref{ref:" + this.refnames.getExportName(string2) + "}");
        } else {
            this.palette.getInlineCv().traversePCDATA(element, laTeXDocumentPortion, context);
        }
    }

    public void addBookmarkName(String string) {
        this.bookmarknames.addName(this.urlDecode(string));
    }

    public void handleBookmark(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        String string = element.getAttribute("text:name");
        if (string != null) {
            this.addTarget(element, "", laTeXDocumentPortion);
            if (this.bookmarknames.containsName(string)) {
                laTeXDocumentPortion.append("\\label{bkm:" + this.bookmarknames.getExportName(string) + "}");
            }
        }
    }

    public void handleBookmarkRef(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        String string = element.getAttribute("text:reference-format");
        String string2 = element.getAttribute("text:ref-name");
        if ("page".equals(string) && string2 != null) {
            laTeXDocumentPortion.append("\\pageref{bkm:" + this.bookmarknames.getExportName(string2) + "}");
        } else {
            this.palette.getInlineCv().traversePCDATA(element, laTeXDocumentPortion, context);
        }
    }

    public void handleAnchor(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        String string = element.getAttribute("xlink:href");
        if (string != null) {
            if (string.startsWith("#")) {
                if (this.config.useHyperref()) {
                    laTeXDocumentPortion.append("\\hyperlink{").append(this.targets.getExportName(this.urlDecode(string.substring(1)))).append("}{");
                    this.palette.getInlineCv().traverseInlineText(element, laTeXDocumentPortion, context, false);
                    laTeXDocumentPortion.append("}");
                } else {
                    this.palette.getInlineCv().traverseInlineText(element, laTeXDocumentPortion, context, true);
                }
            } else if (this.config.useHyperref()) {
                laTeXDocumentPortion.append("\\href{").append(this.urlDecode(string)).append("}{");
                this.palette.getInlineCv().traverseInlineText(element, laTeXDocumentPortion, context, false);
                laTeXDocumentPortion.append("}");
            } else {
                this.palette.getInlineCv().traverseInlineText(element, laTeXDocumentPortion, context, true);
            }
        } else {
            this.palette.getInlineCv().traverseInlineText(element, laTeXDocumentPortion, context, true);
        }
    }

    public void addTargetName(String string) {
        this.targets.addName(this.urlDecode(string));
    }

    public void addTarget(Element element, String string, LaTeXDocumentPortion laTeXDocumentPortion) {
        String string2 = element.getAttribute("text:name");
        if (string2 == null) {
            string2 = element.getAttribute("table:name");
        }
        if (string2 == null || !this.config.useHyperref()) {
            return;
        }
        if (!this.targets.containsName(string2 + string)) {
            return;
        }
        laTeXDocumentPortion.append("\\hypertarget{").append(this.targets.getExportName(string2 + string)).append("}{}");
    }

    public void handlePageNumber(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        laTeXDocumentPortion.append("\\thepage{}");
    }

    public void handlePageCount(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        if (this.config.useLastpage()) {
            this.bUsesPageCount = true;
            laTeXDocumentPortion.append("\\pageref{LastPage}");
        } else {
            laTeXDocumentPortion.append("?");
        }
    }

    private String createPdfMeta(String string, String string2) {
        if (string2 == null) {
            return "";
        }
        string2 = string2.replace(',', ';');
        return ", " + string + "=" + this.palette.getI18n().convert(string2, false, this.palette.getMainContext().getLang());
    }

    private String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }
}

