/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.optimizer.Codegen;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptLocalVariable;

class BodyCodegen {
    private final int JAVASCRIPT_EXCEPTION = 0;
    private final int EVALUATOR_EXCEPTION = 1;
    private final int ECMAERROR_EXCEPTION = 2;
    ClassFileWriter cfw;
    Codegen codegen;
    CompilerEnvirons compilerEnv;
    ScriptOrFnNode scriptOrFn;
    private OptFunctionNode fnCurrent;
    private boolean isTopLevel;
    private static final int MAX_LOCALS = 256;
    private boolean[] locals;
    private short firstFreeLocal;
    private short localsMax;
    private OptLocalVariable[] debugVars;
    private int itsLineNumber;
    private boolean hasVarsInRegs;
    private boolean inDirectCallFunction;
    private boolean itsForcedObjectParameters;
    private int epilogueLabel;
    private short variableObjectLocal;
    private short popvLocal;
    private short contextLocal;
    private short argsLocal;
    private short thisObjLocal;
    private short funObjLocal;
    private short itsZeroArgArray;
    private short itsOneArgArray;
    private short scriptRegexpLocal;

    BodyCodegen() {
    }

    void generateBodyCode() {
        this.initBodyGeneration();
        this.cfw.startMethod(this.codegen.getBodyMethodName(this.scriptOrFn), this.codegen.getBodyMethodSignature(this.scriptOrFn), (short)10);
        this.generatePrologue();
        Node node = this.fnCurrent != null ? this.scriptOrFn.getLastChild() : this.scriptOrFn;
        this.generateCodeFromNode(node, null);
        this.generateEpilogue();
        this.cfw.stopMethod((short)(this.localsMax + 1), this.debugVars);
    }

    private void initBodyGeneration() {
        this.fnCurrent = this.scriptOrFn.getType() == 87 ? OptFunctionNode.get(this.scriptOrFn) : null;
        this.isTopLevel = this.scriptOrFn == this.codegen.scriptOrFnNodes[0];
        this.inDirectCallFunction = this.fnCurrent == null ? false : this.fnCurrent.isTargetOfDirectCall();
        this.hasVarsInRegs = this.fnCurrent != null && !this.fnCurrent.fnode.requiresActivation();
        this.locals = new boolean[256];
        this.funObjLocal = 0;
        this.contextLocal = 1;
        this.variableObjectLocal = (short)2;
        this.thisObjLocal = (short)3;
        this.localsMax = (short)4;
        this.firstFreeLocal = (short)4;
        this.popvLocal = (short)-1;
        this.argsLocal = (short)-1;
        this.itsZeroArgArray = (short)-1;
        this.itsOneArgArray = (short)-1;
        this.scriptRegexpLocal = (short)-1;
        this.epilogueLabel = -1;
    }

    private void generatePrologue() {
        String string;
        int n;
        int n2;
        int n3 = -1;
        if (this.inDirectCallFunction) {
            OptLocalVariable optLocalVariable;
            n3 = this.scriptOrFn.getParamCount();
            n2 = 4;
            for (n = 0; n != n3; ++n) {
                optLocalVariable = this.fnCurrent.getVar(n);
                optLocalVariable.assignJRegister((short)n2);
                n2 = (short)(n2 + 3);
            }
            if (!this.fnCurrent.getParameterNumberContext()) {
                this.itsForcedObjectParameters = true;
                for (n = 0; n != n3; ++n) {
                    optLocalVariable = this.fnCurrent.getVar(n);
                    this.cfw.addALoad(optLocalVariable.getJRegister());
                    this.cfw.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int n4 = this.cfw.acquireLabel();
                    this.cfw.add((byte)-90, n4);
                    this.cfw.addDLoad(optLocalVariable.getJRegister() + 1);
                    this.addDoubleWrap();
                    this.cfw.addAStore(optLocalVariable.getJRegister());
                    this.cfw.markLabel(n4);
                }
            }
        }
        if (this.fnCurrent != null && n3 == -1 && (!this.compilerEnv.isUseDynamicScope() || this.fnCurrent.fnode.getIgnoreDynamicScope())) {
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addInvoke((byte)-71, "org/mozilla/javascript/Scriptable", "getParentScope", "()Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.variableObjectLocal);
        }
        if (n3 > 0) {
            for (n2 = 0; n2 < 3 * n3; ++n2) {
                this.reserveWordLocal(n2 + 4);
            }
        }
        this.argsLocal = this.reserveWordLocal(n3 <= 0 ? 4 : 3 * n3 + 4);
        if (this.fnCurrent == null && this.scriptOrFn.getRegexpCount() != 0) {
            this.scriptRegexpLocal = this.getNewWordLocal();
            this.codegen.pushRegExpArray(this.cfw, this.scriptOrFn, this.contextLocal, this.variableObjectLocal);
            this.cfw.addAStore(this.scriptRegexpLocal);
        }
        if (this.fnCurrent != null && this.fnCurrent.fnode.getCheckThis()) {
            this.cfw.addALoad(this.thisObjLocal);
            this.addScriptRuntimeInvoke("getThis", "(Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.thisObjLocal);
        }
        if (this.hasVarsInRegs) {
            n2 = this.scriptOrFn.getParamCount();
            if (n2 > 0 && n3 < 0) {
                this.cfw.addALoad(this.argsLocal);
                this.cfw.add((byte)-66);
                this.cfw.addPush(n2);
                n = this.cfw.acquireLabel();
                this.cfw.add((byte)-94, n);
                this.cfw.addALoad(this.argsLocal);
                this.cfw.addPush(n2);
                this.addScriptRuntimeInvoke("padArguments", "([Ljava/lang/Object;I)[Ljava/lang/Object;");
                this.cfw.addAStore(this.argsLocal);
                this.cfw.markLabel(n);
            }
            n = -1;
            for (int i = 0; i < this.fnCurrent.getVarCount(); ++i) {
                OptLocalVariable optLocalVariable = this.fnCurrent.getVar(i);
                if (optLocalVariable.isNumber()) {
                    optLocalVariable.assignJRegister(this.getNewWordPairLocal());
                    this.cfw.addPush(0.0);
                    this.cfw.addDStore(optLocalVariable.getJRegister());
                } else if (optLocalVariable.isParameter()) {
                    if (n3 < 0) {
                        optLocalVariable.assignJRegister(this.getNewWordLocal());
                        this.cfw.addALoad(this.argsLocal);
                        this.cfw.addPush(i);
                        this.cfw.add((byte)50);
                        this.cfw.addAStore(optLocalVariable.getJRegister());
                    }
                } else {
                    optLocalVariable.assignJRegister(this.getNewWordLocal());
                    if (n == -1) {
                        Codegen.pushUndefined(this.cfw);
                        n = optLocalVariable.getJRegister();
                    } else {
                        this.cfw.addALoad(n);
                    }
                    this.cfw.addAStore(optLocalVariable.getJRegister());
                }
                optLocalVariable.setStartPC(this.cfw.getCurrentCodeOffset());
            }
            this.debugVars = this.fnCurrent.getVarsArray();
            return;
        }
        if (n3 > 0) {
            this.cfw.addALoad(this.argsLocal);
            this.cfw.addPush(n3);
            this.addOptRuntimeInvoke("padStart", "([Ljava/lang/Object;I)[Ljava/lang/Object;");
            this.cfw.addAStore(this.argsLocal);
            for (n2 = 0; n2 < n3; ++n2) {
                this.cfw.addALoad(this.argsLocal);
                this.cfw.addPush(n2);
                this.cfw.addALoad(3 * n2 + 4);
                this.cfw.add((byte)83);
            }
        }
        if (this.fnCurrent != null) {
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addALoad(this.argsLocal);
            this.addScriptRuntimeInvoke("initVarObj", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.variableObjectLocal);
            string = "activation";
        } else {
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addPush(0);
            this.addScriptRuntimeInvoke("initScript", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;Z)V");
            string = "global";
        }
        n = this.scriptOrFn.getFunctionCount();
        for (int i = 0; i != n; ++i) {
            OptFunctionNode optFunctionNode = OptFunctionNode.get(this.scriptOrFn, i);
            if (optFunctionNode.fnode.getFunctionType() != 1) continue;
            this.visitFunction(optFunctionNode, 1);
        }
        if (this.compilerEnv.isGenerateDebugInfo()) {
            OptLocalVariable optLocalVariable = new OptLocalVariable(string, false);
            optLocalVariable.assignJRegister(this.variableObjectLocal);
            optLocalVariable.setStartPC(this.cfw.getCurrentCodeOffset());
            this.debugVars = new OptLocalVariable[1];
            this.debugVars[0] = optLocalVariable;
        }
        if (this.fnCurrent == null) {
            this.popvLocal = this.getNewWordLocal();
            Codegen.pushUndefined(this.cfw);
            this.cfw.addAStore(this.popvLocal);
            int n5 = this.scriptOrFn.getEndLineno();
            if (n5 != -1) {
                this.cfw.addLineNumberEntry((short)n5);
            }
        } else {
            if (this.fnCurrent.itsContainsCalls0) {
                this.itsZeroArgArray = this.getNewWordLocal();
                this.cfw.add((byte)-78, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
                this.cfw.addAStore(this.itsZeroArgArray);
            }
            if (this.fnCurrent.itsContainsCalls1) {
                this.itsOneArgArray = this.getNewWordLocal();
                this.cfw.addPush(1);
                this.cfw.add((byte)-67, "java/lang/Object");
                this.cfw.addAStore(this.itsOneArgArray);
            }
        }
    }

    private void generateEpilogue() {
        if (this.epilogueLabel != -1) {
            this.cfw.markLabel(this.epilogueLabel);
        }
        if (this.fnCurrent == null || !this.hasVarsInRegs) {
            this.cfw.addALoad(this.contextLocal);
            this.addScriptRuntimeInvoke("popActivation", "(Lorg/mozilla/javascript/Context;)V");
            if (this.fnCurrent == null) {
                this.cfw.addALoad(this.popvLocal);
            }
        }
        this.cfw.add((byte)-80);
    }

    private void generateCodeFromNode(Node node, Node node2) {
        int n = node.getType();
        block0 : switch (n) {
            case 101: 
            case 110: 
            case 112: {
                Node node3;
                this.visitStatement(node);
                for (node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                    this.generateCodeFromNode(node3, node);
                }
                break;
            }
            case 93: 
            case 94: 
            case 106: 
            case 107: 
            case 118: {
                Node node3;
                this.visitStatement(node);
                while (node3 != null) {
                    this.generateCodeFromNode(node3, node);
                    node3 = node3.getNext();
                }
                break;
            }
            case 124: {
                Node node3;
                this.visitStatement(node);
                short s = this.getNewWordLocal();
                node.putIntProp(3, s);
                while (node3 != null) {
                    this.generateCodeFromNode(node3, node);
                    node3 = node3.getNext();
                }
                this.releaseWordLocal(s);
                node.removeProp(3);
                break;
            }
            case 120: {
                break;
            }
            case 87: {
                if (this.fnCurrent == null && node2.getType() == 118) break;
                int n2 = node.getExistingIntProp(1);
                OptFunctionNode optFunctionNode = OptFunctionNode.get(this.scriptOrFn, n2);
                int n3 = optFunctionNode.fnode.getFunctionType();
                if (n3 == 1) break;
                this.visitFunction(optFunctionNode, n3);
                break;
            }
            case 39: {
                this.visitName(node);
                break;
            }
            case 31: 
            case 38: {
                Node node3;
                this.visitCall(node, n, node3);
                break;
            }
            case 40: 
            case 41: {
                this.visitLiteral(node);
                break;
            }
            case 45: {
                this.cfw.addALoad(this.thisObjLocal);
                break;
            }
            case 66: {
                this.cfw.add((byte)42);
                break;
            }
            case 44: {
                this.cfw.add((byte)1);
                break;
            }
            case 47: {
                this.cfw.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                break;
            }
            case 46: {
                this.cfw.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                break;
            }
            case 61: {
                Codegen.pushUndefined(this.cfw);
                break;
            }
            case 50: {
                this.visitRegexp(node);
                break;
            }
            case 69: {
                Node node3;
                this.visitTryCatchFinally((Node.Jump)node, node3);
                break;
            }
            case 53: {
                Node node3;
                this.visitThrow(node, node3);
                break;
            }
            case 67: {
                if (this.fnCurrent == null) {
                    Codegen.badTree();
                }
            }
            case 5: {
                Node node3;
                this.visitStatement(node);
                if (node3 != null) {
                    do {
                        this.generateCodeFromNode(node3, node);
                    } while ((node3 = node3.getNext()) != null);
                } else if (this.fnCurrent != null && n == 5) {
                    Codegen.pushUndefined(this.cfw);
                } else {
                    if (this.popvLocal < 0) {
                        Codegen.badTree();
                    }
                    this.cfw.addALoad(this.popvLocal);
                }
                if (this.epilogueLabel == -1) {
                    this.epilogueLabel = this.cfw.acquireLabel();
                }
                this.cfw.add((byte)-89, this.epilogueLabel);
                break;
            }
            case 92: {
                Node node3;
                this.visitSwitch((Node.Jump)node, node3);
                break;
            }
            case 77: {
                Node node3;
                for (Node node4 = node3.getNext(); node4 != null; node4 = node4.getNext()) {
                    this.generateCodeFromNode(node3, node);
                    this.cfw.add((byte)87);
                    node3 = node4;
                }
                this.generateCodeFromNode(node3, node);
                break;
            }
            case 123: {
                Node node3;
                this.generateCodeFromNode(node3, node);
                while (null != (node3 = node3.getNext())) {
                    this.cfw.add((byte)89);
                    this.generateCodeFromNode(node3, node);
                    this.cfw.add((byte)87);
                }
                break;
            }
            case 62: {
                Node node3;
                this.cfw.addPush(node.getString());
                this.generateCodeFromNode(node3, node);
                this.addScriptRuntimeInvoke("newCatchScope", "(Ljava/lang/String;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
                break;
            }
            case 3: {
                Node node3;
                this.visitEnterWith(node, node3);
                break;
            }
            case 4: {
                Node node3;
                this.visitLeaveWith(node, node3);
                break;
            }
            case 63: {
                Node node3;
                this.generateCodeFromNode(node3, node);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("enumInit", "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
                int n4 = this.getLocalBlockRegister(node);
                this.cfw.addAStore(n4);
                break;
            }
            case 64: 
            case 65: {
                int n5 = this.getLocalBlockRegister(node);
                this.cfw.addALoad(n5);
                if (n == 64) {
                    this.addScriptRuntimeInvoke("enumNext", "(Ljava/lang/Object;)Ljava/lang/Boolean;");
                    break;
                }
                this.addScriptRuntimeInvoke("enumId", "(Ljava/lang/Object;)Ljava/lang/String;");
                break;
            }
            case 51: {
                Node node3;
                this.visitStatement(node);
                if (node3.getType() == 60) {
                    this.visitSetVar(node3, node3.getFirstChild(), false);
                    break;
                }
                while (node3 != null) {
                    this.generateCodeFromNode(node3, node);
                    node3 = node3.getNext();
                }
                if (node.getIntProp(15, -1) != -1) {
                    this.cfw.add((byte)88);
                    break;
                }
                this.cfw.add((byte)87);
                break;
            }
            case 2: {
                Node node3;
                this.visitStatement(node);
                this.generateCodeFromNode(node3, node);
                if (this.popvLocal < 0) {
                    this.popvLocal = this.getNewWordLocal();
                }
                this.cfw.addAStore(this.popvLocal);
                break;
            }
            case 111: {
                this.visitTarget((Node.Target)node);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 115: {
                Node node3;
                this.visitGOTO((Node.Jump)node, n, node3);
                break;
            }
            case 103: {
                Node node3;
                this.visitFinally(node, node3);
                break;
            }
            case 27: {
                Node node3;
                int n6 = this.cfw.acquireLabel();
                int n7 = this.cfw.acquireLabel();
                int n8 = this.cfw.acquireLabel();
                this.generateIfJump(node3, node, n6, n7);
                this.cfw.markLabel(n6);
                this.cfw.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                this.cfw.add((byte)-89, n8);
                this.cfw.markLabel(n7);
                this.cfw.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                this.cfw.markLabel(n8);
                this.cfw.adjustStackTop(-1);
                break;
            }
            case 28: {
                Node node3;
                this.generateCodeFromNode(node3, node);
                this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)I");
                this.cfw.addPush(-1);
                this.cfw.add((byte)-126);
                this.cfw.add((byte)-121);
                this.addDoubleWrap();
                break;
            }
            case 104: {
                Node node3;
                this.generateCodeFromNode(node3, node);
                this.cfw.add((byte)87);
                Codegen.pushUndefined(this.cfw);
                break;
            }
            case 33: {
                Node node3;
                this.generateCodeFromNode(node3, node);
                this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)Ljava/lang/String;");
                break;
            }
            case 119: {
                this.visitTypeofname(node);
                break;
            }
            case 84: {
                this.visitIncDec(node, true);
                break;
            }
            case 85: {
                this.visitIncDec(node, false);
                break;
            }
            case 82: 
            case 83: {
                Node node3;
                this.generateCodeFromNode(node3, node);
                this.cfw.add((byte)89);
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
                int n9 = this.cfw.acquireLabel();
                if (n == 83) {
                    this.cfw.add((byte)-103, n9);
                } else {
                    this.cfw.add((byte)-102, n9);
                }
                this.cfw.add((byte)87);
                this.generateCodeFromNode(node3.getNext(), node);
                this.cfw.markLabel(n9);
                break;
            }
            case 80: {
                Node node3;
                Node node5 = node3.getNext();
                Node node6 = node5.getNext();
                this.generateCodeFromNode(node3, node);
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
                int n10 = this.cfw.acquireLabel();
                this.cfw.add((byte)-103, n10);
                short s = this.cfw.getStackTop();
                this.generateCodeFromNode(node5, node);
                int n11 = this.cfw.acquireLabel();
                this.cfw.add((byte)-89, n11);
                this.cfw.markLabel(n10, s);
                this.generateCodeFromNode(node6, node);
                this.cfw.markLabel(n11);
                break;
            }
            case 22: {
                Node node3;
                this.generateCodeFromNode(node3, node);
                this.generateCodeFromNode(node3.getNext(), node);
                switch (node.getIntProp(15, -1)) {
                    case 0: {
                        this.cfw.add((byte)99);
                        break block0;
                    }
                    case 1: {
                        this.addOptRuntimeInvoke("add", "(DLjava/lang/Object;)Ljava/lang/Object;");
                        break block0;
                    }
                    case 2: {
                        this.addOptRuntimeInvoke("add", "(Ljava/lang/Object;D)Ljava/lang/Object;");
                        break block0;
                    }
                }
                this.addScriptRuntimeInvoke("add", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                break;
            }
            case 24: {
                Node node3;
                this.visitArithmetic(node, (byte)107, node3, node2);
                break;
            }
            case 23: {
                Node node3;
                this.visitArithmetic(node, (byte)103, node3, node2);
                break;
            }
            case 25: 
            case 26: {
                Node node3;
                this.visitArithmetic(node, n == 25 ? (byte)111 : 115, node3, node2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 21: {
                Node node3;
                this.visitBitOp(node, n, node3);
                break;
            }
            case 29: 
            case 30: {
                Node node3;
                this.generateCodeFromNode(node3, node);
                this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)D");
                if (n == 30) {
                    this.cfw.add((byte)119);
                }
                this.addDoubleWrap();
                break;
            }
            case 126: {
                Node node3;
                this.generateCodeFromNode(node3, node);
                this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)D");
                break;
            }
            case 125: {
                Node node3;
                int n12 = -1;
                if (node3.getType() == 40) {
                    n12 = node3.getIntProp(15, -1);
                }
                if (n12 != -1) {
                    node3.removeProp(15);
                    this.generateCodeFromNode(node3, node);
                    node3.putIntProp(15, n12);
                    break;
                }
                this.generateCodeFromNode(node3, node);
                this.addDoubleWrap();
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 54: 
            case 55: {
                Node node3;
                this.visitRelOp(node, node3);
                break;
            }
            case 13: 
            case 14: 
            case 48: 
            case 49: {
                Node node3;
                this.visitEqOp(node, node3);
                break;
            }
            case 34: {
                Node node3;
                this.visitGetProp(node, node3);
                break;
            }
            case 36: {
                Node node3;
                while (node3 != null) {
                    this.generateCodeFromNode(node3, node);
                    node3 = node3.getNext();
                }
                this.cfw.addALoad(this.variableObjectLocal);
                if (node.getIntProp(15, -1) != -1) {
                    this.addOptRuntimeInvoke("getElem", "(Ljava/lang/Object;DLorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
                    break;
                }
                this.addScriptRuntimeInvoke("getElem", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
                break;
            }
            case 59: {
                OptLocalVariable optLocalVariable = (OptLocalVariable)node.getProp(13);
                this.visitGetVar(optLocalVariable, node.getIntProp(15, -1) != -1, node.getString());
                break;
            }
            case 60: {
                Node node3;
                this.visitSetVar(node, node3, true);
                break;
            }
            case 9: {
                Node node3;
                this.visitSetName(node, node3);
                break;
            }
            case 35: 
            case 121: {
                Node node3;
                this.visitSetProp(n, node, node3);
                break;
            }
            case 37: 
            case 122: {
                boolean bl;
                Node node3;
                this.generateCodeFromNode(node3, node);
                node3 = node3.getNext();
                if (n == 122) {
                    this.cfw.add((byte)89);
                }
                this.generateCodeFromNode(node3, node);
                node3 = node3.getNext();
                boolean bl2 = bl = node.getIntProp(15, -1) != -1;
                if (n == 122) {
                    if (bl) {
                        this.cfw.add((byte)93);
                        this.cfw.addALoad(this.variableObjectLocal);
                        this.addOptRuntimeInvoke("getElem", "(Ljava/lang/Object;DLorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
                    } else {
                        this.cfw.add((byte)90);
                        this.cfw.addALoad(this.variableObjectLocal);
                        this.addScriptRuntimeInvoke("getElem", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
                    }
                }
                this.generateCodeFromNode(node3, node);
                this.cfw.addALoad(this.variableObjectLocal);
                if (bl) {
                    this.addOptRuntimeInvoke("setElem", "(Ljava/lang/Object;DLjava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
                    break;
                }
                this.addScriptRuntimeInvoke("setElem", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
                break;
            }
            case 32: {
                Node node3;
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                while (node3 != null) {
                    this.generateCodeFromNode(node3, node);
                    node3 = node3.getNext();
                }
                this.addScriptRuntimeInvoke("delete", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                break;
            }
            case 52: 
            case 58: {
                Node node3;
                this.visitBind(node, n, node3);
                break;
            }
            case 68: {
                Node node3;
                this.generateCodeFromNode(node3, node);
                this.addScriptRuntimeInvoke("getThis", "(Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
                break;
            }
            case 114: {
                Node node3;
                this.generateCodeFromNode(node3, node);
                this.addScriptRuntimeInvoke("getParent", "(Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
                break;
            }
            case 116: {
                Node node3;
                this.visitNewTemp(node, node3);
                break;
            }
            case 117: {
                Node node3;
                this.visitUseTemp(node, node3);
                break;
            }
            case 57: {
                this.cfw.addALoad(this.getLocalBlockRegister(node));
                break;
            }
            default: {
                throw new RuntimeException("Unexpected node type " + n);
            }
        }
    }

    private void generateIfJump(Node node, Node node2, int n, int n2) {
        int n3 = node.getType();
        Node node3 = node.getFirstChild();
        switch (n3) {
            case 27: {
                this.generateIfJump(node3, node, n2, n);
                break;
            }
            case 82: 
            case 83: {
                int n4 = this.cfw.acquireLabel();
                if (n3 == 83) {
                    this.generateIfJump(node3, node, n4, n2);
                } else {
                    this.generateIfJump(node3, node, n, n4);
                }
                this.cfw.markLabel(n4);
                node3 = node3.getNext();
                this.generateIfJump(node3, node, n, n2);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 54: 
            case 55: {
                this.visitIfJumpRelOp(node, node3, n, n2);
                break;
            }
            case 13: 
            case 14: 
            case 48: 
            case 49: {
                this.visitIfJumpEqOp(node, node3, n, n2);
                break;
            }
            default: {
                this.generateCodeFromNode(node, node2);
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
                this.cfw.add((byte)-102, n);
                this.cfw.add((byte)-89, n2);
            }
        }
    }

    private void visitFunction(OptFunctionNode optFunctionNode, int n) {
        int n2 = this.codegen.getIndex(optFunctionNode.fnode);
        this.cfw.add((byte)-69, this.codegen.mainClassName);
        this.cfw.add((byte)89);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addPush(n2);
        this.cfw.addInvoke((byte)-73, this.codegen.mainClassName, "<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;I)V");
        this.cfw.add((byte)89);
        if (this.isTopLevel) {
            this.cfw.add((byte)42);
        } else {
            this.cfw.add((byte)42);
            this.cfw.add((byte)-76, this.codegen.mainClassName, "_dcp", this.codegen.mainClassSignature);
        }
        this.cfw.add((byte)-75, this.codegen.mainClassName, "_dcp", this.codegen.mainClassSignature);
        int n3 = optFunctionNode.getDirectTargetIndex();
        if (n3 >= 0) {
            this.cfw.add((byte)89);
            if (this.isTopLevel) {
                this.cfw.add((byte)42);
            } else {
                this.cfw.add((byte)42);
                this.cfw.add((byte)-76, this.codegen.mainClassName, "_dcp", this.codegen.mainClassSignature);
            }
            this.cfw.add((byte)95);
            this.cfw.add((byte)-75, this.codegen.mainClassName, Codegen.getDirectTargetFieldName(n3), this.codegen.mainClassSignature);
        }
        if (n != 1) {
            this.cfw.add((byte)89);
        }
        this.cfw.addPush(n);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.contextLocal);
        this.addOptRuntimeInvoke("initFunction", "(Lorg/mozilla/javascript/NativeFunction;ILorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)V");
    }

    private void visitTarget(Node.Target target) {
        int n = target.labelId;
        if (n == -1) {
            target.labelId = n = this.cfw.acquireLabel();
        }
        this.cfw.markLabel(n);
    }

    private void visitGOTO(Node.Jump jump, int n, Node node) {
        Node.Target target = jump.target;
        int n2 = target.labelId;
        if (n2 == -1) {
            target.labelId = n2 = this.cfw.acquireLabel();
        }
        int n3 = this.cfw.acquireLabel();
        if (n == 7 || n == 8) {
            if (node == null) {
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
                if (n == 7) {
                    this.cfw.add((byte)-102, n2);
                } else {
                    this.cfw.add((byte)-103, n2);
                }
            } else if (n == 7) {
                this.generateIfJump(node, jump, n2, n3);
            } else {
                this.generateIfJump(node, jump, n3, n2);
            }
        } else {
            while (node != null) {
                this.generateCodeFromNode(node, jump);
                node = node.getNext();
            }
            if (n == 115) {
                this.cfw.add((byte)-88, n2);
            } else {
                this.cfw.add((byte)-89, n2);
            }
        }
        this.cfw.markLabel(n3);
    }

    private void visitFinally(Node node, Node node2) {
        short s = this.getNewWordLocal();
        this.cfw.addAStore(s);
        while (node2 != null) {
            this.generateCodeFromNode(node2, node);
            node2 = node2.getNext();
        }
        this.cfw.add((byte)-87, s);
        this.releaseWordLocal(s);
    }

    private void visitEnterWith(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node);
            node2 = node2.getNext();
        }
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("enterWith", "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
        this.cfw.addAStore(this.variableObjectLocal);
    }

    private void visitLeaveWith(Node node, Node node2) {
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("leaveWith", "(Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
        this.cfw.addAStore(this.variableObjectLocal);
    }

    private void resetTargets(Node node) {
        if (node.getType() == 111) {
            ((Node.Target)node).labelId = -1;
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            this.resetTargets(node2);
        }
    }

    private void visitCall(Node node, int n, Node node2) {
        Node node3 = node2;
        OptFunctionNode optFunctionNode = (OptFunctionNode)node.getProp(16);
        if (optFunctionNode != null) {
            int n2;
            this.generateCodeFromNode(node2, node);
            int n3 = this.cfw.acquireLabel();
            int n4 = optFunctionNode.getDirectTargetIndex();
            if (this.isTopLevel) {
                this.cfw.add((byte)42);
            } else {
                this.cfw.add((byte)42);
                this.cfw.add((byte)-76, this.codegen.mainClassName, "_dcp", this.codegen.mainClassSignature);
            }
            this.cfw.add((byte)-76, this.codegen.mainClassName, Codegen.getDirectTargetFieldName(n4), this.codegen.mainClassSignature);
            short s = this.cfw.getStackTop();
            this.cfw.add((byte)92);
            this.cfw.add((byte)-90, n3);
            this.cfw.add((byte)95);
            this.cfw.add((byte)87);
            if (!this.compilerEnv.isUseDynamicScope()) {
                this.cfw.add((byte)89);
                this.cfw.addInvoke((byte)-71, "org/mozilla/javascript/Scriptable", "getParentScope", "()Lorg/mozilla/javascript/Scriptable;");
            } else {
                this.cfw.addALoad(this.variableObjectLocal);
            }
            this.cfw.addALoad(this.contextLocal);
            this.cfw.add((byte)95);
            if (n == 31) {
                this.cfw.add((byte)1);
            } else {
                node2 = node2.getNext();
                this.generateCodeFromNode(node2, node);
            }
            for (node2 = node2.getNext(); node2 != null; node2 = node2.getNext()) {
                OptLocalVariable optLocalVariable;
                n2 = 0;
                if (node2.getType() == 59 && this.inDirectCallFunction && (optLocalVariable = (OptLocalVariable)node2.getProp(13)) != null && optLocalVariable.isParameter()) {
                    n2 = 1;
                    this.cfw.addALoad(optLocalVariable.getJRegister());
                    this.cfw.addDLoad(optLocalVariable.getJRegister() + 1);
                }
                if (n2 == 0) {
                    int n5 = node2.getIntProp(15, -1);
                    if (n5 == 0) {
                        this.cfw.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        this.generateCodeFromNode(node2, node);
                    } else {
                        this.generateCodeFromNode(node2, node);
                        this.cfw.addPush(0.0);
                    }
                }
                this.resetTargets(node2);
            }
            this.cfw.add((byte)-78, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
            this.cfw.addInvoke((byte)-72, this.codegen.mainClassName, n == 31 ? this.codegen.getDirectCtorName(optFunctionNode.fnode) : this.codegen.getBodyMethodName(optFunctionNode.fnode), this.codegen.getBodyMethodSignature(optFunctionNode.fnode));
            n2 = this.cfw.acquireLabel();
            this.cfw.add((byte)-89, n2);
            this.cfw.markLabel(n3, s);
            this.cfw.add((byte)87);
            this.visitRegularCall(node, n, node3, true);
            this.cfw.markLabel(n2);
        } else {
            this.visitRegularCall(node, n, node3, false);
        }
    }

    private String getSimpleCallName(Node node) {
        Node node2;
        Node node3 = node.getFirstChild();
        if (node3.getType() == 34 && (node2 = node3.getFirstChild()).getType() == 116) {
            Node node4 = node2.getNext();
            Node node5 = node2.getFirstChild();
            if (node5.getType() == 58) {
                Node node6;
                Node node7;
                String string = node5.getString();
                if (node4 != null && node4.getType() == 41 && string.equals(node4.getString()) && (node7 = node3.getNext()).getType() == 68 && (node6 = node7.getFirstChild()).getType() == 117 && node6.getProp(2) == node2) {
                    return string;
                }
            }
        }
        return null;
    }

    private void constructArgArray(int n) {
        if (n == 0) {
            if (this.itsZeroArgArray >= 0) {
                this.cfw.addALoad(this.itsZeroArgArray);
            } else {
                this.cfw.add((byte)-78, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
            }
        } else if (n == 1) {
            if (this.itsOneArgArray >= 0) {
                this.cfw.addALoad(this.itsOneArgArray);
            } else {
                this.cfw.addPush(1);
                this.cfw.add((byte)-67, "java/lang/Object");
            }
        } else {
            this.cfw.addPush(n);
            this.cfw.add((byte)-67, "java/lang/Object");
        }
    }

    private void visitRegularCall(Node node, int n, Node node2, boolean bl) {
        String string;
        Object object;
        String string2;
        int n2;
        OptFunctionNode optFunctionNode = (OptFunctionNode)node.getProp(16);
        Node node3 = node2;
        int n3 = 0;
        int n4 = n2 = n == 31 ? 1 : 2;
        while (node2 != null) {
            ++n3;
            node2 = node2.getNext();
        }
        node2 = node3;
        int n5 = -n2;
        if (bl && node2 != null) {
            node2 = node2.getNext();
            ++n5;
            this.cfw.addALoad(this.contextLocal);
            this.cfw.add((byte)95);
        } else {
            this.cfw.addALoad(this.contextLocal);
        }
        if (bl && n == 31) {
            this.constructArgArray(n3 - n2);
        }
        int n6 = node.getIntProp(17, 0);
        boolean bl2 = false;
        if (!bl && n != 31 && (string2 = this.getSimpleCallName(node)) != null && n6 == 0) {
            bl2 = true;
            this.cfw.addPush(string2);
            this.cfw.addALoad(this.variableObjectLocal);
            node2 = node2.getNext().getNext();
            n5 = 0;
            this.constructArgArray(n3 - n2);
        }
        while (node2 != null) {
            if (n5 < 0) {
                this.generateCodeFromNode(node2, node);
            } else {
                this.cfw.add((byte)89);
                this.cfw.addPush(n5);
                if (optFunctionNode != null) {
                    boolean bl3 = false;
                    if (node2.getType() == 59 && this.inDirectCallFunction && (object = (OptLocalVariable)node2.getProp(13)) != null && ((OptLocalVariable)object).isParameter()) {
                        node2.removeProp(15);
                        this.generateCodeFromNode(node2, node);
                        bl3 = true;
                    }
                    if (!bl3) {
                        this.generateCodeFromNode(node2, node);
                        int n7 = node2.getIntProp(15, -1);
                        if (n7 == 0) {
                            this.addDoubleWrap();
                        }
                    }
                } else {
                    this.generateCodeFromNode(node2, node);
                }
                this.cfw.add((byte)83);
            }
            if (++n5 == 0) {
                this.constructArgArray(n3 - n2);
            }
            node2 = node2.getNext();
        }
        if (n6 != 0) {
            string2 = "org/mozilla/javascript/optimizer/OptRuntime";
            if (n == 31) {
                object = "newObjectSpecial";
                string = "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;I)Ljava/lang/Object;";
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addALoad(this.thisObjLocal);
                this.cfw.addPush(n6);
            } else {
                object = "callSpecial";
                string = "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;ILjava/lang/String;I)Ljava/lang/Object;";
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addALoad(this.thisObjLocal);
                this.cfw.addPush(n6);
                String string3 = this.scriptOrFn.getSourceName();
                this.cfw.addPush(string3 == null ? "" : string3);
                this.cfw.addPush(this.itsLineNumber);
            }
        } else if (bl2) {
            string2 = "org/mozilla/javascript/optimizer/OptRuntime";
            object = "callSimple";
            string = "(Lorg/mozilla/javascript/Context;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;";
        } else {
            string2 = "org/mozilla/javascript/ScriptRuntime";
            this.cfw.addALoad(this.variableObjectLocal);
            if (n == 31) {
                object = "newObject";
                string = "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;";
            } else {
                object = "call";
                string = "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            }
        }
        this.cfw.addInvoke((byte)-72, string2, (String)object, string);
    }

    private void visitStatement(Node node) {
        this.itsLineNumber = node.getLineno();
        if (this.itsLineNumber == -1) {
            return;
        }
        this.cfw.addLineNumberEntry((short)this.itsLineNumber);
    }

    private void visitTryCatchFinally(Node.Jump jump, Node node) {
        int n;
        short s = this.getNewWordLocal();
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addAStore(s);
        int n2 = this.cfw.acquireLabel();
        this.cfw.markLabel(n2, (short)1);
        this.visitStatement(jump);
        while (node != null) {
            this.generateCodeFromNode(node, jump);
            node = node.getNext();
        }
        Node.Target target = jump.target;
        Node.Target target2 = jump.getFinally();
        int n3 = this.cfw.acquireLabel();
        this.cfw.add((byte)-89, n3);
        int n4 = this.getLocalBlockRegister(jump);
        if (target != null) {
            n = target.labelId;
            this.generateCatchBlock(0, s, n, n2, n4);
            this.generateCatchBlock(1, s, n, n2, n4);
            this.generateCatchBlock(2, s, n, n2, n4);
        }
        if (target2 != null) {
            n = this.cfw.acquireLabel();
            this.cfw.markHandler(n);
            this.cfw.addAStore(n4);
            this.cfw.addALoad(s);
            this.cfw.addAStore(this.variableObjectLocal);
            int n5 = target2.labelId;
            this.cfw.add((byte)-88, n5);
            this.cfw.addALoad(n4);
            this.cfw.add((byte)-65);
            this.cfw.addExceptionHandler(n2, n5, n, null);
        }
        this.releaseWordLocal(s);
        this.cfw.markLabel(n3);
    }

    private void generateCatchBlock(int n, short s, int n2, int n3, int n4) {
        String string;
        int n5 = this.cfw.acquireLabel();
        this.cfw.markHandler(n5);
        short s2 = this.getNewWordLocal();
        this.cfw.addAStore(s2);
        this.cfw.addALoad(s);
        this.cfw.addAStore(this.variableObjectLocal);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(s2);
        this.releaseWordLocal(s2);
        this.addScriptRuntimeInvoke("getCatchObject", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Throwable;)Ljava/lang/Object;");
        this.cfw.addAStore(n4);
        if (n == 0) {
            string = "org/mozilla/javascript/JavaScriptException";
        } else if (n == 1) {
            string = "org/mozilla/javascript/EvaluatorException";
        } else {
            if (n != 2) {
                Kit.codeBug();
            }
            string = "org/mozilla/javascript/EcmaError";
        }
        this.cfw.addExceptionHandler(n3, n2, n5, string);
        this.cfw.add((byte)-89, n2);
    }

    private void visitThrow(Node node, Node node2) {
        this.visitStatement(node);
        while (node2 != null) {
            this.generateCodeFromNode(node2, node);
            node2 = node2.getNext();
        }
        this.cfw.add((byte)-69, "org/mozilla/javascript/JavaScriptException");
        this.cfw.add((byte)90);
        this.cfw.add((byte)95);
        this.cfw.addPush(this.scriptOrFn.getSourceName());
        this.cfw.addPush(this.itsLineNumber);
        this.cfw.addInvoke((byte)-73, "org/mozilla/javascript/JavaScriptException", "<init>", "(Ljava/lang/Object;Ljava/lang/String;I)V");
        this.cfw.add((byte)-65);
    }

    private void visitSwitch(Node.Jump jump, Node node) {
        Node node2;
        this.visitStatement(jump);
        while (node != null) {
            this.generateCodeFromNode(node, jump);
            node = node.getNext();
        }
        short s = this.getNewWordLocal();
        this.cfw.addAStore(s);
        ObjArray objArray = (ObjArray)jump.getProp(8);
        for (int i = 0; i < objArray.size(); ++i) {
            node2 = (Node)objArray.get(i);
            Node node3 = node2.getFirstChild();
            this.generateCodeFromNode(node3, node2);
            this.cfw.addALoad(s);
            this.addScriptRuntimeInvoke("seqB", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Boolean;");
            Node.Target target = new Node.Target();
            node2.replaceChild(node3, target);
            this.generateGOTO(7, target);
        }
        this.releaseWordLocal(s);
        Node node4 = (Node)jump.getProp(9);
        if (node4 != null) {
            node2 = new Node.Target();
            node4.getFirstChild().addChildToFront(node2);
            this.generateGOTO(6, (Node.Target)node2);
        }
        node2 = jump.target;
        this.generateGOTO(6, (Node.Target)node2);
    }

    private void generateGOTO(int n, Node.Target target) {
        Node.Jump jump = new Node.Jump(n);
        jump.target = target;
        this.visitGOTO(jump, n, null);
    }

    private void visitTypeofname(Node node) {
        OptLocalVariable optLocalVariable;
        String string = node.getString();
        if (this.hasVarsInRegs && (optLocalVariable = this.fnCurrent.getVar(string)) != null) {
            if (optLocalVariable.isNumber()) {
                this.cfw.addPush("number");
                return;
            }
            this.visitGetVar(optLocalVariable, false, string);
            this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)Ljava/lang/String;");
            return;
        }
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(string);
        this.addScriptRuntimeInvoke("typeofName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/String;");
    }

    private void visitIncDec(Node node, boolean bl) {
        Node node2 = node.getFirstChild();
        if (node.getIntProp(15, -1) != -1) {
            OptLocalVariable optLocalVariable = (OptLocalVariable)node2.getProp(13);
            if (optLocalVariable.getJRegister() == -1) {
                optLocalVariable.assignJRegister(this.getNewWordPairLocal());
            }
            this.cfw.addDLoad(optLocalVariable.getJRegister());
            this.cfw.add((byte)92);
            this.cfw.addPush(1.0);
            this.cfw.add(bl ? (byte)99 : 103);
            this.cfw.addDStore(optLocalVariable.getJRegister());
        } else {
            OptLocalVariable optLocalVariable = (OptLocalVariable)node2.getProp(13);
            String string = bl ? "postIncrement" : "postDecrement";
            int n = node2.getType();
            if (this.hasVarsInRegs && n == 59) {
                if (optLocalVariable == null) {
                    optLocalVariable = this.fnCurrent.getVar(node2.getString());
                }
                if (optLocalVariable.getJRegister() == -1) {
                    optLocalVariable.assignJRegister(this.getNewWordLocal());
                }
                this.cfw.addALoad(optLocalVariable.getJRegister());
                this.cfw.add((byte)89);
                this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;)Ljava/lang/Object;");
                this.cfw.addAStore(optLocalVariable.getJRegister());
            } else if (n == 34) {
                Node node3 = node2.getFirstChild();
                this.generateCodeFromNode(node3, node);
                this.generateCodeFromNode(node3.getNext(), node);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            } else if (n == 36) {
                string = string + "Elem";
                Node node4 = node2.getFirstChild();
                this.generateCodeFromNode(node4, node);
                this.generateCodeFromNode(node4.getNext(), node);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            } else {
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(node2.getString());
                this.addScriptRuntimeInvoke(string, "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/Object;");
            }
        }
    }

    private static boolean isArithmeticNode(Node node) {
        int n = node.getType();
        return n == 23 || n == 26 || n == 25 || n == 24;
    }

    private void visitArithmetic(Node node, byte by, Node node2, Node node3) {
        int n = node.getIntProp(15, -1);
        if (n != -1) {
            this.generateCodeFromNode(node2, node);
            this.generateCodeFromNode(node2.getNext(), node);
            this.cfw.add(by);
        } else {
            boolean bl = BodyCodegen.isArithmeticNode(node3);
            this.generateCodeFromNode(node2, node);
            if (!BodyCodegen.isArithmeticNode(node2)) {
                this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)D");
            }
            this.generateCodeFromNode(node2.getNext(), node);
            if (!BodyCodegen.isArithmeticNode(node2.getNext())) {
                this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)D");
            }
            this.cfw.add(by);
            if (!bl) {
                this.addDoubleWrap();
            }
        }
    }

    private void visitBitOp(Node node, int n, Node node2) {
        int n2 = node.getIntProp(15, -1);
        this.generateCodeFromNode(node2, node);
        if (n == 21) {
            this.addScriptRuntimeInvoke("toUint32", "(Ljava/lang/Object;)J");
            this.generateCodeFromNode(node2.getNext(), node);
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)I");
            this.cfw.addPush(31);
            this.cfw.add((byte)126);
            this.cfw.add((byte)125);
            this.cfw.add((byte)-118);
            this.addDoubleWrap();
            return;
        }
        if (n2 == -1) {
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)I");
            this.generateCodeFromNode(node2.getNext(), node);
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)I");
        } else {
            this.addScriptRuntimeInvoke("toInt32", "(D)I");
            this.generateCodeFromNode(node2.getNext(), node);
            this.addScriptRuntimeInvoke("toInt32", "(D)I");
        }
        switch (n) {
            case 10: {
                this.cfw.add((byte)-128);
                break;
            }
            case 11: {
                this.cfw.add((byte)-126);
                break;
            }
            case 12: {
                this.cfw.add((byte)126);
                break;
            }
            case 20: {
                this.cfw.add((byte)122);
                break;
            }
            case 19: {
                this.cfw.add((byte)120);
                break;
            }
            default: {
                Codegen.badTree();
            }
        }
        this.cfw.add((byte)-121);
        if (n2 == -1) {
            this.addDoubleWrap();
        }
    }

    private boolean nodeIsDirectCallParameter(Node node) {
        OptLocalVariable optLocalVariable;
        return node.getType() == 59 && (optLocalVariable = (OptLocalVariable)node.getProp(13)) != null && optLocalVariable.isParameter() && this.inDirectCallFunction && !this.itsForcedObjectParameters;
    }

    private void genSimpleCompare(int n, int n2, int n3) {
        switch (n) {
            case 16: {
                this.cfw.add((byte)-104);
                this.cfw.add((byte)-98, n2);
                break;
            }
            case 18: {
                this.cfw.add((byte)-105);
                this.cfw.add((byte)-100, n2);
                break;
            }
            case 15: {
                this.cfw.add((byte)-104);
                this.cfw.add((byte)-101, n2);
                break;
            }
            case 17: {
                this.cfw.add((byte)-105);
                this.cfw.add((byte)-99, n2);
                break;
            }
            default: {
                Codegen.badTree();
            }
        }
        if (n3 != -1) {
            this.cfw.add((byte)-89, n3);
        }
    }

    private void visitIfJumpRelOp(Node node, Node node2, int n, int n2) {
        int n3 = node.getType();
        if (n3 == 55 || n3 == 54) {
            this.generateCodeFromNode(node2, node);
            this.generateCodeFromNode(node2.getNext(), node);
            this.cfw.addALoad(this.variableObjectLocal);
            this.addScriptRuntimeInvoke(n3 == 55 ? "instanceOf" : "in", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Z");
            this.cfw.add((byte)-102, n);
            this.cfw.add((byte)-89, n2);
            return;
        }
        int n4 = node.getIntProp(15, -1);
        if (n4 == 0) {
            this.generateCodeFromNode(node2, node);
            this.generateCodeFromNode(node2.getNext(), node);
            this.genSimpleCompare(n3, n, n2);
        } else {
            Object object;
            Object object2;
            Node node3 = node2.getNext();
            boolean bl = this.nodeIsDirectCallParameter(node2);
            boolean bl2 = this.nodeIsDirectCallParameter(node3);
            if (bl || bl2) {
                if (bl) {
                    if (bl2) {
                        object2 = (OptLocalVariable)node2.getProp(13);
                        this.cfw.addALoad(((OptLocalVariable)object2).getJRegister());
                        this.cfw.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        int n5 = this.cfw.acquireLabel();
                        this.cfw.add((byte)-90, n5);
                        object = (OptLocalVariable)node3.getProp(13);
                        this.cfw.addALoad(((OptLocalVariable)object).getJRegister());
                        this.cfw.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        this.cfw.add((byte)-90, n5);
                        this.cfw.addDLoad(((OptLocalVariable)object2).getJRegister() + 1);
                        this.cfw.addDLoad(((OptLocalVariable)object).getJRegister() + 1);
                        this.genSimpleCompare(n3, n, n2);
                        this.cfw.markLabel(n5);
                    } else if (n4 == 2) {
                        object2 = (OptLocalVariable)node2.getProp(13);
                        this.cfw.addALoad(((OptLocalVariable)object2).getJRegister());
                        this.cfw.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        int n6 = this.cfw.acquireLabel();
                        this.cfw.add((byte)-90, n6);
                        this.cfw.addDLoad(((OptLocalVariable)object2).getJRegister() + 1);
                        this.generateCodeFromNode(node3, node);
                        this.genSimpleCompare(n3, n, n2);
                        this.cfw.markLabel(n6);
                    }
                } else if (n4 == 1) {
                    object2 = (OptLocalVariable)node3.getProp(13);
                    this.cfw.addALoad(((OptLocalVariable)object2).getJRegister());
                    this.cfw.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int n7 = this.cfw.acquireLabel();
                    this.cfw.add((byte)-90, n7);
                    this.generateCodeFromNode(node2, node);
                    this.cfw.addDLoad(((OptLocalVariable)object2).getJRegister() + 1);
                    this.genSimpleCompare(n3, n, n2);
                    this.cfw.markLabel(n7);
                }
            }
            this.generateCodeFromNode(node2, node);
            this.generateCodeFromNode(node3, node);
            if (n4 == -1) {
                if (n3 == 18 || n3 == 17) {
                    this.cfw.add((byte)95);
                }
                object2 = n3 == 15 || n3 == 17 ? "cmp_LT" : "cmp_LE";
                this.addScriptRuntimeInvoke((String)object2, "(Ljava/lang/Object;Ljava/lang/Object;)I");
            } else {
                boolean bl3;
                boolean bl4 = bl3 = n4 == 1;
                if (n3 == 18 || n3 == 17) {
                    if (bl3) {
                        this.cfw.add((byte)91);
                        this.cfw.add((byte)87);
                        bl3 = false;
                    } else {
                        this.cfw.add((byte)93);
                        this.cfw.add((byte)88);
                        bl3 = true;
                    }
                }
                Object object3 = object = n3 == 15 || n3 == 17 ? "cmp_LT" : "cmp_LE";
                if (bl3) {
                    this.addOptRuntimeInvoke((String)object, "(DLjava/lang/Object;)I");
                } else {
                    this.addOptRuntimeInvoke((String)object, "(Ljava/lang/Object;D)I");
                }
            }
            this.cfw.add((byte)-102, n);
            this.cfw.add((byte)-89, n2);
        }
    }

    private void visitRelOp(Node node, Node node2) {
        int n = node.getType();
        if (n == 55 || n == 54) {
            this.generateCodeFromNode(node2, node);
            this.generateCodeFromNode(node2.getNext(), node);
            this.cfw.addALoad(this.variableObjectLocal);
            this.addScriptRuntimeInvoke(n == 55 ? "instanceOf" : "in", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Z");
            int n2 = this.cfw.acquireLabel();
            int n3 = this.cfw.acquireLabel();
            this.cfw.add((byte)-102, n2);
            this.cfw.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
            this.cfw.add((byte)-89, n3);
            this.cfw.markLabel(n2);
            this.cfw.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
            this.cfw.markLabel(n3);
            this.cfw.adjustStackTop(-1);
            return;
        }
        int n4 = node.getIntProp(15, -1);
        if (n4 == 0) {
            this.generateCodeFromNode(node2, node);
            this.generateCodeFromNode(node2.getNext(), node);
            int n5 = this.cfw.acquireLabel();
            int n6 = this.cfw.acquireLabel();
            this.genSimpleCompare(n, n5, -1);
            this.cfw.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
            this.cfw.add((byte)-89, n6);
            this.cfw.markLabel(n5);
            this.cfw.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
            this.cfw.markLabel(n6);
            this.cfw.adjustStackTop(-1);
        } else {
            String string = n == 15 || n == 17 ? "cmp_LTB" : "cmp_LEB";
            this.generateCodeFromNode(node2, node);
            this.generateCodeFromNode(node2.getNext(), node);
            if (n4 == -1) {
                if (n == 18 || n == 17) {
                    this.cfw.add((byte)95);
                }
                this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Boolean;");
            } else {
                boolean bl;
                boolean bl2 = bl = n4 == 1;
                if (n == 18 || n == 17) {
                    if (bl) {
                        this.cfw.add((byte)91);
                        this.cfw.add((byte)87);
                        bl = false;
                    } else {
                        this.cfw.add((byte)93);
                        this.cfw.add((byte)88);
                        bl = true;
                    }
                }
                if (bl) {
                    this.addOptRuntimeInvoke(string, "(DLjava/lang/Object;)Ljava/lang/Boolean;");
                } else {
                    this.addOptRuntimeInvoke(string, "(Ljava/lang/Object;D)Ljava/lang/Boolean;");
                }
            }
        }
    }

    private Node getConvertToObjectOfNumberNode(Node node) {
        Node node2;
        if (node.getType() == 125 && (node2 = node.getFirstChild()).getType() == 40) {
            return node2;
        }
        return null;
    }

    private void visitEqOp(Node node, Node node2) {
        String string;
        boolean bl;
        int n = node.getType();
        Node node3 = node2.getNext();
        boolean bl2 = bl = n == 48 || n == 49;
        if (node3.getType() == 44) {
            this.generateCodeFromNode(node2, node);
            if (bl) {
                this.cfw.add((byte)-58, 9);
            } else {
                this.cfw.add((byte)89);
                this.cfw.add((byte)-58, 15);
                Codegen.pushUndefined(this.cfw);
                this.cfw.add((byte)-91, 10);
            }
            if (n == 13 || n == 48) {
                this.cfw.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
            } else {
                this.cfw.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
            }
            if (bl) {
                this.cfw.add((byte)-89, 6);
            } else {
                this.cfw.add((byte)-89, 7);
                this.cfw.add((byte)87);
            }
            if (n == 13 || n == 48) {
                this.cfw.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
            } else {
                this.cfw.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
            }
            return;
        }
        this.generateCodeFromNode(node2, node);
        this.generateCodeFromNode(node2.getNext(), node);
        switch (n) {
            case 13: {
                string = "eqB";
                break;
            }
            case 14: {
                string = "neB";
                break;
            }
            case 48: {
                string = "seqB";
                break;
            }
            case 49: {
                string = "sneB";
                break;
            }
            default: {
                string = null;
                Codegen.badTree();
            }
        }
        this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Boolean;");
    }

    private void visitIfJumpEqOp(Node node, Node node2, int n, int n2) {
        Object object;
        boolean bl;
        int n3 = node.getType();
        Node node3 = node2.getNext();
        boolean bl2 = bl = n3 == 48 || n3 == 49;
        if (node3.getType() == 44) {
            int n4;
            if (n3 != 13 && n3 != 48) {
                n4 = n;
                n = n2;
                n2 = n4;
            }
            this.generateCodeFromNode(node2, node);
            if (bl) {
                this.cfw.add((byte)-58, n);
                this.cfw.add((byte)-89, n2);
                return;
            }
            int n5 = n4 = node2.getType() == 59 ? 1 : 0;
            if (n4 == 0) {
                this.cfw.add((byte)89);
            }
            int n6 = this.cfw.acquireLabel();
            this.cfw.add((byte)-58, n4 != 0 ? n : n6);
            short s = this.cfw.getStackTop();
            if (n4 != 0) {
                this.generateCodeFromNode(node2, node);
            }
            Codegen.pushUndefined(this.cfw);
            this.cfw.add((byte)-91, n);
            this.cfw.add((byte)-89, n2);
            if (n4 == 0) {
                this.cfw.markLabel(n6, s);
                this.cfw.add((byte)87);
                this.cfw.add((byte)-89, n);
            }
            return;
        }
        Node node4 = node2.getNext();
        if (this.nodeIsDirectCallParameter(node2) && (object = this.getConvertToObjectOfNumberNode(node4)) != null) {
            OptLocalVariable optLocalVariable = (OptLocalVariable)node2.getProp(13);
            this.cfw.addALoad(optLocalVariable.getJRegister());
            this.cfw.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
            int n7 = this.cfw.acquireLabel();
            this.cfw.add((byte)-90, n7);
            this.cfw.addDLoad(optLocalVariable.getJRegister() + 1);
            this.cfw.addPush(((Node)object).getDouble());
            this.cfw.add((byte)-105);
            if (n3 == 13) {
                this.cfw.add((byte)-103, n);
            } else {
                this.cfw.add((byte)-102, n);
            }
            this.cfw.add((byte)-89, n2);
            this.cfw.markLabel(n7);
        }
        this.generateCodeFromNode(node2, node);
        this.generateCodeFromNode(node4, node);
        switch (n3) {
            case 13: {
                object = "eq";
                this.addScriptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)Z");
                break;
            }
            case 14: {
                object = "neq";
                this.addOptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)Z");
                break;
            }
            case 48: {
                object = "shallowEq";
                this.addScriptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)Z");
                break;
            }
            case 49: {
                object = "shallowNeq";
                this.addOptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)Z");
                break;
            }
            default: {
                object = null;
                Codegen.badTree();
            }
        }
        this.cfw.add((byte)-102, n);
        this.cfw.add((byte)-89, n2);
    }

    private void visitLiteral(Node node) {
        if (node.getType() == 41) {
            this.cfw.addPush(node.getString());
        } else {
            double d = node.getDouble();
            if (node.getIntProp(15, -1) != -1) {
                this.cfw.addPush(d);
            } else {
                this.codegen.pushNumberAsObject(this.cfw, d);
            }
        }
    }

    private void visitRegexp(Node node) {
        int n = node.getExistingIntProp(7);
        if (this.fnCurrent == null) {
            this.cfw.addALoad(this.scriptRegexpLocal);
        } else {
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.add((byte)-76, this.codegen.mainClassName, "_re", "[Ljava/lang/Object;");
        }
        this.cfw.addPush(n);
        this.cfw.add((byte)50);
    }

    private void visitName(Node node) {
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(node.getString());
        this.addScriptRuntimeInvoke("name", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/Object;");
    }

    private void visitSetName(Node node, Node node2) {
        String string = node.getFirstChild().getString();
        while (node2 != null) {
            this.generateCodeFromNode(node2, node);
            node2 = node2.getNext();
        }
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(string);
        this.addScriptRuntimeInvoke("setName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/Object;");
    }

    private void visitGetVar(OptLocalVariable optLocalVariable, boolean bl, String string) {
        if (this.hasVarsInRegs && optLocalVariable == null) {
            optLocalVariable = this.fnCurrent.getVar(string);
        }
        if (optLocalVariable != null) {
            if (optLocalVariable.getJRegister() == -1) {
                if (optLocalVariable.isNumber()) {
                    optLocalVariable.assignJRegister(this.getNewWordPairLocal());
                } else {
                    optLocalVariable.assignJRegister(this.getNewWordLocal());
                }
            }
            if (optLocalVariable.isParameter() && this.inDirectCallFunction && !this.itsForcedObjectParameters) {
                if (bl) {
                    this.cfw.addALoad(optLocalVariable.getJRegister());
                    this.cfw.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int n = this.cfw.acquireLabel();
                    int n2 = this.cfw.acquireLabel();
                    this.cfw.add((byte)-91, n);
                    this.cfw.addALoad(optLocalVariable.getJRegister());
                    this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)D");
                    this.cfw.add((byte)-89, n2);
                    this.cfw.markLabel(n);
                    this.cfw.addDLoad(optLocalVariable.getJRegister() + 1);
                    this.cfw.markLabel(n2);
                } else {
                    this.cfw.addALoad(optLocalVariable.getJRegister());
                    this.cfw.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int n = this.cfw.acquireLabel();
                    int n3 = this.cfw.acquireLabel();
                    this.cfw.add((byte)-91, n);
                    this.cfw.addALoad(optLocalVariable.getJRegister());
                    this.cfw.add((byte)-89, n3);
                    this.cfw.markLabel(n);
                    this.cfw.addDLoad(optLocalVariable.getJRegister() + 1);
                    this.addDoubleWrap();
                    this.cfw.markLabel(n3);
                }
            } else if (optLocalVariable.isNumber()) {
                this.cfw.addDLoad(optLocalVariable.getJRegister());
            } else {
                this.cfw.addALoad(optLocalVariable.getJRegister());
            }
            return;
        }
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(string);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("getProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
    }

    private void visitSetVar(Node node, Node node2, boolean bl) {
        OptLocalVariable optLocalVariable = (OptLocalVariable)node.getProp(13);
        if (this.hasVarsInRegs && optLocalVariable == null) {
            optLocalVariable = this.fnCurrent.getVar(node2.getString());
        }
        if (optLocalVariable != null) {
            this.generateCodeFromNode(node2.getNext(), node);
            if (optLocalVariable.getJRegister() == -1) {
                if (optLocalVariable.isNumber()) {
                    optLocalVariable.assignJRegister(this.getNewWordPairLocal());
                } else {
                    optLocalVariable.assignJRegister(this.getNewWordLocal());
                }
            }
            if (optLocalVariable.isParameter() && this.inDirectCallFunction && !this.itsForcedObjectParameters) {
                if (node.getIntProp(15, -1) != -1) {
                    if (bl) {
                        this.cfw.add((byte)92);
                    }
                    this.cfw.addALoad(optLocalVariable.getJRegister());
                    this.cfw.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int n = this.cfw.acquireLabel();
                    int n2 = this.cfw.acquireLabel();
                    this.cfw.add((byte)-91, n);
                    this.addDoubleWrap();
                    this.cfw.addAStore(optLocalVariable.getJRegister());
                    this.cfw.add((byte)-89, n2);
                    this.cfw.markLabel(n);
                    this.cfw.addDStore(optLocalVariable.getJRegister() + 1);
                    this.cfw.markLabel(n2);
                } else {
                    if (bl) {
                        this.cfw.add((byte)89);
                    }
                    this.cfw.addAStore(optLocalVariable.getJRegister());
                }
            } else if (node.getIntProp(15, -1) != -1) {
                this.cfw.addDStore(optLocalVariable.getJRegister());
                if (bl) {
                    this.cfw.addDLoad(optLocalVariable.getJRegister());
                }
            } else {
                this.cfw.addAStore(optLocalVariable.getJRegister());
                if (bl) {
                    this.cfw.addALoad(optLocalVariable.getJRegister());
                }
            }
            return;
        }
        node2.setType(52);
        node.setType(9);
        this.visitSetName(node, node2);
        if (!bl) {
            this.cfw.add((byte)87);
        }
    }

    private void visitGetProp(Node node, Node node2) {
        int n = node.getIntProp(11, 0);
        if (n != 0) {
            while (node2 != null) {
                this.generateCodeFromNode(node2, node);
                node2 = node2.getNext();
            }
            this.cfw.addALoad(this.variableObjectLocal);
            String string = null;
            if (n == 1) {
                string = "getProto";
            } else if (n == 2) {
                string = "getParent";
            } else {
                Codegen.badTree();
            }
            this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
            return;
        }
        Node node3 = node2.getNext();
        this.generateCodeFromNode(node2, node);
        this.generateCodeFromNode(node3, node);
        this.cfw.addALoad(this.variableObjectLocal);
        int n2 = node2.getType();
        if ((n2 == 45 || n2 == 116 && node2.getFirstChild().getType() == 45) && node3.getType() == 41) {
            this.addOptRuntimeInvoke("thisGet", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        } else {
            this.addScriptRuntimeInvoke("getProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        }
    }

    private void visitSetProp(int n, Node node, Node node2) {
        Node node3 = node2;
        this.generateCodeFromNode(node2, node);
        node2 = node2.getNext();
        int n2 = node.getIntProp(11, 0);
        if (n2 != 0) {
            String string;
            if (n == 121) {
                this.cfw.add((byte)89);
                string = null;
                if (n2 == 1) {
                    string = "getProto";
                } else if (n2 == 2) {
                    string = "getParent";
                } else {
                    Codegen.badTree();
                }
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
            }
            this.generateCodeFromNode(node2, node);
            this.cfw.addALoad(this.variableObjectLocal);
            string = null;
            if (n2 == 1) {
                string = "setProto";
            } else if (n2 == 2) {
                string = "setParent";
            } else {
                Codegen.badTree();
            }
            this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            return;
        }
        if (n == 121) {
            this.cfw.add((byte)89);
        }
        Node node4 = node2;
        this.generateCodeFromNode(node2, node);
        node2 = node2.getNext();
        if (n == 121) {
            this.cfw.add((byte)90);
            this.cfw.addALoad(this.variableObjectLocal);
            if (node3.getType() == 45 && node4.getType() == 41) {
                this.addOptRuntimeInvoke("thisGet", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            } else {
                this.addScriptRuntimeInvoke("getProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            }
        }
        this.generateCodeFromNode(node2, node);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("setProp", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
    }

    private void visitBind(Node node, int n, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node);
            node2 = node2.getNext();
        }
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(node.getString());
        this.addScriptRuntimeInvoke(n == 52 ? "bind" : "getBase", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Lorg/mozilla/javascript/Scriptable;");
    }

    private int getLocalBlockRegister(Node node) {
        Node node2 = (Node)node.getProp(4);
        int n = node2.getExistingIntProp(3);
        return n;
    }

    private void visitNewTemp(Node node, Node node2) {
        this.generateCodeFromNode(node2, node);
        short s = this.getNewWordLocal();
        node.putIntProp(3, s);
        this.cfw.add((byte)89);
        this.cfw.addAStore(s);
        if (node.getIntProp(6, 0) == 0) {
            this.releaseWordLocal(s);
        }
    }

    private void visitUseTemp(Node node, Node node2) {
        Node node3 = (Node)node.getProp(2);
        int n = node3.getExistingIntProp(3);
        this.cfw.addALoad(n);
        int n2 = node3.getIntProp(6, 0);
        if (n2 <= 1) {
            this.releaseWordLocal((short)n);
        }
        if (n2 != 0 && n2 != Integer.MAX_VALUE) {
            node3.putIntProp(6, n2 - 1);
        }
    }

    private void addScriptRuntimeInvoke(String string, String string2) {
        this.cfw.addInvoke((byte)-72, "org/mozilla/javascript/ScriptRuntime", string, string2);
    }

    private void addOptRuntimeInvoke(String string, String string2) {
        this.cfw.addInvoke((byte)-72, "org/mozilla/javascript/optimizer/OptRuntime", string, string2);
    }

    private void addDoubleWrap() {
        this.addOptRuntimeInvoke("wrapDouble", "(D)Ljava/lang/Double;");
    }

    private short getNewWordPairLocal() {
        short s;
        for (s = this.firstFreeLocal; s < 255 && (this.locals[s] || this.locals[s + 1]); s = (short)(s + 1)) {
        }
        if (s < 255) {
            this.locals[s] = true;
            this.locals[s + 1] = true;
            if (s == this.firstFreeLocal) {
                for (int i = this.firstFreeLocal + 2; i < 256; ++i) {
                    if (this.locals[i]) continue;
                    this.firstFreeLocal = (short)i;
                    if (this.localsMax < this.firstFreeLocal) {
                        this.localsMax = this.firstFreeLocal;
                    }
                    return s;
                }
            } else {
                return s;
            }
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private short reserveWordLocal(int n) {
        if (this.getNewWordLocal() != n) {
            throw new RuntimeException("Local allocation error");
        }
        return (short)n;
    }

    private short getNewWordLocal() {
        short s = this.firstFreeLocal;
        this.locals[s] = true;
        for (int i = this.firstFreeLocal + 1; i < 256; ++i) {
            if (this.locals[i]) continue;
            this.firstFreeLocal = (short)i;
            if (this.localsMax < this.firstFreeLocal) {
                this.localsMax = this.firstFreeLocal;
            }
            return s;
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private void releaseWordpairLocal(short s) {
        if (s < this.firstFreeLocal) {
            this.firstFreeLocal = s;
        }
        this.locals[s] = false;
        this.locals[s + 1] = false;
    }

    private void releaseWordLocal(short s) {
        if (s < this.firstFreeLocal) {
            this.firstFreeLocal = s;
        }
        this.locals[s] = false;
    }
}

