/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Method;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public final class LazilyLoadedCtor {
    private static Method getter;
    private static Method setter;
    private String ctorName;
    private String className;
    private boolean sealed;
    private boolean isReplaced;

    public LazilyLoadedCtor(ScriptableObject scriptableObject, String string, String string2, boolean bl) {
        this.className = string2;
        this.ctorName = string;
        this.sealed = bl;
        if (getter == null) {
            Method[] methodArray = FunctionObject.getMethodList(this.getClass());
            getter = FunctionObject.findSingleMethod(methodArray, "getProperty");
            setter = FunctionObject.findSingleMethod(methodArray, "setProperty");
        }
        try {
            scriptableObject.defineProperty(string, this, getter, setter, 2);
        }
        catch (PropertyException propertyException) {
            throw Context.throwAsScriptRuntimeEx(propertyException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(ScriptableObject scriptableObject) {
        ScriptableObject scriptableObject2 = scriptableObject;
        synchronized (scriptableObject2) {
            if (!this.isReplaced) {
                boolean bl = false;
                Class clazz = Kit.classOrNull(this.className);
                if (clazz == null) {
                    bl = true;
                } else {
                    try {
                        ScriptableObject.defineClass(scriptableObject, clazz, this.sealed);
                        this.isReplaced = true;
                    }
                    catch (SecurityException securityException) {
                        bl = true;
                    }
                    catch (Exception exception) {
                        throw Context.throwAsScriptRuntimeEx(exception);
                    }
                }
                if (bl) {
                    scriptableObject.delete(this.ctorName);
                    return Scriptable.NOT_FOUND;
                }
            }
        }
        return scriptableObject.get(this.ctorName, (Scriptable)scriptableObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setProperty(ScriptableObject scriptableObject, Object object) {
        ScriptableObject scriptableObject2 = scriptableObject;
        synchronized (scriptableObject2) {
            this.isReplaced = true;
            return object;
        }
    }
}

