dojo.provide("popupcalendar.Calendar");

dojo.require("dojo.widget.*");
// TODO cleanup
//dojo.require("dojo.event.*");
//dojo.require("dojo.html");

popupcalendar.Calendar = function() {
	dojo.widget.HtmlWidget.call(this);
}
dojo.inherits(popupcalendar.Calendar, dojo.widget.HtmlWidget);
dojo.widget.tags.addParseTreeHandler("dojo:calendar");
dojo.lang.extend(popupcalendar.Calendar, {
	widgetType: "Calendar",

	// TODO These are part of dojo widget framework and may be used in future
	// templateString: '<div dojoAttachPoint="calendarNode"></div>',
	// templateCssPath: dojo.uri.dojoUri("../bpui/widget/templates/Calendar.css"),

	fillInTemplate: function(args, frag) {
		this.initParams(args.calendarParams);
		this.doRender();
	},

	// Default widget values
	yearIndex: 6, monthIndex: 0, dayIndex: 3, separator: '/',
	months: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
	weekdays: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
	jsFirstWeekday: 0, isPopup: false, selectedDate: null,

	/**
	 * Initialize parameters.
	 */
	initParams: function(params) {
		if (params) {
			dojo.lang.mixin(this, params);
			this._initDateFormatter();
		}
	},

	/**
	 * Generate markup and maybe show the component
	 */
    doRender: function() {
        // Default is to show the current month
        this.displayMonth = this.selectedDate == null
			? new Date() : this.selectedDate;
        this._redraw();
		if (!this.isPopup) {
			this.show();
		}
    },

	_initDateFormatter: function() {
		this.dateFormatter = new popupcalendar.Calendar.DateFormat(
			this.yearIndex, this.monthIndex, this.dayIndex, this.separator);
	},

    _redraw: function() {
        // Calculate the first of the main month to display in "first".
        var first = new Date(this.displayMonth.getFullYear(),
                             this.displayMonth.getMonth(), 1);

        // Remove any existing content
        if (this.domNode.firstChild != null) {
            this.domNode.removeChild(this.domNode.firstChild);
        }

        // Render outer table
        var table = document.createElement("table");
        table.className = "CalTable";
        // TODO clean this up
//        table.border = "1";
//        table.cellPadding = "1";
//        table.cellSpacing = "0";
        this.domNode.appendChild(table);
        var tbody = document.createElement("tbody");
        table.appendChild(tbody);

        // Render month and year controls
        var tr = document.createElement("tr");
        tbody.appendChild(tr);
        var cell = document.createElement("th");
        tr.appendChild(cell)
        // TODO
        cell.colSpan = 7;
        cell.align = "center";
        this.renderControls(cell, first);

        // Render weekday header row
        tr = document.createElement("tr");
        tbody.appendChild(tr);
        for (var i = this.jsFirstWeekday; i < 7; i++ ) {
            this.appendHeaderCellSpan(tr, this.weekdays[i], "14%");
        }
        for (var i = 0; i < this.jsFirstWeekday; i++ ) {
            this.appendHeaderCellSpan(tr, this.weekdays[i], "14%");
        }

        // Render first week data row
        var tr = document.createElement("tr");
        tbody.appendChild(tr);

        var oneDayInMs = 1000 * 60 * 60 * 24;
        var column = 0;
        var day;
        var firstDay = first.getDay();
        if (firstDay == this.jsFirstWeekday) {
            // First cell on first row is the first of the main month
            day = first;
        } else {
            // First cell on first row is in previous month
            var backDays = (firstDay - this.jsFirstWeekday + 7) % 7;
            day = new Date(first.getTime() - backDays * oneDayInMs);
            // assert day == date of first cell on first row in previous month

            // Generate start of first row up to first of month
            while (day.getMonth() !=  first.getMonth()) {
                this.appendCellDay(tr, day, "CalOtherMonth");
                day = new Date(day.getTime() + oneDayInMs);
                column++;
            }
        }

        while (column < 7) {
            var className = this.isSelectedDate(day) ?
                "CalSelectedDate" : "CalCurrentMonth";
            this.appendCellDay(tr, day, className);
            day = new Date(day.getTime() + oneDayInMs);
            column++;
        }

        // Render intermediate rows
        while (day.getDate() != 1) {
            tr = document.createElement("tr");
            tbody.appendChild(tr);
            column = 0;
            while (column < 7 && day.getDate() != 1) {
                var className = this.isSelectedDate(day) ?
                    "CalSelectedDate" : "CalCurrentMonth";
                this.appendCellDay(tr, day, className);
                day = new Date(day.getTime() + oneDayInMs);
                column++;
            }
        }

        // Render any cells in the last row of the following month
        while (column < 7) {
            this.appendCellDay(tr, day, "CalOtherMonth");
            day = new Date(day.getTime() + oneDayInMs);
            column++;
        }
    },

    renderControls: function(parent, currentMonth) {
        var table = document.createElement("table");
        parent.appendChild(table);
        table.border = "0";
        table.cellSpacing = "0";
        table.cellPadding = "3";
        var tbody = document.createElement("tbody");
        table.appendChild(tbody);
        var tr = document.createElement("tr");
        tbody.appendChild(tr);

        if (this.monthIndex < this.yearIndex) {
            this.renderMonthControls(tr);
            this.appendHeaderCellSpan(tr, this.months[
                                          currentMonth.getMonth()]);
            this.appendHeaderCellSpan(tr, currentMonth.getFullYear());
            this.renderYearControls(tr);
        } else {
            this.renderYearControls(tr);
            this.appendHeaderCellSpan(tr, currentMonth.getFullYear());
            this.appendHeaderCellSpan(tr, this.months[
                                          currentMonth.getMonth()]);
            this.renderMonthControls(tr);
        }

		if (this.isPopup) {
			// TODO fix icon
			var thisObj = this;
			this.appendHeaderCellLink(tr, "X",
									  function() {
										  return thisObj.requestClose(); });
		}
    },

    renderMonthControls: function(tr) {
        var thisObj = this;
        this.appendHeaderCellLink(tr, "&lt;",
                                  function() {
                                      return thisObj.decrementMonth(); });
        this.appendHeaderCellLink(tr, "&gt;",
                                  function() {
                                      return thisObj.incrementMonth(); });
    },

    renderYearControls: function(tr) {
        var thisObj = this;
        this.appendHeaderCellLink(tr, "&lt;",
                                  function() {
                                      return thisObj.decrementYear(); });
        this.appendHeaderCellLink(tr, "&gt;",
                                  function() {
                                      return thisObj.incrementYear(); });
    },

    appendHeaderCellLink: function(tr, content, onclick) {
        var cell = document.createElement("th");
        tr.appendChild(cell);
        var link = document.createElement("a");
        cell.appendChild(link);
        cell.style.width = "5%";
        link.href = "#";
        link.innerHTML = content;
        link.onclick = onclick;
    },

    appendHeaderCellSpan: function(tr, content, width) {
        var cell = document.createElement("th");
        tr.appendChild(cell);
        var span = document.createElement("span");
        cell.appendChild(span);
        if (arguments.length == 3) {
            cell.style.width = width;
        }
        cell.innerHTML = content;
    },

    appendCellDay: function(tr, day, className) {
        var td = document.createElement("td");
        tr.appendChild(td);
        var link = document.createElement("a");
        td.appendChild(link);
        td.className = className;
        link.title = this.format(day);
        link.innerHTML = day.getDate();
        var _this = this;
        link.onclick = function() { return _this._setDate(day); };
    },

    _setDate: function(date) {
        this.selectedDate = date;
		if (this.isPopup) {
			this.requestClose();
		}
        return false;
    },

	/**
	 * Event where popup calendars hook into to get selectedDate value
	 */
	requestClose: function() {
	},

    decrementMonth: function() {
        var year = this.displayMonth.getFullYear();
        var month = this.displayMonth.getMonth() - 1;
        if (month < 0) {
            month = 11;
            year--;
        }
        this.displayMonth = new Date(year, month);
        this._redraw();
        return false;
    },

    incrementMonth: function() {
        var year = this.displayMonth.getFullYear();
        var month = this.displayMonth.getMonth() + 1;
        if (month > 11) {
            month = 0;
            year++;
        }
        this.displayMonth = new Date(year, month);
        this._redraw();
        return false;
    },

    decrementYear: function() {
        var year = this.displayMonth.getFullYear() - 1;
        var month = this.displayMonth.getMonth();
        if (year < 1) {
            year = 1;
        }
        this.displayMonth = new Date(year, month);
        this._redraw();
        return false;
    },

    incrementYear: function() {
        var year = this.displayMonth.getFullYear() + 1;
        var month = this.displayMonth.getMonth();
        this.displayMonth = new Date(year, month);
        this._redraw();
        return false;
    },

    isSelectedDate: function(date) {
        if (this.selectedDate == null || date == null) {
            return false;
        }
        if (this.selectedDate.getFullYear() != date.getFullYear()
            || this.selectedDate.getMonth() != date.getMonth()
            || this.selectedDate.getDate() != date.getDate()) {
            return false;
        }
        return true;
    },

    format: function(date) {
		if (!this.dateFormatter) {
			this._initDateFormatter();
		}
		return this.dateFormatter.format(date);
    }
});

/**
 * Utility class to format dates
 */
popupcalendar.Calendar.DateFormat = function(yearIndex, monthIndex, dayIndex,
											 separator) {
	this.yearIndex = yearIndex;
	this.monthIndex = monthIndex;
	this.dayIndex = dayIndex;
	this.separator = separator;
};
dojo.inherits(popupcalendar.Calendar.DateFormat, Object);
dojo.lang.extend(popupcalendar.Calendar.DateFormat, {
    format: function(date) {
        var retVal = "";
		if (!date) {
			return retVal;
		}
        var yearIndex = this.yearIndex;
        var monthIndex = this.monthIndex;
        var dayIndex = this.dayIndex;
        var separator = this.separator;
        // Convert to conventional month numbering
        var realMonth = date.getMonth() + 1;
        if (yearIndex < dayIndex && yearIndex < monthIndex) {
            // Year is first
            retVal += date.getFullYear() + separator;
        }
        if (dayIndex < monthIndex) {
            retVal += this.zeroPad2(date.getDate()) + separator
                + this.zeroPad2(realMonth);
        } else {
            retVal += this.zeroPad2(realMonth) + separator
                + this.zeroPad2(date.getDate());
        }
        if (yearIndex > dayIndex && yearIndex > monthIndex) {
            // Year is last
            retVal += separator + date.getFullYear();
        }
        return retVal;
	},

    /** Converts number to string and zero-pads it to 2 digits */
    zeroPad2: function(n) {
        if (n < 0 || n > 9) {
            return n.toString();
        }
        return "0" + n;
    }
});
