/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.awt.Point;
import java.util.Date;
import org.netbeans.beaninfo.editors.ArrayOfIntSupport;
import org.netbeans.beaninfo.editors.DimensionEditor;
import org.netbeans.beaninfo.editors.PointCustomEditor;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class PointEditor
extends ArrayOfIntSupport {
    public PointEditor() {
        super("java.awt.Point", 2);
    }

    int[] getValues() {
        Point p = (Point)this.getValue();
        return new int[]{p.x, p.y};
    }

    void setValues(int[] val) {
        if (val[0] < 0 || val[1] < 0) {
            String msg = NbBundle.getMessage((Class)DimensionEditor.class, (String)"CTL_NegativeSize");
            IllegalArgumentException iae = new IllegalArgumentException("Negative value");
            ErrorManager.getDefault().annotate((Throwable)iae, 256, iae.getMessage(), msg, null, new Date());
            throw iae;
        }
        this.setValue(new Point(val[0], val[1]));
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new PointCustomEditor(this);
    }

    String getHintFormat() {
        return NbBundle.getMessage((Class)PointEditor.class, (String)"CTL_HintFormatPE");
    }

    protected String getXMLValueTag() {
        return "Point";
    }
}

