/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.CommandLine;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    String ownName;
    PrintWriter out;
    static final int EXIT_OK = 0;
    static final int EXIT_ERROR = 1;
    static final int EXIT_CMDERR = 2;
    static final int EXIT_SYSERR = 3;
    static final int EXIT_ABNORMAL = 4;
    private Option[] recognizedOptions = new Option[]{new Option("-g", "opt.g"), new Option("-g:none", "opt.g.none"){

        boolean process(String option) {
            Main.this.options.put("-g:", "none");
            return false;
        }
    }, new Option("-g:{lines,vars,source}", "opt.g.lines.vars.source"){

        boolean matches(String s) {
            return s.startsWith("-g:");
        }

        boolean process(String option) {
            String suboptions = option.substring(3);
            Main.this.options.put("-g:", suboptions);
            StringTokenizer t = new StringTokenizer(suboptions, ",");
            while (t.hasMoreTokens()) {
                String tok = t.nextToken();
                String opt = "-g:" + tok;
                Main.this.options.put(opt, opt);
            }
            return false;
        }
    }, new XOption("-Xlint", "opt.Xlint"), new XOption("-Xlint:{all,deprecation,unchecked,fallthrough,path,serial,finally,-deprecation,-unchecked,-fallthrough,-path,-serial,-finally}", "opt.Xlint.suboptlist"){

        boolean matches(String s) {
            return s.startsWith("-Xlint:");
        }

        boolean process(String option) {
            String suboptions = option.substring(7);
            Main.this.options.put("-Xlint:", suboptions);
            StringTokenizer t = new StringTokenizer(suboptions, ",");
            while (t.hasMoreTokens()) {
                String tok = t.nextToken();
                String opt = "-Xlint:" + tok;
                Main.this.options.put(opt, opt);
            }
            return false;
        }
    }, new Option("-nowarn", "opt.nowarn"), new Option("-verbose", "opt.verbose"), new Option("-deprecation", "opt.deprecation"){

        boolean process(String option) {
            Main.this.options.put("-Xlint:deprecation", option);
            return false;
        }
    }, new Option("-classpath", "opt.arg.path", "opt.classpath"), new Option("-cp", "opt.arg.path", "opt.classpath"){

        boolean process(String option, String arg) {
            return super.process("-classpath", arg);
        }
    }, new Option("-sourcepath", "opt.arg.path", "opt.sourcepath"), new Option("-bootclasspath", "opt.arg.path", "opt.bootclasspath"){

        boolean process(String option, String arg) {
            Main.this.options.remove("-Xbootclasspath/p:");
            Main.this.options.remove("-Xbootclasspath/a:");
            return super.process(option, arg);
        }
    }, new XOption("-Xbootclasspath/p:", "opt.arg.path", "opt.Xbootclasspath.p"), new XOption("-Xbootclasspath/a:", "opt.arg.path", "opt.Xbootclasspath.a"), new XOption("-Xbootclasspath:", "opt.arg.path", "opt.bootclasspath"){

        boolean process(String option, String arg) {
            Main.this.options.remove("-Xbootclasspath/p:");
            Main.this.options.remove("-Xbootclasspath/a:");
            return super.process("-bootclasspath", arg);
        }
    }, new Option("-extdirs", "opt.arg.dirs", "opt.extdirs"), new XOption("-Djava.ext.dirs=", "opt.arg.dirs", "opt.extdirs"){

        boolean process(String option, String arg) {
            return super.process("-extdirs", arg);
        }
    }, new Option("-endorseddirs", "opt.arg.dirs", "opt.endorseddirs"), new XOption("-Djava.endorsed.dirs=", "opt.arg.dirs", "opt.endorseddirs"){

        boolean process(String option, String arg) {
            return super.process("-endorseddirs", arg);
        }
    }, new Option("-d", "opt.arg.directory", "opt.d"), new Option("-encoding", "opt.arg.encoding", "opt.encoding"), new Option("-source", "opt.arg.release", "opt.source"){

        boolean process(String option, String operand) {
            Source source = Source.lookup(operand);
            if (source == null) {
                Main.this.error("err.invalid.source", new Object[]{operand});
                return true;
            }
            return super.process(option, operand);
        }
    }, new Option("-target", "opt.arg.release", "opt.target"){

        boolean process(String option, String operand) {
            Target target = Target.lookup(operand);
            if (target == null) {
                Main.this.error("err.invalid.target", new Object[]{operand});
                return true;
            }
            return super.process(option, operand);
        }
    }, new Option("-version", "opt.version"){

        boolean process(String option) {
            Log.printLines(Main.this.out, Main.this.ownName + " " + JavaCompiler.version());
            return super.process(option);
        }
    }, new Option("-help", "opt.help"){

        boolean process(String option) {
            Main.this.help();
            return super.process(option);
        }
    }, new Option("-X", "opt.X"){

        boolean process(String option) {
            Main.this.xhelp();
            return super.process(option);
        }
    }, new Option("-J", "opt.arg.flag", "opt.J"){

        String helpSynopsis() {
            this.hasSuffix = true;
            return super.helpSynopsis();
        }

        boolean process(String option) {
            throw new AssertionError((Object)"the -J flag should be caught by the launcher.");
        }
    }, new HiddenOption("-moreinfo"){

        boolean process(String option) {
            Type.moreInfo = true;
            return super.process(option);
        }
    }, new HiddenOption("-Werror"), new HiddenOption("-complexinference"), new HiddenOption("-prompt"), new HiddenOption("-doe"), new HiddenOption("-warnunchecked"){

        boolean process(String option) {
            Main.this.options.put("-Xlint:unchecked", option);
            return false;
        }
    }, new XOption("-Xmaxerrs", "opt.arg.number", "opt.maxerrs"), new XOption("-Xmaxwarns", "opt.arg.number", "opt.maxwarns"), new XOption("-Xstdout", "opt.arg.file", "opt.Xstdout"){

        boolean process(String option, String arg) {
            try {
                Main.this.out = new PrintWriter((Writer)new FileWriter(arg), true);
            }
            catch (IOException e) {
                Main.this.error("err.error.writing.file", new Object[]{arg, e});
                return true;
            }
            return super.process(option, arg);
        }
    }, new HiddenOption("-O"), new HiddenOption("-Xjcov"), new HiddenOption("-XD"){
        String s;

        boolean matches(String s) {
            this.s = s;
            return s.startsWith(this.name);
        }

        boolean process(String option) {
            this.s = this.s.substring(this.name.length());
            int eq = this.s.indexOf(61);
            String key = eq < 0 ? this.s : this.s.substring(0, eq);
            String value = eq < 0 ? this.s : this.s.substring(eq + 1);
            Main.this.options.put(key, value);
            return false;
        }
    }, new HiddenOption("sourcefile"){
        String s;

        boolean matches(String s) {
            this.s = s;
            return s.endsWith(".java");
        }

        boolean process(String option) {
            if (!Main.this.filenames.contains(this.s)) {
                Main.this.filenames.append(this.s);
            }
            return false;
        }
    }};
    private Options options = null;
    ListBuffer<String> filenames = null;
    private static final String javacRB = "com.sun.tools.javac.resources.javac";
    private static ResourceBundle messageRB;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$tools$javac$main$Main;

    public Main(String name) {
        this(name, new PrintWriter(System.err, true));
    }

    public Main(String name, PrintWriter out) {
        this.ownName = name;
        this.out = out;
    }

    void help() {
        Log.printLines(this.out, Main.getLocalizedString("msg.usage.header", new Object[]{this.ownName}));
        for (int i = 0; i < this.recognizedOptions.length; ++i) {
            this.recognizedOptions[i].help();
        }
        this.out.println();
    }

    void xhelp() {
        for (int i = 0; i < this.recognizedOptions.length; ++i) {
            this.recognizedOptions[i].xhelp();
        }
        this.out.println();
        Log.printLines(this.out, Main.getLocalizedString("msg.usage.nonstandard.footer", new Object[0]));
    }

    void error(String key, Object[] args) {
        this.warning(key, args);
        this.help();
    }

    void warning(String key, Object[] args) {
        Log.printLines(this.out, new StringBuffer().append(this.ownName).append(": ").append(Main.getLocalizedString(key, args)).toString());
    }

    protected List<String> processArgs(String[] flags) {
        Target target;
        int ac = 0;
        while (ac < flags.length) {
            int j;
            String flag = flags[ac];
            ++ac;
            for (j = 0; j < this.recognizedOptions.length && !this.recognizedOptions[j].matches(flag); ++j) {
            }
            if (j == this.recognizedOptions.length) {
                this.error("err.invalid.flag", new Object[]{flag});
                return null;
            }
            Option option = this.recognizedOptions[j];
            if (option.hasArg()) {
                if (ac == flags.length) {
                    this.error("err.req.arg", new Object[]{flag});
                    return null;
                }
                String operand = flags[ac];
                ++ac;
                if (!option.process(flag, operand)) continue;
                return null;
            }
            if (!option.process(flag)) continue;
            return null;
        }
        String sourceString = (String)this.options.get("-source");
        Source source = sourceString != null ? Source.lookup(sourceString) : Source.DEFAULT;
        String targetString = (String)this.options.get("-target");
        Target target2 = target = targetString != null ? Target.lookup(targetString) : Target.DEFAULT;
        if (Character.isDigit(target.name.charAt(0)) && target.compareTo(source.requiredTarget()) < 0) {
            if (targetString != null) {
                if (sourceString == null) {
                    this.warning("warn.target.default.source.conflict", new Object[]{targetString, source.requiredTarget().name});
                } else {
                    this.warning("warn.source.target.conflict", new Object[]{sourceString, source.requiredTarget().name});
                }
                return null;
            }
            this.options.put("-target", source.requiredTarget().name);
        }
        return this.filenames.toList();
    }

    public int compile(String[] args) {
        return this.compile(args, new Context());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compile(String[] args, Context context) {
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!assertionsEnabled) {
            // empty if block
        }
        this.options = Options.instance(context);
        this.filenames = new ListBuffer();
        JavaCompiler comp = null;
        try {
            if (args.length == 0) {
                this.help();
                int n = 2;
                return n;
            }
            List<String> filenames = this.processArgs(CommandLine.parse(args));
            if (filenames == null) {
                int n = 2;
                return n;
            }
            if (filenames.isEmpty()) {
                if (this.options.get("-help") != null || this.options.get("-X") != null) {
                    int n = 0;
                    return n;
                }
                this.error("err.no.source.files", new Object[0]);
                int n = 2;
                return n;
            }
            context.put(Log.outKey, this.out);
            comp = JavaCompiler.instance(context);
            if (comp == null) {
                int e = 3;
                return e;
            }
            List<Symbol.ClassSymbol> cs = comp.compile(filenames);
            if (comp.errorCount() != 0 || this.options.get("-Werror") != null && comp.warningCount() != 0) {
                int n = 1;
                return n;
            }
        }
        catch (IOException ex) {
            this.ioMessage(ex);
            int n = 3;
            return n;
        }
        catch (OutOfMemoryError ex) {
            this.resourceMessage(ex);
            int n = 3;
            return n;
        }
        catch (StackOverflowError ex) {
            this.resourceMessage(ex);
            int n = 3;
            return n;
        }
        catch (FatalError ex) {
            this.feMessage(ex);
            int n = 3;
            return n;
        }
        catch (Throwable ex) {
            if (comp == null || comp.errorCount() == 0 || this.options == null || this.options.get("dev") != null) {
                this.bugMessage(ex);
            }
            int n = 4;
            return n;
        }
        finally {
            if (comp != null) {
                comp.close();
            }
            this.filenames = null;
            this.options = null;
        }
        return 0;
    }

    void bugMessage(Throwable ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.bug", new Object[]{JavaCompiler.version()}));
        ex.printStackTrace(this.out);
    }

    void feMessage(Throwable ex) {
        Log.printLines(this.out, ex.getMessage());
    }

    void ioMessage(Throwable ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.io", new Object[0]));
        ex.printStackTrace(this.out);
    }

    void resourceMessage(Throwable ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.resource", new Object[0]));
        ex.printStackTrace(this.out);
    }

    private static String getLocalizedString(String key, Object[] args) {
        return Main.getText(new StringBuffer().append("javac.").append(key).toString(), args);
    }

    private static void initResource() {
        try {
            messageRB = ResourceBundle.getBundle(javacRB);
        }
        catch (MissingResourceException e) {
            FatalError x = new FatalError("Fatal Error: Resource for javac is missing");
            x.initCause(e);
            throw x;
        }
    }

    private static String getText(String key, Object[] _args) {
        String[] args = new String[_args.length];
        for (int i = 0; i < _args.length; ++i) {
            args[i] = new StringBuffer().append("").append(_args[i]).toString();
        }
        if (messageRB == null) {
            Main.initResource();
        }
        try {
            return MessageFormat.format(messageRB.getString(key), args);
        }
        catch (MissingResourceException e) {
            String msg = "javac message file broken: key={0} arguments={1}, {2}";
            return MessageFormat.format(msg, args);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$tools$javac$main$Main == null ? (class$com$sun$tools$javac$main$Main = Main.class$("com.sun.tools.javac.main.Main")) : class$com$sun$tools$javac$main$Main).desiredAssertionStatus();
    }

    private class HiddenOption
    extends Option {
        HiddenOption(String name) {
            super(name, null, null);
        }

        HiddenOption(String name, String argsNameKey) {
            super(name, argsNameKey, null);
        }

        void help() {
        }

        void xhelp() {
        }
    }

    private class XOption
    extends Option {
        XOption(String name, String argsNameKey, String descrKey) {
            super(name, argsNameKey, descrKey);
        }

        XOption(String name, String descrKey) {
            this(name, null, descrKey);
        }

        void help() {
        }

        void xhelp() {
            super.help();
        }
    }

    private class Option {
        String name;
        String argsNameKey;
        String descrKey;
        boolean hasSuffix;

        Option(String name, String argsNameKey, String descrKey) {
            this.name = name;
            this.argsNameKey = argsNameKey;
            this.descrKey = descrKey;
            char lastChar = name.charAt(name.length() - 1);
            this.hasSuffix = lastChar == ':' || lastChar == '=';
        }

        Option(String name, String descrKey) {
            this(name, null, descrKey);
        }

        public String toString() {
            return this.name;
        }

        boolean hasArg() {
            return this.argsNameKey != null && !this.hasSuffix;
        }

        boolean matches(String arg) {
            return this.hasSuffix ? arg.startsWith(this.name) : arg.equals(this.name);
        }

        void help() {
            String s = "  " + this.helpSynopsis();
            Main.this.out.print(s);
            for (int j = s.length(); j < 29; ++j) {
                Main.this.out.print(" ");
            }
            Log.printLines(Main.this.out, Main.getLocalizedString(this.descrKey, new Object[0]));
        }

        String helpSynopsis() {
            return this.name + (this.argsNameKey == null ? "" : (this.hasSuffix ? "" : " ") + Main.getLocalizedString(this.argsNameKey, new Object[0]));
        }

        void xhelp() {
        }

        boolean process(String option, String arg) {
            Main.this.options.put(option, arg);
            return false;
        }

        boolean process(String option) {
            if (this.hasSuffix) {
                return this.process(this.name, option.substring(this.name.length()));
            }
            return this.process(option, option);
        }
    }
}

