/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import org.netbeans.mdr.persistence.btreeimpl.btreestorage.ActiveBtreeExtent;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeDataFile;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.Converter;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.DeletedBtreeExtent;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.IntHolder;
import org.netbeans.mdr.util.Logger;

class ContinuationBtreeExtent
extends ActiveBtreeExtent {
    static final int CONTINUATION_FIXED_LENGTH = 12;
    static final int MAX_CONTINUATION_DATA_LENGTH = 8180;

    ContinuationBtreeExtent(BtreeDataFile file, int chunkNum, short numChunks) {
        super(file, chunkNum, numChunks);
        this.dataStart = 12;
    }

    ContinuationBtreeExtent(DeletedBtreeExtent del, int length) {
        super(del);
        this.setMyDataLength(length);
        this.dataStart = 12;
    }

    ContinuationBtreeExtent(BtreeDataFile file, int chunkNum, short numChunks, int dLen) {
        super(file, chunkNum, numChunks);
        this.dataStart = 12;
        this.setMyDataLength(dLen);
        this.headerIsDirty = true;
    }

    void readHeaderFromPage(byte[] buffer, IntHolder offset) {
        this.dataLength = Converter.readInt(buffer, offset);
        if (this.dataLength > this.getAvailableDataLength()) {
            Logger.getDefault().log("Bad data length read: ----------------------");
            Logger.getDefault().log("chunk number: " + this.myChunkNum);
            Logger.getDefault().log("dataLength: " + this.dataLength);
            Logger.getDefault().log("available: " + this.getAvailableDataLength());
        }
    }

    protected void writeHeaderToPage(CachedPage page, int offset) {
        Converter.writeInt(page.contents, offset, this.dataLength);
    }

    int getMyDataLength() {
        return this.dataLength;
    }

    int getAvailableDataLength() {
        return this.chunks * 32 - 12;
    }

    short getMagic() {
        return 27499;
    }

    static int getNumChunks(int dataLength) {
        int size = (dataLength + 12 - 1) / 32 + 1;
        return Math.min(size, 256);
    }

    int setMyDataLength(int length) {
        int oldDatalength = this.dataLength;
        this.dataLength = Math.min(length, this.getAvailableDataLength());
        if (oldDatalength != this.dataLength) {
            this.headerIsDirty = true;
        }
        return this.dataLength;
    }

    boolean isMaximum() {
        return this.dataLength == 8180;
    }

    byte getType() {
        return 2;
    }

    String getTypeName() {
        return "continuation";
    }
}

