/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.wizards;

import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.api.ejbjar.Ear;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.api.WebProjectCreateData;
import org.netbeans.modules.web.project.api.WebProjectUtilities;
import org.netbeans.modules.web.project.ui.FoldersListSettings;
import org.netbeans.modules.web.project.ui.wizards.FileSearchUtility;
import org.netbeans.modules.web.project.ui.wizards.ImportBuildfile;
import org.netbeans.modules.web.project.ui.wizards.ImportLocationVisual;
import org.netbeans.modules.web.project.ui.wizards.PanelSourceFolders;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ImportWebProjectWizardIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 1L;
    private String buildfileName = "build.xml";
    private String moduleLoc;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;

    private WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new ThePanel(), new PanelSourceFolders.Panel()};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(ImportWebProjectWizardIterator.class, (String)"LBL_IW_Step1"), NbBundle.getMessage(ImportWebProjectWizardIterator.class, (String)"LBL_IW_Step2")};
    }

    public Set instantiate(TemplateWizard wiz) throws IOException {
        Integer index;
        Project p;
        ProjectWebModule wm;
        Ear ear;
        FileObject libFolder;
        File f;
        FileObject docBase;
        File dirF = (File)wiz.getProperty("projdir");
        if (dirF != null) {
            dirF = FileUtil.normalizeFile((File)dirF);
        }
        File dirSrcF = (File)wiz.getProperty("sourceRoot");
        String name = (String)wiz.getProperty("name");
        String contextPath = (String)wiz.getProperty("contextPath");
        String docBaseName = (String)wiz.getProperty("docBase");
        File[] sourceFolders = (File[])wiz.getProperty("javaRoot");
        File[] testFolders = (File[])wiz.getProperty("testRoot");
        String libName = (String)wiz.getProperty("libFolder");
        String serverInstanceID = (String)wiz.getProperty("serverInstanceID");
        String j2eeLevel = (String)wiz.getProperty("j2eeLevel");
        FileObject wmFO = FileUtil.toFileObject((File)dirSrcF);
        assert (wmFO != null) : "No such dir on disk: " + dirSrcF;
        assert (wmFO.isFolder()) : "Not really a dir: " + dirSrcF;
        if (docBaseName == null || docBaseName.equals("")) {
            docBase = FileSearchUtility.guessDocBase(wmFO);
        } else {
            f = new File(docBaseName);
            docBase = FileUtil.toFileObject((File)f);
        }
        if (libName == null || libName.equals("")) {
            libFolder = FileSearchUtility.guessLibrariesFolder(wmFO);
        } else {
            f = new File(libName);
            libFolder = FileUtil.toFileObject((File)f);
        }
        if (j2eeLevel == null) {
            j2eeLevel = "1.4";
        }
        String buildfile = this.getBuildfile();
        WebProjectCreateData createData = new WebProjectCreateData();
        createData.setProjectDir(dirF);
        createData.setName(name);
        createData.setWebModuleFO(wmFO);
        createData.setSourceFolders(sourceFolders);
        createData.setTestFolders(testFolders);
        createData.setDocBase(docBase);
        createData.setLibFolder(libFolder);
        createData.setJavaEEVersion(j2eeLevel);
        createData.setServerInstanceID(serverInstanceID);
        createData.setBuildfile(buildfile);
        createData.setJavaPlatformName((String)wiz.getProperty("setJavaPlatform"));
        createData.setSourceLevel((String)wiz.getProperty("setSourceLevel"));
        AntProjectHelper h = WebProjectUtilities.importProject(createData);
        FileObject dir = FileUtil.toFileObject((File)dirF);
        Project earProject = (Project)wiz.getProperty("earApplication");
        WebProject createdWebProject = (WebProject)ProjectManager.getDefault().findProject(dir);
        if (earProject != null && createdWebProject != null && (ear = Ear.getEar((FileObject)earProject.getProjectDirectory())) != null) {
            ear.addWebModule(createdWebProject.getAPIWebModule());
        }
        if ((wm = (ProjectWebModule)(p = ProjectManager.getDefault().findProject(dir)).getLookup().lookup(ProjectWebModule.class)) != null) {
            wm.setContextPath(contextPath);
        }
        if ((index = (Integer)wiz.getProperty("nameIndex")) != null) {
            FoldersListSettings.getDefault().setNewProjectCount(index);
        }
        wiz.putProperty("name", null);
        FoldersListSettings.getDefault().setLastUsedServer(serverInstanceID);
        return Collections.singleton(DataObject.find((FileObject)dir));
    }

    private String getBuildfile() {
        return this.buildfileName;
    }

    private void setBuildfile(String name) {
        this.buildfileName = name;
    }

    public void initialize(TemplateWizard wiz) {
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(ImportWebProjectWizardIterator.class, (String)"TXT_WebExtSources"));
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wiz) {
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(ImportWebProjectWizardIterator.class, (String)"LBL_WizardStepsCount"), new Integer(this.index + 1).toString(), new Integer(this.panels.length).toString());
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    public final class ThePanel
    implements WizardDescriptor.ValidatingPanel {
        private ImportLocationVisual panel;
        private WizardDescriptor wizardDescriptor;
        private final Set listeners = new HashSet(1);

        private ThePanel() {
        }

        public Component getComponent() {
            if (this.panel == null) {
                this.panel = new ImportLocationVisual(this);
            }
            return this.panel;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(ThePanel.class);
        }

        public boolean isValid() {
            this.getComponent();
            return this.panel.valid(this.wizardDescriptor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addChangeListener(ChangeListener l) {
            Set set = this.listeners;
            synchronized (set) {
                this.listeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeChangeListener(ChangeListener l) {
            Set set = this.listeners;
            synchronized (set) {
                this.listeners.remove(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void fireChangeEvent() {
            Iterator it;
            Set set = this.listeners;
            synchronized (set) {
                it = new HashSet(this.listeners).iterator();
            }
            ChangeEvent ev = new ChangeEvent(this);
            while (it.hasNext()) {
                ((ChangeListener)it.next()).stateChanged(ev);
            }
        }

        public void readSettings(Object settings) {
            this.wizardDescriptor = (WizardDescriptor)settings;
            this.panel.read(this.wizardDescriptor);
            Object substitute = this.panel.getClientProperty("NewProjectWizard_Title");
            if (substitute != null) {
                this.wizardDescriptor.putProperty("NewProjectWizard_Title", substitute);
            }
        }

        public void storeSettings(Object settings) {
            WizardDescriptor d = (WizardDescriptor)settings;
            this.panel.store(d);
            d.putProperty("NewProjectWizard_Title", null);
            ImportWebProjectWizardIterator.this.moduleLoc = this.panel.moduleLocationTextField.getText().trim();
        }

        public void validate() throws WizardValidationException {
            File dirF = new File(this.panel.projectLocationTextField.getText());
            if (!new File(dirF, "build.xml").exists()) {
                ImportWebProjectWizardIterator.this.setBuildfile("build.xml");
            } else {
                File buildFile = new File(dirF, ImportWebProjectWizardIterator.this.getBuildfile());
                if (buildFile.exists()) {
                    JButton ok = this.createButton("LBL_IW_Buildfile_OK", "ACS_IW_BuildFileDialog_OKButton_LabelMnemonic", "LBL_IW_BuildFileDialog_OK_LabelMnemonic");
                    JButton cancel = this.createButton("LBL_IW_Buildfile_Cancel", "ACS_IW_BuildFileDialog_CancelButton_LabelMnemonic", "LBL_IW_BuildFileDialog_Cancel_LabelMnemonic");
                    ImportBuildfile ibf = new ImportBuildfile(buildFile, ok);
                    DialogDescriptor descriptor = new DialogDescriptor((Object)ibf, NbBundle.getMessage(ImportWebProjectWizardIterator.class, (String)"LBL_IW_BuildfileTitle"), true, new Object[]{ok, cancel}, DialogDescriptor.OK_OPTION, 0, null, null);
                    Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
                    dialog.setVisible(true);
                    if (descriptor.getValue() != ok) {
                        throw new WizardValidationException((JComponent)this.panel.projectLocationTextField, "", "");
                    }
                    ImportWebProjectWizardIterator.this.setBuildfile(ibf.getBuildName());
                }
            }
        }

        private JButton createButton(String labelId, String labelMnemonicId, String mnemonicId) {
            JButton button = new JButton(NbBundle.getMessage(ImportWebProjectWizardIterator.class, (String)labelId));
            button.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportWebProjectWizardIterator.class, (String)labelMnemonicId));
            button.setMnemonic(NbBundle.getMessage(ImportWebProjectWizardIterator.class, (String)mnemonicId).charAt(0));
            return button;
        }
    }
}

