/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.web.api.webmodule.WebFrameworkSupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.customizer.AddFrameworkPanel;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerFrameworks
extends JPanel
implements HelpCtx.Provider,
ListSelectionListener {
    private WebProject project;
    private WebProjectProperties uiProperties;
    private List usedFrameworks = new LinkedList();
    private List newFrameworks = new LinkedList();
    private JButton jButtonAdd;
    private JLabel jLabelConfig;
    private JLabel jLabelFrameworks;
    private JList jListFrameworks;
    private JPanel jPanelConfig;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;

    public CustomizerFrameworks(WebProjectProperties uiProperties) {
        this.uiProperties = uiProperties;
        this.initComponents();
        this.project = uiProperties.getProject();
        this.initFrameworksList(this.project.getAPIWebModule());
    }

    private void initFrameworksList(WebModule webModule) {
        this.jListFrameworks.setModel(new DefaultListModel());
        List frameworks = WebFrameworkSupport.getFrameworkProviders();
        for (int i = 0; i < frameworks.size(); ++i) {
            WebFrameworkProvider framework = (WebFrameworkProvider)frameworks.get(i);
            if (!framework.isInWebModule(webModule)) continue;
            this.usedFrameworks.add(framework);
            ((DefaultListModel)this.jListFrameworks.getModel()).addElement(framework.getName());
        }
        this.jListFrameworks.getSelectionModel().setSelectionMode(0);
        this.jListFrameworks.addListSelectionListener(this);
        if (this.usedFrameworks.size() > 0) {
            this.jListFrameworks.setSelectedIndex(0);
        }
        if (frameworks.size() == this.jListFrameworks.getModel().getSize()) {
            this.jButtonAdd.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jLabelFrameworks = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListFrameworks = new JList();
        this.jButtonAdd = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jLabelConfig = new JLabel();
        this.jPanelConfig = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabelFrameworks.setDisplayedMnemonic(NbBundle.getMessage(CustomizerFrameworks.class, (String)"LBL_CustomizerFrameworks_ListMnemonic").charAt(0));
        this.jLabelFrameworks.setLabelFor(this.jListFrameworks);
        this.jLabelFrameworks.setText(NbBundle.getMessage(CustomizerFrameworks.class, (String)"LBL_UsedFrameworks"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jLabelFrameworks, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jListFrameworks);
        this.jListFrameworks.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerFrameworks.class, (String)"ACS_Frameworks_FrameworksList_A11YDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButtonAdd.setMnemonic(NbBundle.getMessage(CustomizerFrameworks.class, (String)"LBL_CustomizerFrameworks_AddButton_LabelMnemonic").charAt(0));
        this.jButtonAdd.setText(NbBundle.getMessage(CustomizerFrameworks.class, (String)"LBL_AddFramework"));
        this.jButtonAdd.setActionCommand("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomizerFrameworks.this.jButtonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jButtonAdd, gridBagConstraints);
        this.jButtonAdd.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerFrameworks.class, (String)"ACS_Frameworks_AddButton_A11YDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabelConfig.setLabelFor(this.jPanelConfig);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabelConfig, gridBagConstraints);
        this.jPanelConfig.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanelConfig, gridBagConstraints);
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        AddFrameworkPanel panel = new AddFrameworkPanel(this.usedFrameworks);
        JPanel inner = new JPanel();
        inner.setLayout(new GridBagLayout());
        inner.getAccessibleContext().setAccessibleDescription(panel.getAccessibleContext().getAccessibleDescription());
        inner.getAccessibleContext().setAccessibleName(panel.getAccessibleContext().getAccessibleName());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        inner.add((Component)panel, gridBagConstraints);
        DialogDescriptor desc = new DialogDescriptor((Object)inner, NbBundle.getMessage(CustomizerFrameworks.class, (String)"LBL_SelectWebExtension_DialogTitle"));
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        if (res.equals(NotifyDescriptor.YES_OPTION)) {
            this.newFrameworks.addAll(panel.getSelectedFrameworks());
            if (this.newFrameworks != null) {
                this.uiProperties.setNewFrameworks(this.newFrameworks);
                for (int i = 0; i < this.newFrameworks.size(); ++i) {
                    WebFrameworkProvider framework = (WebFrameworkProvider)this.newFrameworks.get(i);
                    if (!((DefaultListModel)this.jListFrameworks.getModel()).contains(framework.getName())) {
                        ((DefaultListModel)this.jListFrameworks.getModel()).addElement(framework.getName());
                    }
                    if (this.usedFrameworks.size() == 0) {
                        this.usedFrameworks.add(framework);
                    } else {
                        for (int j = 0; j < this.usedFrameworks.size(); ++j) {
                            if (((WebFrameworkProvider)this.usedFrameworks.get(j)).getName().equals(framework.getName())) continue;
                            this.usedFrameworks.add(framework);
                            break;
                        }
                    }
                    this.jListFrameworks.setSelectedValue(framework.getName(), true);
                }
            }
        }
        if (WebFrameworkSupport.getFrameworkProviders().size() == this.jListFrameworks.getModel().getSize()) {
            this.jButtonAdd.setEnabled(false);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerFrameworks.class);
    }

    public void valueChanged(ListSelectionEvent e) {
        String frameworkName = (String)this.jListFrameworks.getSelectedValue();
        int selectedIndex = this.jListFrameworks.getSelectedIndex();
        if (selectedIndex != -1) {
            WebFrameworkProvider framework = (WebFrameworkProvider)this.usedFrameworks.get(selectedIndex);
            WebModule wm = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
            if (framework.getName().equals(frameworkName)) {
                if (framework.getConfigurationPanel(wm) != null) {
                    String message = MessageFormat.format(NbBundle.getMessage(CustomizerFrameworks.class, (String)"LBL_FrameworkConfiguration"), frameworkName);
                    this.jLabelConfig.setText(message);
                    this.jPanelConfig.removeAll();
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.gridheight = 0;
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    this.jPanelConfig.add(framework.getConfigurationPanel(wm).getComponent(), gridBagConstraints);
                    this.jPanelConfig.revalidate();
                } else {
                    this.hideConfigPanel();
                }
            }
        } else {
            this.hideConfigPanel();
        }
    }

    private void hideConfigPanel() {
        this.jLabelConfig.setText("");
        this.jPanelConfig.removeAll();
        this.jPanelConfig.repaint();
        this.jPanelConfig.revalidate();
    }
}

