/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.ui.ServletUriPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class SetExecutionUriAction
extends NodeAction {
    public static final String ATTR_EXECUTION_URI = "execution.uri";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performAction(Node[] activatedNodes) {
        DataObject data;
        if (activatedNodes == null || activatedNodes.length != 1 || activatedNodes[0] == null || (data = (DataObject)activatedNodes[0].getCookie(DataObject.class)) == null) return;
        FileObject servletFo = data.getPrimaryFile();
        WebModule webModule = WebModule.getWebModule((FileObject)servletFo);
        String[] urlPatterns = SetExecutionUriAction.getServletMappings(webModule, servletFo);
        if (urlPatterns != null && urlPatterns.length > 0) {
            String oldUri = (String)servletFo.getAttribute(ATTR_EXECUTION_URI);
            ServletUriPanel uriPanel = new ServletUriPanel(urlPatterns, oldUri, false);
            DialogDescriptor desc = new DialogDescriptor((Object)uriPanel, NbBundle.getMessage(SetExecutionUriAction.class, (String)"TTL_setServletExecutionUri"));
            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            if (!res.equals(NotifyDescriptor.YES_OPTION)) return;
            try {
                servletFo.setAttribute(ATTR_EXECUTION_URI, (Object)uriPanel.getServletUri());
                return;
            }
            catch (IOException ex) {}
            return;
        } else {
            String mes = MessageFormat.format(NbBundle.getMessage(SetExecutionUriAction.class, (String)"TXT_missingServletMappings"), servletFo.getName());
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        DataObject data;
        if (activatedNodes != null && activatedNodes.length == 1 && activatedNodes[0] != null && (data = (DataObject)activatedNodes[0].getCookie(DataObject.class)) != null) {
            String mimetype = data.getPrimaryFile().getMIMEType();
            Boolean servletAttr = (Boolean)data.getPrimaryFile().getAttribute("org.netbeans.modules.web.IsServletFile");
            return "text/x-java".equals(mimetype) && Boolean.TRUE.equals(servletAttr);
        }
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SetExecutionUriAction.class);
    }

    public String getName() {
        return NbBundle.getMessage(SetExecutionUriAction.class, (String)"LBL_serveltExecutionUriAction");
    }

    protected String iconResource() {
        return "org/netbeans/modules/web/project/ui/resources/servletUri.gif";
    }

    protected boolean asynchronous() {
        return false;
    }

    public static String[] getServletMappings(WebModule webModule, FileObject javaClass) {
        if (webModule == null) {
            return null;
        }
        FileObject webDir = webModule.getDocumentBase();
        if (webDir == null) {
            return null;
        }
        FileObject fo = webDir.getFileObject("WEB-INF/web.xml");
        if (fo == null) {
            return null;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)javaClass, (String)"classpath/source");
        String className = classPath.getResourceName(javaClass, '.', false);
        try {
            WebApp webApp = DDProvider.getDefault().getDDRoot(fo);
            Servlet[] servlets = webApp.getServlet();
            ArrayList<String> mappingList = new ArrayList<String>();
            for (int i = 0; i < servlets.length; ++i) {
                if (!className.equals(servlets[i].getServletClass())) continue;
                String servletName = servlets[i].getServletName();
                ServletMapping[] maps = webApp.getServletMapping();
                for (int j = 0; j < maps.length; ++j) {
                    String urlPattern;
                    if (!maps[j].getServletName().equals(servletName) || (urlPattern = maps[j].getUrlPattern()) == null) continue;
                    mappingList.add(urlPattern);
                }
            }
            String[] mappings = new String[mappingList.size()];
            mappingList.toArray(mappings);
            return mappings;
        }
        catch (IOException ex) {
            return null;
        }
    }
}

