/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.catalog;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.netbeans.core.IDESettings;
import org.netbeans.modules.autoupdate.AutoModuleNewType;
import org.netbeans.modules.autoupdate.catalog.ModuleBean;
import org.netbeans.modules.autoupdate.catalog.ModuleDeleter;
import org.netbeans.modules.autoupdate.catalog.ModuleDeleterImpl;
import org.netbeans.modules.autoupdate.catalog.ModuleNodeActions;
import org.netbeans.modules.autoupdate.catalog.ModuleNodeUtils;
import org.openide.ErrorManager;
import org.openide.actions.NewAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ToolsAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

public class ModuleNode
extends AbstractNode {
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)ModuleNode.class);
    private static final String MODULE_ITEM_ICON_BASE = "org/netbeans/modules/autoupdate/resources/moduleItem.gif";
    private static final String MODULE_ITEM_DISABLED_BASE = "org/netbeans/modules/autoupdate/resources/moduleItemDisabled.gif";
    private static final String MODULE_ITEM_ERROR_BASE = "org/netbeans/modules/autoupdate/resources/moduleItemError.gif";
    private static final String MODULE_TEST_ITEM_ICON_BASE = "org/netbeans/modules/autoupdate/resources/testModuleItem.gif";
    private static final String MODULES_ICON_BASE = "org/netbeans/modules/autoupdate/resources/modules.gif";
    private static File lastChosenDir = null;
    private static ModuleDeleter deleter;
    private boolean simple = false;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$catalog$ModuleNode$Item;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableDisableAction;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableAllAction;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$UninstallAction;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$netbeans$core$IDESettings;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$catalog$ModuleNode$CategoryNode;

    public ModuleNode() {
        this(false);
    }

    public ModuleNode(boolean simple) {
        super((Children)new Modules(simple));
        this.setName("Modules");
        this.setDisplayName(bundle.getString("CTL_Modules_name"));
        this.setShortDescription(bundle.getString("CTL_Modules_hint"));
        this.setIconBaseWithExtension(MODULES_ICON_BASE);
        this.simple = simple;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ModuleNode.class);
    }

    public Node cloneNode() {
        return new ModuleNode();
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get((Class)NewAction.class), null, SystemAction.get((Class)ModuleNodeActions.SortAction.class), null, SystemAction.get((Class)ToolsAction.class), SystemAction.get((Class)PropertiesAction.class)};
    }

    protected Sheet createSheet() {
        Sheet.Set set = new Sheet.Set();
        set.setName("sorting");
        set.setDisplayName(bundle.getString("LBL_ModuleNode_sheet_sorting"));
        set.put(((Modules)this.getChildren()).createSortingProperty());
        Sheet sheet = new Sheet();
        sheet.put(set);
        return sheet;
    }

    public NewType[] getNewTypes() {
        return new NewType[]{new NewType(){

            public String getName() {
                return bundle.getString("CTL_NewModuleByFile");
            }

            public void create() throws IOException {
                ModuleNode.this.addFile(false);
            }
        }, new NewType(){

            public String getName() {
                return bundle.getString("CTL_NewTestModule");
            }

            public void create() throws IOException {
                ModuleNode.this.addFile(true);
            }
        }, new AutoModuleNewType()};
    }

    void addFile(boolean reloadable) {
        ActionMap parent;
        ActionMap map;
        KeyStroke enter;
        Object value;
        final JFileChooser chooser = new JFileChooser();
        chooser.setFileHidingEnabled(false);
        InputMap im = chooser.getInputMap(1);
        if (im != null && (value = im.get(enter = KeyStroke.getKeyStroke(10, 0))) == null) {
            im.put(enter, "approveSelection");
        }
        if ((map = chooser.getActionMap()) != null && (parent = map.getParent()) != null) {
            final Action original = parent.get("approveSelection");
            parent.put("approveSelection", new AbstractAction(){

                public void actionPerformed(ActionEvent evt) {
                    File file = chooser.getSelectedFile();
                    if (file != null && file.isDirectory()) {
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        chooser.setCurrentDirectory(file);
                    } else if (original != null) {
                        original.actionPerformed(evt);
                    }
                }
            });
        }
        if (lastChosenDir != null) {
            chooser.setCurrentDirectory(lastChosenDir);
        }
        chooser.setFileSelectionMode(0);
        chooser.setApproveButtonText(bundle.getString("CTL_ModuleSelect"));
        chooser.setApproveButtonToolTipText(bundle.getString("CTL_ModuleSelectToolTip"));
        chooser.setFileFilter(new FileFilter(){

            public String getDescription() {
                return bundle.getString("CTL_ModuleSelectFilter");
            }

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".jar");
            }
        });
        int result = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
        lastChosenDir = chooser.getCurrentDirectory();
        if (result == 0) {
            File jar = chooser.getSelectedFile();
            ModuleNode.getAllModules().create(jar, reloadable);
        }
    }

    private static ModuleBean.AllModulesBean getAllModules() {
        return ModuleBean.AllModulesBean.getDefault();
    }

    private static ModuleDeleter getModuleDeleter() {
        if (deleter == null) {
            deleter = new ModuleDeleterImpl();
        }
        return deleter;
    }

    private static final class CategoryNode
    extends AbstractNode {
        private final boolean libraries;
        private final boolean bridges;

        public CategoryNode(boolean bridgeNotLib) {
            this(bridgeNotLib, false);
        }

        private CategoryNode(boolean bridgeNotLib, boolean simple) {
            super((Children)new CategoryChildren(bridgeNotLib, simple));
            this.setName(bridgeNotLib ? "bridges" : "libraries");
            this.setDisplayName(bundle.getString(bridgeNotLib ? "LBL_ModuleNode_bridges" : "LBL_ModuleNode_libraries"));
            this.setIconBaseWithExtension(ModuleNode.MODULES_ICON_BASE);
            this.libraries = !bridgeNotLib;
            this.bridges = bridgeNotLib;
        }

        public CategoryNode(String category) {
            this(category, false);
        }

        private CategoryNode(String category, boolean simple) {
            super((Children)new CategoryChildren(category, simple));
            this.setName(category);
            this.setIconBaseWithExtension(ModuleNode.MODULES_ICON_BASE);
            this.libraries = false;
            this.bridges = false;
        }

        public boolean canDestroy() {
            return ModuleNodeUtils.canUninstall(new Node[]{this});
        }

        public void destroy() {
            ModuleNodeUtils.doUninstall(new Node[]{this});
        }

        public boolean canRename() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$autoupdate$catalog$ModuleNode$CategoryNode == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNode$CategoryNode = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNode$CategoryNode")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNode$CategoryNode);
        }

        public Action[] getActions(boolean context) {
            return new Action[]{SystemAction.get((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableDisableAction == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableDisableAction = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNodeActions$EnableDisableAction")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableDisableAction)), SystemAction.get((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableAllAction == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableAllAction = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNodeActions$EnableAllAction")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableAllAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$UninstallAction == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$UninstallAction = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNodeActions$UninstallAction")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$UninstallAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$SortAction == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$SortAction = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNodeActions$SortAction")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$SortAction)), null, SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ModuleNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }

        protected Sheet createSheet() {
            Sheet s = Sheet.createDefault();
            if (this.libraries || this.bridges) {
                return s;
            }
            Sheet.Set ss = s.get("properties");
            class EnabledProp
            extends PropertySupport.ReadWrite
            implements PropertyChangeListener {
                private Set modules;
                private final String category;
                private PropertyEditor editor;

                public EnabledProp(String category) {
                    super("enabled", Boolean.TYPE, bundle.getString("PROP_modules_enabled"), bundle.getString("HINT_modules_enabled"));
                    this.modules = new HashSet();
                    this.editor = null;
                    this.category = category;
                    this.calculateModules();
                    ModuleNode.getAllModules().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)ModuleNode.getAllModules()));
                }

                public Object getValue() {
                    Boolean val = null;
                    Iterator it = this.modules.iterator();
                    while (it.hasNext()) {
                        ModuleBean m = (ModuleBean)it.next();
                        if (m.isEnabled()) {
                            if (val == null) {
                                val = Boolean.TRUE;
                                continue;
                            }
                            if (val.booleanValue()) continue;
                            return null;
                        }
                        if (val == null) {
                            val = Boolean.FALSE;
                            continue;
                        }
                        if (!val.booleanValue()) continue;
                        return null;
                    }
                    return val;
                }

                public void setValue(Object val) {
                    boolean e = (Boolean)val;
                    Iterator it = this.modules.iterator();
                    ModuleNode.getAllModules().pause();
                    while (it.hasNext()) {
                        ModuleBean m = (ModuleBean)it.next();
                        m.setEnabled(e);
                    }
                    ModuleNode.getAllModules().resume();
                }

                public boolean canWrite() {
                    Iterator it = this.modules.iterator();
                    while (it.hasNext()) {
                        ModuleBean m = (ModuleBean)it.next();
                        if (m.isAutoload() || m.getJar() == null || m.isEager()) {
                            throw new IllegalStateException();
                        }
                        if (!m.isProblematic()) continue;
                        return false;
                    }
                    return true;
                }

                private void calculateModules() {
                    HashSet<ModuleBean> modules2 = new HashSet<ModuleBean>();
                    ModuleBean[] testing = ModuleNode.getAllModules().getModules();
                    for (int i = 0; i < testing.length; ++i) {
                        if (testing[i].getJar() == null || testing[i].isAutoload() || testing[i].isEager() || !this.category.equals(testing[i].getCategory())) continue;
                        modules2.add(testing[i]);
                        if (this.modules.contains(testing[i])) continue;
                        testing[i].addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)testing[i]));
                    }
                    this.modules = modules2;
                }

                public void propertyChange(PropertyChangeEvent evt) {
                    CategoryNode.this.firePropertyChange("enabled", null, null);
                    this.calculateModules();
                }

                public PropertyEditor getPropertyEditor() {
                    if (this.editor == null) {
                        this.editor = super.getPropertyEditor();
                    }
                    return this.editor;
                }
            }
            ss.put((Node.Property)new EnabledProp(this.getName()));
            return s;
        }

        private static final class CategoryChildren
        extends Children.Keys
        implements PropertyChangeListener {
            private final String category;
            private final boolean bridgeNotLib;
            private boolean simple = false;

            public CategoryChildren(boolean bridgeNotLib) {
                this(bridgeNotLib, false);
            }

            public CategoryChildren(String category) {
                this(category, false);
            }

            public CategoryChildren(String category, boolean simple) {
                this.simple = simple;
                this.category = category;
                this.bridgeNotLib = false;
            }

            public CategoryChildren(boolean bridgeNotLib, boolean simple) {
                this.simple = simple;
                this.category = null;
                this.bridgeNotLib = bridgeNotLib;
            }

            protected void addNotify() {
                this.refreshKeys();
                ModuleNode.getAllModules().addPropertyChangeListener(this);
            }

            protected void removeNotify() {
                ModuleNode.getAllModules().removePropertyChangeListener(this);
                this.setKeys(Collections.EMPTY_SET);
            }

            public Node findChild(String name) {
                ModuleNode.getAllModules().waitForModules().waitFinished();
                this.refreshKeys();
                return super.findChild(name);
            }

            private void refreshKeys() {
                ArrayList<ModuleBean> keys = new ArrayList<ModuleBean>();
                ModuleBean[] modules = ModuleNode.getAllModules().getModules();
                for (int i = 0; i < modules.length; ++i) {
                    boolean lib = modules[i].getJar() == null || modules[i].isAutoload();
                    boolean bridge = modules[i].isEager();
                    if (this.category != null && !lib && !bridge && this.category.equals(modules[i].getCategory())) {
                        keys.add(modules[i]);
                        continue;
                    }
                    if (this.category == null && !this.bridgeNotLib && lib) {
                        keys.add(modules[i]);
                        continue;
                    }
                    if (this.category != null || !this.bridgeNotLib || !bridge) continue;
                    keys.add(modules[i]);
                }
                final Collator collator = Collator.getInstance();
                Collections.sort(keys, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        ModuleBean m1 = (ModuleBean)o1;
                        ModuleBean m2 = (ModuleBean)o2;
                        return collator.compare(m1.getDisplayName(), m2.getDisplayName());
                    }
                });
                this.setKeys(keys);
            }

            protected Node[] createNodes(Object key) {
                return new Node[]{new Item((ModuleBean)key, this.simple)};
            }

            public void propertyChange(PropertyChangeEvent ev) {
                this.refreshKeys();
            }
        }
    }

    private static class Modules
    extends Children.Keys
    implements PropertyChangeListener {
        private static final Object LIBRARY_KEY = new Object();
        private static final Object BRIDGE_KEY = new Object();
        private IDESettings settings;
        private boolean simple = false;

        public Modules() {
        }

        public Modules(boolean simple) {
            this.simple = simple;
        }

        private void refreshKeys() {
            if (this.settings == null) {
                this.addNotify();
            }
            Object[] items = ModuleNode.getAllModules().getModules();
            if (this.settings.getModulesSortMode() == 5) {
                Collator collator = Collator.getInstance();
                class CategoryComparator
                implements Comparator {
                    private final /* synthetic */ Comparator val$collator;

                    CategoryComparator(Comparator comparator) {
                        this.val$collator = comparator;
                    }

                    public int compare(Object o1, Object o2) {
                        if (o1 == LIBRARY_KEY) {
                            if (o2 == LIBRARY_KEY) {
                                return 0;
                            }
                            return 1;
                        }
                        if (o2 == LIBRARY_KEY) {
                            return -1;
                        }
                        if (o1 == BRIDGE_KEY) {
                            if (o2 == BRIDGE_KEY) {
                                return 0;
                            }
                            return 1;
                        }
                        if (o2 == BRIDGE_KEY) {
                            return -1;
                        }
                        String name1 = o1 instanceof ModuleBean ? ((ModuleBean)o1).getDisplayName() : (String)o1;
                        String name2 = o2 instanceof ModuleBean ? ((ModuleBean)o2).getDisplayName() : (String)o2;
                        return this.val$collator.compare(name1, name2);
                    }
                }
                TreeSet<Object> categories = new TreeSet<Object>(new CategoryComparator(collator));
                for (int i = 0; i < items.length; ++i) {
                    if (((ModuleBean)items[i]).getJar() == null || ((ModuleBean)items[i]).isAutoload()) {
                        categories.add(LIBRARY_KEY);
                        continue;
                    }
                    if (((ModuleBean)items[i]).isEager()) {
                        categories.add(BRIDGE_KEY);
                        continue;
                    }
                    String category = ((ModuleBean)items[i]).getCategory();
                    if (category != null) {
                        categories.add(category);
                        continue;
                    }
                    categories.add(items[i]);
                }
                this.setKeys(categories);
            } else if (this.settings.getModulesSortMode() != 0) {
                if (this.settings.getModulesSortMode() == 3) {
                    for (int i = 0; i < items.length; ++i) {
                        ((ModuleBean)items[i]).addPropertyChangeListener(this);
                    }
                }
                ArrayList<Object> itemsL = new ArrayList<Object>(Arrays.asList(items));
                Collections.sort(itemsL, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        ModuleBean m1 = (ModuleBean)o1;
                        ModuleBean m2 = (ModuleBean)o2;
                        switch (Modules.this.settings.getModulesSortMode()) {
                            case 2: {
                                return m1.getCodeName().compareTo(m2.getCodeName());
                            }
                            case 3: {
                                int k1 = (m1.isReloadable() ? 0 : 4) + (m1.isAutoload() || m1.isEager() || m1.getJar() == null ? 2 : 0) + (m1.isEnabled() ? 0 : 1);
                                int k2 = (m2.isReloadable() ? 0 : 4) + (m2.isAutoload() || m2.isEager() || m2.getJar() == null ? 2 : 0) + (m2.isEnabled() ? 0 : 1);
                                if (k1 != k2) {
                                    return k1 - k2;
                                }
                            }
                            case 1: {
                                return Collator.getInstance().compare(m1.getDisplayName(), m2.getDisplayName());
                            }
                            case 4: {
                                File j1 = m1.getJar();
                                File j2 = m2.getJar();
                                if (j1 != null) {
                                    if (j2 != null) {
                                        return j1.compareTo(j2);
                                    }
                                    return 1;
                                }
                                if (j2 != null) {
                                    return -1;
                                }
                                return 0;
                            }
                        }
                        return 0;
                    }
                });
                this.setKeys(itemsL);
            } else {
                this.setKeys(items);
            }
        }

        Node.Property createSortingProperty() {
            this.settings = (IDESettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = ModuleNode.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
            return new PropertySupport.ReadWrite("sorted", Integer.TYPE, bundle.getString("PROP_ModuleNode_sorted"), bundle.getString("HINT_ModuleNode_sorted")){

                public Object getValue() {
                    return new Integer(Modules.this.settings.getModulesSortMode());
                }

                public void setValue(Object o) {
                    Modules.this.settings.setModulesSortMode(((Integer)o).intValue());
                }

                public boolean supportsDefaultValue() {
                    return true;
                }

                public void restoreDefaultValue() {
                    this.setValue(new Integer(5));
                }

                public PropertyEditor getPropertyEditor() {
                    return new SortingModeEditor();
                }
            };
        }

        public void addNotify() {
            this.settings = (IDESettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = ModuleNode.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
            ModuleNode.getAllModules().addPropertyChangeListener(this);
            this.settings.addPropertyChangeListener((PropertyChangeListener)this);
            this.refreshKeys();
        }

        public void removeNotify() {
            this.settings.removePropertyChangeListener((PropertyChangeListener)this);
            ModuleNode.getAllModules().removePropertyChangeListener(this);
            ModuleBean[] items = ModuleNode.getAllModules().getModules();
            for (int i = 0; i < items.length; ++i) {
                items[i].removePropertyChangeListener(this);
            }
        }

        public Node findChild(String name) {
            ModuleNode.getAllModules().waitForModules().waitFinished();
            this.refreshKeys();
            return super.findChild(name);
        }

        public void propertyChange(PropertyChangeEvent ev) {
            this.refreshKeys();
        }

        protected Node[] createNodes(Object key) {
            if (key == LIBRARY_KEY) {
                return new Node[]{new CategoryNode(false)};
            }
            if (key == BRIDGE_KEY) {
                return new Node[]{new CategoryNode(true)};
            }
            if (key instanceof String) {
                return new Node[]{new CategoryNode((String)key)};
            }
            return new Node[]{new Item((ModuleBean)key, this.simple)};
        }

        private static final class SortingModeEditor
        extends PropertyEditorSupport {
            private final String[] tags = new String[]{ModuleNode.access$000().getString("LBL_ModuleNode_SORT_UNSORTED"), ModuleNode.access$000().getString("LBL_ModuleNode_SORT_DISPLAYNAME"), ModuleNode.access$000().getString("LBL_ModuleNode_SORT_CODENAME"), ModuleNode.access$000().getString("LBL_ModuleNode_SORT_ENABLED"), ModuleNode.access$000().getString("LBL_ModuleNode_SORT_URL"), ModuleNode.access$000().getString("LBL_ModuleNode_SORT_CATEGORY")};

            public String[] getTags() {
                return this.tags;
            }

            public String getAsText() {
                return this.tags[(Integer)this.getValue()];
            }

            public void setAsText(String text) {
                for (int i = 0; i < this.tags.length; ++i) {
                    if (!this.tags[i].equals(text)) continue;
                    this.setValue(new Integer(i));
                    return;
                }
                throw new IllegalArgumentException();
            }
        }
    }

    static class Item
    extends AbstractNode
    implements PropertyChangeListener {
        private ModuleBean item;
        private boolean listeningToAllModules = false;
        private boolean simple = false;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Item(ModuleBean item) {
            super(Children.LEAF, Lookups.singleton((Object)item));
            this.item = item;
            this.setName(item.getCodeNameBase());
            item.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)item));
            this.updateDisplayStuff();
        }

        public Item(ModuleBean item, boolean simple) {
            this(item);
            this.simple = simple;
        }

        ModuleBean getItem() {
            if (!$assertionsDisabled && this.item == null) {
                throw new AssertionError((Object)"Cannot be called untill item is null.");
            }
            return this.item;
        }

        void uninstall() {
            ModuleDeleter deleter = ModuleNode.getModuleDeleter();
            if (!$assertionsDisabled && deleter == null) {
                throw new AssertionError((Object)"ModuleDeleter must be available.");
            }
            boolean canUninstall = deleter.canDelete(this.item.getModule());
            if (canUninstall) {
                try {
                    deleter.delete(this.item.getModule());
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify(256, (Throwable)ioe);
                }
            } else if (this.canDestroy()) {
                this.item.delete();
            }
        }

        private void updateDisplayStuff() {
            this.setDisplayName(this.item.getDisplayName());
            this.setShortDescription(this.item.getShortDescription());
            this.setIconBaseWithExtension(this.item.isEnabled() ? (this.item.isReloadable() ? ModuleNode.MODULE_TEST_ITEM_ICON_BASE : ModuleNode.MODULE_ITEM_ICON_BASE) : (this.item.isProblematic() ? ModuleNode.MODULE_ITEM_ERROR_BASE : ModuleNode.MODULE_ITEM_DISABLED_BASE));
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.updateDisplayStuff();
            this.firePropertyChange(null, null, null);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$autoupdate$catalog$ModuleNode$Item == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNode$Item = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNode$Item")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNode$Item);
        }

        public Action[] getActions(boolean context) {
            return new Action[]{SystemAction.get((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableDisableAction == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableDisableAction = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNodeActions$EnableDisableAction")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableDisableAction)), SystemAction.get((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableAllAction == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableAllAction = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNodeActions$EnableAllAction")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableAllAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$UninstallAction == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$UninstallAction = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNodeActions$UninstallAction")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$UninstallAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$SortAction == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$SortAction = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNodeActions$SortAction")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$SortAction)), null, SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ModuleNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }

        public Action getPreferredAction() {
            return SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ModuleNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction));
        }

        public void destroy() {
            if (ModuleNodeUtils.confirmUninstall(new Node[]{this})) {
                this.uninstall();
            }
        }

        public boolean canDestroy() {
            boolean canUninstall = ModuleNode.getModuleDeleter().canDelete(this.item.getModule());
            if (!canUninstall) {
                return this.item.getJar() != null;
            }
            return true;
        }

        protected Sheet createSheet() {
            Sheet s = Sheet.createDefault();
            Sheet.Set ss = s.get("properties");
            Sheet.Set sse = Sheet.createExpertSet();
            s.put(sse);
            try {
                PropertySupport.Reflection p;
                if (!this.simple) {
                    p = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String, "getDisplayName", null);
                    p.setName("displayName");
                    p.setDisplayName(bundle.getString("PROP_modules_name"));
                    p.setShortDescription(bundle.getString("HINT_modules_name"));
                    ss.put((Node.Property)p);
                }
                p = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String, "getSpecificationVersion", null);
                p.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
                p.setName("specificationVersion");
                p.setDisplayName(bundle.getString("PROP_modules_specversion"));
                p.setShortDescription(bundle.getString("HINT_modules_specversion"));
                ss.put((Node.Property)p);
                if (!this.simple) {
                    p = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String, "getImplementationVersion", null);
                    p.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
                    p.setName("implementationVersion");
                    p.setDisplayName(bundle.getString("PROP_modules_implversion"));
                    p.setShortDescription(bundle.getString("HINT_modules_implversion"));
                    sse.put((Node.Property)p);
                    p = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String, "getBuildVersion", null);
                    p.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
                    p.setName("buildVersion");
                    p.setDisplayName(bundle.getString("PROP_modules_buildversion"));
                    p.setShortDescription(bundle.getString("HINT_modules_buildversion"));
                    sse.put((Node.Property)p);
                    p = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String, "getShortDescription", null);
                    p.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
                    p.setName("shortDescription");
                    p.setDisplayName(bundle.getString("PROP_modules_shortDescription"));
                    p.setShortDescription(bundle.getString("HINT_modules_shortDescription"));
                    ss.put((Node.Property)p);
                    p = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String, "getLongDescription", null);
                    p.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
                    p.setName("longDescription");
                    p.setDisplayName(bundle.getString("PROP_modules_longDescription"));
                    p.setShortDescription(bundle.getString("HINT_modules_longDescription"));
                    ss.put((Node.Property)p);
                    p = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String, "getCategory", null);
                    p.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
                    p.setName("category");
                    p.setDisplayName(bundle.getString("PROP_modules_category"));
                    p.setShortDescription(bundle.getString("HINT_modules_category"));
                    sse.put((Node.Property)p);
                }
                class EnabledOrReloadableProp
                extends PropertySupport.Reflection {
                    public EnabledOrReloadableProp(String getter, String setter) throws NoSuchMethodException {
                        super((Object)Item.this.item, Boolean.TYPE, getter, setter);
                    }

                    public boolean canWrite() {
                        if (!super.canWrite()) {
                            return false;
                        }
                        if (this.getName().equals("enabled")) {
                            return Item.this.item.getJar() != null && !Item.this.item.isProblematic() && !Item.this.item.isAutoload() && !Item.this.item.isEager();
                        }
                        if (this.getName().equals("reloadable")) {
                            return Item.this.item.getJar() != null && (Item.this.item.isReloadable() || Item.this.item.getJar().getParentFile().canWrite());
                        }
                        throw new IllegalStateException();
                    }
                }
                p = new EnabledOrReloadableProp("isEnabled", "setEnabled");
                p.setName("enabled");
                p.setDisplayName(bundle.getString("PROP_modules_enabled"));
                p.setShortDescription(bundle.getString("HINT_modules_enabled"));
                ss.put((Node.Property)p);
                if (!this.simple) {
                    p = new EnabledOrReloadableProp("isReloadable", "setReloadable");
                    p.setName("reloadable");
                    p.setDisplayName(bundle.getString("PROP_modules_reloadable"));
                    p.setShortDescription(bundle.getString("HINT_modules_reloadable"));
                    sse.put((Node.Property)p);
                    p = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String, "getCodeName", null);
                    p.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
                    p.setName("codeName");
                    p.setDisplayName(bundle.getString("PROP_modules_codename"));
                    p.setShortDescription(bundle.getString("HINT_modules_codename"));
                    sse.put((Node.Property)p);
                    if (this.item.getJar() != null) {
                        p = new PropertySupport.Reflection((Object)this.item, class$java$io$File == null ? (class$java$io$File = ModuleNode.class$("java.io.File")) : class$java$io$File, "getJar", null);
                        p.setName("jar");
                        p.setDisplayName(bundle.getString("PROP_modules_jar"));
                        p.setShortDescription(bundle.getString("HINT_modules_jar"));
                        sse.put((Node.Property)p);
                    }
                    class ClasspathProperty
                    extends PropertySupport.ReadOnly {
                        public ClasspathProperty() {
                            super("classpath", Item.getNbClassPathOrStringClass(), bundle.getString("PROP_modules_classpath"), bundle.getString("HINT_modules_classpath"));
                        }

                        public Object getValue() throws InvocationTargetException {
                            String cp = Item.this.item.getEffectiveClasspath();
                            if (this.getValueType() == (class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String)) {
                                return cp;
                            }
                            try {
                                Constructor c = this.getValueType().getConstructor(class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String);
                                return c.newInstance(cp);
                            }
                            catch (Exception e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    }
                    sse.put((Node.Property)new ClasspathProperty());
                    p = new PropertySupport.Reflection((Object)this.item, Boolean.TYPE, "isAutoload", null);
                    p.setName("autoload");
                    p.setDisplayName(bundle.getString("PROP_modules_autoload"));
                    p.setShortDescription(bundle.getString("HINT_modules_autoload"));
                    sse.put((Node.Property)p);
                    p = new PropertySupport.Reflection((Object)this.item, Boolean.TYPE, "isEager", null);
                    p.setName("eager");
                    p.setDisplayName(bundle.getString("PROP_modules_eager"));
                    p.setShortDescription(bundle.getString("HINT_modules_eager"));
                    sse.put((Node.Property)p);
                    p = new PropertySupport.Reflection((Object)this.item, array$Ljava$lang$String == null ? (array$Ljava$lang$String = ModuleNode.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, "getProvides", null);
                    p.setName("provides");
                    p.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
                    p.setDisplayName(bundle.getString("PROP_modules_provides"));
                    p.setShortDescription(bundle.getString("HINT_modules_provides"));
                    sse.put((Node.Property)p);
                    p = new PropertySupport.Reflection((Object)this.item, array$Ljava$lang$String == null ? (array$Ljava$lang$String = ModuleNode.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, "getProblemDescriptions", null);
                    p.setName("problemDescriptions");
                    p.setDisplayName(bundle.getString("PROP_modules_problemDescriptions"));
                    p.setShortDescription(bundle.getString("HINT_modules_problemDescriptions"));
                    sse.put((Node.Property)p);
                }
            }
            catch (NoSuchMethodException nsme) {
                ErrorManager.getDefault().notify((Throwable)nsme);
            }
            sse.put((Node.Property)new UsedByProp());
            return s;
        }

        private static Class getNbClassPathOrStringClass() {
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ModuleNode.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            try {
                return l.loadClass("org.openide.execution.NbClassPath");
            }
            catch (ClassNotFoundException cnfe) {
                return class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String;
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$autoupdate$catalog$ModuleNode == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNode = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNode")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNode).desiredAssertionStatus();
        }

        private final class UsedByProp
        extends PropertySupport.ReadOnly
        implements ModuleBean.AllModulesBean.RelationCallback,
        PropertyChangeListener {
            private String[] value;

            public UsedByProp() {
                super("usedBy", array$Ljava$lang$String == null ? (array$Ljava$lang$String = ModuleNode.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, bundle.getString("PROP_modules_usedby"), bundle.getString("HINT_modules_usedby"));
                this.value = null;
            }

            public Object getValue() {
                if (this.value != null) {
                    return this.value;
                }
                ModuleBean.AllModulesBean amb = ModuleBean.AllModulesBean.getDefault();
                amb.getRelations(Item.this.item, 3, this);
                if (!Item.this.listeningToAllModules) {
                    Item.this.listeningToAllModules = true;
                    amb.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)amb));
                    ModuleBean[] mods = amb.getModules();
                    for (int i = 0; i < mods.length; ++i) {
                        if (mods[i] == Item.this.item) continue;
                        mods[i].addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)mods[i]));
                    }
                }
                return new String[]{bundle.getString("LBL_please_wait_modules_usedby")};
            }

            public void result(Set modules) {
                ArrayList<String> l = new ArrayList<String>(Math.max(modules.size(), 1));
                if (Item.this.item.isEnabled()) {
                    Iterator it = modules.iterator();
                    while (it.hasNext()) {
                        ModuleBean mb = (ModuleBean)it.next();
                        if (!mb.isEnabled()) continue;
                        l.add(mb.getDisplayName());
                    }
                    Collections.sort(l, Collator.getInstance());
                }
                String[] old = this.value;
                this.value = l.toArray(new String[l.size()]);
                Item.this.firePropertyChange("usedBy", old, this.value);
            }

            public void propertyChange(PropertyChangeEvent ev) {
                this.value = null;
                Item.this.firePropertyChange("usedBy", null, null);
            }
        }
    }
}

