/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

class ServerPanel
extends JPanel {
    static final long serialVersionUID = -3335861235683235775L;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private ButtonGroup buttonGroup;
    private JTable table;

    public ServerPanel() {
        this.initComponents();
        ServerTableModel model = new ServerTableModel();
        this.table = new AutoResizeTable(model);
        this.table.getAccessibleContext().setAccessibleDescription(ServerPanel.getBundle("ACS_ServerPanelTable"));
        this.jLabel1.setLabelFor(this.table);
        this.table.getColumnModel().getColumn(0).setMaxWidth(36);
        this.jScrollPane1.setViewportView(this.table);
        model.refreshContent();
        this.jLabel1.setDisplayedMnemonic(ServerPanel.getBundle("LAB_AvailableServers_Mnemonic").charAt(0));
        this.getAccessibleContext().setAccessibleDescription(ServerPanel.getBundle("ACS_ServerPanel"));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel1.setText(ServerPanel.getBundle("LAB_AvailableServers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.table.setEnabled(enabled);
    }

    private static String getBundle(String key) {
        return NbBundle.getMessage((Class)ServerPanel.class, (String)key);
    }

    static /* synthetic */ String access$000(String x0) {
        return ServerPanel.getBundle(x0);
    }

    class ServerTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{" ", ServerPanel.access$000("LAB_TableHeader")};
        private List atypes = new ArrayList();
        private PropertyChangeListener listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("enabled")) {
                    ServerPanel.this.table.repaint();
                }
            }
        };

        ServerTableModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.atypes.size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return ((AutoupdateType)((Object)this.atypes.get(row))).isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
            return ((AutoupdateType)((Object)this.atypes.get(row))).getName();
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col <= 0;
        }

        public void setValueAt(Object value, int row, int col) {
            if (value instanceof Boolean) {
                ((AutoupdateType)((Object)this.atypes.get(row))).setEnabled((Boolean)value);
            }
        }

        void refreshContent() {
            HashMap allUpdates = new HashMap();
            Enumeration en = AutoupdateType.autoupdateTypes();
            this.atypes.clear();
            while (en.hasMoreElements()) {
                AutoupdateType at = (AutoupdateType)((Object)en.nextElement());
                this.atypes.add(at);
                at.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)((Object)at)));
            }
        }
    }

    static class AutoResizeTable
    extends JTable {
        private boolean firstPaint = true;
        private int hm = 1;

        public AutoResizeTable(TableModel model) {
            super(model);
        }

        public AutoResizeTable(TableModel model, int heightMultiple) {
            this(model);
            this.hm = heightMultiple;
        }

        public void paint(Graphics g) {
            if (this.firstPaint) {
                this.adjustRowHeight(g);
                this.firstPaint = false;
                return;
            }
            super.paint(g);
        }

        private void adjustRowHeight(Graphics g) {
            Font f = this.getFont();
            FontMetrics fm = g.getFontMetrics(f);
            int rowHeight = this.hm * fm.getHeight();
            this.setRowHeight(this.hm == 1 ? rowHeight + 4 : rowHeight);
        }
    }
}

