/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.ChangeSupport;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SourceGroupSupport;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SourceGroupUISupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.dialogs.BrowseFolders;
import org.netbeans.modules.web.jsf.wizards.JSFClinetGenerator;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class PersistenceClientSetupPanelVisual
extends JPanel
implements DocumentListener {
    private WizardDescriptor wizard;
    private Project project;
    private JTextComponent packageComboBoxEditor;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton browseFolderButton;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JTextField jsfFolder;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JComboBox packageComboBox;
    private JLabel packageLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;

    public PersistenceClientSetupPanelVisual(WizardDescriptor wizard) {
        this.wizard = wizard;
        this.initComponents();
        this.packageComboBoxEditor = (JTextComponent)this.packageComboBox.getEditor().getEditorComponent();
        Document packageComboBoxDocument = this.packageComboBoxEditor.getDocument();
        packageComboBoxDocument.addDocumentListener(this);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jsfFolder = new JTextField();
        this.browseFolderButton = new JButton();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.packageLabel = new JLabel();
        this.packageComboBox = new JComboBox();
        this.setName(NbBundle.getMessage(PersistenceClientSetupPanelVisual.class, (String)"LBL_JSFPagesAndClasses"));
        this.jLabel2.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("ACS_JSF_Pages").charAt(0));
        this.jLabel2.setText(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("LBL_JSF_pages_folder"));
        this.browseFolderButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("ACS_Browse2").charAt(0));
        this.browseFolderButton.setText(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("LBL_Browse"));
        this.browseFolderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PersistenceClientSetupPanelVisual.this.browseFolderButtonActionPerformed(evt);
            }
        });
        this.jLabel3.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("ACS_Controller").charAt(0));
        this.jLabel3.setText(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("LBL_JSF_Managed_bean"));
        this.jLabel4.setText(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MSG_Jsf_Pages_Location"));
        this.jLabel5.setText(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MSG_Folders"));
        this.projectLabel.setText(NbBundle.getMessage(PersistenceClientSetupPanelVisual.class, (String)"LBL_Project"));
        this.projectTextField.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(PersistenceClientSetupPanelVisual.class, (String)"LBL_SrcLocation"));
        this.locationComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PersistenceClientSetupPanelVisual.this.locationComboBoxActionPerformed(evt);
            }
        });
        this.packageLabel.setText(NbBundle.getMessage(PersistenceClientSetupPanelVisual.class, (String)"LBL_Package"));
        this.packageComboBox.setEditable(true);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel4).addContainerGap(321, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jsfFolder, -1, 335, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browseFolderButton)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.projectLabel).add((Component)this.locationLabel).add((Component)this.packageLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.locationComboBox, 0, 462, Short.MAX_VALUE).add((Component)this.projectTextField, -1, 462, Short.MAX_VALUE).add((Component)this.packageComboBox, 0, 462, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel5).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jsfFolder, -2, -1, -2).add((Component)this.browseFolderButton)).add(27, 27, 27).add((Component)this.jLabel5).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.projectLabel).add((Component)this.projectTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.locationLabel).add((Component)this.locationComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.packageLabel).add((Component)this.packageComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabel3).addContainerGap(70, Short.MAX_VALUE)));
    }

    private void locationComboBoxActionPerformed(ActionEvent evt) {
        this.locationChanged();
    }

    private void browseFolderButtonActionPerformed(ActionEvent evt) {
        Sources s = (Sources)Templates.getProject((WizardDescriptor)this.wizard).getLookup().lookup(Sources.class);
        SourceGroup[] groups = s.getSourceGroups("doc_root");
        FileObject fo = BrowseFolders.showDialog(groups);
        if (fo != null) {
            String res = "/" + JSFConfigUtilities.getResourcePath(groups, fo, '/', true);
            this.jsfFolder.setText(res);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    boolean valid(WizardDescriptor wizard) {
        List entities = (List)wizard.getProperty("EntityClass");
        String controllerPkg = this.getPackage();
        boolean filesAlreadyExist = false;
        String troubleMaker = "";
        for (Entity entity : entities) {
            String fqn;
            String entityClass = entity.getClass2();
            String simpleClassName = JSFClinetGenerator.simpleClassName(entityClass);
            String firstLower = simpleClassName.substring(0, 1).toLowerCase() + simpleClassName.substring(1);
            String folder = this.jsfFolder.getText().endsWith("/") ? this.jsfFolder.getText() : this.jsfFolder.getText() + "/";
            folder = folder + firstLower;
            String controller = controllerPkg + "." + simpleClassName + "Controller";
            String string = fqn = this.getPackage().length() > 0 ? this.getPackage().replace('.', '/') + "/" + simpleClassName : simpleClassName;
            if (this.getLocationValue().getRootFolder().getFileObject(fqn + "Controller.java") != null) {
                filesAlreadyExist = true;
                troubleMaker = controllerPkg + "." + simpleClassName + "Controller.java";
                break;
            }
            if (this.getLocationValue().getRootFolder().getFileObject(fqn + "Converter.java") == null) continue;
            filesAlreadyExist = true;
            troubleMaker = controllerPkg + "." + simpleClassName + "Converter.java";
            break;
        }
        if (filesAlreadyExist) {
            wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientSetupPanelVisual.class, (String)"MSG_FilesAlreadyExist", (Object)troubleMaker));
            return false;
        }
        wizard.putProperty("WizardPanel_errorMessage", null);
        return true;
    }

    public SourceGroup getLocationValue() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    public String getPackage() {
        return this.packageComboBoxEditor.getText();
    }

    private void locationChanged() {
        this.updateSourceGroupPackages();
        this.changeSupport.fireChange();
    }

    void read(WizardDescriptor settings) {
        this.jsfFolder.setText((String)settings.getProperty("JSFFolder"));
        this.project = Templates.getProject((WizardDescriptor)settings);
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)settings);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        SourceGroup[] sourceGroups = SourceGroupSupport.getJavaSourceGroups((Project)this.project);
        SourceGroupUISupport.connect((JComboBox)this.locationComboBox, (SourceGroup[])sourceGroups);
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.updateSourceGroupPackages();
        if (targetFolder != null) {
            SourceGroup targetSourceGroup = SourceGroupSupport.getFolderSourceGroup((SourceGroup[])sourceGroups, (FileObject)targetFolder);
            if (targetSourceGroup != null) {
                this.locationComboBox.setSelectedItem(targetSourceGroup);
                String targetPackage = SourceGroupSupport.getPackageForFolder((SourceGroup)targetSourceGroup, (FileObject)targetFolder);
                if (targetPackage != null) {
                    this.packageComboBoxEditor.setText(targetPackage);
                }
            }
            if (FileUtil.isParentOf((FileObject)WebModule.getWebModule((FileObject)targetFolder).getDocumentBase(), (FileObject)targetFolder)) {
                Sources s = (Sources)Templates.getProject((WizardDescriptor)this.wizard).getLookup().lookup(Sources.class);
                SourceGroup[] groups = s.getSourceGroups("doc_root");
                this.jsfFolder.setText("/" + JSFConfigUtilities.getResourcePath(groups, targetFolder, '/', true));
            }
        }
    }

    void store(WizardDescriptor settings) {
        settings.putProperty("JSFFolder", (Object)this.jsfFolder.getText());
        settings.putProperty("ControllerBean", (Object)this.getPackage());
        try {
            Templates.setTargetFolder((WizardDescriptor)settings, (FileObject)SourceGroupSupport.getFolderForPackage((SourceGroup)this.getLocationValue(), (String)this.getPackage()));
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    private void updateSourceGroupPackages() {
        SourceGroup sourceGroup = (SourceGroup)this.locationComboBox.getSelectedItem();
        ComboBoxModel model = PackageView.createListView((SourceGroup)sourceGroup);
        if (model.getSelectedItem() != null && model.getSelectedItem().toString().startsWith("META-INF") && model.getSize() > 1) {
            model.setSelectedItem(model.getElementAt(1));
        }
        this.packageComboBox.setModel(model);
    }

    public void insertUpdate(DocumentEvent e) {
        this.changeSupport.fireChange();
    }

    public void removeUpdate(DocumentEvent e) {
        this.changeSupport.fireChange();
    }

    public void changedUpdate(DocumentEvent e) {
        this.changeSupport.fireChange();
    }
}

