/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.samples;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.derby.api.DerbyDatabases;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.samples.JavaEESamplesWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class JavaEESamplesPanelVisual
extends JPanel
implements DocumentListener {
    private boolean withDB = false;
    private JavaEESamplesWizardPanel panel;
    private JButton browseButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JTextArea infoDBLocation;
    private JLabel lblDBLocation;
    private JLabel lblDBName;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JTextField txtDBLocation;
    private JTextField txtDBName;

    public JavaEESamplesPanelVisual(JavaEESamplesWizardPanel panel, boolean withDB) {
        this.initComponents();
        this.panel = panel;
        this.withDB = withDB;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.txtDBName.getDocument().addDocumentListener(this);
        if (!withDB) {
            this.txtDBName.setVisible(false);
            this.lblDBName.setVisible(false);
            this.txtDBLocation.setVisible(false);
            this.lblDBLocation.setVisible(false);
            this.infoDBLocation.setVisible(false);
        }
    }

    public String getProjectName() {
        return this.projectNameTextField.getText();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.lblDBName = new JLabel();
        this.txtDBName = new JTextField();
        this.lblDBLocation = new JLabel();
        this.txtDBLocation = new JTextField();
        this.infoDBLocation = new JTextArea();
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/samples/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)bundle.getString("LBL_ProjectName"));
        this.projectNameTextField.setEditable(false);
        this.projectNameTextField.setEnabled(false);
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)bundle.getString("LBL_ProjectLocation"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)bundle.getString("LBL_Browse"));
        this.browseButton.setActionCommand("BROWSE");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaEESamplesPanelVisual.this.browseButtonActionPerformed(evt);
            }
        });
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)bundle.getString("LBL_ProjectFolder"));
        this.createdFolderTextField.setEditable(false);
        this.createdFolderTextField.setEnabled(false);
        this.lblDBName.setLabelFor(this.txtDBName);
        Mnemonics.setLocalizedText((JLabel)this.lblDBName, (String)NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"LBL_DBName"));
        this.lblDBLocation.setLabelFor(this.txtDBLocation);
        Mnemonics.setLocalizedText((JLabel)this.lblDBLocation, (String)NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"LBL_DBLocation"));
        this.txtDBLocation.setEditable(false);
        this.txtDBLocation.setEnabled(false);
        this.infoDBLocation.setColumns(20);
        this.infoDBLocation.setEditable(false);
        this.infoDBLocation.setLineWrap(true);
        this.infoDBLocation.setRows(5);
        this.infoDBLocation.setText(NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"CreateDatabasePanelVisual.infoTextArea.text"));
        this.infoDBLocation.setWrapStyleWord(true);
        this.infoDBLocation.setFocusable(false);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.infoDBLocation).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.projectNameLabel).add((Component)this.projectLocationLabel).add((Component)this.createdFolderLabel).add((Component)this.lblDBName).add((Component)this.lblDBLocation)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.txtDBName, -1, 224, Short.MAX_VALUE).add((Component)this.createdFolderTextField, -1, 224, Short.MAX_VALUE).add((Component)this.txtDBLocation, -1, 224, Short.MAX_VALUE).add((Component)this.projectLocationTextField, -1, 224, Short.MAX_VALUE).add((Component)this.projectNameTextField, -1, 224, Short.MAX_VALUE)))).addPreferredGap(0).add((Component)this.browseButton)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.projectNameLabel).add((Component)this.projectNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.projectLocationLabel).add((Component)this.projectLocationTextField, -2, -1, -2).add((Component)this.browseButton)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.createdFolderLabel).add((Component)this.createdFolderTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblDBName).add((Component)this.txtDBName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lblDBLocation).add((Component)this.txtDBLocation, -2, -1, -2)).add(24, 24, 24).add((Component)this.infoDBLocation, -2, 90, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if ("BROWSE".equals(command)) {
            File f;
            JFileChooser chooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
            chooser.setDialogTitle(NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"LBL_TITLE"));
            chooser.setFileSelectionMode(1);
            String path = this.projectLocationTextField.getText();
            if (path.length() > 0 && (f = new File(path)).exists()) {
                chooser.setSelectedFile(f);
            }
            if (0 == chooser.showOpenDialog(this)) {
                File projectDir = chooser.getSelectedFile();
                this.projectLocationTextField.setText(FileUtil.normalizeFile((File)projectDir).getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        File destFolder;
        File projLoc;
        if (!this.isJavaEECapableServerRegistered()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"ERR_MissingJavaEE5AppServer"));
            return false;
        }
        if (this.projectNameTextField.getText().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"MSG_InvalidProjectName"));
            return false;
        }
        String projectLocation = this.projectLocationTextField.getText();
        File f = FileUtil.normalizeFile((File)new File(projectLocation).getAbsoluteFile());
        if (!f.isDirectory() || projectLocation.length() == 0) {
            String message = NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"MSG_InvalidPath");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)message);
            return false;
        }
        for (projLoc = destFolder = FileUtil.normalizeFile((File)new File(this.createdFolderTextField.getText()).getAbsoluteFile()); projLoc != null && !projLoc.exists(); projLoc = projLoc.getParentFile()) {
        }
        if (projLoc == null || !projLoc.canWrite()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"MSG_FolderCannotBeCreated"));
            return false;
        }
        if (FileUtil.toFileObject((File)projLoc) == null) {
            String message = NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"MSG_InvalidPath");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)message);
            return false;
        }
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"MSG_FolderAlreadyExists"));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        return this.withDB ? this.validDBData(wizardDescriptor) : true;
    }

    boolean validDBData(WizardDescriptor wizardDescriptor) {
        String dbName = this.txtDBName.getText();
        String errorMsg = null;
        if (DerbyDatabases.isDerbyRegistered()) {
            int illegalChar = DerbyDatabases.getFirstIllegalCharacter((String)dbName);
            if (illegalChar > -1) {
                errorMsg = NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"ERR_DatabaseNameIllegalChar", (Object)Character.valueOf((char)illegalChar));
            } else if (DerbyDatabases.databaseExists((String)dbName)) {
                errorMsg = NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"ERR_DatabaseDirectoryExists", (Object)dbName);
            } else if (dbName.length() == 0) {
                errorMsg = NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"ERR_DatabaseNameEmpty");
            }
        } else {
            errorMsg = NbBundle.getMessage(JavaEESamplesPanelVisual.class, (String)"ERR_JavaDBNotRegistered");
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)errorMsg);
        return errorMsg == null;
    }

    void store(WizardDescriptor d) {
        String name = this.projectNameTextField.getText().trim();
        String folder = this.createdFolderTextField.getText().trim();
        d.putProperty("projdir", (Object)new File(folder));
        d.putProperty("name", (Object)name);
        if (this.withDB) {
            String dbName = this.txtDBName.getText().trim();
            d.putProperty("dbName", (Object)dbName);
        }
    }

    void read(WizardDescriptor settings) {
        File projectLocation = (File)settings.getProperty("projdir");
        projectLocation = projectLocation == null || projectLocation.getParentFile() == null || !projectLocation.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : projectLocation.getParentFile();
        this.projectLocationTextField.setText(projectLocation.getAbsolutePath());
        String projectName = (String)settings.getProperty("name");
        if (projectName == null) {
            projectName = "sample";
        }
        this.projectNameTextField.setText(projectName);
        this.projectNameTextField.selectAll();
        if (this.withDB) {
            String dbName = DerbyDatabases.getFirstFreeDatabaseName((String)projectName);
            this.txtDBName.setText(dbName);
            this.txtDBName.selectAll();
            this.updateDBPath(dbName);
        }
    }

    void validate(WizardDescriptor d) throws WizardValidationException {
    }

    public void changedUpdate(DocumentEvent e) {
        this.update(e);
    }

    public void insertUpdate(DocumentEvent e) {
        this.update(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.update(e);
    }

    private void update(DocumentEvent e) {
        Document doc;
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange("name", null, this.projectNameTextField.getText());
        }
        if (this.projectLocationTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange("projdir", null, this.projectLocationTextField.getText());
        }
        if ((doc = e.getDocument()) == this.projectNameTextField.getDocument() || doc == this.projectLocationTextField.getDocument()) {
            String projectName = this.projectNameTextField.getText();
            String projectFolder = this.projectLocationTextField.getText();
            this.createdFolderTextField.setText(projectFolder + File.separatorChar + projectName);
        } else if (doc == this.txtDBName.getDocument()) {
            String dbName = this.txtDBName.getText();
            this.firePropertyChange("dbName", null, dbName);
            this.updateDBPath(dbName);
        }
        this.panel.fireChangeEvent();
    }

    private void updateDBPath(String dbName) {
        String dbPath = new File(DerbyDatabases.getSystemHome(), dbName).getPath();
        this.txtDBLocation.setText(dbPath);
    }

    private boolean isJavaEECapableServerRegistered() {
        for (String serverInstanceID : Deployment.getDefault().getServerInstanceIDs()) {
            J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceID);
            if (!j2eePlatform.getSupportedSpecVersions().contains("1.5")) continue;
            return true;
        }
        return false;
    }
}

