/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.explorer;

import java.util.HashMap;
import java.util.Map;
import org.openide.util.Lookup;

public abstract class PsSettings {
    private static PsSettings defaultInstance = null;

    protected PsSettings() {
    }

    public static PsSettings getDefault() {
        if (defaultInstance == null && (defaultInstance = (PsSettings)Lookup.getDefault().lookup(PsSettings.class)) == null) {
            defaultInstance = new Trivial();
        }
        return defaultInstance;
    }

    public abstract int getInt(String var1, int var2);

    public abstract void putInt(String var1, int var2);

    public abstract void putBoolean(String var1, boolean var2);

    public abstract boolean getBoolean(String var1, boolean var2);

    public abstract void put(String var1, String var2);

    public abstract String get(String var1, String var2);

    private static class Trivial
    extends PsSettings {
        private Map map = new HashMap();

        private Trivial() {
        }

        public String get(String key, String defaultValue) {
            String result = (String)this.map.get(key);
            if (result == null) {
                result = defaultValue;
            }
            return result;
        }

        public boolean getBoolean(String key, boolean defaultValue) {
            Boolean result = (Boolean)this.map.get(key);
            if (result == null) {
                return defaultValue;
            }
            return result;
        }

        public int getInt(String key, int defaultValue) {
            Integer i = (Integer)this.map.get(key);
            if (i == null) {
                return defaultValue;
            }
            return i;
        }

        public void put(String key, String value) {
            this.map.put(key, value);
        }

        public void putBoolean(String key, boolean value) {
            this.map.put(key, value ? Boolean.TRUE : Boolean.FALSE);
        }

        public void putInt(String key, int value) {
            this.map.put(key, new Integer(value));
        }
    }
}

