/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.ui;

import java.net.URLClassLoader;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.modules.websvc.registry.ui.ArrayTypeTreeNode;
import org.netbeans.modules.websvc.registry.ui.ReflectionHelper;
import org.netbeans.modules.websvc.registry.ui.TypeNodeData;
import org.netbeans.modules.websvc.registry.ui.WebServiceReflectionException;
import org.openide.ErrorManager;

public class StructureTypeTreeNode
extends DefaultMutableTreeNode {
    private URLClassLoader urlClassLoader;
    private String packageName;

    public StructureTypeTreeNode(Object userObject, URLClassLoader inClassLoader, String inPackageName) {
        super(userObject);
        this.urlClassLoader = inClassLoader;
        this.packageName = inPackageName;
    }

    public void updateValueOfChild(TypeNodeData inData) {
        TypeNodeData data = (TypeNodeData)this.getUserObject();
        try {
            ReflectionHelper.setStructureValue(data, inData, this.urlClassLoader, this.packageName);
        }
        catch (WebServiceReflectionException wsfe) {
            Throwable cause = wsfe.getCause();
            ErrorManager.getDefault().notify(cause);
            ErrorManager.getDefault().log(this.getClass().getName() + ": Error trying to update Children of a Structure on: " + data.getParameterType().getFormalName() + "WebServiceReflectionException=" + cause);
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.getParent();
        if (null != parentNode && parentNode instanceof ArrayTypeTreeNode) {
            ((ArrayTypeTreeNode)parentNode).updateValueOfChildren();
        } else if (null != parentNode && parentNode instanceof StructureTypeTreeNode) {
            ((StructureTypeTreeNode)parentNode).updateValueOfChild(data);
        }
    }
}

