/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.netbeans.modules.options.OptionsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;

public class OptionsWindowAction
extends AbstractAction {
    private static Dialog dialog;
    private static WeakReference optionsDialogDescriptor;
    private static ErrorManager log;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public OptionsWindowAction() {
        this.putValue("Name", OptionsWindowAction.loc("CTL_Options_Window_Action"));
    }

    public void actionPerformed(ActionEvent evt) {
        if (dialog != null) {
            dialog.setVisible(true);
            dialog.toFront();
            log.log("Front Options Dialog");
            return;
        }
        DialogDescriptor descriptor = (DialogDescriptor)optionsDialogDescriptor.get();
        OptionsPanel optionsPanel = null;
        if (descriptor == null) {
            Object[] objectArray;
            JButton bClassic = (JButton)OptionsWindowAction.loc(new JButton(), "CTL_Classic");
            JButton bOK = (JButton)OptionsWindowAction.loc(new JButton(), "CTL_OK");
            optionsPanel = new OptionsPanel();
            String string = OptionsWindowAction.loc("CTL_Options_Dialog_Title");
            if (Utilities.getOperatingSystem() == 4096) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = DialogDescriptor.CANCEL_OPTION;
                objectArray = objectArray2;
                objectArray2[1] = bOK;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = bOK;
                objectArray = objectArray3;
                objectArray3[1] = DialogDescriptor.CANCEL_OPTION;
            }
            descriptor = new DialogDescriptor((Object)optionsPanel, string, false, objectArray, DialogDescriptor.OK_OPTION, 0, null, null);
            descriptor.setAdditionalOptions(new Object[]{bClassic});
            descriptor.setHelpCtx(optionsPanel.getHelpCtx());
            OptionsPanelListener listener = new OptionsPanelListener(descriptor, optionsPanel, bOK, bClassic);
            descriptor.setButtonListener((ActionListener)listener);
            optionsPanel.addPropertyChangeListener(listener);
            optionsDialogDescriptor = new WeakReference<DialogDescriptor>(descriptor);
            log.log("Create new Options Dialog");
        } else {
            optionsPanel = (OptionsPanel)descriptor.getMessage();
            optionsPanel.update();
            log.log("Reopen Options Dialog");
        }
        dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.setVisible(true);
        dialog.addWindowListener(new MyWindowListener(optionsPanel));
        descriptor = null;
    }

    private static String loc(String key) {
        return NbBundle.getMessage((Class)OptionsWindowAction.class, (String)key);
    }

    private static Component loc(Component c, String key) {
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)OptionsWindowAction.loc(key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)OptionsWindowAction.loc(key));
        }
        return c;
    }

    static {
        optionsDialogDescriptor = new WeakReference<Object>(null);
        log = ErrorManager.getDefault().getInstance(OptionsWindowAction.class.getName());
    }

    class OpenOptionsListener
    implements ActionListener {
        OpenOptionsListener() {
        }

        public void actionPerformed(ActionEvent e) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    log.log("Options Dialog - Back to modern.");
                    OptionsWindowAction.this.actionPerformed(new ActionEvent(this, 0, "Open"));
                }
            });
        }
    }

    private class MyWindowListener
    implements WindowListener {
        private OptionsPanel optionsPanel;

        MyWindowListener(OptionsPanel optionsPanel) {
            this.optionsPanel = optionsPanel;
        }

        public void windowClosing(WindowEvent e) {
            if (dialog == null) {
                return;
            }
            log.log("Options Dialog - windowClosed ");
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    MyWindowListener.this.optionsPanel.cancel();
                }
            });
            dialog = null;
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }
    }

    private class OptionsPanelListener
    implements PropertyChangeListener,
    ActionListener {
        private DialogDescriptor descriptor;
        private OptionsPanel optionsPanel;
        private JButton bOK;
        private JButton bClassic;

        OptionsPanelListener(DialogDescriptor descriptor, OptionsPanel optionsPanel, JButton bOK, JButton bClassic) {
            this.descriptor = descriptor;
            this.optionsPanel = optionsPanel;
            this.bOK = bOK;
            this.bClassic = bClassic;
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (ev.getPropertyName().equals("buranhelpCtx")) {
                this.descriptor.setHelpCtx(this.optionsPanel.getHelpCtx());
            } else if (ev.getPropertyName().equals("buranvalid")) {
                this.bOK.setEnabled(this.optionsPanel.dataValid());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(ActionEvent e) {
            if (dialog == null) {
                return;
            }
            if (e.getSource() == this.bOK) {
                log.log("Options Dialog - Ok pressed.");
                Dialog d = dialog;
                dialog = null;
                d.dispose();
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        OptionsPanelListener.this.optionsPanel.save();
                    }
                });
                return;
            }
            if (e.getSource() == DialogDescriptor.CANCEL_OPTION || e.getSource() == DialogDescriptor.CLOSED_OPTION) {
                log.log("Options Dialog - Cancel pressed.");
                Dialog d = dialog;
                dialog = null;
                d.dispose();
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        OptionsPanelListener.this.optionsPanel.cancel();
                    }
                });
                return;
            }
            if (e.getSource() != this.bClassic) return;
            log.log("Options Dialog - Classic pressed.");
            Dialog d = dialog;
            dialog = null;
            if (this.optionsPanel.isChanged()) {
                NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)OptionsWindowAction.loc("CTL_Some_values_changed"), 1, 3);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                if (result == NotifyDescriptor.YES_OPTION) {
                    d.dispose();
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            OptionsPanelListener.this.optionsPanel.save();
                        }
                    });
                } else {
                    if (result != NotifyDescriptor.NO_OPTION) {
                        dialog = d;
                        return;
                    }
                    d.dispose();
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            OptionsPanelListener.this.optionsPanel.cancel();
                        }
                    });
                }
            } else {
                d.dispose();
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        OptionsPanelListener.this.optionsPanel.cancel();
                    }
                });
            }
            try {
                ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = OptionsWindowAction.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
                Class<?> clz = cl.loadClass("org.netbeans.core.actions.OptionsAction");
                CallableSystemAction a = (CallableSystemAction)SystemAction.findObject(clz, (boolean)true);
                a.putValue("additionalActionName", (Object)OptionsWindowAction.loc("CTL_Modern"));
                a.putValue("optionsDialogTitle", (Object)OptionsWindowAction.loc("CTL_Classic_Title"));
                a.putValue("additionalActionListener", (Object)new OpenOptionsListener());
                a.performAction();
                return;
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }
}

