/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.IOException;
import org.netbeans.Module;
import org.netbeans.core.startup.CoreBridge;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.StartLog;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class MainLookup
extends ProxyLookup {
    private static boolean started = false;
    private static ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private static InstanceContent instanceContent = new InstanceContent();
    private static Lookup instanceLookup = new AbstractLookup((AbstractLookup.Content)instanceContent);

    public static void startedNbTopManager() {
        started = true;
    }

    public MainLookup() {
        super(new Lookup[]{Lookups.metaInfServices((ClassLoader)classLoader), Lookups.singleton((Object)classLoader), Lookup.EMPTY, instanceLookup});
    }

    public static final void systemClassLoaderChanged(ClassLoader nue) {
        if (classLoader != nue) {
            classLoader = nue;
            MainLookup l = (MainLookup)Lookup.getDefault();
            Lookup[] delegates = l.getLookups();
            Lookup[] newDelegates = (Lookup[])delegates.clone();
            newDelegates[0] = Lookups.metaInfServices((ClassLoader)classLoader);
            newDelegates[1] = Lookups.singleton((Object)classLoader);
            l.setLookups(newDelegates);
        } else {
            MainLookup.moduleClassLoadersUp();
        }
    }

    public static final void moduleClassLoadersUp() {
        MainLookup l = (MainLookup)Lookup.getDefault();
        Lookup[] newDelegates = null;
        Lookup[] delegates = l.getLookups();
        newDelegates = (Lookup[])delegates.clone();
        newDelegates[0] = Lookups.metaInfServices((ClassLoader)classLoader);
        l.setLookups(newDelegates);
    }

    public static final void moduleLookupReady(Lookup moduleLookup) {
        MainLookup l = (MainLookup)Lookup.getDefault();
        Lookup[] newDelegates = (Lookup[])l.getLookups().clone();
        newDelegates[2] = moduleLookup;
        l.setLookups(newDelegates);
    }

    public static final void modulesClassPathInitialized() {
        Lookup lookup = Lookup.getDefault();
        StartLog.logProgress("Got Lookup");
        ((MainLookup)lookup).doInitializeLookup();
    }

    public static void register(Object obj) {
        instanceContent.add(obj);
    }

    public static void register(Object obj, InstanceContent.Convertor conv) {
        instanceContent.add(obj, conv);
    }

    public static void unregister(Object obj) {
        instanceContent.remove(obj);
    }

    public static void unregister(Object obj, InstanceContent.Convertor conv) {
        instanceContent.remove(obj, conv);
    }

    private final void doInitializeLookup() {
        Lookup[] arr = new Lookup[]{this.getLookups()[0], this.getLookups()[1], this.getLookups()[2], instanceLookup, CoreBridge.conditionallyLookupCacheLoad()};
        StartLog.logProgress("prepared other Lookups");
        this.setLookups(arr);
        StartLog.logProgress("Lookups set");
    }

    public void storeCache() throws IOException {
        Lookup[] ls = this.getLookups();
        if (ls.length == 5) {
            CoreBridge.getDefault().lookupCacheStore(ls[4]);
        }
    }

    protected void beforeLookup(Lookup.Template templ) {
        Class type = templ.getType();
        if (!(started || type != ModuleInfo.class && type != Module.class)) {
            Main.getModuleSystem();
        }
        super.beforeLookup(templ);
    }
}

