/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.util.Collection;
import java.util.LinkedList;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeChild;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.Util;

public abstract class TreeParentNode
extends TreeChild {
    public static final String PROP_CHILD_LIST = "childList";
    private TreeObjectList childList = new TreeObjectList(this.createChildListContentManager());

    protected TreeParentNode() {
    }

    protected TreeParentNode(TreeParentNode parentNode, boolean deep) {
        super(parentNode);
        if (deep) {
            this.childList.addAll((Collection)((TreeObjectList)parentNode.childList.clone()));
        }
    }

    public abstract Object clone(boolean var1);

    public final Object clone() {
        return this.clone(true);
    }

    public boolean equals(Object object, boolean deep) {
        if (!super.equals(object, deep)) {
            return false;
        }
        TreeParentNode peer = (TreeParentNode)object;
        return Util.equals(this.childList, peer.childList);
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeParentNode peer = (TreeParentNode)treeObject;
        this.childList.merge(peer.childList);
    }

    public boolean isAssignableChild(TreeChild child) {
        return this.childList.isAssignableObject(child);
    }

    public final TreeObjectList getChildNodes() {
        return this.childList;
    }

    protected void setReadOnly(boolean newReadOnly) {
        super.setReadOnly(newReadOnly);
        this.childList.setReadOnly(newReadOnly);
    }

    public final TreeChild getFirstChild() {
        if (this.childList.size() == 0) {
            return null;
        }
        return (TreeChild)this.childList.get(0);
    }

    public final TreeChild getLastChild() {
        if (this.childList.size() == 0) {
            return null;
        }
        return (TreeChild)this.childList.get(this.childList.size() - 1);
    }

    public final void insertBefore(TreeChild newChild, TreeChild refChild) throws ReadOnlyException {
        this.childList.checkReadOnly();
        int index = this.childList.indexOf(refChild);
        if (index < 0) {
            return;
        }
        this.childList.add(index, newChild);
    }

    public final void replaceChild(TreeChild oldChild, TreeChild newChild) throws ReadOnlyException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\nTreeParentNode::replaceChild: oldChild = " + oldChild);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("              ::replaceChild: newChild = " + newChild);
        }
        this.childList.checkReadOnly();
        int index = this.childList.indexOf(oldChild);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("              ::replaceChild: childList [oldChild]  = " + index);
        }
        if (index < 0) {
            return;
        }
        this.childList.set(index, newChild);
    }

    public final void removeChild(TreeChild oldChild) throws ReadOnlyException {
        this.childList.checkReadOnly();
        this.childList.remove(oldChild);
    }

    public final void appendChild(TreeChild newChild) throws ReadOnlyException {
        this.childList.checkReadOnly();
        this.childList.add(newChild);
    }

    public final void insertChildAt(TreeChild child, int index) throws ReadOnlyException {
        this.childList.checkReadOnly();
        this.childList.add(index, child);
    }

    public final int indexOf(TreeChild node) {
        return this.childList.indexOf(node);
    }

    public final TreeChild item(int index) {
        return (TreeChild)this.childList.get(index);
    }

    public final int getChildrenNumber() {
        return this.childList.size();
    }

    public final boolean hasChildNodes() {
        return !this.childList.isEmpty();
    }

    public final boolean hasChildNodes(Class childClass) {
        return this.hasChildNodes(childClass, false);
    }

    public boolean hasChildNodes(Class childClass, boolean recursive) {
        for (TreeChild child : this.getChildNodes()) {
            if (childClass == null || childClass.isAssignableFrom(child.getClass())) {
                return true;
            }
            if (!recursive || !(child instanceof TreeParentNode) || !((TreeParentNode)child).hasChildNodes(childClass, true)) continue;
            return true;
        }
        return false;
    }

    public final Collection getChildNodes(Class childClass) {
        return this.getChildNodes(childClass, false);
    }

    public Collection getChildNodes(Class childClass, boolean recursive) {
        LinkedList<TreeChild> allChildNodes = new LinkedList<TreeChild>();
        for (TreeChild child : this.getChildNodes()) {
            if (childClass == null || childClass.isAssignableFrom(child.getClass())) {
                allChildNodes.add(child);
            }
            if (!recursive || !(child instanceof TreeParentNode)) continue;
            allChildNodes.addAll(((TreeParentNode)child).getChildNodes(childClass, true));
        }
        return allChildNodes;
    }

    protected abstract TreeObjectList.ContentManager createChildListContentManager();

    protected abstract class ChildListContentManager
    extends TreeObjectList.ContentManager {
        protected ChildListContentManager() {
        }

        public void checkAssignableObject(Object obj) {
            super.checkAssignableObject(obj);
            this.checkAssignableClass(TreeChild.class, obj);
        }

        public void objectInserted(TreeObject obj) {
            ((TreeChild)obj).setParentNode(TreeParentNode.this);
            TreeParentNode.this.firePropertyChange(TreeParentNode.PROP_CHILD_LIST, TreeParentNode.this.childList, obj);
        }

        public void objectRemoved(TreeObject obj) {
            ((TreeChild)obj).setParentNode(null);
            TreeParentNode.this.firePropertyChange(TreeParentNode.PROP_CHILD_LIST, TreeParentNode.this.childList, obj);
        }

        public void orderChanged(int[] permutation) {
            TreeParentNode.this.firePropertyChange(TreeParentNode.PROP_CHILD_LIST, TreeParentNode.this.childList, permutation);
        }
    }
}

