/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.api.webmodule;

import java.util.Collections;
import java.util.Iterator;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.metadata.MetadataUnit;
import org.netbeans.modules.web.spi.webmodule.WebModuleImplementation;
import org.netbeans.modules.web.spi.webmodule.WebModuleProvider;
import org.netbeans.modules.web.webmodule.WebModuleAccessor;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class WebModule
implements MetadataUnit {
    public static final String J2EE_13_LEVEL = "1.3";
    public static final String J2EE_14_LEVEL = "1.4";
    public static final String JAVA_EE_5_LEVEL = "1.5";
    private WebModuleImplementation impl;
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(WebModuleProvider.class));

    private WebModule(WebModuleImplementation impl) {
        if (impl == null) {
            throw new IllegalArgumentException();
        }
        this.impl = impl;
    }

    public static WebModule getWebModule(FileObject f) {
        if (f == null) {
            throw new NullPointerException("Passed null to WebModule.getWebModule(FileObject)");
        }
        Iterator it = implementations.allInstances().iterator();
        while (it.hasNext()) {
            WebModuleProvider impl = (WebModuleProvider)it.next();
            WebModule wm = impl.findWebModule(f);
            if (wm == null) continue;
            return wm;
        }
        return null;
    }

    public FileObject getDocumentBase() {
        return this.impl.getDocumentBase();
    }

    public FileObject getWebInf() {
        return this.impl.getWebInf();
    }

    public FileObject getDeploymentDescriptor() {
        return this.impl.getDeploymentDescriptor();
    }

    public String getContextPath() {
        return this.impl.getContextPath();
    }

    public String getJ2eePlatformVersion() {
        return this.impl.getJ2eePlatformVersion();
    }

    public FileObject[] getJavaSources() {
        return this.impl.getJavaSources();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!WebModule.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        WebModule wm = (WebModule)obj;
        return this.getDocumentBase().equals(wm.getDocumentBase()) && this.getJ2eePlatformVersion().equals(wm.getJ2eePlatformVersion()) && this.getContextPath().equals(wm.getContextPath());
    }

    public int hashCode() {
        return this.getDocumentBase().getPath().length() + this.getContextPath().length();
    }

    public ClassPath getClassPath() {
        FileObject[] roots = this.getJavaSources();
        if (roots.length > 0) {
            FileObject fo = roots[0];
            return org.netbeans.modules.j2ee.metadata.ClassPathSupport.createWeakProxyClassPath((ClassPath[])new ClassPath[]{ClassPath.getClassPath((FileObject)fo, (String)"classpath/source"), ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile")});
        }
        return ClassPathSupport.createClassPath(Collections.emptyList());
    }

    static {
        WebModuleAccessor.DEFAULT = new WebModuleAccessor(){

            public WebModule createWebModule(WebModuleImplementation spiWebmodule) {
                return new WebModule(spiWebmodule);
            }

            public WebModuleImplementation getWebModuleImplementation(WebModule wm) {
                return wm == null ? null : wm.impl;
            }
        };
    }
}

