/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.search.DialogLifetime;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.types.TextType;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openidex.search.SearchPattern;

public abstract class TextCustomizer
extends JPanel
implements Customizer,
DialogLifetime,
ItemListener,
KeyListener {
    private TextType peer;
    private final JCheckBox caseSensitiveCheckBox = new JCheckBox();
    private JPanel jPanel1;
    private final JCheckBox regexpCheckBox = new JCheckBox();
    private JComboBox substringComboBox;
    private final JCheckBox wholeWordsCheckBox = new JCheckBox();
    static final /* synthetic */ boolean $assertionsDisabled;

    public TextCustomizer() {
        this.initComponents();
        this.initAccessibility();
        this.initTextFieldListeners();
        TitledBorder tb = new TitledBorder(this.getBorderLabel());
        tb.setBorder(new CompoundBorder());
        this.setBorder(tb);
        this.initHistory();
    }

    protected String getBorderLabel() {
        return null;
    }

    private void initAccessibility() {
        ResourceBundle bundle = NbBundle.getBundle((Class)TextCustomizer.class);
        this.substringComboBox.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_PROP_SUBSTRING"));
        this.substringComboBox.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_PROP_SUBSTRING"));
        this.caseSensitiveCheckBox.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_LABEL_CASE_SENSITIVE"));
        this.wholeWordsCheckBox.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_LABEL_WHOLE_WORDS"));
        this.regexpCheckBox.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_LABEL_RE"));
    }

    private void initTextFieldListeners() {
        class TextChangeListener
        implements DocumentListener {
            private JTextField textField;

            TextChangeListener(JTextField textField) {
                this.textField = textField;
            }

            public void changedUpdate(DocumentEvent e) {
                this.documentChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                this.documentChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                this.documentChanged();
            }

            private void documentChanged() {
                TextCustomizer.this.stringChanged();
            }
        }
        ((JTextField)this.substringComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new TextChangeListener((JTextField)this.substringComboBox.getEditor().getEditorComponent()));
    }

    private void initHistory() {
        List patterns = this.getSearchPatterns();
        if (!patterns.isEmpty()) {
            HashSet<String> inserted = new HashSet<String>(patterns.size());
            Vector<String> itemsList = new Vector<String>(patterns.size());
            Iterator it = patterns.iterator();
            while (it.hasNext()) {
                String str = ((SearchPattern)it.next()).getSearchExpression();
                if (!inserted.add(str)) continue;
                itemsList.add(str);
            }
            this.substringComboBox.setModel(new DefaultComboBoxModel(itemsList));
            this.substringComboBox.setSelectedIndex(-1);
        }
    }

    public void initFromHistory() {
        Object topmostItem = this.getSearchPatterns().get(0);
        if (topmostItem != null) {
            this.putCurrentSearchPattern((SearchPattern)topmostItem);
        }
    }

    private void initComponents() {
        this.substringComboBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.substringComboBox.setEditable(true);
        this.substringComboBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.substringComboBox.setMinimumSize(null);
        this.substringComboBox.setOpaque(false);
        this.substringComboBox.setPreferredSize(null);
        this.substringComboBox.addItemListener(this);
        this.activateEnterKeyBypass();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.substringComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.caseSensitiveCheckBox, (String)NbBundle.getMessage((Class)TextCustomizer.class, (String)"TEXT_LABEL_CASE_SENSITIVE"));
        this.caseSensitiveCheckBox.setBorder(null);
        this.caseSensitiveCheckBox.addItemListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 12, 0, 11);
        this.add((Component)this.caseSensitiveCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.wholeWordsCheckBox, (String)NbBundle.getMessage((Class)TextCustomizer.class, (String)"TEXT_LABEL_WHOLE_WORDS"));
        this.wholeWordsCheckBox.setBorder(null);
        this.wholeWordsCheckBox.addItemListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 12, 0, 11);
        this.add((Component)this.wholeWordsCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.regexpCheckBox, (String)NbBundle.getMessage((Class)TextCustomizer.class, (String)"TEXT_LABEL_RE"));
        this.regexpCheckBox.setBorder(null);
        this.regexpCheckBox.addItemListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 12, 0, 11);
        this.add((Component)this.regexpCheckBox, gridBagConstraints);
    }

    private void activateEnterKeyBypass() {
        Component editor = this.substringComboBox.getEditor().getEditorComponent();
        if (!(editor instanceof JTextField)) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return;
        }
        ((JTextField)editor).addKeyListener(this);
    }

    public void keyPressed(KeyEvent e) {
        JButton button;
        JRootPane rootPane;
        if (e.getKeyCode() == 10 && e.getModifiersEx() == 0 && (rootPane = SwingUtilities.getRootPane(this)) != null && (button = rootPane.getDefaultButton()) != null && button.isEnabled()) {
            e.consume();
            button.doClick();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private String getComboText() {
        return ((JTextField)this.substringComboBox.getEditor().getEditorComponent()).getText();
    }

    private void regexpChkBoxChanged() {
        this.enableUI();
        if (this.peer == null) {
            return;
        }
        String text = this.getComboText();
        if (text == null || text.length() == 0) {
            return;
        }
        if (!this.regexpCheckBox.isSelected()) {
            this.peer.setMatchString(text);
            this.substringComboBox.getEditor().getEditorComponent().setForeground(this.getForegroundColor());
        } else {
            try {
                this.peer.setRe(text);
                this.substringComboBox.getEditor().getEditorComponent().setForeground(this.getForegroundColor());
            }
            catch (IllegalArgumentException ex) {
                this.substringComboBox.getEditor().getEditorComponent().setForeground(this.getErrorForegroundColor());
            }
        }
    }

    private void stringChanged() {
        if (this.peer == null) {
            return;
        }
        String text = this.getComboText();
        if (!this.regexpCheckBox.isSelected()) {
            this.peer.setMatchString(text);
            this.substringComboBox.getEditor().getEditorComponent().setForeground(this.getForegroundColor());
        } else {
            try {
                this.peer.setRe(text);
                this.substringComboBox.getEditor().getEditorComponent().setForeground(this.getForegroundColor());
            }
            catch (IllegalArgumentException ex) {
                this.substringComboBox.getEditor().getEditorComponent().setForeground(this.getErrorForegroundColor());
            }
        }
    }

    public void setObject(Object obj) {
        this.peer = (TextType)((Object)obj);
        this.substringComboBox.setForeground(this.getForegroundColor());
        Boolean isRegexp = null;
        String text = this.peer.getRe();
        if (text.length() != 0) {
            isRegexp = Boolean.TRUE;
        } else {
            text = this.peer.getMatchString();
            if (text.length() != 0) {
                isRegexp = Boolean.FALSE;
            } else {
                text = this.getComboText();
            }
        }
        if (isRegexp != null) {
            this.substringComboBox.setSelectedItem(text);
            this.regexpCheckBox.setSelected(isRegexp);
            this.caseSensitiveCheckBox.setSelected(this.peer.isCaseSensitive());
            this.wholeWordsCheckBox.setSelected(this.peer.getWholeWords());
        } else if (text != null && text.length() != 0) {
            this.stringChanged();
        }
        this.enableUI();
    }

    public void addPropertyChangeListener(PropertyChangeListener p1) {
    }

    public void removePropertyChangeListener(PropertyChangeListener p1) {
    }

    public void requestFocus() {
        JTextField tf = (JTextField)this.substringComboBox.getEditor().getEditorComponent();
        int n = tf.getText().length();
        if (n > 0) {
            tf.setCaretPosition(0);
            tf.moveCaretPosition(n);
        }
        tf.requestFocus();
    }

    private Color findColor(String key, Color defCol) {
        Color color = UIManager.getDefaults().getColor(key);
        if (color != null) {
            return color;
        }
        return defCol;
    }

    private Color getForegroundColor() {
        return this.findColor("TextField.foreground", Color.black);
    }

    private Color getErrorForegroundColor() {
        return this.findColor("TextField.errorForeground", Color.red);
    }

    private void enableUI() {
        boolean r = this.regexpCheckBox.isSelected();
        this.regexpCheckBox.setEnabled(true);
        this.caseSensitiveCheckBox.setEnabled(!r);
        this.wholeWordsCheckBox.setEnabled(!r);
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.substringComboBox) {
            this.stringChanged();
        } else if (source == this.wholeWordsCheckBox) {
            this.peer.setWholeWords(this.wholeWordsCheckBox.isSelected());
        } else if (source == this.caseSensitiveCheckBox) {
            this.peer.setCaseSensitive(this.caseSensitiveCheckBox.isSelected());
        } else if (source == this.regexpCheckBox) {
            this.regexpChkBoxChanged();
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    private SearchPattern getCurrentSearchPattern() {
        return SearchPattern.create((String)this.getComboText(), (boolean)this.wholeWordsCheckBox.isSelected(), (boolean)this.caseSensitiveCheckBox.isSelected(), (boolean)this.regexpCheckBox.isSelected());
    }

    private void putCurrentSearchPattern(SearchPattern pat) {
        if (!$assertionsDisabled && pat == null) {
            throw new AssertionError();
        }
        this.substringComboBox.setSelectedItem(pat.getSearchExpression());
        this.wholeWordsCheckBox.setSelected(pat.isWholeWords());
        this.caseSensitiveCheckBox.setSelected(pat.isMatchCase());
        this.regexpCheckBox.setSelected(pat.isRegExp());
        this.enableUI();
    }

    private void initCheckBoxes(SearchPattern pat) {
        this.wholeWordsCheckBox.setSelected(pat.isWholeWords());
        this.caseSensitiveCheckBox.setSelected(pat.isMatchCase());
        this.regexpCheckBox.setSelected(pat.isRegExp());
        this.enableUI();
    }

    protected abstract List getSearchPatterns();

    protected abstract void addSearchPattern(SearchPattern var1);

    public void onOk() {
        SearchPattern searchPattern = this.getCurrentSearchPattern();
        if (searchPattern != null) {
            this.addSearchPattern(searchPattern);
            String expr = searchPattern.getSearchExpression();
            if (expr != null && expr.length() != 0) {
                FindDialogMemory.getDefault().setSearchTypeUsed(((Object)((Object)this.peer)).getClass().getName(), true);
            }
        }
    }

    public void onCancel() {
    }

    static {
        $assertionsDisabled = !TextCustomizer.class.desiredAssertionStatus();
    }
}

