/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.modules.palette.Category;
import org.netbeans.modules.palette.DefaultCategory;
import org.netbeans.modules.palette.Item;
import org.netbeans.modules.palette.Model;
import org.netbeans.modules.palette.ModelListener;
import org.netbeans.modules.palette.RootNode;
import org.netbeans.modules.palette.Settings;
import org.netbeans.modules.palette.ui.Customizer;
import org.netbeans.spi.palette.DragAndDropHandler;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Lookup;

public class DefaultModel
implements Model,
NodeListener {
    private RootNode rootNode;
    private Item selectedItem;
    private Category selectedCategory;
    private PropertyChangeSupport propertySupport;
    private ArrayList modelListeners = new ArrayList(3);
    private Category[] categories;

    public DefaultModel(RootNode rootNode) {
        this.rootNode = rootNode;
        this.propertySupport = new PropertyChangeSupport(this);
        this.rootNode.addNodeListener(this);
    }

    public void setSelectedItem(Lookup category, Lookup item) {
        Node itNode;
        Node catNode;
        Category cat = null;
        Item it = null;
        if (null != category && null != (catNode = (Node)category.lookup(Node.class))) {
            cat = this.findCategory(catNode);
        }
        if (null != item && null != cat && null != (itNode = (Node)item.lookup(Node.class))) {
            it = this.findItem(cat, itNode);
        }
        Item oldValue = this.selectedItem;
        this.selectedItem = it;
        this.selectedCategory = cat;
        this.propertySupport.firePropertyChange("selectedItem", oldValue, this.selectedItem);
    }

    public void clearSelection() {
        this.setSelectedItem(null, null);
    }

    public Action[] getActions() {
        return this.rootNode.getActions(false);
    }

    public Item getSelectedItem() {
        return this.selectedItem;
    }

    public Category getSelectedCategory() {
        return this.selectedCategory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener listener) {
        ArrayList arrayList = this.modelListeners;
        synchronized (arrayList) {
            this.modelListeners.add(listener);
            this.propertySupport.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener listener) {
        ArrayList arrayList = this.modelListeners;
        synchronized (arrayList) {
            this.modelListeners.remove(listener);
            this.propertySupport.removePropertyChangeListener(listener);
        }
    }

    public Category[] getCategories() {
        if (null == this.categories) {
            Node[] nodes = this.rootNode.getChildren().getNodes(DefaultModel.canBlock());
            this.categories = this.nodes2categories(nodes);
        }
        return this.categories;
    }

    public static boolean canBlock() {
        return !Children.MUTEX.isReadAccess() && !Children.MUTEX.isWriteAccess();
    }

    public void childrenAdded(NodeMemberEvent ev) {
        this.categories = null;
        this.getCategories();
        Category[] addedCategories = this.findCategories(ev.getDelta());
        this.fireCategoriesChanged(addedCategories, true);
    }

    public void childrenRemoved(NodeMemberEvent ev) {
        Category[] removedCategories = this.findCategories(ev.getDelta());
        this.categories = null;
        this.fireCategoriesChanged(removedCategories, false);
    }

    public void childrenReordered(NodeReorderEvent ev) {
        this.categories = null;
        this.fireCategoriesChanged(null, false);
    }

    public void nodeDestroyed(NodeEvent ev) {
        this.rootNode.removeNodeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCategoriesChanged(Category[] changedCategories, boolean added) {
        ModelListener[] listeners;
        ArrayList arrayList = this.modelListeners;
        synchronized (arrayList) {
            listeners = new ModelListener[this.modelListeners.size()];
            listeners = (ModelListener[])this.modelListeners.toArray((Object[])listeners);
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (null != changedCategories) {
                if (added) {
                    listeners[i].categoriesAdded(changedCategories);
                    continue;
                }
                listeners[i].categoriesRemoved(changedCategories);
                continue;
            }
            listeners[i].categoriesReordered();
        }
    }

    private Category[] nodes2categories(Node[] nodes) {
        Category[] res = new Category[nodes.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new DefaultCategory(nodes[i]);
        }
        return res;
    }

    private Category[] findCategories(Node[] nodes) {
        Category[] res = new Category[nodes.length];
        for (int i = 0; i < res.length; ++i) {
            boolean found = false;
            for (int j = 0; !found && null != this.categories && j < this.categories.length; ++j) {
                Node catNode = (Node)this.categories[j].getLookup().lookup(class$org$openide$nodes$Node == null ? DefaultModel.class$("org.openide.nodes.Node") : class$org$openide$nodes$Node);
                if (!nodes[i].equals((Object)catNode)) continue;
                res[i] = this.categories[i];
                found = true;
            }
            if (found) continue;
            res[i] = new DefaultCategory(nodes[i]);
        }
        return res;
    }

    public void refresh() {
        this.clearSelection();
        this.categories = null;
        this.rootNode.refreshChildren();
    }

    public void showCustomizer(Settings settings) {
        Customizer.show((Node)this.rootNode, settings);
    }

    public Lookup getRoot() {
        return this.rootNode.getLookup();
    }

    public boolean moveCategory(Category source, Category target, boolean moveBefore) {
        int targetIndex = this.categoryToIndex(target);
        if (!moveBefore) {
            ++targetIndex;
        }
        DragAndDropHandler handler = this.getDragAndDropHandler();
        return handler.moveCategory(source.getLookup(), targetIndex);
    }

    private int categoryToIndex(Category category) {
        Index order;
        Node node = (Node)category.getLookup().lookup(Node.class);
        if (null != node && null != (order = (Index)this.rootNode.getCookie(Index.class))) {
            return order.indexOf(node);
        }
        return -1;
    }

    public String getName() {
        return this.rootNode.getName();
    }

    private Category findCategory(Node node) {
        Category[] cats = this.getCategories();
        for (int i = 0; i < cats.length; ++i) {
            Node catNode = (Node)cats[i].getLookup().lookup(class$org$openide$nodes$Node == null ? DefaultModel.class$("org.openide.nodes.Node") : class$org$openide$nodes$Node);
            if (null == catNode || !catNode.equals((Object)node)) continue;
            return cats[i];
        }
        return null;
    }

    private Item findItem(Category category, Node node) {
        Item[] items = category.getItems();
        for (int i = 0; i < items.length; ++i) {
            Node itNode = (Node)items[i].getLookup().lookup(class$org$openide$nodes$Node == null ? DefaultModel.class$("org.openide.nodes.Node") : class$org$openide$nodes$Node);
            if (null == itNode || !itNode.equals((Object)node)) continue;
            return items[i];
        }
        return null;
    }

    public boolean canReorderCategories() {
        return this.getDragAndDropHandler().canReorderCategories(this.rootNode.getLookup());
    }

    private DragAndDropHandler getDragAndDropHandler() {
        return (DragAndDropHandler)this.rootNode.getLookup().lookup(DragAndDropHandler.class);
    }
}

