/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

public final class NbPlatform {
    private static final String PLATFORM_PREFIX = "nbplatform.";
    private static final String PLATFORM_DEST_DIR_SUFFIX = ".netbeans.dest.dir";
    private static final String PLATFORM_LABEL_SUFFIX = ".label";
    private static final String PLATFORM_SOURCES_SUFFIX = ".sources";
    private static final String PLATFORM_JAVADOC_SUFFIX = ".javadoc";
    private static final String PLATFORM_HARNESS_DIR_SUFFIX = ".harness.dir";
    public static final String PLATFORM_ID_DEFAULT = "default";
    private static Set platforms;
    public static final int HARNESS_VERSION_UNKNOWN = 0;
    public static final int HARNESS_VERSION_50 = 1;
    public static final int HARNESS_VERSION_50u1 = 2;
    private final String id;
    private String label;
    private File nbdestdir;
    private File harness;
    private URL[] sourceRoots;
    private URL[] javadocRoots;
    private List listsForSources;
    private int harnessVersion = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void reset() {
        platforms = null;
    }

    public static Set getPlatforms() {
        if (platforms == null) {
            File loc;
            platforms = new HashSet();
            Map p = PropertyUtils.sequentialPropertyEvaluator(null, (PropertyProvider[])new PropertyProvider[]{PropertyUtils.globalPropertyProvider()}).getProperties();
            boolean foundDefault = false;
            Iterator entries = p.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String key = (String)entry.getKey();
                if (!key.startsWith(PLATFORM_PREFIX) || !key.endsWith(PLATFORM_DEST_DIR_SUFFIX)) continue;
                String id = key.substring(PLATFORM_PREFIX.length(), key.length() - PLATFORM_DEST_DIR_SUFFIX.length());
                String label = (String)p.get(PLATFORM_PREFIX + id + PLATFORM_LABEL_SUFFIX);
                String destdir = (String)entry.getValue();
                String harnessdir = (String)p.get(PLATFORM_PREFIX + id + PLATFORM_HARNESS_DIR_SUFFIX);
                String sources = (String)p.get(PLATFORM_PREFIX + id + PLATFORM_SOURCES_SUFFIX);
                String javadoc = (String)p.get(PLATFORM_PREFIX + id + PLATFORM_JAVADOC_SUFFIX);
                File destdirF = FileUtil.normalizeFile((File)new File(destdir));
                File harness = harnessdir != null ? FileUtil.normalizeFile((File)new File(harnessdir)) : NbPlatform.findHarness(destdirF);
                platforms.add(new NbPlatform(id, label, destdirF, harness, NbPlatform.findURLs(sources), NbPlatform.findURLs(javadoc)));
                foundDefault |= id.equals(PLATFORM_ID_DEFAULT);
            }
            if (!foundDefault && (loc = NbPlatform.defaultPlatformLocation()) != null) {
                platforms.add(new NbPlatform(PLATFORM_ID_DEFAULT, null, loc, NbPlatform.findHarness(loc), new URL[0], new URL[0]));
            }
            if (Util.err.isLoggable(1)) {
                Util.err.log("NbPlatform initial list: " + platforms);
            }
        }
        return platforms;
    }

    public static NbPlatform getDefaultPlatform() {
        return NbPlatform.getPlatformByID(PLATFORM_ID_DEFAULT);
    }

    public static File defaultPlatformLocation() {
        File bootJar = InstalledFileLocator.getDefault().locate("core/core.jar", "org.netbeans.core.startup", false);
        if (bootJar == null) {
            return null;
        }
        File harnessJar = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-apisupport-harness.jar", "org.netbeans.modules.apisupport.harness", false);
        if (harnessJar == null) {
            ErrorManager.getDefault().log(16, "Cannot resolve default platform. Probably either \"org.netbeans.modules.apisupport.harness\" module is missing or is corrupted.");
            return null;
        }
        File loc = harnessJar.getParentFile().getParentFile().getParentFile();
        if (!loc.equals(bootJar.getParentFile().getParentFile().getParentFile())) {
            return null;
        }
        return FileUtil.normalizeFile((File)loc);
    }

    private static URL[] defaultPlatformSources(File loc) {
        block3: {
            if (loc.getName().equals("netbeans") && loc.getParentFile().getName().equals("nbbuild")) {
                try {
                    return new URL[]{loc.getParentFile().getParentFile().toURI().toURL()};
                }
                catch (MalformedURLException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)e);
                }
            }
        }
        return new URL[0];
    }

    private static URL[] defaultPlatformJavadoc() {
        File apidocsZip = InstalledFileLocator.getDefault().locate("docs/NetBeansAPIs.zip", "org.netbeans.modules.apisupport.apidocs", true);
        if (apidocsZip != null) {
            return new URL[]{Util.urlForJar(apidocsZip)};
        }
        return new URL[0];
    }

    public static NbPlatform getPlatformByID(String id) {
        Iterator it = NbPlatform.getPlatforms().iterator();
        while (it.hasNext()) {
            NbPlatform p = (NbPlatform)it.next();
            if (!p.getID().equals(id)) continue;
            return p;
        }
        return null;
    }

    public static NbPlatform getPlatformByDestDir(File destDir) {
        File superparent;
        File parent;
        Iterator it = NbPlatform.getPlatforms().iterator();
        while (it.hasNext()) {
            NbPlatform p = (NbPlatform)it.next();
            if (!p.getDestDir().equals(destDir)) continue;
            return p;
        }
        URL[] sources = new URL[]{};
        if (destDir.getName().equals("netbeans") && (parent = destDir.getParentFile()) != null && parent.getName().equals("nbbuild") && (superparent = parent.getParentFile()) != null && ModuleList.isNetBeansOrg(superparent)) {
            sources = new URL[]{Util.urlForDir(superparent)};
        }
        return new NbPlatform(null, null, destDir, NbPlatform.findHarness(destDir), sources, new URL[0]);
    }

    private static File findHarness(File destDir) {
        File[] kids = destDir.listFiles();
        if (kids != null) {
            for (int i = 0; i < kids.length; ++i) {
                if (!NbPlatform.isHarness(kids[i])) continue;
                return kids[i];
            }
        }
        return new File(destDir, "harness");
    }

    public static boolean isHarness(File dir) {
        return new File(dir, "modules" + File.separatorChar + "org-netbeans-modules-apisupport-harness.jar").isFile();
    }

    public static boolean contains(File destDir) {
        boolean contains = false;
        Iterator it = NbPlatform.getPlatforms().iterator();
        while (it.hasNext()) {
            NbPlatform p = (NbPlatform)it.next();
            if (!p.getDestDir().equals(destDir)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static NbPlatform addPlatform(String id, File destdir, String label) throws IOException {
        return NbPlatform.addPlatform(id, destdir, NbPlatform.findHarness(destdir), label);
    }

    public static NbPlatform addPlatform(final String id, final File destdir, final File harness, final String label) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    String plafDestDir = NbPlatform.PLATFORM_PREFIX + id + NbPlatform.PLATFORM_DEST_DIR_SUFFIX;
                    props.setProperty(plafDestDir, destdir.getAbsolutePath());
                    if (!destdir.isDirectory()) {
                        throw new FileNotFoundException(destdir.getAbsolutePath());
                    }
                    NbPlatform.storeHarnessLocation(id, destdir, harness, props);
                    props.setProperty(NbPlatform.PLATFORM_PREFIX + id + NbPlatform.PLATFORM_LABEL_SUFFIX, label);
                    PropertyUtils.putGlobalProperties((EditableProperties)props);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
        NbPlatform plaf = new NbPlatform(id, label, FileUtil.normalizeFile((File)destdir), harness, NbPlatform.findURLs(null), NbPlatform.findURLs(null));
        NbPlatform.getPlatforms().add(plaf);
        if (Util.err.isLoggable(1)) {
            Util.err.log("NbPlatform added: " + plaf);
        }
        return plaf;
    }

    private static void storeHarnessLocation(String id, File destdir, File harness, EditableProperties props) {
        String harnessDirKey = PLATFORM_PREFIX + id + PLATFORM_HARNESS_DIR_SUFFIX;
        if (harness.equals(NbPlatform.findHarness(destdir))) {
            String plafDestDir = PLATFORM_PREFIX + id + PLATFORM_DEST_DIR_SUFFIX;
            props.setProperty(harnessDirKey, "${" + plafDestDir + "}/" + harness.getName());
        } else if (harness.equals(NbPlatform.getDefaultPlatform().getHarnessLocation())) {
            props.setProperty(harnessDirKey, "${nbplatform.default.harness.dir}");
        } else {
            props.setProperty(harnessDirKey, harness.getAbsolutePath());
        }
    }

    public static void removePlatform(final NbPlatform plaf) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    props.remove((Object)(NbPlatform.PLATFORM_PREFIX + plaf.getID() + NbPlatform.PLATFORM_DEST_DIR_SUFFIX));
                    props.remove((Object)(NbPlatform.PLATFORM_PREFIX + plaf.getID() + NbPlatform.PLATFORM_HARNESS_DIR_SUFFIX));
                    props.remove((Object)(NbPlatform.PLATFORM_PREFIX + plaf.getID() + NbPlatform.PLATFORM_LABEL_SUFFIX));
                    props.remove((Object)(NbPlatform.PLATFORM_PREFIX + plaf.getID() + NbPlatform.PLATFORM_SOURCES_SUFFIX));
                    props.remove((Object)(NbPlatform.PLATFORM_PREFIX + plaf.getID() + NbPlatform.PLATFORM_JAVADOC_SUFFIX));
                    PropertyUtils.putGlobalProperties((EditableProperties)props);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
        NbPlatform.getPlatforms().remove(plaf);
        if (Util.err.isLoggable(1)) {
            Util.err.log("NbPlatform removed: " + plaf);
        }
    }

    private NbPlatform(String id, String label, File nbdestdir, File harness, URL[] sources, URL[] javadoc) {
        this.id = id;
        this.label = label;
        this.nbdestdir = nbdestdir;
        this.harness = harness;
        this.sourceRoots = sources;
        this.javadocRoots = javadoc;
    }

    static URL[] findURLs(String path) {
        if (path == null) {
            return new URL[0];
        }
        String[] pieces = PropertyUtils.tokenizePath((String)path);
        URL[] urls = new URL[pieces.length];
        for (int i = 0; i < pieces.length; ++i) {
            urls[i] = Util.urlForDirOrJar(FileUtil.normalizeFile((File)new File(pieces[i])));
        }
        return urls;
    }

    public String getID() {
        return this.id;
    }

    public boolean isDefault() {
        return PLATFORM_ID_DEFAULT.equals(this.id);
    }

    public String getLabel() {
        if (this.label == null) {
            try {
                this.label = this.isValid() ? NbPlatform.computeDisplayName(this.nbdestdir) : NbBundle.getMessage((Class)NbPlatform.class, (String)"MSG_InvalidPlatform", (Object)this.getDestDir().getAbsolutePath());
            }
            catch (IOException e) {
                Util.err.notify(1, (Throwable)e);
                this.label = this.nbdestdir.getAbsolutePath();
            }
        }
        if (this.isDefault()) {
            return NbBundle.getMessage((Class)NbPlatform.class, (String)"LBL_default_platform", (Object)this.label);
        }
        return this.label;
    }

    public File getDestDir() {
        return this.nbdestdir;
    }

    public void setDestDir(File destdir) {
        this.nbdestdir = destdir;
    }

    public URL[] getSourceRoots() {
        if (this.sourceRoots.length == 0 && this.isDefault()) {
            return NbPlatform.defaultPlatformSources(this.getDestDir());
        }
        return this.sourceRoots;
    }

    private void maybeUpdateDefaultPlatformSources() {
        if (this.sourceRoots.length == 0 && this.isDefault()) {
            this.sourceRoots = NbPlatform.defaultPlatformSources(this.getDestDir());
        }
    }

    public void addSourceRoot(URL root) throws IOException {
        this.maybeUpdateDefaultPlatformSources();
        URL[] newSourceRoots = new URL[this.sourceRoots.length + 1];
        System.arraycopy(this.sourceRoots, 0, newSourceRoots, 0, this.sourceRoots.length);
        newSourceRoots[this.sourceRoots.length] = root;
        this.setSourceRoots(newSourceRoots);
    }

    public void removeSourceRoots(URL[] urlsToRemove) throws IOException {
        this.maybeUpdateDefaultPlatformSources();
        ArrayList<URL> newSources = new ArrayList<URL>(Arrays.asList(this.sourceRoots));
        newSources.removeAll(Arrays.asList(urlsToRemove));
        URL[] sources = new URL[newSources.size()];
        this.setSourceRoots(newSources.toArray(sources));
    }

    public void moveSourceRootUp(int indexToUp) throws IOException {
        this.maybeUpdateDefaultPlatformSources();
        if (indexToUp <= 0) {
            return;
        }
        URL[] newSourceRoots = new URL[this.sourceRoots.length];
        System.arraycopy(this.sourceRoots, 0, newSourceRoots, 0, this.sourceRoots.length);
        newSourceRoots[indexToUp - 1] = this.sourceRoots[indexToUp];
        newSourceRoots[indexToUp] = this.sourceRoots[indexToUp - 1];
        this.setSourceRoots(newSourceRoots);
    }

    public void moveSourceRootDown(int indexToDown) throws IOException {
        this.maybeUpdateDefaultPlatformSources();
        if (indexToDown >= this.sourceRoots.length - 1) {
            return;
        }
        URL[] newSourceRoots = new URL[this.sourceRoots.length];
        System.arraycopy(this.sourceRoots, 0, newSourceRoots, 0, this.sourceRoots.length);
        newSourceRoots[indexToDown + 1] = this.sourceRoots[indexToDown];
        newSourceRoots[indexToDown] = this.sourceRoots[indexToDown + 1];
        this.setSourceRoots(newSourceRoots);
    }

    public void setSourceRoots(URL[] roots) throws IOException {
        this.putGlobalProperty(PLATFORM_PREFIX + this.getID() + PLATFORM_SOURCES_SUFFIX, NbPlatform.urlsToAntPath(roots));
        this.sourceRoots = roots;
        this.listsForSources = null;
    }

    public URL[] getJavadocRoots() {
        if (this.javadocRoots.length == 0 && this.isDefault()) {
            return NbPlatform.defaultPlatformJavadoc();
        }
        return this.javadocRoots;
    }

    private void maybeUpdateDefaultPlatformJavadoc() {
        if (this.javadocRoots.length == 0 && this.isDefault()) {
            this.javadocRoots = NbPlatform.defaultPlatformJavadoc();
        }
    }

    public void addJavadocRoot(URL root) throws IOException {
        this.maybeUpdateDefaultPlatformJavadoc();
        URL[] newJavadocRoots = new URL[this.javadocRoots.length + 1];
        System.arraycopy(this.javadocRoots, 0, newJavadocRoots, 0, this.javadocRoots.length);
        newJavadocRoots[this.javadocRoots.length] = root;
        this.setJavadocRoots(newJavadocRoots);
    }

    public void removeJavadocRoots(URL[] urlsToRemove) throws IOException {
        this.maybeUpdateDefaultPlatformJavadoc();
        ArrayList<URL> newJavadocs = new ArrayList<URL>(Arrays.asList(this.javadocRoots));
        newJavadocs.removeAll(Arrays.asList(urlsToRemove));
        URL[] javadocs = new URL[newJavadocs.size()];
        this.setJavadocRoots(newJavadocs.toArray(javadocs));
    }

    public void moveJavadocRootUp(int indexToUp) throws IOException {
        this.maybeUpdateDefaultPlatformJavadoc();
        if (indexToUp <= 0) {
            return;
        }
        URL[] newJavadocRoots = new URL[this.javadocRoots.length];
        System.arraycopy(this.javadocRoots, 0, newJavadocRoots, 0, this.javadocRoots.length);
        newJavadocRoots[indexToUp - 1] = this.javadocRoots[indexToUp];
        newJavadocRoots[indexToUp] = this.javadocRoots[indexToUp - 1];
        this.setJavadocRoots(newJavadocRoots);
    }

    public void moveJavadocRootDown(int indexToDown) throws IOException {
        this.maybeUpdateDefaultPlatformJavadoc();
        if (indexToDown >= this.javadocRoots.length - 1) {
            return;
        }
        URL[] newJavadocRoots = new URL[this.javadocRoots.length];
        System.arraycopy(this.javadocRoots, 0, newJavadocRoots, 0, this.javadocRoots.length);
        newJavadocRoots[indexToDown + 1] = this.javadocRoots[indexToDown];
        newJavadocRoots[indexToDown] = this.javadocRoots[indexToDown + 1];
        this.setJavadocRoots(newJavadocRoots);
    }

    public void setJavadocRoots(URL[] roots) throws IOException {
        this.putGlobalProperty(PLATFORM_PREFIX + this.getID() + PLATFORM_JAVADOC_SUFFIX, NbPlatform.urlsToAntPath(roots));
        this.javadocRoots = roots;
    }

    public boolean isValid() {
        return NbPlatform.isPlatformDirectory(this.getDestDir());
    }

    static String urlsToAntPath(URL[] urls) {
        StringBuffer path = new StringBuffer();
        for (int i = 0; i < urls.length; ++i) {
            if (urls[i].getProtocol().equals("jar")) {
                path.append(NbPlatform.urlToAntPath(FileUtil.getArchiveFile((URL)urls[i])));
            } else {
                path.append(NbPlatform.urlToAntPath(urls[i]));
            }
            if (i == urls.length - 1) continue;
            path.append(':');
        }
        return path.toString();
    }

    private static String urlToAntPath(URL url) {
        return new File(URI.create(url.toExternalForm())).getAbsolutePath();
    }

    private void putGlobalProperty(final String key, final String value) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    if ("".equals(value)) {
                        props.remove((Object)key);
                    } else {
                        props.setProperty(key, value);
                    }
                    PropertyUtils.putGlobalProperties((EditableProperties)props);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public File getSourceLocationOfModule(File jar) {
        if (this.listsForSources == null) {
            this.listsForSources = new ArrayList();
            URL[] sourceRoots = this.getSourceRoots();
            for (int i = 0; i < sourceRoots.length; ++i) {
                File dir;
                URL u = sourceRoots[i];
                if (!u.getProtocol().equals("file") || !(dir = new File(URI.create(u.toExternalForm()))).isDirectory()) continue;
                try {
                    if (ModuleList.isNetBeansOrg(dir)) {
                        this.listsForSources.add(ModuleList.findOrCreateModuleListFromNetBeansOrgSources(dir));
                        continue;
                    }
                    this.listsForSources.add(ModuleList.findOrCreateModuleListFromSuiteWithoutBinaries(dir));
                    continue;
                }
                catch (IOException e) {
                    Util.err.notify(1, (Throwable)e);
                }
            }
        }
        Iterator it = this.listsForSources.iterator();
        while (it.hasNext()) {
            File src;
            ModuleEntry entry;
            ModuleList l = (ModuleList)it.next();
            Set entries = l.getAllEntriesSoft();
            Iterator it2 = entries.iterator();
            while (it2.hasNext()) {
                entry = (ModuleEntry)it2.next();
                if (!entry.getJarLocation().getName().equals(jar.getName()) || (src = entry.getSourceLocation()) == null || !src.isDirectory()) continue;
                return src;
            }
            entries = l.getAllEntries();
            it2 = entries.iterator();
            while (it2.hasNext()) {
                entry = (ModuleEntry)it2.next();
                if (!entry.getJarLocation().getName().equals(jar.getName()) || (src = entry.getSourceLocation()) == null || !src.isDirectory()) continue;
                return src;
            }
        }
        return null;
    }

    public ModuleEntry[] getModules() {
        try {
            TreeSet set = new TreeSet(ModuleList.findOrCreateModuleListFromBinaries(this.getDestDir()).getAllEntriesSoft());
            ModuleEntry[] entries = new ModuleEntry[set.size()];
            set.toArray(entries);
            return entries;
        }
        catch (IOException e) {
            Util.err.notify((Throwable)e);
            return new ModuleEntry[0];
        }
    }

    private static File findCoreJar(File destdir) {
        File[] subdirs = destdir.listFiles();
        if (subdirs != null) {
            for (int i = 0; i < subdirs.length; ++i) {
                File coreJar;
                if (!subdirs[i].isDirectory() || !subdirs[i].getName().startsWith("platform") || !(coreJar = new File(subdirs[i], "core" + File.separatorChar + "core.jar")).isFile()) continue;
                return coreJar;
            }
        }
        return null;
    }

    public static boolean isPlatformDirectory(File destdir) {
        return NbPlatform.findCoreJar(destdir) != null;
    }

    public static boolean isSupportedPlatform(File destdir) {
        boolean valid = false;
        File coreJar = NbPlatform.findCoreJar(destdir);
        if (coreJar != null) {
            String platformDir = coreJar.getParentFile().getParentFile().getName();
            if (!$assertionsDisabled && !platformDir.startsWith("platform")) {
                throw new AssertionError();
            }
            int version = Integer.parseInt(platformDir.substring(8));
            valid = version >= 6;
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String computeDisplayName(File destdir) throws IOException {
        String implVers;
        String currVer;
        File coreJar = NbPlatform.findCoreJar(destdir);
        if (coreJar == null) {
            throw new IllegalArgumentException(destdir.getAbsolutePath());
        }
        JarFile jf = new JarFile(coreJar);
        try {
            currVer = NbPlatform.findCurrVer(jf, "");
            if (currVer == null) {
                throw new IOException(coreJar.getAbsolutePath());
            }
            implVers = jf.getManifest().getMainAttributes().getValue("OpenIDE-Module-Implementation-Version");
            if (implVers == null) {
                throw new IOException(coreJar.getAbsolutePath());
            }
        }
        finally {
            jf.close();
        }
        File[] clusters = destdir.listFiles();
        if (clusters != null) {
            block6: for (int i = 0; i < clusters.length; ++i) {
                String[] kids;
                File coreLocaleDir = new File(clusters[i], "core" + File.separatorChar + "locale");
                if (!coreLocaleDir.isDirectory() || (kids = coreLocaleDir.list()) == null) continue;
                for (int j = 0; j < kids.length; ++j) {
                    String infix;
                    int uscore;
                    String name = kids[j];
                    String prefix = "core";
                    String suffix = ".jar";
                    if (!name.startsWith(prefix) || !name.endsWith(suffix) || (uscore = (infix = name.substring(prefix.length(), name.length() - suffix.length())).lastIndexOf(95)) == -1) continue;
                    String lastPiece = infix.substring(uscore + 1);
                    if (Arrays.asList(Locale.getISOCountries()).contains(lastPiece) || !lastPiece.equals("nb") && Arrays.asList(Locale.getISOLanguages()).contains(lastPiece)) continue;
                    jf = new JarFile(new File(coreLocaleDir, name));
                    try {
                        String brandedCurrVer = NbPlatform.findCurrVer(jf, infix);
                        if (brandedCurrVer == null) continue;
                        currVer = brandedCurrVer;
                        break block6;
                    }
                    finally {
                        jf.close();
                    }
                }
            }
        }
        return MessageFormat.format(currVer, implVers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findCurrVer(JarFile jar, String infix) throws IOException {
        ZipEntry bundle = jar.getEntry("org/netbeans/core/startup/Bundle" + infix + ".properties");
        if (bundle == null) {
            bundle = jar.getEntry("org/netbeans/core/Bundle" + infix + ".properties");
        }
        if (bundle == null) {
            return null;
        }
        Properties props = new Properties();
        InputStream is = jar.getInputStream(bundle);
        try {
            props.load(is);
        }
        finally {
            is.close();
        }
        return props.getProperty("currentVersion");
    }

    public static boolean isLabelValid(String supposedLabel) {
        if (supposedLabel == null) {
            return false;
        }
        Iterator it = NbPlatform.getPlatforms().iterator();
        while (it.hasNext()) {
            String label = ((NbPlatform)it.next()).getLabel();
            if (!supposedLabel.equals(label)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "NbPlatform[" + this.getID() + ":" + this.getDestDir() + ";sources=" + Arrays.asList(this.getSourceRoots()) + ";javadoc=" + Arrays.asList(this.getJavadocRoots()) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getHarnessVersion() {
        if (this.harnessVersion != -1) {
            return this.harnessVersion;
        }
        if (!this.isValid()) {
            this.harnessVersion = 0;
            return 0;
        }
        File harnessJar = new File(this.harness, "modules" + File.separatorChar + "org-netbeans-modules-apisupport-harness.jar");
        if (harnessJar.isFile()) {
            try {
                JarFile jf = new JarFile(harnessJar);
                try {
                    String spec = jf.getManifest().getMainAttributes().getValue("OpenIDE-Module-Specification-Version");
                    if (spec != null) {
                        SpecificationVersion v = new SpecificationVersion(spec);
                        if (v.compareTo((Object)new SpecificationVersion("1.7")) >= 0) {
                            this.harnessVersion = 2;
                            int n = 2;
                            return n;
                        }
                        if (v.compareTo((Object)new SpecificationVersion("1.6")) >= 0) {
                            this.harnessVersion = 1;
                            int n = 1;
                            return n;
                        }
                    }
                }
                finally {
                    jf.close();
                }
            }
            catch (IOException e) {
                Util.err.notify(1, (Throwable)e);
            }
            catch (NumberFormatException e) {
                Util.err.notify(1, (Throwable)e);
            }
        }
        this.harnessVersion = 0;
        return 0;
    }

    public File getHarnessLocation() {
        return this.harness;
    }

    public File getBundledHarnessLocation() {
        return NbPlatform.findHarness(this.nbdestdir);
    }

    public void setHarnessLocation(final File harness) throws IOException {
        if (harness.equals(this.harness)) {
            return;
        }
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    NbPlatform.storeHarnessLocation(NbPlatform.this.id, NbPlatform.this.nbdestdir, harness, props);
                    PropertyUtils.putGlobalProperties((EditableProperties)props);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
        this.harness = harness;
        this.harnessVersion = -1;
    }

    public static String getHarnessVersionDisplayName(int version) {
        switch (version) {
            case 1: {
                return NbBundle.getMessage((Class)NbPlatform.class, (String)"LBL_harness_version_5.0");
            }
            case 2: {
                return NbBundle.getMessage((Class)NbPlatform.class, (String)"LBL_harness_version_5.0u1");
            }
        }
        if (!$assertionsDisabled && version != 0) {
            throw new AssertionError();
        }
        return NbBundle.getMessage((Class)NbPlatform.class, (String)"LBL_harness_version_unknown");
    }

    static {
        $assertionsDisabled = !NbPlatform.class.desiredAssertionStatus();
    }
}

