/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.net.URL;
import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.modules.apisupport.project.ui.ShowJavadocAction;
import org.openide.ErrorManager;
import org.openide.actions.EditAction;
import org.openide.actions.FindAction;
import org.openide.actions.OpenAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

class ActionFilterNode
extends FilterNode {
    private static final int MODE_PACKAGE = 2;
    private static final int MODE_FILE = 3;
    private static final int MODE_FILE_CONTENT = 4;
    private final int mode;
    private Action[] actionCache;
    static final /* synthetic */ boolean $assertionsDisabled;

    static ActionFilterNode create(Node original) {
        DataObject dobj = (DataObject)original.getLookup().lookup(DataObject.class);
        if (!$assertionsDisabled && dobj == null) {
            throw new AssertionError();
        }
        FileObject root = dobj.getPrimaryFile();
        ProxyLookup lkp = new ProxyLookup(new Lookup[]{original.getLookup(), Lookups.singleton((Object)new JavadocProvider(root, root))});
        return new ActionFilterNode(original, 2, root, (Lookup)lkp);
    }

    private ActionFilterNode(Node original, int mode, FileObject cpRoot, FileObject resource) {
        this(original, mode, cpRoot, (Lookup)new ProxyLookup(new Lookup[]{original.getLookup(), Lookups.singleton((Object)new JavadocProvider(cpRoot, resource))}));
    }

    private ActionFilterNode(Node original, int mode) {
        super(original, (Children)new ActionFilterChildren(original, mode, null));
        this.mode = mode;
    }

    private ActionFilterNode(Node original, int mode, FileObject root, Lookup lkp) {
        super(original, (Children)new ActionFilterChildren(original, mode, root), lkp);
        this.mode = mode;
    }

    public Action[] getActions(boolean context) {
        Action[] result = this.initActions();
        return result;
    }

    public Action getPreferredAction() {
        Action[] actions;
        if (this.mode == 3 && (actions = this.initActions()).length > 0 && (actions[0] instanceof OpenAction || actions[0] instanceof EditAction)) {
            return actions[0];
        }
        return null;
    }

    private Action[] initActions() {
        if (this.actionCache == null) {
            ArrayList<Action> result = new ArrayList<Action>(2);
            if (this.mode == 3) {
                Action[] superActions = super.getActions(false);
                for (int i = 0; i < superActions.length; ++i) {
                    if (!(superActions[i] instanceof OpenAction) && !(superActions[i] instanceof EditAction)) continue;
                    result.add(superActions[i]);
                }
                result.add((Action)SystemAction.get((Class)ShowJavadocAction.class));
            } else if (this.mode == 2) {
                result.add((Action)SystemAction.get((Class)ShowJavadocAction.class));
                Action[] superActions = super.getActions(false);
                for (int i = 0; i < superActions.length; ++i) {
                    if (!(superActions[i] instanceof FindAction)) continue;
                    result.add(superActions[i]);
                }
            }
            this.actionCache = result.toArray(new Action[result.size()]);
        }
        return this.actionCache;
    }

    static {
        $assertionsDisabled = !ActionFilterNode.class.desiredAssertionStatus();
    }

    private static class JavadocProvider
    implements ShowJavadocAction.JavadocProvider {
        private final FileObject cpRoot;
        private final FileObject resource;

        JavadocProvider(FileObject cpRoot, FileObject resource) {
            this.cpRoot = cpRoot;
            this.resource = resource;
        }

        public boolean hasJavadoc() {
            try {
                boolean rNotNull = this.resource != null;
                int jLength = JavadocForBinaryQuery.findJavadoc((URL)this.cpRoot.getURL()).getRoots().length;
                return rNotNull && jLength > 0;
            }
            catch (FileStateInvalidException fsi) {
                return false;
            }
        }

        public void showJavadoc() {
            try {
                URL pageURL;
                String relativeName = FileUtil.getRelativePath((FileObject)this.cpRoot, (FileObject)this.resource);
                URL[] urls = JavadocForBinaryQuery.findJavadoc((URL)this.cpRoot.getURL()).getRoots();
                if (relativeName.length() == 0) {
                    pageURL = ShowJavadocAction.findJavadoc("overview-summary.html", urls);
                    if (pageURL == null) {
                        pageURL = ShowJavadocAction.findJavadoc("index.html", urls);
                    }
                } else if (this.resource.isFolder()) {
                    pageURL = ShowJavadocAction.findJavadoc(relativeName + "/package-summary.html", urls);
                } else {
                    String javadocFileName = relativeName.substring(0, relativeName.lastIndexOf(46)) + ".html";
                    pageURL = ShowJavadocAction.findJavadoc(javadocFileName, urls);
                }
                ShowJavadocAction.showJavaDoc(pageURL, relativeName.replace('/', '.'));
            }
            catch (FileStateInvalidException fsi) {
                ErrorManager.getDefault().notify((Throwable)fsi);
            }
        }
    }

    private static class ActionFilterChildren
    extends FilterNode.Children {
        private final int mode;
        private final FileObject cpRoot;
        static final /* synthetic */ boolean $assertionsDisabled;

        ActionFilterChildren(Node original, int mode, FileObject cpRooot) {
            super(original);
            this.mode = mode;
            this.cpRoot = cpRooot;
        }

        protected Node[] createNodes(Object key) {
            Node n = (Node)key;
            switch (this.mode) {
                case 2: {
                    DataObject dobj = (DataObject)n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = ActionFilterNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                    if (dobj == null) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)"DataNode without DataObject in Lookup");
                        }
                        return new Node[0];
                    }
                    if (dobj.getPrimaryFile().isFolder()) {
                        return new Node[]{new ActionFilterNode((Node)key, 2, this.cpRoot, dobj.getPrimaryFile())};
                    }
                    return new Node[]{new ActionFilterNode((Node)key, 3, this.cpRoot, dobj.getPrimaryFile())};
                }
                case 3: 
                case 4: {
                    return new Node[]{new ActionFilterNode((Node)key, 4)};
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Unknown mode");
            }
            return new Node[0];
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$ui$ActionFilterNode == null ? (class$org$netbeans$modules$apisupport$project$ui$ActionFilterNode = ActionFilterNode.class$("org.netbeans.modules.apisupport.project.ui.ActionFilterNode")) : class$org$netbeans$modules$apisupport$project$ui$ActionFilterNode).desiredAssertionStatus();
        }
    }
}

