/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.parser;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import javax.jmi.reflect.RefFeatured;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.ArrayClass;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.GenericElement;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.JavaPackageClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKind;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeClass;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.jmiimpl.javamodel.AnnotationTypeClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaEnumClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ParameterImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ParameterizedTypeImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.TypeClassImpl;
import org.netbeans.modules.javacore.parser.ASTProvider;
import org.netbeans.modules.javacore.parser.AnnotationInfo;
import org.netbeans.modules.javacore.parser.AnnotationTypeInfo;
import org.netbeans.modules.javacore.parser.AnnotationValueInfo;
import org.netbeans.modules.javacore.parser.ArrayRef;
import org.netbeans.modules.javacore.parser.AttributeInfo;
import org.netbeans.modules.javacore.parser.ClassInfo;
import org.netbeans.modules.javacore.parser.ElementInfo;
import org.netbeans.modules.javacore.parser.EnumInfo;
import org.netbeans.modules.javacore.parser.FeatureInfo;
import org.netbeans.modules.javacore.parser.FieldGroupInfo;
import org.netbeans.modules.javacore.parser.FieldInfo;
import org.netbeans.modules.javacore.parser.LocalClassScope;
import org.netbeans.modules.javacore.parser.LocalVarScope;
import org.netbeans.modules.javacore.parser.MethodInfo;
import org.netbeans.modules.javacore.parser.MethodScope;
import org.netbeans.modules.javacore.parser.NameRef;
import org.netbeans.modules.javacore.parser.ParameterInfo;
import org.netbeans.modules.javacore.parser.PrimitiveTypeRef;
import org.netbeans.modules.javacore.parser.ResourceInfo;
import org.netbeans.modules.javacore.parser.Scope;
import org.netbeans.modules.javacore.parser.TypeParamInfo;
import org.netbeans.modules.javacore.parser.TypeParamRef;
import org.netbeans.modules.javacore.parser.TypeParamScope;
import org.netbeans.modules.javacore.parser.TypeRef;
import org.netbeans.modules.javacore.parser.WildCardRef;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public class MDRParser
extends ASTProvider {
    private Map semanticInfo;
    private ClassPath classPath;
    private JMManager manager;
    private JavaPackageClass jpckClass;
    private JavaClassClassImpl jclsClass;
    private TypeClass typeClass;
    private JavaEnumClassImpl enumClass;
    private AnnotationTypeClassImpl annotClass;
    private ClassDefinition currentClass;
    private Feature currentFeature;
    private String jpck;
    private Stack typeScopeInfo;
    private Stack variableScope;
    private Scope enumSwitchScope;
    private ClassIndex index;
    private TreeMap attributionToDo;
    private List localSuperInfo;
    private MDRepository rep;
    private Scope staticImpScope;
    private int javaFeatures;
    private boolean running;
    private boolean resolveClassName;
    private static final boolean DEBUG = false;
    private static Map superInfoMap = new HashMap();
    private static final ModifiersInfo NO_MODIFIERS = new ModifiersInfo(0, null);
    private static final RequestProcessor PARSE_AFTER_SCAN_RP = new RequestProcessor("Parse-After-Scan Request Processor");
    public static final int M_ENUM = 16384;
    public static final int M_ANNOTATION = 8192;
    public Map mofidToBounds;
    public int[] guardedBlocksBorders;

    public MDRParser(Resource r, FileObject fobj) {
        super(r, fobj);
        this.init();
    }

    public MDRParser(Resource r, FileObject fobj, String sourceText, boolean isFromDoc) {
        super(r, fobj, sourceText, isFromDoc);
        this.init();
    }

    private void init() {
        JavaModelPackage srcExtent = (JavaModelPackage)this.getResource().refImmediatePackage();
        this.jpckClass = srcExtent.getJavaPackage();
        this.jclsClass = (JavaClassClassImpl)srcExtent.getJavaClass();
        this.typeClass = srcExtent.getType();
        this.enumClass = (JavaEnumClassImpl)srcExtent.getJavaEnum();
        this.annotClass = (AnnotationTypeClassImpl)srcExtent.getAnnotationType();
        this.index = ClassIndex.getIndex(srcExtent);
        this.semanticInfo = new HashMap();
        this.typeScopeInfo = new Stack();
        this.variableScope = new Stack();
        this.attributionToDo = MDRParser.getAttributionToDoMap();
        this.localSuperInfo = new ArrayList();
        this.manager = (JMManager)JavaMetamodel.getManager();
        this.rep = JavaMetamodel.getDefaultRepository();
    }

    private static void reparseAfterScan(final FileObject fobj) {
        PARSE_AFTER_SCAN_RP.post(new Runnable(){

            public void run() {
                JMManager manager = (JMManager)JavaMetamodel.getManager();
                if (manager.waitScanFinished()) {
                    manager.addModified(fobj);
                    JavaMetamodel.getDefaultRepository().beginTrans(true);
                    JavaMetamodel.getDefaultRepository().endTrans(false);
                }
            }
        });
    }

    private static TreeMap getAttributionToDoMap() {
        return new TreeMap(new Comparator(){

            public int compare(Object o1, Object o2) {
                int i2;
                int i1 = ((ASTree)o1).getFirstToken();
                if (i1 < (i2 = ((ASTree)o2).getFirstToken())) {
                    return -1;
                }
                if (i1 > i2) {
                    return 1;
                }
                i1 = ((ASTree)o1).getLastToken();
                if (i1 < (i2 = ((ASTree)o2).getLastToken())) {
                    return 1;
                }
                if (i1 > i2) {
                    return -1;
                }
                return 0;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSemanticInfo(ASTree tree, Element element) {
        Object info = this.semanticInfo.get(tree);
        if (info == null) {
            if (!this.attributionToDo.isEmpty()) {
                ASTree tmp;
                Iterator it = this.attributionToDo.keySet().iterator();
                while (it.hasNext() && (tmp = (ASTree)it.next()).getFirstToken() <= tree.getFirstToken()) {
                    if (tmp.getLastToken() < tree.getLastToken()) continue;
                    this.doAttribution();
                    info = this.semanticInfo.get(tree);
                    break;
                }
            }
            if (info == null) {
                return null;
            }
        }
        boolean wasSafe = JMManager.getTransactionMutex().isSafeTrans();
        this.manager.setSafeTrans(true);
        try {
            Object object = this.getModelElement(tree, element, info);
            return object;
        }
        finally {
            this.manager.setSafeTrans(wasSafe);
        }
    }

    private void doAttribution() {
        TreeMap map = this.attributionToDo;
        this.attributionToDo = MDRParser.getAttributionToDoMap();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Element el = (Element)entry.getValue();
            if (!el.isValid()) continue;
            this.enterBody(el, (ASTree)entry.getKey());
        }
    }

    public void prepareForAttribution(MetadataElement feature, ASTree featureTree) {
        this.attributionToDo.put(featureTree, feature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void enterBody(Element element, ASTree elementTree) {
        if (this.running) {
            ErrorManager.getDefault().notify(1, (Throwable)new Exception("Recursion in enterBody"));
            return;
        }
        this.running = true;
        boolean wasSafe = JMManager.getTransactionMutex().isSafeTrans();
        this.manager.setSafeTrans(true);
        if (JMManager.PERF_DEBUG) {
            try {
                Feature f = JavaModelUtil.getDeclaringFeature(element);
                System.err.println("Attributing method: " + f.getDeclaringClass().getName() + '.' + f.getName() + '.' + elementTree.getFirstToken());
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        long time = System.currentTimeMillis();
        try {
            Feature feature = JavaModelUtil.getDeclaringFeature(element);
            this.classPath = this.manager.getClassPath();
            this.currentClass = feature.getDeclaringClass();
            this.computeScope(this.currentClass);
            this.semanticInfo.put(elementTree, element);
            this.currentFeature = feature;
            this.processASTBody(elementTree);
            this.typeScopeInfo.pop();
            this.variableScope.pop();
        }
        finally {
            superInfoMap.keySet().removeAll(this.localSuperInfo);
            this.localSuperInfo.clear();
            this.typeScopeInfo.clear();
            this.variableScope.clear();
            this.currentFeature = null;
            this.currentClass = null;
            this.manager.setSafeTrans(wasSafe);
            this.running = false;
        }
        if (JMManager.PERF_DEBUG) {
            System.out.println("    finished: " + (System.currentTimeMillis() - time) + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResourceInfo enterMembers() {
        if (this.running) {
            ErrorManager.getDefault().notify(1, (Throwable)new Exception("Recursion in enterMembers"));
            return null;
        }
        this.running = true;
        boolean wasSafe = JMManager.getTransactionMutex().isSafeTrans();
        this.manager.setSafeTrans(true);
        try {
            this.classPath = this.manager.getClassPath();
            ASTree topNode = this.getASTree();
            if (topNode != null) {
                if (this.getPackage("java.lang") == null) {
                    MDRParser.reparseAfterScan(this.getFileObject());
                }
                ResourceInfo resourceInfo = (ResourceInfo)this.processAST(topNode);
                return resourceInfo;
            }
        }
        finally {
            superInfoMap.keySet().removeAll(this.localSuperInfo);
            this.localSuperInfo.clear();
            this.manager.setSafeTrans(wasSafe);
            this.running = false;
        }
        return null;
    }

    public int getJavaFeatures() {
        return this.javaFeatures;
    }

    private void computeScope(ClassDefinition jcls) {
        Scope varScope;
        Scope classScope;
        if (jcls == null) {
            Resource rsc = this.getResource();
            classScope = Scope.createTypeScope(rsc, this.classPath);
            varScope = new Scope(null);
            this.staticImpScope = Scope.createStaticImpScope(rsc);
        } else if (jcls instanceof JavaClassImpl && ((JavaClassImpl)jcls).isTransient() && ((JavaClassImpl)jcls).getDeclaringClass() == null) {
            ASTree[] jclsSubASTs = ((MetadataElement)jcls).getASTree().getSubTrees();
            Token firstToken = this.getToken(jclsSubASTs[jclsSubASTs.length - 1].getFirstToken());
            Scope[] localscope = (Scope[])this.semanticInfo.get(firstToken);
            classScope = new Scope(localscope[0]);
            varScope = new Scope(localscope[1]);
            classScope.addMember(Scope.createMemberTypeScope(jcls, this));
            varScope.addMember(Scope.createFieldScope(jcls));
        } else if (jcls instanceof JavaClass) {
            JavaClass javaClass = (JavaClass)jcls;
            ClassDefinition decl = javaClass.getDeclaringClass();
            this.computeScope(decl);
            classScope = new Scope((Scope)this.typeScopeInfo.pop());
            varScope = new Scope((Scope)this.variableScope.pop());
            classScope.addMember(Scope.createMemberTypeScope(jcls, this));
            varScope.addMember(Scope.createFieldScope(jcls));
            Iterator typeParIt = javaClass.getTypeParameters().iterator();
            while (typeParIt.hasNext()) {
                TypeParameter tp = (TypeParameter)typeParIt.next();
                classScope.addMember(new TypeParamScope(tp));
            }
        } else {
            ASTree parentAST = ((MetadataElement)jcls).getASTree();
            Token firstToken = this.getToken(parentAST.getFirstToken());
            Scope[] anonscope = (Scope[])this.semanticInfo.get(firstToken);
            classScope = new Scope(anonscope[0]);
            varScope = new Scope(anonscope[1]);
            classScope.addMember(Scope.createMemberTypeScope(jcls, this));
            varScope.addMember(Scope.createFieldScope(jcls));
        }
        this.typeScopeInfo.push(classScope);
        this.variableScope.push(varScope);
    }

    private JavaPackage getPackage(String packId) {
        return this.jpckClass.resolvePackage(packId);
    }

    Object processAST(ASTree tree) {
        return this.processAST(tree, null);
    }

    Object processAST(ASTree tree, String fqn) {
        if (tree == null) {
            return null;
        }
        ASTree[] parts = tree.getSubTrees();
        int treeType = tree.getType();
        switch (treeType) {
            case 15: {
                this.typeScopeInfo.push(new Scope(null));
                this.processAST(parts[0]);
                this.jpck = this.getResource().getPackageName();
                ElementInfo[] importList = (ElementInfo[])this.processAST(parts[1]);
                this.typeScopeInfo.pop();
                this.typeScopeInfo.push(Scope.createTypeScope(this.jpck, this.classPath, importList));
                Object topClasses = this.processAST(parts[2], this.jpck);
                this.typeScopeInfo.pop();
                return new ResourceInfo(tree, treeType, this.getResource(), (ClassInfo[])topClasses, importList);
            }
            case 46: {
                return this.resolveTypeName(parts[1]);
            }
            case 54: 
            case 68: {
                String id = treeType == 54 && parts[0] != null ? this.resolveStaticImport(parts[1]) : ((NameRef)this.resolveTypeName((ASTree)parts[1])).name;
                return new ElementInfo(tree, treeType, id);
            }
            case 34: {
                ElementInfo[] imports = null;
                if (parts != null) {
                    imports = new ElementInfo[parts.length];
                    for (int i = 0; i < imports.length; ++i) {
                        imports[i] = (ElementInfo)this.processAST(parts[i]);
                    }
                }
                return imports;
            }
            case 67: {
                ClassInfo[] classes = null;
                if (parts != null) {
                    int i;
                    ASTree[] filtered = this.filterParts(parts);
                    for (i = 0; i < filtered.length; ++i) {
                        this.resolveSuperTypes(filtered[i], fqn);
                    }
                    classes = new ClassInfo[filtered.length];
                    for (i = 0; i < classes.length; ++i) {
                        classes[i] = (ClassInfo)this.processAST(filtered[i], fqn);
                    }
                }
                return classes;
            }
            case 82: {
                return new FeatureInfo(tree, treeType, this.getText(parts[0]), 0, null);
            }
            case 83: {
                ElementInfo[] constants = null;
                if (parts != null) {
                    ASTree[] filtered = this.filterParts(parts);
                    constants = new ElementInfo[filtered.length];
                    for (int i = 0; i < filtered.length; ++i) {
                        constants[i] = (ElementInfo)this.processAST(filtered[i], fqn);
                    }
                }
                return constants;
            }
            case 12: 
            case 38: 
            case 81: 
            case 88: {
                FeatureInfo[] features = null;
                if (parts != null) {
                    int i;
                    ASTree[] filtered = this.filterParts(parts);
                    for (i = 0; i < filtered.length; ++i) {
                        this.resolveSuperTypes(filtered[i], fqn);
                    }
                    ArrayList<Object> tempFeatures = new ArrayList<Object>(filtered.length);
                    for (i = 0; i < filtered.length; ++i) {
                        Object temp = this.processAST(filtered[i], fqn);
                        if (temp instanceof FieldInfo[]) {
                            tempFeatures.addAll(Arrays.asList((Object[])temp));
                            continue;
                        }
                        tempFeatures.add(temp);
                    }
                    features = tempFeatures.toArray(new FeatureInfo[tempFeatures.size()]);
                }
                return features;
            }
            case 84: {
                ModifiersInfo modInfo = this.getModifiers(parts[0]);
                int modifiers = modInfo != NO_MODIFIERS ? modInfo.modifiers : this.getDeprecated(tree);
                ASTree body = parts[3];
                ASTree ifacesAST = parts[2];
                NameRef[] interfaces = null;
                Scope classScope = new Scope((Scope)this.typeScopeInfo.peek());
                JavaEnum jcls = (JavaEnum)this.semanticInfo.get(tree);
                String currentFqn = jcls.getName();
                classScope.addMember(Scope.createMemberTypeScope((ClassDefinition)jcls, this));
                this.typeScopeInfo.push(classScope);
                modifiers |= 0x4000;
                this.javaFeatures |= 2;
                if (ifacesAST != null) {
                    interfaces = (NameRef[])this.semanticInfo.get(ifacesAST);
                }
                ASTree enumConsts = body.getSubTrees()[0];
                ASTree bodyDecls = body.getSubTrees()[1];
                ElementInfo[] constants = enumConsts == null ? null : (ElementInfo[])this.processAST(enumConsts, currentFqn);
                FeatureInfo[] features = bodyDecls == null ? null : (FeatureInfo[])this.processAST(bodyDecls, currentFqn);
                EnumInfo enumInfo = new EnumInfo(tree, treeType, currentFqn, modifiers, features, interfaces, constants, modInfo.annotations);
                this.typeScopeInfo.pop();
                return enumInfo;
            }
            case 89: {
                ModifiersInfo modInfo = this.getModifiers(parts[0]);
                int modifiers = modInfo != NO_MODIFIERS ? modInfo.modifiers : this.getDeprecated(tree);
                ASTree body = parts[2];
                Object interfaces = null;
                Scope classScope = new Scope((Scope)this.typeScopeInfo.peek());
                AnnotationType annType = (AnnotationType)this.semanticInfo.get(tree);
                this.javaFeatures |= 4;
                String currentFqn = annType.getName();
                classScope.addMember(Scope.createMemberTypeScope((ClassDefinition)annType, this));
                this.typeScopeInfo.push(classScope);
                FeatureInfo[] features = (FeatureInfo[])this.processAST(body, currentFqn);
                AnnotationTypeInfo annTypeInfo = new AnnotationTypeInfo(tree, treeType, currentFqn, modifiers, features, modInfo.annotations);
                this.typeScopeInfo.pop();
                return annTypeInfo;
            }
            case 13: 
            case 37: {
                ModifiersInfo modInfo = this.getModifiers(parts[0]);
                int modifiers = modInfo != NO_MODIFIERS ? modInfo.modifiers : this.getDeprecated(tree);
                ASTree body = parts[5];
                ASTree ifacesAST = parts[4];
                TypeParamInfo[] typeParams = (TypeParamInfo[])this.processAST(parts[2]);
                NameRef sclass = (NameRef)this.semanticInfo.get(parts[1]);
                NameRef[] interfaces = null;
                Scope classScope = new Scope((Scope)this.typeScopeInfo.peek());
                JavaClass jcls = (JavaClass)this.semanticInfo.get(tree);
                String currentFqn = jcls.getName();
                classScope.addMember(Scope.createMemberTypeScope((ClassDefinition)jcls, this));
                this.typeScopeInfo.push(classScope);
                if (treeType == 37) {
                    modifiers |= 0x200;
                }
                if (ifacesAST != null) {
                    interfaces = (NameRef[])this.semanticInfo.get(ifacesAST);
                }
                typeParams = (TypeParamInfo[])this.processAST(parts[2], currentFqn);
                FeatureInfo[] features = (FeatureInfo[])this.processAST(body, currentFqn);
                ClassInfo clsInfo = new ClassInfo(tree, treeType, currentFqn, modifiers, features, sclass, interfaces, typeParams, modInfo.annotations);
                this.typeScopeInfo.pop();
                return clsInfo;
            }
            case 18: 
            case 41: {
                ModifiersInfo modInfo = this.getModifiers(parts[0]);
                int modifiers = modInfo != NO_MODIFIERS ? modInfo.modifiers : this.getDeprecated(tree);
                TypeParamRef[] exceptions = null;
                TypeParamInfo[] typeParams = (TypeParamInfo[])this.processAST(parts[1]);
                TypeRef type = this.resolveTypeName(parts[2]);
                Object[] header = (Object[])this.processAST(parts[3]);
                ASTree exsAST = parts[4];
                String name = null;
                ParameterInfo[] pars = (ParameterInfo[])header[1];
                if (treeType == 41) {
                    name = (String)header[0];
                }
                if (exsAST != null) {
                    ASTree[] exIds = exsAST.getSubTrees();
                    exceptions = new TypeParamRef[exIds.length];
                    for (int i = 0; i < exIds.length; ++i) {
                        exceptions[i] = (TypeParamRef)this.resolveTypeName(exIds[i]);
                    }
                }
                return new MethodInfo(tree, treeType, name, modifiers, type == null ? null : MDRParser.fullType(type, header[2]), pars, exceptions, typeParams, modInfo.annotations);
            }
            case 19: 
            case 70: {
                return new Object[]{this.processAST(parts[0]), this.processAST(parts[1])};
            }
            case 42: {
                return new Object[]{this.processAST(parts[0]), this.processAST(parts[1]), this.processAST(parts[2])};
            }
            case 31: {
                ParameterInfo[] pars = new ParameterInfo[parts.length];
                for (int i = 0; i < pars.length; ++i) {
                    pars[i] = (ParameterInfo)this.processAST(parts[i], fqn);
                }
                return pars;
            }
            case 30: {
                ModifiersInfo modInfo = this.getModifiers(parts[0]);
                boolean isFinal = false;
                TypeRef type = this.resolveTypeName(parts[1]);
                Object[] decl = (Object[])this.processAST(parts[3]);
                TypeRef varType = MDRParser.fullType(type, decl[1]);
                String name = (String)decl[0];
                if (modInfo != null) {
                    isFinal = Modifier.isFinal(modInfo.modifiers);
                }
                return new ParameterInfo(tree, treeType, name, isFinal, varType, parts[2] != null, modInfo.annotations);
            }
            case 78: {
                TypeParamInfo[] typeParams = new TypeParamInfo[parts.length];
                this.javaFeatures |= 1;
                this.createTypeParametrScope(tree);
                for (int i = 0; i < typeParams.length; ++i) {
                    typeParams[i] = (TypeParamInfo)this.processAST(parts[i]);
                }
                return typeParams;
            }
            case 77: {
                String name = (String)this.processAST(parts[0]);
                TypeParamRef[] bounds = (TypeParamRef[])this.processAST(parts[1]);
                return new TypeParamInfo(tree, tree.getType(), name, bounds);
            }
            case 74: {
                TypeParamRef[] result = new TypeParamRef[parts.length];
                for (int i = 0; i < parts.length; ++i) {
                    result[i] = (TypeParamRef)this.resolveTypeName(parts[i]);
                }
                return result;
            }
            case 75: {
                Object[] result = new Object[parts.length];
                this.javaFeatures |= 1;
                for (int i = 0; i < parts.length; ++i) {
                    ASTree argAST = parts[i];
                    result[i] = argAST.getType() == 361 ? this.resolveTypeName(argAST) : this.processAST(argAST);
                }
                return result;
            }
            case 28: {
                ModifiersInfo modInfo = this.getModifiers(parts[0]);
                int modifiers = modInfo != NO_MODIFIERS ? modInfo.modifiers : this.getDeprecated(tree);
                TypeRef type = this.resolveTypeName(parts[1]);
                ASTree varDeclsTree = parts[2];
                Object[] decls = (Object[])this.processAST(varDeclsTree);
                if (varDeclsTree.getType() == 70) {
                    TypeRef varType = MDRParser.fullType(type, decls[1]);
                    String name = (String)decls[0];
                    return new FieldInfo(tree, treeType, name, modifiers, varType, -1, modInfo.annotations);
                }
                FieldInfo[] fields = new FieldInfo[decls.length];
                ASTree[] children = varDeclsTree.getSubTrees();
                for (int i = 0; i < decls.length; ++i) {
                    Object[] decl = (Object[])decls[i];
                    fields[i] = new FieldInfo(children[i], 28, (String)decl[0], modifiers, MDRParser.fullType(type, decl[1]), i, modInfo.annotations);
                }
                return new FieldGroupInfo(tree, 71, modifiers, type, fields, modInfo.annotations);
            }
            case 87: {
                ModifiersInfo modInfo = this.getModifiers(parts[0]);
                int modifiers = modInfo != NO_MODIFIERS ? modInfo.modifiers : this.getDeprecated(tree);
                TypeRef type = this.resolveTypeName(parts[1]);
                String name = (String)this.processAST(parts[2]);
                AnnotationValueInfo defaultValue = (AnnotationValueInfo)this.processAST(parts[3]);
                return new AttributeInfo(tree, treeType, name, modifiers, type, defaultValue, modInfo.annotations);
            }
            case 36: 
            case 56: {
                ASTree modTree = parts[0];
                ModifiersInfo modInfo = this.getModifiers(parts[0]);
                int modifiers = modInfo.modifiers;
                return new FeatureInfo(tree, treeType, null, modifiers, modInfo.annotations);
            }
            case 86: {
                NameRef name = (NameRef)this.resolveTypeName(parts[0]);
                ASTree pAST = parts[1];
                ASTree[] pairsAST = pAST != null ? pAST.getSubTrees() : new ASTree[]{};
                AnnotationValueInfo[] attributePairs = new AnnotationValueInfo[pairsAST.length];
                this.javaFeatures |= 8;
                for (int i = 0; i < attributePairs.length; ++i) {
                    AnnotationValueInfo attributePair;
                    Object[] ann;
                    ASTree[] valueASTs = pairsAST[i].getSubTrees();
                    String pairName = (String)this.processAST(valueASTs[0]);
                    ASTree valueAST = valueASTs[1];
                    int valueType = valueAST.getType();
                    if (valueType == 86) {
                        ann = this.processAST(valueAST);
                        attributePair = new AnnotationValueInfo(pairsAST[i], 4096, pairName, ann);
                    } else if (valueType == 4) {
                        ann = MDRParser.getArray(this.processAST(valueAST));
                        attributePair = new AnnotationValueInfo(pairsAST[i], 4098, pairName, ann);
                    } else {
                        ann = this.getText(valueAST);
                        attributePair = new AnnotationValueInfo(pairsAST[i], 4097, pairName, ann);
                    }
                    attributePairs[i] = attributePair;
                }
                return new AnnotationInfo(tree, treeType, name, attributePairs);
            }
            case 52: {
                ASTree dim = parts[1];
                ASTree typeAST = parts[0];
                TypeRef t = typeAST.getType() != 51 ? this.resolveTypeName(typeAST) : (TypeRef)this.processAST(typeAST);
                if (dim != null && t != null) {
                    int dimension = (Integer)this.processAST(dim);
                    t = new ArrayRef((PrimitiveTypeRef)t, dimension);
                }
                return t;
            }
            case 51: {
                return this.getPrimitiveType(parts[0]);
            }
            case 22: {
                return new Integer((tree.getLastToken() - tree.getFirstToken() + 1) / 2);
            }
            case 79: {
                ASTree lowerAST = parts[0];
                if (lowerAST == null) {
                    return new WildCardRef(false, null);
                }
                boolean isLower = lowerAST.getType() == 273;
                TypeRef bound = this.resolveTypeName(parts[1]);
                return new WildCardRef(isLower, bound);
            }
            case 45: {
                ASTree parent = parts[0];
                ASTree nameAST = parts[1];
                String name = (String)this.processAST(nameAST);
                NameRef sInfo = null;
                NameRef ref = null;
                if (parent != null) {
                    TypeParamRef parentRef = parent.getType() == 361 ? (TypeParamRef)this.resolveTypeName(parent) : (TypeParamRef)this.processAST(parent);
                    Object parentInfo = this.semanticInfo.get(parent);
                    if (parentInfo instanceof String && ((String)parentInfo).charAt(0) == '*') {
                        NameRef pckRef = (NameRef)parentRef;
                        String pckName = pckRef.name.concat(".").concat(name);
                        sInfo = this.getPackage(pckName);
                        if (sInfo != null) {
                            ref = new NameRef(pckName);
                        }
                    }
                    Object[] args = MDRParser.getArray(this.processAST(parts[2]));
                    if (sInfo == null) {
                        TypeRef[] argRef = new TypeRef[args.length];
                        System.arraycopy(args, 0, argRef, 0, args.length);
                        sInfo = ref = new NameRef(name, parentRef, argRef);
                    }
                    this.storeSemanticInfo(nameAST, sInfo);
                } else {
                    Object[] args = MDRParser.getArray(this.processAST(parts[2]));
                    TypeParamRef nameRef = (TypeParamRef)this.resolveTypeName(nameAST);
                    TypeRef[] argRef = new TypeRef[args.length];
                    System.arraycopy(args, 0, argRef, 0, args.length);
                    sInfo = ref = new NameRef(nameRef.name, null, argRef);
                }
                this.storeSemanticInfo(tree, sInfo);
                return ref;
            }
            case 361: {
                return ((Token)tree).getValue();
            }
            case 44: {
                int modifiers = 0;
                int annCount = 0;
                AnnotationInfo[] infos = new AnnotationInfo[parts.length];
                for (int i = 0; i < parts.length; ++i) {
                    ASTree modTree = parts[i];
                    if (modTree.getType() == 86) {
                        AnnotationInfo ai = (AnnotationInfo)this.processAST(modTree);
                        infos[annCount++] = ai;
                        if (!ai.type.name.equals("Deprecated") && !ai.type.name.equals("java.lang.Deprecated")) continue;
                        modifiers |= Integer.MIN_VALUE;
                        continue;
                    }
                    Token tok = (Token)modTree;
                    modifiers |= ((Integer)tok.getValue()).intValue();
                    if (!tok.getDeprecatedFlag()) continue;
                    modifiers |= Integer.MIN_VALUE;
                }
                AnnotationInfo[] annArray = new AnnotationInfo[annCount];
                System.arraycopy(infos, 0, annArray, 0, annCount);
                return new ModifiersInfo(modifiers, annArray);
            }
            case 92: {
                return new AnnotationValueInfo(tree, 4097, null, null);
            }
        }
        if (parts != null) {
            Object[] val = null;
            Object[] valArr = null;
            int arrIndex = 0;
            for (int i = 0; i < parts.length; ++i) {
                Object[] ret = this.processAST(parts[i]);
                if (ret == null) continue;
                if (val == null) {
                    val = ret;
                    continue;
                }
                if (arrIndex == 0) {
                    valArr = new Object[parts.length - i + 1];
                    valArr[0] = val;
                    valArr[1] = ret;
                    arrIndex = 2;
                    continue;
                }
                valArr[arrIndex++] = ret;
            }
            return arrIndex == 0 ? val : valArr;
        }
        return null;
    }

    private String resolveStaticImport(ASTree mpid) {
        ASTree[] mpiparts;
        String id = null;
        if (mpid != null && (mpiparts = mpid.getSubTrees()) != null) {
            NameRef parentRef = (NameRef)this.resolveTypeName(mpiparts[0]);
            ASTree nameAST = mpiparts[1];
            String name = (String)this.processAST(nameAST);
            JavaClass jcls = (JavaClass)((SemiPersistentElement)this.getResource()).resolveType(parentRef);
            Feature feature = null;
            if (jcls != null) {
                Object[] features = jcls.getFeatures().toArray();
                for (int i = 0; i < features.length; ++i) {
                    Feature f = (Feature)features[i];
                    if (!name.equals(f.getName())) continue;
                    feature = f;
                    break;
                }
            }
            this.storeSemanticInfo(mpid, feature);
            this.storeSemanticInfo(nameAST, feature);
            id = parentRef.name.concat(".").concat(name);
        }
        return id;
    }

    private Object getModelElement(ASTree tree, Element mdrElement, Object symbolInfo) {
        if (symbolInfo instanceof String) {
            String name;
            String strInfo = (String)symbolInfo;
            char firstChar = strInfo.charAt(0);
            switch (firstChar) {
                case '*': 
                case '<': 
                case '@': 
                case '^': {
                    name = strInfo.substring(1);
                    break;
                }
                default: {
                    return this.typeClass.resolve(strInfo);
                }
            }
            switch (firstChar) {
                case '*': {
                    return this.getPackage(name);
                }
                case '@': {
                    return this.resolveClass(name);
                }
                case '<': {
                    return this.resolveTypeParameter(tree, name);
                }
                case '^': {
                    return this.rep.getByMofId(name);
                }
            }
            return null;
        }
        if (symbolInfo.getClass().equals(TypeParamRef.class)) {
            TypeParamRef tpRef = (TypeParamRef)symbolInfo;
            return ((MetadataElement)mdrElement).resolveType(tpRef);
        }
        if (symbolInfo instanceof TypeRef) {
            Type el;
            if (mdrElement == null) {
                mdrElement = this.getResource();
            }
            if ((el = ((MetadataElement)mdrElement).resolveType((TypeRef)symbolInfo)) instanceof ParameterizedType) {
                return ((ParameterizedType)el).getDefinition();
            }
            if (el instanceof ParameterizedTypeImpl.Wrapper) {
                ParameterizedTypeImpl.Wrapper w = (ParameterizedTypeImpl.Wrapper)el;
                return (Element)w.getWrappedObject();
            }
            return el;
        }
        if (symbolInfo instanceof FieldRefInfo) {
            JavaClass declClass;
            FieldRefInfo fref = (FieldRefInfo)symbolInfo;
            ClassDefinition javaClass = (ClassDefinition)this.getModelElement(null, null, fref.declClass);
            if (javaClass == null) {
                return null;
            }
            Feature f = (Feature)this.rep.getByMofId(fref.mofid);
            if (f != null && (declClass = (JavaClass)f.getDeclaringClass()).equals(javaClass)) {
                return f;
            }
            String name = fref.name;
            if (fref instanceof CallableRefInfo) {
                CallableRefInfo c = (CallableRefInfo)fref;
                Object[] features = javaClass.getContents().toArray();
                if (name == null) {
                    for (int i = 0; i < features.length; ++i) {
                        ClassMember element = (ClassMember)features[i];
                        if (!(element instanceof Constructor) || !MDRParser.parametersMatch((CallableFeature)element, c.parTypes)) continue;
                        return element;
                    }
                } else {
                    for (int i = 0; i < features.length; ++i) {
                        ClassMember element = (ClassMember)features[i];
                        if (!(element instanceof Method) || !name.equals(element.getName()) || !MDRParser.parametersMatch((CallableFeature)element, c.parTypes)) continue;
                        return element;
                    }
                }
            } else {
                Object[] features = javaClass.getFeatures().toArray();
                for (int i = 0; i < features.length; ++i) {
                    ClassMember element = (ClassMember)features[i];
                    if (!(element instanceof Field) || !name.equals(element.getName())) continue;
                    return element;
                }
            }
            ErrorManager.getDefault().log(16, fref + " not found in " + this.getResource().getName());
            return null;
        }
        if (symbolInfo instanceof LocalVarRefInfo) {
            LocalVarRefInfo localvar = (LocalVarRefInfo)symbolInfo;
            if (localvar.var == null) {
                List<Resource> topCollection = Collections.singletonList(this.getResource());
                localvar.var = (Variable)this.getModelElement(topCollection, localvar.varDeclAST);
            }
            return localvar.var;
        }
        if (!(symbolInfo instanceof MetadataElement) || ((MetadataElement)((Object)symbolInfo)).isTransient()) {
            return symbolInfo;
        }
        JMManager.getLog().log("Invalid type :" + symbolInfo);
        return null;
    }

    private TypeParameter resolveTypeParameter(ASTree tree, String name) {
        int firstToken = tree.getFirstToken();
        int lastToken = tree.getLastToken();
        TypeParameter tp = null;
        Iterator<Object> elIterator = Collections.singletonList(this.getResource()).iterator();
        while (elIterator.hasNext()) {
            MetadataElement el = (MetadataElement)elIterator.next();
            ASTree t = el.getASTree();
            if (t == tree) {
                return tp;
            }
            if (firstToken < t.getFirstToken() || lastToken > t.getLastToken()) continue;
            if (el instanceof GenericElement) {
                Iterator tpIt = ((GenericElement)el).getTypeParameters().iterator();
                while (tpIt.hasNext()) {
                    TypeParameter p = (TypeParameter)tpIt.next();
                    if (!p.getName().equals(name)) continue;
                    tp = p;
                }
            }
            elIterator = el.getChildren().iterator();
        }
        return null;
    }

    private JavaClass resolveClass(TypeParamRef name) {
        SemiPersistentElement res = (SemiPersistentElement)this.getResource();
        JavaClass jcls = (JavaClass)res.resolveType(name);
        if (jcls instanceof ParameterizedType) {
            return ((ParameterizedType)jcls).getDefinition();
        }
        return jcls;
    }

    private JavaClass resolveClass(String name) {
        JavaClass javaClass = this.jclsClass.resolveClass(name, true);
        if (javaClass == null) {
            // empty if block
        }
        return javaClass;
    }

    private MetadataElement getModelElement(Collection elements, ASTree findingTree) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        int firstToken = findingTree.getFirstToken();
        int lastToken = findingTree.getLastToken();
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            MetadataElement element = (MetadataElement)((Object)it.next());
            ASTree elementTree = element.getASTree();
            if (elementTree == findingTree) {
                return element;
            }
            if (elementTree.getFirstToken() > firstToken || elementTree.getLastToken() < lastToken) continue;
            MetadataElement result = this.getModelElement(element.getChildren(), findingTree);
            if (result == null) {
                throw new IllegalArgumentException("Tree not found! (Tree type = " + findingTree.getType() + "; Bounds: " + firstToken + ", " + lastToken + "; Element type: " + elementTree.getType() + "; Bounds: " + elementTree.getFirstToken() + ", " + elementTree.getLastToken() + ")");
            }
            return result;
        }
        return null;
    }

    public boolean isVariableAccess(ASTree tree) {
        Object info;
        if (tree == null) {
            return false;
        }
        if (!this.attributionToDo.isEmpty()) {
            this.doAttribution();
        }
        if ((info = this.semanticInfo.get(tree)) == null) {
            if (tree.getType() == 45) {
                return this.isVariableAccess(tree.getSubTrees()[0]);
            }
            return false;
        }
        if (info.getClass().equals(FieldRefInfo.class) || info instanceof LocalVarRefInfo) {
            return true;
        }
        if (info instanceof String) {
            String id = (String)info;
            if (id.charAt(0) != '^') {
                return false;
            }
            Object jmiObject = this.getSemanticInfo(tree, null);
            return jmiObject instanceof Variable;
        }
        return false;
    }

    static boolean parametersMatch(CallableFeature callableFeature, TypeRef[] parTypes) {
        Object[] params = callableFeature.getParameters().toArray();
        if (params.length != parTypes.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            ParameterImpl par = (ParameterImpl)((Object)params[i]);
            ParameterInfo parInfo = (ParameterInfo)par.getElementInfo();
            if (parTypes[i++].equals(parInfo.type)) continue;
            return false;
        }
        return true;
    }

    void createTypeParametrScope(ASTree typeParsAST) {
        if (typeParsAST == null) {
            return;
        }
        if (typeParsAST.getType() != 78) {
            throw new IllegalArgumentException("Type " + typeParsAST.getType());
        }
        ASTree[] typeParams = typeParsAST.getSubTrees();
        Scope currentScope = (Scope)this.typeScopeInfo.peek();
        for (int i = 0; i < typeParams.length; ++i) {
            ASTree typeParAST = typeParams[i];
            String name = (String)this.processAST(typeParAST.getSubTrees()[0]);
            currentScope.addMember(new TypeParamScope(name));
        }
    }

    void resolveSuperTypes(ASTree classTree, String fqn) {
        int treeType = classTree.getType();
        this.typeScopeInfo.push(new Scope((Scope)this.typeScopeInfo.peek()));
        switch (treeType) {
            case 84: {
                ASTree[] parts = classTree.getSubTrees();
                String name = (String)this.processAST(parts[1]);
                ASTree ifacesAST = parts[2];
                ArrayList<JavaClass> interJcls = Collections.EMPTY_LIST;
                String currentFqn = fqn.length() == 0 ? name : fqn.concat(".").concat(name);
                JavaClass superJcls = null;
                NameRef sclass = NameRef.java_lang_Enum;
                this.semanticInfo.put(parts[1], sclass);
                if (ifacesAST != null) {
                    ASTree[] ifaces = ifacesAST.getSubTrees();
                    NameRef[] interfaces = new NameRef[ifaces.length];
                    interJcls = new ArrayList<JavaClass>();
                    for (int i = 0; i < ifaces.length; ++i) {
                        interfaces[i] = (NameRef)this.resolveTypeName(ifaces[i]);
                        interJcls.add(this.resolveClass(interfaces[i]));
                    }
                    this.semanticInfo.put(ifacesAST, interfaces);
                }
                if (this.semanticInfo.get(classTree) == null) {
                    JavaClass jcls = this.getClassByFqn(currentFqn);
                    if (jcls == null) {
                        JMManager.getLog().log("Enum not found in index: " + currentFqn + ". Recovering...");
                        Thread.dumpStack();
                        jcls = this.enumClass.create(currentFqn, 0, false);
                        this.setParent(jcls, fqn);
                    } else if (!(jcls instanceof JavaEnum)) {
                        JMManager.getLog().log(1, "Wrong type of object found in index. Expected: JavaEnum, found: " + jcls.getClass().getName());
                        JMManager.getLog().log(1, "Recovering...");
                        Thread.dumpStack();
                        JavaClass oldCls = jcls;
                        jcls = this.enumClass.create(currentFqn, oldCls.getModifiers(), false);
                        this.swapChild(oldCls, jcls);
                    }
                    this.semanticInfo.put(classTree, jcls);
                }
                if (sclass != null) {
                    superJcls = this.resolveClass(sclass);
                }
                superInfoMap.put(currentFqn, new SuperInfo(superJcls, interJcls));
                this.localSuperInfo.add(currentFqn);
                break;
            }
            case 13: 
            case 37: 
            case 89: {
                ASTree ifacesAST;
                ASTree superclassAST;
                ASTree[] parts = classTree.getSubTrees();
                String name = (String)this.processAST(parts[1]);
                ArrayList<JavaClass> interJcls = Collections.EMPTY_LIST;
                NameRef sclass = null;
                String currentFqn = fqn.length() == 0 ? name : fqn.concat(".").concat(name);
                JavaClass superJcls = null;
                if (treeType == 89) {
                    superclassAST = null;
                    ifacesAST = null;
                    sclass = NameRef.java_lang_Annotation;
                } else {
                    this.createTypeParametrScope(parts[2]);
                    superclassAST = parts[3];
                    ifacesAST = parts[4];
                    if (superclassAST != null) {
                        sclass = (NameRef)this.resolveTypeName(superclassAST.getSubTrees()[0]);
                    } else if (!(name.equals("Object") && this.jpck.equals("java.lang") || treeType != 13)) {
                        sclass = NameRef.java_lang_Object;
                    }
                }
                if (sclass != null) {
                    this.semanticInfo.put(parts[1], sclass);
                }
                if (ifacesAST != null) {
                    ASTree[] ifaces = ifacesAST.getSubTrees();
                    NameRef[] interfaces = new NameRef[ifaces.length];
                    interJcls = new ArrayList<JavaClass>();
                    for (int i = 0; i < ifaces.length; ++i) {
                        interfaces[i] = (NameRef)this.resolveTypeName(ifaces[i]);
                        interJcls.add(this.resolveClass(interfaces[i]));
                    }
                    this.semanticInfo.put(ifacesAST, interfaces);
                }
                if (this.semanticInfo.get(classTree) == null) {
                    JavaClass jcls = this.getClassByFqn(currentFqn);
                    if (jcls == null) {
                        JMManager.getLog().notify(1, (Throwable)new Exception((treeType == 89 ? "Annotation" : "Class") + " not found in index: " + currentFqn + ". Recovering..."));
                        jcls = treeType == 89 ? this.annotClass.create(currentFqn, 0, false) : this.jclsClass.create(currentFqn, 0, null, null, false);
                        this.setParent(jcls, fqn);
                    } else if (treeType == 89 && !(jcls instanceof AnnotationType)) {
                        JMManager.getLog().log(16, "Wrong type of object found in index. Expected: AnnotationType, found: " + jcls.getClass().getName());
                        JMManager.getLog().notify(1, (Throwable)new Exception("Recovering..."));
                        JavaClass oldCls = jcls;
                        jcls = this.annotClass.create(currentFqn, oldCls.getModifiers(), false);
                        this.swapChild(oldCls, jcls);
                    } else if (treeType != 89 && (jcls instanceof AnnotationType || jcls instanceof JavaEnum)) {
                        JMManager.getLog().log(16, "Wrong type of object found in index. Expected: JavaClass, found: " + jcls.getClass().getName());
                        JMManager.getLog().notify(1, (Throwable)new Exception("Recovering..."));
                        JavaClass oldCls = jcls;
                        jcls = this.jclsClass.create(currentFqn, oldCls.getModifiers(), null, null, false);
                        this.swapChild(oldCls, jcls);
                    }
                    this.semanticInfo.put(classTree, jcls);
                }
                if (sclass != null) {
                    superJcls = this.resolveClass(sclass);
                }
                superInfoMap.put(currentFqn, new SuperInfo(superJcls, interJcls));
                this.localSuperInfo.add(currentFqn);
            }
        }
        this.typeScopeInfo.pop();
    }

    private JavaClass getClassByFqn(String currentFqn) {
        JavaClass jcls = null;
        Set classes = this.index.getClassesByFqn(currentFqn);
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            JavaClass tmp = (JavaClass)it.next();
            if (!tmp.isValid() || !this.getResource().equals(tmp.getResource())) continue;
            jcls = tmp;
            break;
        }
        return jcls;
    }

    private void swapChild(JavaClass oldType, JavaClass newType) {
        RefFeatured parent = oldType.refImmediateComposite();
        if (parent instanceof ResourceImpl) {
            ListIterator<JavaClass> it = ((ResourceImpl)parent).getPersistentClassifiers().listIterator();
            while (it.hasNext()) {
                JavaClass cls = (JavaClass)it.next();
                if (!cls.equals(oldType)) continue;
                it.set(newType);
                oldType.refDelete();
                if (((ResourceImpl)parent).classifiersInited()) {
                    ((ResourceImpl)parent).reinitClassifiers();
                }
                return;
            }
            JMManager.getLog().log("Old type wasn't found in classifiers of its parent resource. Adding newType to the end of the resource classifiers list...");
            it.add(newType);
            oldType.refDelete();
            return;
        }
        if (parent instanceof JavaClassImpl) {
            JavaClassImpl enclosingClass = (JavaClassImpl)parent;
            boolean contentsInited = enclosingClass.contentsInited();
            boolean contentsEmpty = enclosingClass.getPersistentContents().isEmpty();
            if (contentsInited || !contentsEmpty) {
                ListIterator<JavaClass> it = enclosingClass.getPersistentContents().listIterator();
                while (it.hasNext()) {
                    Element cls = (Element)it.next();
                    if (!cls.equals(oldType)) continue;
                    it.set(newType);
                    oldType.refDelete();
                    if (contentsInited) {
                        enclosingClass.reinitContents();
                    }
                    return;
                }
                JMManager.getLog().log("Old type wasn't found in classifiers of its parent resource. Adding newType to the end of the resource classifiers list...");
                it.add(newType);
            } else {
                ((JavaClassImpl)newType).setParentClass(enclosingClass);
            }
            ((JavaClassImpl)oldType).setParentClass(null);
            oldType.refDelete();
            return;
        }
        JMManager.getLog().log("Parent of newType has not been set since parent of the oldType is: " + parent.getClass().getName());
    }

    private void setParent(JavaClass jcls, String fqn) {
        if (fqn.equals(this.jpck)) {
            ResourceImpl res = (ResourceImpl)this.getResource();
            res.getPersistentClassifiers().add(jcls);
            if (res.classifiersInited()) {
                res.reinitClassifiers();
            }
        } else {
            JavaClassImpl enclosingClass = (JavaClassImpl)this.getClassByFqn(fqn);
            if (enclosingClass == null) {
                JMManager.getLog().log("Could not find parent class: " + fqn);
                JMManager.getLog().log("Setting resource as a parent...");
                ResourceImpl res = (ResourceImpl)this.getResource();
                res.getPersistentClassifiers().add(jcls);
                if (res.classifiersInited()) {
                    res.reinitClassifiers();
                }
            } else {
                boolean contentsInited = enclosingClass.contentsInited();
                boolean contentsEmpty = enclosingClass.getPersistentContents().isEmpty();
                if (contentsInited || !contentsEmpty) {
                    enclosingClass.getPersistentContents().add(jcls);
                    if (contentsInited) {
                        enclosingClass.reinitContents();
                    }
                } else {
                    ((JavaClassImpl)jcls).setParentClass(enclosingClass);
                }
            }
        }
    }

    ModifiersInfo getModifiers(ASTree t) {
        ModifiersInfo nfo = (ModifiersInfo)this.processAST(t);
        return nfo == null ? NO_MODIFIERS : nfo;
    }

    private int getDeprecated(ASTree t) {
        Token tok = this.getToken(t.getFirstToken());
        return tok.getDeprecatedFlag() ? Integer.MIN_VALUE : 0;
    }

    public static TypeRef fullType(Object t, Object dims) {
        TypeRef td = (TypeRef)t;
        if (dims != null) {
            int dimension = (Integer)dims;
            if (td instanceof ArrayRef) {
                ArrayRef aref = (ArrayRef)td;
                return new ArrayRef(aref.parent, aref.dimCount + dimension);
            }
            return new ArrayRef((PrimitiveTypeRef)td, dimension);
        }
        return td;
    }

    Type fullType(Type td, Object dims) {
        if (dims != null) {
            int dimension = (Integer)dims;
            ArrayClass arrayClass = ((JavaModelPackage)td.refImmediatePackage()).getArray();
            for (int i = 0; i < dimension; ++i) {
                td = arrayClass.resolveArray(td);
            }
        }
        return td;
    }

    private static Object[] getArray(Object obj) {
        if (obj == null) {
            return new Object[0];
        }
        if (obj.getClass().isArray()) {
            return (Object[])obj;
        }
        return new Object[]{obj};
    }

    TypeRef resolveTypeName(ASTree typeAST) {
        if (typeAST != null) {
            int treeType = typeAST.getType();
            if (treeType == 361) {
                Object name = this.resolveTypeName((String)this.processAST(typeAST));
                this.storeSemanticInfo(typeAST, name);
                if (name instanceof TypeRef) {
                    return (TypeRef)name;
                }
                if (name instanceof Type) {
                    return SemiPersistentElement.typeToTypeRef((Type)name);
                }
                String fqn = name instanceof JavaPackage ? ((JavaPackage)name).getName() : (String)name;
                return new NameRef(fqn, null, null);
            }
            return (TypeRef)this.processAST(typeAST);
        }
        return null;
    }

    Object resolveTypeName(String simpleName) {
        Scope currentScope = (Scope)this.typeScopeInfo.peek();
        Object ref = currentScope.lookup(simpleName);
        if (ref == null) {
            JavaPackage jpck = this.getPackage(simpleName);
            if (jpck != null) {
                return jpck;
            }
            return simpleName;
        }
        return ref;
    }

    private PrimitiveTypeRef getPrimitiveType(ASTree tree) {
        switch (tree.getType()) {
            case 261: {
                return PrimitiveTypeRef.BYTE;
            }
            case 293: {
                return PrimitiveTypeRef.SHORT;
            }
            case 283: {
                return PrimitiveTypeRef.INT;
            }
            case 285: {
                return PrimitiveTypeRef.LONG;
            }
            case 264: {
                return PrimitiveTypeRef.CHAR;
            }
            case 276: {
                return PrimitiveTypeRef.FLOAT;
            }
            case 270: {
                return PrimitiveTypeRef.DOUBLE;
            }
            case 259: {
                return PrimitiveTypeRef.BOOLEAN;
            }
            case 304: {
                return PrimitiveTypeRef.VOID;
            }
        }
        ErrorManager.getDefault().log(65536, "Unknown type " + tree.getType());
        return null;
    }

    JavaClass getSuperClass(ClassDefinition jcls) {
        SuperInfo info = (SuperInfo)superInfoMap.get(jcls.getName());
        if (info != null) {
            return info.superClass;
        }
        if (this.getResource().equals(jcls.getResource())) {
            JMManager.getLog().log(1, "Unresolved superclass for " + jcls.getName());
            return null;
        }
        JavaClass superClass = jcls.getSuperClass();
        if (superClass instanceof ParameterizedType) {
            return ((ParameterizedType)superClass).getDefinition();
        }
        return superClass;
    }

    Collection getInterfaces(ClassDefinition jcls) {
        SuperInfo info = (SuperInfo)superInfoMap.get(jcls.getName());
        if (info != null) {
            return info.interfaces;
        }
        if (this.getResource().equals(jcls.getResource())) {
            JMManager.getLog().log(1, "Unresolved Interface for " + jcls.getName());
            return Collections.EMPTY_LIST;
        }
        return jcls.getInterfaces();
    }

    private Type processASTBody(ASTree tree) {
        ClassDefinition td = null;
        if (tree == null) {
            return null;
        }
        ASTree[] parts = tree.getSubTrees();
        int treeType = tree.getType();
        block0 : switch (treeType) {
            case 15: {
                this.typeScopeInfo.push(Scope.createTypeScope(this.getResource(), this.classPath));
                this.processASTBody(parts[2]);
                this.typeScopeInfo.pop();
                break;
            }
            case 13: 
            case 37: 
            case 84: 
            case 89: {
                ClassDefinition savedCurrentClass = this.currentClass;
                this.currentClass = (ClassDefinition)this.semanticInfo.get(tree);
                if (this.currentClass != null) {
                    Scope classScope = new Scope((Scope)this.typeScopeInfo.peek());
                    Scope varScope = new Scope((Scope)this.variableScope.peek());
                    classScope.addMember(Scope.createMemberTypeScope(this.currentClass, this));
                    varScope.addMember(Scope.createFieldScope(this.currentClass));
                    this.typeScopeInfo.push(classScope);
                    this.variableScope.push(varScope);
                    if (treeType == 84) {
                        ASTree enumBodyDecls = parts[3].getSubTrees()[1];
                        if (enumBodyDecls != null) {
                            this.processASTBody(enumBodyDecls);
                        }
                    } else if (treeType == 89) {
                        this.processASTBody(parts[2]);
                    } else {
                        this.processASTBody(parts[5]);
                    }
                    this.variableScope.pop();
                    this.typeScopeInfo.pop();
                } else {
                    Scope currTypeScope = (Scope)this.typeScopeInfo.peek();
                    Scope currVarScope = (Scope)this.variableScope.peek();
                    JavaClassImpl locClass = this.createTransientClasses(tree, null);
                    currTypeScope.addMember(new LocalClassScope(locClass));
                    this.resolveSuperTypes(tree, "");
                    ClassInfo locClassInfo = (ClassInfo)this.processAST(tree);
                    locClass.updatePersistent(locClassInfo);
                    locClass.setElementInfo(locClassInfo);
                    Token firstBodyToken = this.getToken(parts[parts.length - 1].getFirstToken());
                    this.semanticInfo.put(firstBodyToken, new Scope[]{(Scope)currTypeScope.clone(), (Scope)currVarScope.clone()});
                }
                this.currentClass = savedCurrentClass;
                break;
            }
            case 28: {
                ASTree varDeclsTree = parts[2];
                if (varDeclsTree.getType() == 70) {
                    this.processASTBody(varDeclsTree.getSubTrees()[2]);
                    break;
                }
                ASTree[] varDeclsTreeArray = varDeclsTree.getSubTrees();
                for (int i = 0; i < varDeclsTreeArray.length; ++i) {
                    ASTree varDeclTree = varDeclsTreeArray[i];
                    this.processASTBody(varDeclTree.getSubTrees()[2]);
                }
                break;
            }
            case 82: {
                ASTree identifier = parts[0];
                ASTree initValue = parts[1];
                ASTree anonymousClass = parts[2];
                List parTypes = this.getArgumetsTypes(initValue);
                this.usesMethod(null, this.currentClass, parTypes, identifier, false);
                if (anonymousClass == null) break;
                this.createAnonClass(anonymousClass, (JavaClass)this.currentClass, null);
                break;
            }
            case 18: 
            case 41: {
                CallableFeature bhFeature = (CallableFeature)this.semanticInfo.get(tree);
                Scope methodVarScope = new Scope((Scope)this.variableScope.peek());
                Scope methodTypeScope = new Scope((Scope)this.typeScopeInfo.peek());
                Iterator parIt = bhFeature.getParameters().iterator();
                Iterator typeParIt = bhFeature.getTypeParameters().iterator();
                while (parIt.hasNext()) {
                    Parameter fp = (Parameter)parIt.next();
                    methodVarScope.addMember(new LocalVarScope((Variable)fp));
                }
                while (typeParIt.hasNext()) {
                    TypeParameter tp = (TypeParameter)typeParIt.next();
                    methodTypeScope.addMember(new TypeParamScope(tp));
                }
                this.variableScope.push(methodVarScope);
                this.typeScopeInfo.push(methodTypeScope);
                this.processASTBody(parts[5]);
                this.typeScopeInfo.pop();
                this.variableScope.pop();
                break;
            }
            case 36: 
            case 56: {
                this.variableScope.push(new Scope((Scope)this.variableScope.peek()));
                this.typeScopeInfo.push(new Scope((Scope)this.typeScopeInfo.peek()));
                this.processASTBody(parts[1]);
                this.typeScopeInfo.pop();
                this.variableScope.pop();
                break;
            }
            case 30: {
                ParameterInfo par = (ParameterInfo)this.processAST(tree);
                Scope currVarScope = (Scope)this.variableScope.peek();
                Type type = ((SemiPersistentElement)this.currentFeature).resolveType(par.type);
                LocalVarRefInfo ref = new LocalVarRefInfo(tree, type);
                currVarScope.addMember(new LocalVarScope(par.name, ref));
                this.storeSemanticInfo(tree, par);
                break;
            }
            case 7: 
            case 10: 
            case 58: {
                boolean createVarScope;
                if (parts == null || parts.length <= 0) break;
                boolean bl = createVarScope = treeType != 7 || this.getToken(tree.getFirstToken()).getType() == 309;
                if (createVarScope) {
                    this.variableScope.push(((Scope)this.variableScope.peek()).clone());
                }
                for (int i = 0; i < parts.length; ++i) {
                    this.processASTBody(parts[i]);
                }
                if (!createVarScope) break;
                this.variableScope.pop();
                break;
            }
            case 40: {
                ASTree[] varDeclsTreeArray;
                Scope currVarScope = (Scope)this.variableScope.peek();
                ASTree modifiers = parts[0];
                ModifiersInfo modInfo = this.getModifiers(modifiers);
                Type type = this.resolveClassName(parts[1]);
                ASTree varDeclsTree = parts[2];
                Object[] names = MDRParser.getArray(this.processAST(varDeclsTree));
                if (modifiers != null) {
                    Boolean isFinal = Modifier.isFinal(modInfo.modifiers);
                    AnnotationInfo[] ann = modInfo.annotations;
                    this.semanticInfo.put(modifiers, new Object[]{isFinal, ann});
                }
                this.usesType(type, tree);
                if (varDeclsTree.getType() == 70) {
                    varDeclsTreeArray = new ASTree[]{varDeclsTree};
                    names = new Object[]{names};
                } else {
                    varDeclsTreeArray = varDeclsTree.getSubTrees();
                }
                for (int i = 0; i < names.length; ++i) {
                    Object[] name = (Object[])names[i];
                    Type varType = this.fullType(type, name[1]);
                    String varName = (String)name[0];
                    ASTree varDecl = varDeclsTreeArray[i];
                    if (names.length > 1) {
                        this.usesType(varType, varDecl);
                    }
                    currVarScope.addMember(new LocalVarScope(varName, new LocalVarRefInfo(varDecl, varType)));
                    this.processASTBody(varDecl.getSubTrees()[2]);
                }
                break;
            }
            case 32: {
                ASTree initAST = parts[0];
                Scope forScope = null;
                if (initAST != null && initAST.getType() == 40) {
                    forScope = new Scope((Scope)this.variableScope.peek());
                    this.variableScope.push(forScope);
                }
                for (int i = 0; i < parts.length; ++i) {
                    this.processASTBody(parts[i]);
                }
                if (forScope == null) break;
                this.variableScope.pop();
                break;
            }
            case 29: {
                this.variableScope.push(((Scope)this.variableScope.peek()).clone());
                for (int i = 0; i < parts.length; ++i) {
                    this.processASTBody(parts[i]);
                }
                this.variableScope.pop();
                break;
            }
            case 63: {
                Type switchExpression = TypeClassImpl.getRawType(this.processASTBody(parts[0]));
                boolean enumSwitch = switchExpression instanceof JavaEnum;
                Scope oldEnumScope = this.enumSwitchScope;
                this.enumSwitchScope = enumSwitch ? Scope.createFieldScope((ClassDefinition)((JavaEnum)switchExpression)) : null;
                this.processASTBody(parts[1]);
                this.enumSwitchScope = oldEnumScope;
                break;
            }
            case 61: {
                if (this.enumSwitchScope != null) {
                    this.variableScope.push(this.enumSwitchScope);
                }
                this.processASTBody(parts[0]);
                if (this.enumSwitchScope == null) break;
                this.variableScope.pop();
                break;
            }
            case 49: {
                Type classType = this.resolveClassName(parts[0]);
                return this.jclsClass.resolveClass("java.lang.Class", false);
            }
            case 50: {
                if (parts != null) {
                    td = this.resolveClassName(parts[0]);
                    break;
                }
                td = this.currentClass;
                break;
            }
            case 355: 
            case 356: 
            case 357: 
            case 358: 
            case 359: 
            case 360: {
                String typeText;
                Object value = ((Token)tree).getValue();
                switch (treeType) {
                    case 356: {
                        if (value instanceof Long) {
                            typeText = "long";
                            break;
                        }
                        typeText = "int";
                        break;
                    }
                    case 357: {
                        if (value instanceof Double) {
                            typeText = "double";
                            break;
                        }
                        typeText = "float";
                        break;
                    }
                    case 355: {
                        typeText = "boolean";
                        break;
                    }
                    case 358: {
                        typeText = "char";
                        break;
                    }
                    case 359: {
                        return this.resolveClass("java.lang.String");
                    }
                    case 360: {
                        return this.resolveClass("java.lang.Object");
                    }
                    default: {
                        ErrorManager.getDefault().log(65536, "Unknown Literal: " + treeType);
                        return null;
                    }
                }
                return this.typeClass.resolve(typeText);
            }
            case 14: {
                ASTree primaryAST = parts[0];
                ASTree classIdAST = parts[2];
                ASTree anonymousClass = parts[4];
                NameRef cls = null;
                if (primaryAST == null) {
                    td = this.resolveClassName(classIdAST);
                    if (classIdAST.getType() == 45) {
                        cls = (NameRef)this.processAST(classIdAST);
                    }
                } else {
                    Object type;
                    JavaClass jcls = (JavaClass)this.resolvePrimaryWithSuper(primaryAST, false, treeType);
                    if (jcls != null && (type = this.getMemberOf(jcls, (Token)classIdAST)) instanceof JavaClass) {
                        td = (JavaClass)type;
                        this.usesType((Type)td, classIdAST);
                    }
                }
                List parTypes = this.getArgumetsTypes(parts[3]);
                if (td == null) break;
                this.usesMethod(null, (ClassDefinition)((JavaClass)td), parTypes, tree, false);
                if (anonymousClass == null) break;
                this.createAnonClass(anonymousClass, (JavaClass)td, cls);
                break;
            }
            case 3: {
                int i;
                ASTree elemTypeAST = parts[0];
                Type elemType = this.resolveClassName(elemTypeAST);
                if (elemType != null) {
                    ASTree dimsExprAST = parts[1];
                    ASTree dimsAST = parts[2];
                    int dims = this.getDimExprsDimenstion(dimsExprAST);
                    Integer dimsVal = (Integer)this.processAST(dimsAST);
                    if (dimsVal != null) {
                        dims += dimsVal.intValue();
                    }
                    if (dims > 0) {
                        ArrayClass arrayClass = ((JavaModelPackage)elemType.refImmediatePackage()).getArray();
                        for (i = 0; i < dims; ++i) {
                            elemType = arrayClass.resolveArray(elemType);
                        }
                    }
                    this.usesType(elemType, tree);
                }
                for (i = 1; i < parts.length; ++i) {
                    this.processASTBody(parts[i]);
                }
                td = elemType;
                break;
            }
            case 27: {
                Token fieldId = (Token)parts[2];
                String fieldName = (String)fieldId.getValue();
                boolean hasSuper = parts[1] != null;
                ClassDefinition jcls = this.resolvePrimaryWithSuper(parts[0], hasSuper, treeType);
                if (jcls == null || jcls instanceof UnresolvedClass) {
                    return null;
                }
                Field field = (Field)Scope.createFieldScope(jcls).lookup(fieldName);
                if (field == null) break;
                td = field.getType();
                this.usesField((Variable)field, fieldId);
                this.storeSemanticInfo(tree, field);
                if (!(td instanceof JavaClass) || !(td instanceof PrimitiveType)) break;
                break;
            }
            case 43: {
                ASTree pTree = parts[0];
                Token methodId = (Token)parts[3];
                String methodName = (String)methodId.getValue();
                boolean hasSuper = parts[1] != null;
                ClassDefinition jcls = this.resolvePrimaryWithSuper(pTree, hasSuper, treeType);
                if (jcls != null) {
                    // empty if block
                }
                List parTypes = this.getArgumetsTypes(parts[4]);
                if (jcls == null) break;
                boolean impicitThis = pTree == null && !hasSuper;
                td = this.usesMethod(methodName, jcls, parTypes, tree, impicitThis);
                break;
            }
            case 25: {
                ASTree pTree = parts[0];
                boolean hasSuper = parts[2].getType() == 296;
                ClassDefinition jcls = this.resolvePrimaryWithSuper(pTree, hasSuper, treeType);
                if (jcls != null) {
                    // empty if block
                }
                List parTypes = this.getArgumetsTypes(parts[3]);
                if (jcls == null) break;
                td = this.usesMethod(null, jcls, parTypes, tree, false);
                break;
            }
            case 2: {
                ASTree arrTypeAST = parts[0];
                td = this.processASTBody(arrTypeAST);
                this.processASTBody(parts[1]);
                if (td == null) break;
                if (td instanceof UnresolvedClass) {
                    td = null;
                    break;
                }
                if (!(td instanceof Array)) break;
                td = ((Array)td).getType();
                break;
            }
            case 47: {
                ASTree fieldAccess = parts[0];
                td = this.processASTBody(fieldAccess);
                for (int i = 1; i < parts.length; ++i) {
                    this.processASTBody(parts[i]);
                }
                break;
            }
            case 48: {
                td = this.processASTBody(parts[1]);
                break;
            }
            case 16: {
                td = this.processASTBody(parts[0]);
                break;
            }
            case 9: {
                ASTree typeTree = parts[0];
                int type = typeTree.getType();
                if (type == 47) {
                    typeTree = typeTree.getSubTrees()[0];
                    type = typeTree.getType();
                }
                if (type != 51 && type != 45 && type != 361 && type != 52) {
                    return null;
                }
                td = this.resolveClassName(typeTree);
                this.processASTBody(parts[1]);
                break;
            }
            case 35: {
                int operatorType = parts[1].getType();
                Type leftType = this.processASTBody(parts[0]);
                Type rightType = operatorType == 282 ? this.resolveClassName(parts[2]) : this.processASTBody(parts[2]);
                switch (operatorType) {
                    case 282: 
                    case 319: 
                    case 320: 
                    case 325: 
                    case 326: 
                    case 327: 
                    case 328: 
                    case 329: 
                    case 330: {
                        td = this.typeClass.resolve("boolean");
                        break block0;
                    }
                    case 333: {
                        if (leftType instanceof ClassDefinition || rightType instanceof ClassDefinition) {
                            td = this.resolveClass("java.lang.String");
                            break block0;
                        }
                    }
                    case 334: 
                    case 335: 
                    case 336: 
                    case 337: 
                    case 338: 
                    case 339: 
                    case 340: {
                        td = this.computeType(leftType, rightType);
                        break block0;
                    }
                    case 341: 
                    case 342: 
                    case 343: {
                        if (leftType == null || !"long".equals(leftType.getName())) {
                            td = this.typeClass.resolve("int");
                            break block0;
                        }
                        td = this.typeClass.resolve("long");
                        break block0;
                    }
                }
                ErrorManager.getDefault().log(16, "Unknown operator " + operatorType + " in " + this.getText(tree));
                break;
            }
            case 17: {
                this.processASTBody(parts[0]);
                td = this.processASTBody(parts[1]);
                this.processASTBody(parts[2]);
                break;
            }
            case 6: {
                ASTree leftTree = parts[0];
                td = this.processASTBody(leftTree);
                this.processASTBody(parts[2]);
                break;
            }
            case 52: {
                ASTree dim = parts[1];
                td = this.processASTBody(parts[0]);
                if (dim == null) break;
                td = this.fullType((Type)td, this.processAST(dim));
                break;
            }
            case 51: {
                td = ((SemiPersistentElement)this.getResource()).resolveType(this.getPrimitiveType(parts[0]));
                break;
            }
            case 45: 
            case 361: {
                Object type = this.processMultiPartId(tree, parts);
                if (type instanceof Type) {
                    td = (Type)type;
                    break;
                }
                return null;
            }
            default: {
                if (parts == null) break;
                for (int i = 0; i < parts.length; ++i) {
                    this.processASTBody(parts[i]);
                }
            }
        }
        this.usesType((Type)td, tree);
        return td;
    }

    private JavaClassImpl createTransientClasses(ASTree tree, JavaClass parent) {
        if (tree == null) {
            return null;
        }
        ASTree[] parts = tree.getSubTrees();
        int treeType = tree.getType();
        switch (treeType) {
            case 13: 
            case 37: 
            case 84: 
            case 89: {
                JavaClassImpl jcls;
                ASTree body;
                String currentFqn;
                String name = (String)this.processAST(parts[1]);
                String string = currentFqn = parent == null ? name : parent.getName().concat(".").concat(name);
                if (treeType == 84) {
                    body = parts[3];
                    jcls = this.enumClass.create(currentFqn, 16384, true);
                } else if (treeType == 89) {
                    body = parts[2];
                    jcls = this.annotClass.create(currentFqn, 8192, true);
                } else {
                    int mods = 0;
                    if (treeType == 37) {
                        mods = 512;
                    }
                    body = parts[5];
                    jcls = this.jclsClass.create(currentFqn, mods, null, null, true);
                }
                if (parent != null) {
                    ((JavaClassImpl)jcls).setParentClass((JavaClassImpl)parent);
                }
                this.semanticInfo.put(tree, jcls);
                this.createTransientClasses(body, jcls);
                return jcls;
            }
            case 12: 
            case 38: 
            case 81: 
            case 88: {
                for (int i = 0; i < parts.length; ++i) {
                    this.createTransientClasses(parts[i], parent);
                }
                break;
            }
        }
        return null;
    }

    private void createAnonClass(ASTree anonymousClass, JavaClass superClass, NameRef cls) {
        Scope classScope = new Scope((Scope)this.typeScopeInfo.peek());
        NameRef[] ifcs = null;
        Token firstToken = this.getToken(anonymousClass.getFirstToken());
        if (cls == null) {
            cls = (NameRef)SemiPersistentElement.typeToTypeRef((Type)superClass);
        }
        classScope.addMember(Scope.createMemberTypeScope((ClassDefinition)superClass, this));
        this.typeScopeInfo.push(classScope);
        this.createTransientClasses(anonymousClass, null);
        FeatureInfo[] features = (FeatureInfo[])this.processAST(anonymousClass, "");
        if (superClass.isInterface()) {
            ifcs = new NameRef[]{cls};
            cls = NameRef.java_lang_Object;
        }
        ClassInfo clsInfo = new ClassInfo(anonymousClass, anonymousClass.getType(), null, 0, features, cls, ifcs, null, ElementInfo.EMPTY_ANNOTATIONS);
        this.semanticInfo.put(firstToken, new Scope[]{classScope, (Scope)this.variableScope.peek()});
        this.typeScopeInfo.pop();
        this.semanticInfo.put(anonymousClass, clsInfo);
    }

    private Object processIdentifier(Token identifier) {
        Object type = this.resolveName(identifier);
        Variable refField = null;
        if (type == null) {
            return null;
        }
        if (type instanceof Variable) {
            refField = (Variable)type;
            type = refField.getType();
            this.usesField(refField, identifier);
        } else {
            this.storeSemanticInfo(identifier, type);
            if (type instanceof LocalVarRefInfo) {
                type = ((LocalVarRefInfo)type).type;
            }
        }
        return type;
    }

    private Object processMultiPartId(ASTree tree, ASTree[] parts) {
        Object type;
        if (tree.getType() == 361) {
            return this.processIdentifier((Token)tree);
        }
        if (tree.getType() == 3) {
            ASTree elemTypeAST = parts[0];
            Type elemType = this.resolveClassName(elemTypeAST);
            if (elemType != null) {
                ASTree dimsExprAST = parts[1];
                ASTree dimsAST = parts[2];
                int dims = this.getDimExprsDimenstion(dimsExprAST);
                Integer dimsVal = (Integer)this.processAST(dimsAST);
                if (dimsVal != null) {
                    dims += dimsVal.intValue();
                }
                if (dims > 0) {
                    ArrayClass arrayClass = ((JavaModelPackage)elemType.refImmediatePackage()).getArray();
                    for (int i = 0; i < dims; ++i) {
                        elemType = arrayClass.resolveArray(elemType);
                    }
                }
                this.usesType(elemType, tree);
            }
            for (int i = 1; i < parts.length; ++i) {
                this.processASTBody(parts[i]);
            }
            return elemType;
        }
        ASTree parent = parts[0];
        Token member = (Token)parts[1];
        Field refField = null;
        type = parent != null ? (!((type = this.processMultiPartId(parent, parent.getSubTrees())) instanceof PrimitiveType) ? this.getMemberOf(type, member) : null) : this.processIdentifier(member);
        if (type != null) {
            if (type instanceof Field) {
                refField = (Field)type;
                type = refField.getType();
                this.usesField((Variable)refField, member);
            } else {
                this.storeSemanticInfo(member, type);
                if (type instanceof LocalVarRefInfo) {
                    type = ((LocalVarRefInfo)type).type;
                }
            }
            if (refField != null) {
                this.usesField((Variable)refField, tree);
            } else {
                this.storeSemanticInfo(tree, type);
            }
        }
        this.processASTBody(parts[2]);
        return type;
    }

    private Object getMemberOf(Object element, Token id) {
        String member = (String)id.getValue();
        if (element instanceof ClassDefinition) {
            ClassDefinition jcls = (ClassDefinition)element;
            Object memberFeature = null;
            if (!this.resolveClassName) {
                memberFeature = Scope.createFieldScope(jcls).lookup(member);
            }
            if (memberFeature == null) {
                memberFeature = Scope.createMemberTypeScope(jcls, this).lookup(member);
                if (jcls != null && memberFeature instanceof String) {
                    memberFeature = this.resolveClass((String)memberFeature);
                }
            }
            if (memberFeature == null && this.resolveClassName) {
                memberFeature = this.jclsClass.resolve(jcls.getName() + "." + member);
            }
            return memberFeature;
        }
        if (element instanceof JavaPackage) {
            String fqn = ((JavaPackage)element).getName().concat(".").concat(member);
            JavaClass jcls = this.resolveClass(fqn);
            if (jcls != null) {
                return jcls;
            }
            return this.getPackage(fqn);
        }
        if (element instanceof Array) {
            if (member.equals("length")) {
                return this.typeClass.resolve("int");
            }
            return null;
        }
        return null;
    }

    private Object resolveName(Token id) {
        Scope varScope;
        Object je;
        String simpleName = (String)id.getValue();
        if (!this.resolveClassName && (je = (varScope = (Scope)this.variableScope.peek()).lookup(simpleName)) != null) {
            return je;
        }
        je = this.staticImpScope.lookup(simpleName);
        if (je != null) {
            return je;
        }
        Scope typeScope = (Scope)this.typeScopeInfo.peek();
        je = typeScope.lookup(simpleName);
        if (je != null && je instanceof String) {
            je = this.resolveClass((String)je);
        }
        if (je == null) {
            je = this.resolveClass(simpleName);
        }
        if (je != null) {
            return je;
        }
        je = this.getPackage(simpleName);
        if (je != null) {
            return je;
        }
        return this.typeClass.resolve(simpleName);
    }

    private ClassDefinition resolvePrimaryWithSuper(ASTree primaryTree, boolean hasSuper, int parentTreeType) {
        Type type;
        Object jcls = primaryTree != null ? ((type = !hasSuper || parentTreeType == 25 ? this.processASTBody(primaryTree) : this.resolveClassName(primaryTree)) instanceof ClassDefinition ? (ClassDefinition)type : this.jclsClass.resolveClass("java.lang.Object", false)) : this.currentClass;
        if (hasSuper && jcls != null) {
            jcls = jcls.getSuperClass();
        }
        return jcls;
    }

    private List getArgumetsTypes(ASTree argListTree) {
        ArrayList parTypes = new ArrayList();
        if (argListTree != null) {
            if (argListTree.getType() == 1) {
                ASTree[] argsAST = argListTree.getSubTrees();
                for (int i = 0; i < argsAST.length; ++i) {
                    this.addArgumentToList(parTypes, argsAST[i]);
                }
            } else {
                this.addArgumentToList(parTypes, argListTree);
            }
        }
        return parTypes;
    }

    private Type resolveClassName(ASTree tree) {
        this.resolveClassName = true;
        Type type = this.processASTBody(tree);
        this.resolveClassName = false;
        return type;
    }

    private void addArgumentToList(List list, ASTree argExpr) {
        Type argType = this.processASTBody(argExpr);
        if (argType == null) {
            argType = this.typeClass.resolve("void");
        }
        list.add(argType);
    }

    private int getDimExprsDimenstion(ASTree dimexprs) {
        if (dimexprs == null) {
            return 0;
        }
        if (dimexprs.getType() == 21) {
            return dimexprs.getSubTrees().length;
        }
        return 1;
    }

    private Type computeType(Type left, Type right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        if (left instanceof PrimitiveType && right instanceof PrimitiveType) {
            PrimitiveTypeKind leftKind = ((PrimitiveType)left).getKind();
            PrimitiveTypeKind rightKind = ((PrimitiveType)right).getKind();
            if (leftKind.equals(PrimitiveTypeKindEnum.DOUBLE)) {
                return left;
            }
            if (rightKind.equals(PrimitiveTypeKindEnum.DOUBLE)) {
                return right;
            }
            if (leftKind.equals(PrimitiveTypeKindEnum.FLOAT)) {
                return left;
            }
            if (rightKind.equals(PrimitiveTypeKindEnum.FLOAT)) {
                return right;
            }
            if (leftKind.equals(PrimitiveTypeKindEnum.LONG)) {
                return left;
            }
            if (rightKind.equals(PrimitiveTypeKindEnum.LONG)) {
                return right;
            }
            return this.typeClass.resolve("int");
        }
        ErrorManager.getDefault().log(16, "Invalid types " + left.getName() + " " + right.getName());
        return null;
    }

    private void usesField(Variable field, ASTree id) {
        this.storeSemanticInfo(id, field);
    }

    private void usesType(Type td, ASTree id) {
        this.storeSemanticInfo(id, td);
    }

    private CallableFeature findMethod(ClassDefinition jcls, String name, List parameters) {
        if (jcls != null && !(jcls instanceof UnresolvedClass)) {
            Object methods = null;
            if (name == null) {
                Object[] features = jcls.getContents().toArray();
                ArrayList<Object> constructors = new ArrayList<Object>();
                for (int i = 0; i < features.length; ++i) {
                    Object feature = features[i];
                    if (!(feature instanceof Constructor)) continue;
                    constructors.add(feature);
                    methods = feature;
                }
                if (constructors.size() > 1) {
                    methods = constructors;
                }
            } else {
                MethodScope methodScope = Scope.createMethodScope(jcls);
                methods = methodScope.lookup(name);
            }
            if (methods instanceof List) {
                List methodList = (List)methods;
                CallableFeature[] methodArr = methodList.toArray(new CallableFeature[methodList.size()]);
                CallableFeature closest = methodArr[0];
                Type[] parTypes = parameters.toArray(new Type[parameters.size()]);
                int parDiff = this.computeParDiff(closest, parTypes.length);
                int parDistance = -1;
                boolean isAccessible = false;
                if (parDiff == 0) {
                    isAccessible = this.isAccessible(closest);
                }
                for (int i = 1; i < methodArr.length; ++i) {
                    int canDiff;
                    CallableFeature candidate = methodArr[i];
                    int localParDiff = this.computeParDiff(candidate, parTypes.length);
                    if (localParDiff > 0) {
                        if (localParDiff >= parDiff) continue;
                        parDiff = localParDiff;
                        closest = candidate;
                        continue;
                    }
                    if (parDiff > 0) {
                        parDiff = 0;
                        closest = candidate;
                        isAccessible = this.isAccessible(candidate);
                        continue;
                    }
                    if (!this.isAccessible(candidate)) continue;
                    if (!isAccessible) {
                        closest = candidate;
                        isAccessible = true;
                        continue;
                    }
                    if (parDistance == -1 && (parDistance = this.isApplicable(closest, parTypes)) == 0) {
                        return closest;
                    }
                    int localParDist = this.isApplicable(candidate, parTypes);
                    if (localParDist == 0) {
                        return candidate;
                    }
                    if (localParDist == Integer.MAX_VALUE) continue;
                    if (localParDist < parDistance) {
                        parDistance = localParDist;
                        closest = candidate;
                        continue;
                    }
                    if (localParDist != parDistance || (canDiff = this.isApplicable(closest, candidate)) == Integer.MAX_VALUE) continue;
                    if (canDiff > 0) {
                        closest = candidate;
                        continue;
                    }
                    if (Modifier.isAbstract(candidate.getModifiers()) || !Modifier.isAbstract(closest.getModifiers())) continue;
                    closest = candidate;
                }
                return closest;
            }
            return (CallableFeature)methods;
        }
        return null;
    }

    private int isApplicable(CallableFeature method, CallableFeature bestSoFar) {
        ArrayList<Type> parTypes = new ArrayList<Type>();
        Object[] pars = bestSoFar.getParameters().toArray();
        for (int i = 0; i < pars.length; ++i) {
            Parameter p = (Parameter)pars[i];
            parTypes.add(p.getType());
        }
        return this.isApplicable(method, parTypes.toArray(new Type[parTypes.size()]));
    }

    private int isApplicable(CallableFeature method, Type[] pars) {
        Object[] mpars = method.getParameters().toArray();
        int diff = 0;
        boolean varArg = false;
        Type methodType = null;
        for (int p = 0; p < pars.length; ++p) {
            int localDiff;
            if (p < mpars.length) {
                Parameter par = (Parameter)mpars[p];
                methodType = par.getType();
            }
            if ((localDiff = this.subType(pars[p], methodType)) == Integer.MAX_VALUE) {
                return localDiff;
            }
            diff += localDiff;
        }
        return diff;
    }

    private int subType(Type sub, Type type) {
        if (sub == type) {
            return 0;
        }
        if (type.getName().equals(sub.getName())) {
            return 0;
        }
        if (sub instanceof ClassDefinition && type instanceof ClassDefinition) {
            return ((ClassDefinition)sub).isSubTypeOf((ClassDefinition)type) ? 1 : Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private int computeParDiff(CallableFeature method, int parNum) {
        Object[] mpars = method.getParameters().toArray();
        int plen = mpars.length;
        boolean varArg = false;
        if (plen > 0) {
            Parameter lastPar = (Parameter)mpars[plen - 1];
            varArg = lastPar.isVarArg();
        }
        if (varArg && (plen < parNum || plen == parNum + 1)) {
            return 0;
        }
        return Math.abs(parNum - plen);
    }

    private boolean isAccessible(CallableFeature method) {
        int mods = method.getModifiers();
        if (Modifier.isPublic(mods)) {
            return true;
        }
        if (Modifier.isPrivate(mods)) {
            return method.getResource().equals(this.getResource());
        }
        boolean samePackage = method.getResource().getPackageName().equals(this.getResource().getPackageName());
        if (!Modifier.isProtected(mods)) {
            return samePackage;
        }
        if (samePackage) {
            return true;
        }
        return this.currentClass.isSubTypeOf(method.getDeclaringClass());
    }

    private Type usesMethod(String name, ClassDefinition desc, List parameters, ASTree id, boolean implicitThis) {
        CallableFeature ref = this.findMethod(desc, name, parameters);
        Type type = null;
        if (ref == null && implicitThis && desc != null) {
            JavaClass jcls;
            String className;
            if (desc instanceof JavaClass) {
                type = this.usesMethod(name, ((JavaClass)desc).getDeclaringClass(), parameters, id, true);
            } else {
                ClassDefinition immComposite = desc;
                while ((immComposite = (Element)immComposite.refImmediateComposite()) != null && !(immComposite instanceof ClassDefinition)) {
                }
                type = this.usesMethod(name, immComposite, parameters, id, true);
            }
            if (type == null && name != null && (className = (String)this.staticImpScope.lookup(name.concat("("))) != null && (jcls = this.resolveClass(className)) != null) {
                return this.usesMethod(name, (ClassDefinition)jcls, parameters, id, false);
            }
            return type;
        }
        if (ref != null) {
            this.storeSemanticInfo(id, ref);
            type = ref.getType();
        }
        return type;
    }

    private void storeSemanticInfo(ASTree tree, Object ref) {
        if (tree == null || ref == null || this.semanticInfo.get(tree) != null) {
            return;
        }
        Object indirectRef = ref instanceof Element ? this.getElementId((Element)ref) : ref;
        this.semanticInfo.put(tree, indirectRef);
    }

    private Object getElementId(Element el) {
        String name = null;
        if (el instanceof ParameterizedType) {
            return this.getElementId((Element)((ParameterizedType)el).getDefinition());
        }
        if (el instanceof ParameterizedTypeImpl.Wrapper) {
            ParameterizedTypeImpl.Wrapper w = (ParameterizedTypeImpl.Wrapper)el;
            return this.getElementId((Element)w.getWrappedObject());
        }
        if (el instanceof UnresolvedClass || el instanceof TypeParameter || el instanceof Type && (!(el instanceof ClassDefinition) || !(el instanceof MetadataElement) || !((MetadataElement)el).isTransient())) {
            SemiPersistentElement spel = (SemiPersistentElement)this.currentClass;
            if (spel == null) {
                spel = (SemiPersistentElement)this.getResource();
            }
            return SemiPersistentElement.typeToTypeRef((Type)el);
        }
        if (el instanceof Parameter || el instanceof MetadataElement && ((MetadataElement)el).isTransient()) {
            return "^".concat(el.refMofId());
        }
        if (el instanceof NamedElement) {
            name = ((NamedElement)el).getName();
        }
        if (el instanceof JavaPackage) {
            return "*".concat(name);
        }
        if (el instanceof Field) {
            Field f = (Field)el;
            return new FieldRefInfo((TypeRef)this.getElementId((Element)f.getDeclaringClass()), name, f.refMofId());
        }
        if (el instanceof CallableFeature) {
            CallableFeature fe = (CallableFeature)el;
            Object[] pars = fe.getParameters().toArray();
            TypeRef[] parTypes = new TypeRef[pars.length];
            for (int i = 0; i < parTypes.length; ++i) {
                Parameter p = (Parameter)pars[i];
                parTypes[i] = (TypeRef)this.getElementId((Element)p.getType());
            }
            return new CallableRefInfo((TypeRef)this.getElementId((Element)fe.getDeclaringClass()), name, parTypes, fe.refMofId());
        }
        JMManager.getLog().log("Invalid type " + el);
        if (el instanceof NamedElement) {
            JMManager.getLog().log("Name " + name);
        }
        return null;
    }

    private static class ModifiersInfo {
        private int modifiers;
        private AnnotationInfo[] annotations;

        ModifiersInfo(int mods, AnnotationInfo[] anns) {
            this.modifiers = mods;
            this.annotations = anns;
        }
    }

    private static class SuperInfo {
        private JavaClass superClass;
        private List interfaces;

        SuperInfo(JavaClass jcls, List ifaces) {
            this.superClass = jcls;
            this.interfaces = ifaces;
        }
    }

    private static class LocalVarRefInfo {
        private Type type;
        private ASTree varDeclAST;
        private Variable var;

        LocalVarRefInfo(ASTree decl, Type t) {
            this.varDeclAST = decl;
            this.type = t;
        }
    }

    private static class CallableRefInfo
    extends FieldRefInfo {
        private TypeRef[] parTypes;

        CallableRefInfo(TypeRef decl, String n, TypeRef[] pt, String id) {
            super(decl, n, id);
            this.parTypes = pt;
        }
    }

    private static class FieldRefInfo {
        private TypeRef declClass;
        private String name;
        private String mofid;

        FieldRefInfo(TypeRef decl, String n, String id) {
            this.declClass = decl;
            this.name = n;
            this.mofid = id;
        }
    }
}

