/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.strings;

import java.util.Arrays;
import org.netbeans.modules.java.navigation.spi.strings.Abbreviator;

public final class AbbreviatorImpl
extends Abbreviator {
    private float[] buf = new float[50];
    private float maxWeight = 0.0f;
    private float minWeight = 0.0f;
    private final int[] lengths = new int[13];
    private boolean allUpper = false;

    public float[] process(char[] c, float importance) {
        this.buf = this.ensureCapacity(this.buf, c.length);
        Arrays.fill(this.lengths, 0);
        float[] result = this.iterChars(c, this.buf, importance, false);
        if (this.allUpper) {
            result = this.iterChars(c, this.buf, importance, true);
        }
        return result;
    }

    public int[] getLengthsForLastRun() {
        return (int[])this.lengths.clone();
    }

    public float getMaxWeightForLastRun() {
        return this.maxWeight;
    }

    public float getMinWeightForLastRun() {
        return this.minWeight;
    }

    private float[] iterChars(char[] c, float[] weights, float importance, boolean ignoreUpper) {
        this.allUpper = true;
        this.maxWeight = 0.0f;
        float[] result = this.buf;
        char prev = '*';
        boolean lastWasUpper = false;
        boolean lastWasPlosive = false;
        boolean lastWasSiliblant = false;
        boolean lastWasVowel = false;
        boolean lastWasFricative = false;
        boolean lastWasPunctuation = true;
        for (int i = 0; i < c.length; ++i) {
            boolean upper = Character.isUpperCase(c[i]);
            boolean plosive = this.isPlosiveOrGlottal(prev, c[i]) || (c[i] == 'c' || c[i] == 'C') && lastWasPunctuation && i < c.length - 1 && c[i + 1] != 'h' && c[i + 1] != 'H';
            boolean siliblant = this.isSiliblant(prev, c[i]);
            boolean fricative = this.isFricative(c[i]);
            boolean vowel = this.isVowel(c[i]);
            boolean punctuation = !Character.isLetter(c[i]);
            this.allUpper &= upper;
            if (!ignoreUpper && upper && !lastWasUpper) {
                result[i] = lastWasPunctuation || i == 0 ? 1.0f : 0.95f;
            } else if (plosive && !lastWasPlosive) {
                result[i] = 0.8f;
                if (lastWasSiliblant && (!lastWasUpper || ignoreUpper)) {
                    result[i - 1] = 0.75f;
                }
            } else if (siliblant) {
                result[i] = 0.6f;
                if (this.isDipthongStart(prev) && (!lastWasUpper || ignoreUpper)) {
                    int n = i - 1;
                    result[n] = result[n] + 1.0f;
                }
            } else if (this.isDipthong(prev, c[i])) {
                result[i] = 0.5f;
                result[i - 1] = 0.65f;
            } else {
                result[i] = this.isPalatal(c[i]) ? (lastWasPlosive ? 0.5f : 0.3f) : (this.isVowel(c[i]) ? (lastWasVowel ? 0.125f : (lastWasPunctuation ? 0.76f : 0.2f)) : (this.isFricative(c[i]) ? 0.5f : (!Character.isLetter(c[i]) ? 1.0f : 0.45f)));
            }
            if (prev == c[i]) {
                int n = i;
                result[n] = result[n] - 0.1f;
            }
            if (lastWasPunctuation) {
                result[i] = Math.min(result[i] + 0.45f, 1.0f);
            }
            lastWasUpper = upper;
            lastWasFricative = fricative;
            lastWasSiliblant = siliblant;
            lastWasVowel = vowel;
            lastWasPlosive = plosive;
            lastWasPunctuation = punctuation;
            this.maxWeight = Math.max(result[i], this.maxWeight);
            this.minWeight = Math.min(result[i], this.minWeight);
            int n = i;
            result[n] = result[n] + (importance - 0.5f) / 9.0f;
            int j = (int)(result[i] * 10.0f - 1.0f);
            while (j >= 0) {
                int n2 = j--;
                this.lengths[n2] = this.lengths[n2] + 1;
            }
            prev = c[i];
        }
        result[0] = Math.max(1.0f, result[0] + 0.2f);
        return result;
    }

    private float[] ensureCapacity(float[] i, int size) {
        if (i.length >= size) {
            return i;
        }
        return new float[size + size / 2];
    }

    private boolean isVowel(char c) {
        return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u' || c == 'y' || c == 'A' || c == 'E' || c == 'I' || c == 'O' || c == 'U' || c == 'Y';
    }

    private boolean isPlosiveOrGlottal(char prev, char c) {
        boolean wasN = (prev == 'n' || prev == 'N') && Character.isUpperCase(prev) == Character.isUpperCase(c);
        return c == 'p' || c == 't' || c == 'b' || c == 'd' || c == 'g' && !wasN || c == 'k' || c == 'q' || c == 'P' || c == 'T' || c == 'B' || c == 'D' || c == 'G' && !wasN || c == 'K' || c == 'Q';
    }

    private boolean isFricative(char c) {
        return c == 'f' || c == 'j' || c == 'h' || c == 'v' || c == 'F' || c == 'J' || c == 'H' || c == 'V';
    }

    private boolean isSiliblant(char prev, char c) {
        return c == 's' || c == 'z' || c == 'X' || c == 'S' || c == 'Z' || c == 'x' || this.isDipthong(prev, c);
    }

    private boolean isDipthongStart(char c) {
        return c == 's' || c == 'c' || c == 't' || c == 'p' || c == 'S' || c == 'C' || c == 'T' || c == 'P';
    }

    private boolean isDipthongEnd(char c) {
        return c == 'h' || c == 'h';
    }

    private boolean isPalatal(char c) {
        return c == 'm' || c == 'n' || c == 'r' || c == 'l' || c == 'M' || c == 'N' || c == 'R' || c == 'L';
    }

    private boolean isDipthong(char prev, char curr) {
        return this.isDipthongStart(prev) && this.isDipthongEnd(curr);
    }
}

