/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.spi;

import java.util.StringTokenizer;

public final class StringFilter {
    final String s;

    private StringFilter(String s) {
        this.s = s;
    }

    public static StringFilter create(String filter) {
        return new StringFilter(filter);
    }

    public String getText() {
        return this.isInverseFilter() ? this.s.substring(1) : this.s;
    }

    public boolean isInverseFilter() {
        return this.s.startsWith("!");
    }

    public boolean match(String toMatch) {
        String s = this.s;
        boolean invert = false;
        if (s.startsWith("!")) {
            invert = true;
            s = s.substring(1);
        }
        boolean result = s.trim().length() == 0 ? true : (s.indexOf("*") == -1 ? toMatch.startsWith(s) : (s.indexOf("*") == s.length() - 1 ? toMatch.startsWith(s.substring(s.length() - 1)) : this.wildcardMatch(toMatch)));
        if (invert) {
            result = !result;
        }
        return result;
    }

    private boolean wildcardMatch(String toMatch) {
        int pos = 0;
        StringTokenizer tok = new StringTokenizer(this.s, "*");
        while (tok.hasMoreTokens()) {
            String curr = tok.nextToken();
            int nupos = toMatch.indexOf(curr, pos);
            if (nupos == -1) {
                return false;
            }
            pos = nupos;
        }
        return true;
    }

    public String toString() {
        return this.s;
    }
}

