/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.data;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.j2ee.sun.share.CharsetMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableDialogPanelAccessor;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.ValidationSupport;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.ParamMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.ParamType;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.PropertyList;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.PropertyListMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.PropertyParam;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.LocaleMapping;

public class DynamicPropertyPanel
extends JPanel
implements GenericTableDialogPanelAccessor {
    private boolean isEditPopup;
    private PropertyList theList;
    private List paramMappings;
    private boolean hasDescription;
    private boolean isEditable;
    private JLabel nameRequiredMark;
    private JLabel nameLabel;
    private JLabel valueRequiredMark;
    private JLabel valueLabel;
    private JComboBox propertiesCombo;
    private JComponent customEditor;
    private JTextField descriptionField;
    private JTextField customTextField;
    private JComboBox customComboBox;
    private JCheckBox customCheckBox;
    private int normalizedHeight;
    private DefaultComboBoxModel propertyListModel;
    private String name;
    private ParamMapping nameMapping;
    private String value;
    private String description;
    private static final ResourceBundle localBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private ResourceBundle propertyListBundle;
    private static final String TEXT_TRUE = "true";
    private static final String TEXT_FALSE = "false";
    private static final int NAME_FIELD = 0;
    private static final int VALUE_FIELD = 1;
    private static final int DESCRIPTION_FIELD = 2;
    private static final int NUM_FIELDS_NO_DESCRIPTION = 2;
    private static final int NUM_FIELDS_WITH_DESCRIPTION = 3;

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }

    private void initUserComponents() {
        this.customTextField = new JTextField();
        this.customComboBox = new JComboBox();
        this.customCheckBox = new JCheckBox();
        this.nameRequiredMark = new JLabel();
        this.nameLabel = new JLabel();
        this.propertiesCombo = new JComboBox();
        this.valueRequiredMark = new JLabel();
        this.valueLabel = new JLabel();
        this.customEditor = this.customTextField;
        int textFieldHeight = this.customTextField.getPreferredSize().height;
        int comboBoxHeight = this.customComboBox.getPreferredSize().height;
        int checkBoxHeight = this.customCheckBox.getPreferredSize().height;
        this.normalizedHeight = Math.max(textFieldHeight, Math.max(comboBoxHeight, checkBoxHeight));
        this.nameRequiredMark.setText(localBundle.getString("LBL_RequiredMark"));
        this.nameRequiredMark.setLabelFor(this.propertiesCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.nameRequiredMark.getAccessibleContext().setAccessibleName(localBundle.getString("ACSN_RequiredMark"));
        this.nameRequiredMark.getAccessibleContext().setAccessibleDescription(localBundle.getString("ACSD_RequiredMark"));
        this.add((Component)this.nameRequiredMark, gridBagConstraints);
        this.nameLabel.setText(localBundle.getString("LBL_Name_1"));
        this.nameLabel.setDisplayedMnemonic(localBundle.getString("MNE_Name").charAt(0));
        this.nameLabel.setLabelFor(this.propertiesCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.propertiesCombo.setEditable(this.isEditable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 6, 0, 11);
        gridBagConstraints.weightx = 1.0;
        this.propertiesCombo.getAccessibleContext().setAccessibleName(localBundle.getString("ACSN_Name"));
        this.propertiesCombo.getAccessibleContext().setAccessibleDescription(localBundle.getString("ACSD_Name"));
        this.add((Component)this.propertiesCombo, gridBagConstraints);
        this.propertiesCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DynamicPropertyPanel.this.handlePropertiesComboActionPerformed(evt);
            }
        });
        int valueBelow = this.hasDescription ? 0 : 11;
        this.valueRequiredMark.setText(localBundle.getString("LBL_RequiredMark"));
        this.valueRequiredMark.setLabelFor(this.customEditor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, valueBelow, 0);
        this.valueRequiredMark.getAccessibleContext().setAccessibleName(localBundle.getString("ACSN_RequiredMark"));
        this.valueRequiredMark.getAccessibleContext().setAccessibleDescription(localBundle.getString("ACSD_RequiredMark"));
        this.add((Component)this.valueRequiredMark, gridBagConstraints);
        this.valueLabel.setText(localBundle.getString("LBL_Value_1"));
        this.valueLabel.setDisplayedMnemonic(localBundle.getString("MNE_Value").charAt(0));
        this.valueLabel.setLabelFor(this.customEditor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, valueBelow, 0);
        this.add((Component)this.valueLabel, gridBagConstraints);
        int extraHeight = this.normalizedHeight - textFieldHeight;
        int extraBelow = extraHeight / 2;
        int extraAbove = extraHeight - extraBelow;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(extraAbove + 6, 6, extraBelow + valueBelow, 11);
        gridBagConstraints.weightx = 1.0;
        this.customTextField.getAccessibleContext().setAccessibleName(localBundle.getString("ACSN_Value"));
        this.customTextField.getAccessibleContext().setAccessibleDescription(localBundle.getString("ACSD_Value"));
        this.customComboBox.getAccessibleContext().setAccessibleName(localBundle.getString("ACSN_Value"));
        this.customComboBox.getAccessibleContext().setAccessibleDescription(localBundle.getString("ACSD_Value"));
        this.customCheckBox.getAccessibleContext().setAccessibleName(localBundle.getString("ACSN_Value"));
        this.customCheckBox.getAccessibleContext().setAccessibleDescription(localBundle.getString("ACSD_Value"));
        this.add((Component)this.customEditor, gridBagConstraints);
        if (this.hasDescription) {
            JLabel descRequiredMark = new JLabel();
            JLabel descLabel = new JLabel();
            this.descriptionField = new JTextField();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(6, 12, 11, 0);
            this.add((Component)descRequiredMark, gridBagConstraints);
            descLabel.setText(localBundle.getString("LBL_Description_1"));
            descLabel.setDisplayedMnemonic(localBundle.getString("MNE_Description").charAt(0));
            descLabel.setLabelFor(this.descriptionField);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(6, 6, 11, 0);
            this.add((Component)descLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(6, 6, 11, 11);
            gridBagConstraints.weightx = 1.0;
            this.descriptionField.getAccessibleContext().setAccessibleName(localBundle.getString("ACSN_Description"));
            this.descriptionField.getAccessibleContext().setAccessibleDescription(localBundle.getString("ACSD_Description"));
            this.add((Component)this.descriptionField, gridBagConstraints);
            this.descriptionField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    DynamicPropertyPanel.this.handleDescriptionFieldKeyReleased(evt);
                }
            });
        }
        this.customTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                DynamicPropertyPanel.this.handleCustomTextFieldKeyReleased(evt);
            }
        });
        this.customCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                DynamicPropertyPanel.this.handleCustomCheckBoxItemStateChanged(evt);
            }
        });
        this.customComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DynamicPropertyPanel.this.handleCustomComboBoxActionPerformed(evt);
            }
        });
        this.buildMappings();
        this.propertyListModel = new DefaultComboBoxModel();
        Iterator iter = this.paramMappings.iterator();
        while (iter.hasNext()) {
            this.propertyListModel.addElement((ParamMapping)iter.next());
        }
        this.propertiesCombo.setModel(this.propertyListModel);
    }

    private void handleCustomTextFieldKeyReleased(KeyEvent evt) {
        if (this.customEditor == this.customTextField) {
            this.value = this.customTextField.getText();
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    private void handleCustomCheckBoxItemStateChanged(ItemEvent evt) {
        if (this.customEditor == this.customCheckBox) {
            this.value = Utils.interpretCheckboxState(evt) ? TEXT_TRUE : TEXT_FALSE;
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    private void handleCustomComboBoxActionPerformed(ActionEvent evt) {
        if (this.customEditor == this.customComboBox && "comboBoxChanged".equals(evt.getActionCommand())) {
            Object selectedItem = this.customComboBox.getSelectedItem();
            if (selectedItem instanceof String) {
                this.value = (String)selectedItem;
            } else if (selectedItem instanceof CharsetMapping) {
                this.value = ((CharsetMapping)selectedItem).getCharset().toString();
            } else if (selectedItem instanceof LocaleMapping) {
                this.value = ((LocaleMapping)selectedItem).getLocale().toString();
            }
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    private void handleDescriptionFieldKeyReleased(KeyEvent evt) {
        if (this.hasDescription) {
            this.description = this.descriptionField.getText();
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    private void handlePropertiesComboActionPerformed(ActionEvent evt) {
        if ("comboBoxChanged".equals(evt.getActionCommand())) {
            Object selectedItem = this.propertyListModel.getSelectedItem();
            if (selectedItem instanceof ParamMapping) {
                this.nameMapping = (ParamMapping)selectedItem;
                this.selectProperty(this.nameMapping);
            } else if (selectedItem instanceof String) {
                this.nameMapping = null;
                this.name = (String)selectedItem;
                if (this.propertyListModel.getIndexOf(selectedItem) == -1) {
                    this.propertyListModel.addElement(selectedItem);
                }
                this.enableTextFields(true);
                this.displayCustomEditor(this.customTextField);
            }
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    private void selectProperty(ParamMapping pm) {
        PropertyParam param = pm.getParam();
        if (param != null) {
            String defaultDesc;
            ParamType paramType = param.getParamType();
            String type = paramType.getType();
            this.enableTextFields(true);
            this.valueRequiredMark.setText(paramType.getRequired().equals(TEXT_TRUE) ? localBundle.getString("LBL_RequiredMark") : "");
            String paramLabel = param.getParamLabel();
            if (paramLabel != null) {
                this.valueLabel.setText(this.propertyListBundle.getString(paramLabel) + " :");
            } else {
                this.valueLabel.setText(localBundle.getString("LBL_Value_1"));
            }
            this.value = param.getDefaultValue();
            if (type.equals("boolean")) {
                this.customCheckBox.setSelected(this.value.equals(TEXT_TRUE));
                this.displayCustomEditor(this.customCheckBox);
            } else if (type.equals("text")) {
                this.customTextField.setText(this.value);
                this.customTextField.setCaretPosition(0);
                this.displayCustomEditor(this.customTextField);
            } else if (type.equals("number")) {
                this.customTextField.setText(this.value);
                this.customTextField.setCaretPosition(0);
                this.displayCustomEditor(this.customTextField);
            } else if (type.equals("list")) {
                DefaultComboBoxModel<Object> valueListModel = new DefaultComboBoxModel<Object>();
                Object defaultValue = this.value;
                if (paramType.isParamCharset()) {
                    SortedMap charsets = CharsetMapping.getSortedAvailableCharsetMappings();
                    Iterator iter = charsets.entrySet().iterator();
                    while (iter.hasNext()) {
                        CharsetMapping cm = (CharsetMapping)iter.next().getValue();
                        valueListModel.addElement(cm);
                    }
                    defaultValue = this.value != null ? CharsetMapping.getCharsetMapping(this.value) : CharsetMapping.getCharsetMapping("UTF8");
                } else if (paramType.isParamLocale()) {
                    SortedMap locales = LocaleMapping.getSortedAvailableLocaleMappings();
                    Iterator iter = locales.entrySet().iterator();
                    while (iter.hasNext()) {
                        LocaleMapping lm = (LocaleMapping)iter.next().getValue();
                        valueListModel.addElement(lm);
                    }
                    defaultValue = this.value != null ? LocaleMapping.getLocaleMapping(this.value) : LocaleMapping.getLocaleMapping(Locale.getDefault());
                } else {
                    int n = paramType.sizeParamValue();
                    for (int i = 0; i < n; ++i) {
                        valueListModel.addElement(paramType.getParamValue(i));
                    }
                    if (defaultValue == null) {
                        defaultValue = valueListModel.getElementAt(0);
                    }
                }
                this.customComboBox.setModel(valueListModel);
                this.customComboBox.setEditable(paramType.getEditable().equals(TEXT_TRUE));
                this.customComboBox.setSelectedItem(defaultValue);
                this.displayCustomEditor(this.customComboBox);
            }
            if (this.hasDescription && (defaultDesc = param.getParamDescription()) != null) {
                this.description = this.propertyListBundle.getString(defaultDesc);
                this.descriptionField.setText(this.description);
                this.descriptionField.setCaretPosition(0);
            }
        } else {
            this.enableTextFields(false);
            this.displayCustomEditor(this.customTextField);
        }
    }

    private void buildMappings() {
        List properties = this.theList.fetchPropertyParamList();
        this.paramMappings = new ArrayList(properties.size() + 1);
        if (!this.isEditable) {
            this.paramMappings.add(new ParamMapping(null));
        }
        Iterator iter = properties.iterator();
        while (iter.hasNext()) {
            PropertyParam pp = (PropertyParam)iter.next();
            this.paramMappings.add(new ParamMapping(pp));
        }
    }

    private void displayCustomEditor(JComponent newCustomEditor) {
        if (this.customEditor != newCustomEditor) {
            int extraHeight = this.normalizedHeight - newCustomEditor.getPreferredSize().height;
            int extraBelow = extraHeight / 2;
            int extraAbove = extraHeight - extraBelow;
            int valueBelow = this.hasDescription ? 0 : 11;
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.insets = new Insets(extraAbove + 6, 6, extraBelow + valueBelow, 11);
            constraints.weightx = 1.0;
            this.valueRequiredMark.setLabelFor(newCustomEditor);
            this.valueLabel.setLabelFor(newCustomEditor);
            int customEditorIndex = this.componentIndexOf(this.customEditor);
            this.remove(this.customEditor);
            this.add(newCustomEditor, constraints, customEditorIndex);
            Window parentWindow = this.getParentWindow();
            if (parentWindow != null) {
                parentWindow.pack();
            }
            Rectangle bounds = newCustomEditor.getBounds(null);
            bounds.y -= extraAbove;
            bounds.height += extraHeight;
            this.repaint(bounds);
            this.customEditor = newCustomEditor;
        }
    }

    private int componentIndexOf(JComponent control) {
        int result = -1;
        Component[] children = this.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (control != children[i]) continue;
            result = i;
            break;
        }
        return result;
    }

    private void enableTextFields(boolean flag) {
        this.value = null;
        this.customTextField.setText(this.value);
        this.customTextField.setEditable(flag);
        this.customTextField.setEnabled(flag);
        if (this.hasDescription) {
            this.description = null;
            this.descriptionField.setText(this.description);
            this.descriptionField.setEditable(flag);
            this.descriptionField.setEnabled(flag);
        }
    }

    private Window getParentWindow() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Window)) continue;
            return (Window)parent;
        }
        return null;
    }

    public void init(ASDDVersion asVersion, int preferredWidth, List entries, Object data) {
        this.theList = (PropertyList)data;
        this.hasDescription = this.theList.getDescription().equals(TEXT_TRUE);
        this.isEditable = this.theList.getEditable().equals(TEXT_TRUE);
        String bundlePath = this.theList.getBundlePath();
        if (bundlePath != null) {
            this.propertyListBundle = ResourceBundle.getBundle(bundlePath);
        }
        this.initComponents();
        this.initUserComponents();
        this.setPreferredSize(new Dimension(preferredWidth, this.getPreferredSize().height));
        if (!this.isEditable) {
            this.selectProperty((ParamMapping)this.paramMappings.get(0));
        }
    }

    public Object[] getValues() {
        PropertyParam param;
        Object[] result = this.hasDescription ? new Object[3] : new Object[2];
        result[0] = this.nameMapping != null ? ((param = this.nameMapping.getParam()) != null ? param.getParamName() : "") : this.name;
        result[1] = this.value;
        if (this.hasDescription) {
            result[2] = this.description;
        }
        return result;
    }

    public void setValues(Object[] values) {
        ParamMapping pm;
        if (values == null) {
            values = new Object[this.hasDescription ? 3 : 2];
            values[0] = null;
            values[1] = null;
            if (this.hasDescription) {
                values[2] = null;
            }
            this.isEditPopup = false;
        } else {
            this.isEditPopup = true;
        }
        this.name = (String)values[0];
        this.nameMapping = null;
        if (this.name != null && this.name.length() > 0) {
            Iterator iter = this.paramMappings.iterator();
            while (iter.hasNext()) {
                ParamMapping pm2 = (ParamMapping)iter.next();
                PropertyParam param = pm2.getParam();
                if (param == null || !this.name.equals(param.getParamName())) continue;
                this.nameMapping = pm2;
                break;
            }
        } else if (this.paramMappings.size() > 0 && (pm = (ParamMapping)this.paramMappings.get(0)).getParam() == null) {
            this.nameMapping = pm;
        }
        if (this.nameMapping != null) {
            this.propertiesCombo.setSelectedItem(this.nameMapping);
        } else {
            this.propertiesCombo.setSelectedItem(this.name);
        }
        if (this.isEditPopup) {
            this.propertiesCombo.setEnabled(false);
            this.value = (String)values[1];
            if (this.customEditor == this.customCheckBox) {
                this.customCheckBox.setSelected(Utils.booleanValueOf(this.value));
            } else if (this.customEditor == this.customTextField) {
                this.customTextField.setText(this.value);
                this.customTextField.setCaretPosition(0);
            } else if (this.customEditor == this.customComboBox) {
                this.customComboBox.setSelectedItem(this.value);
            }
            if (this.hasDescription) {
                this.description = (String)values[2];
                this.descriptionField.setText(this.description);
                this.descriptionField.setCaretPosition(0);
            }
        }
    }

    public boolean requiredFieldsFilled() {
        return true;
    }

    public Collection getErrors(ValidationSupport validationSupport) {
        ArrayList<String> errorList = new ArrayList<String>();
        if (this.hasEmptyName()) {
            errorList.add(localBundle.getString("ERR_NameFieldIsEmpty"));
        } else if (this.nameMapping != null) {
            if (this.value == null || this.value.length() == 0) {
                Object[] args = new Object[]{localBundle.getString("LBL_Value")};
                errorList.add(MessageFormat.format(localBundle.getString("ERR_SpecifiedFieldIsEmpty"), args));
            } else {
                PropertyParam param = this.nameMapping.getParam();
                ParamType paramType = param.getParamType();
                String type = paramType.getType();
                String name = param.getParamName();
                if (type.equals("text")) {
                    this.validate(this.value, param.getParamValidator(), name, errorList);
                } else if (type.equals("number")) {
                    this.validateNumber(this.value, paramType.getParamMin(), paramType.getParamMax(), errorList);
                } else if (type.equals("list")) {
                    this.validate(this.value, param.getParamValidator(), name, errorList);
                }
            }
        }
        return errorList;
    }

    private boolean hasEmptyName() {
        boolean result = true;
        if (this.nameMapping != null && this.nameMapping.getParam() != null) {
            result = false;
        } else if (this.nameMapping == null && this.name != null && this.name.length() > 0) {
            result = false;
        }
        return result;
    }

    private void validateNumber(String theNumber, String paramMin, String paramMax, List errorList) {
        try {
            Object[] args;
            long x = Long.parseLong(theNumber);
            long min = Long.MIN_VALUE;
            long max = Long.MAX_VALUE;
            if (paramMin != null && x < (min = Long.parseLong(paramMin))) {
                args = new Object[]{theNumber, Long.toString(min)};
                errorList.add(MessageFormat.format(localBundle.getString("ERR_NumberTooLow"), args));
            }
            if (paramMax != null && x > (max = Long.parseLong(paramMax))) {
                args = new Object[]{theNumber, Long.toString(max)};
                errorList.add(MessageFormat.format(localBundle.getString("ERR_NumberTooHigh"), args));
            }
        }
        catch (NumberFormatException ex) {
            Object[] args = new Object[]{theNumber};
            errorList.add(MessageFormat.format(localBundle.getString("ERR_NumberInvalid"), args));
        }
    }

    private void validate(String value, String validatorName, String propertyName, List errorList) {
        Pattern validatorPattern;
        if (validatorName != null && (validatorPattern = PropertyListMapping.getValidator(validatorName)) != null && !validatorPattern.matcher(value).matches()) {
            Object[] args = new Object[]{propertyName, validatorName};
            String propInvalidMsg = localBundle.getString("ERR_PropertyValueInvalid");
            errorList.add(MessageFormat.format(propInvalidMsg, args));
        }
    }
}

