/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.XpathEvent;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.netbeans.modules.j2ee.sun.share.config.ConfigurationStorage;
import org.netbeans.modules.j2ee.sun.share.config.DDCommon;
import org.netbeans.modules.j2ee.sun.share.config.StandardDDImpl;
import org.netbeans.modules.j2ee.sun.share.config.ui.ConfigBeanNode;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.openide.ErrorManager;
import org.openide.nodes.Node;

public class ConfigBeanStorage
implements PropertyChangeListener,
Comparable {
    private ConfigurationStorage storage;
    DConfigBean bean;
    private ConfigBeanStorage parent;
    private ConfigBeanNode node = null;
    private Map childMap = new HashMap();
    public static final String RESOURCE_REF = "resource-ref";
    private List childrenChangeListeners = new Vector();

    public ConfigBeanStorage(DConfigBean bean, ConfigBeanStorage parent, ConfigurationStorage storage) throws ConfigurationException {
        this.bean = bean;
        this.parent = parent;
        this.storage = storage;
        this.initChildren();
        StandardDDImpl dd = (StandardDDImpl)bean.getDDBean();
        dd.proxy.addConfigBean(this);
        bean.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public Map getChildMap() {
        return this.childMap;
    }

    public ConfigurationStorage getStorage() {
        return this.storage;
    }

    public synchronized Node getNode() {
        this.node = new ConfigBeanNode(this);
        return this.node;
    }

    public void propertyChange(PropertyChangeEvent pce) {
        if (this.storage != null && !"displayName".equalsIgnoreCase(pce.getPropertyName())) {
            this.storage.setChanged();
        }
        if ("displayName".equalsIgnoreCase(pce.getPropertyName()) && this.node != null) {
            this.node.setDisplayName((String)pce.getNewValue());
        }
    }

    public void remove() {
        DDCommon dd = ((StandardDDImpl)this.bean.getDDBean()).proxy;
        dd.removeConfigBean(this);
        if (this.parent != null) {
            try {
                this.parent.bean.removeDConfigBean(this.bean);
                this.storage.setChanged();
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    private void initChildren() throws ConfigurationException {
        String[] xpaths = this.bean.getXpaths();
        if (xpaths == null) {
            return;
        }
        for (int i = 0; i < xpaths.length; ++i) {
            DDBean[] beans = this.bean.getDDBean().getChildBean(xpaths[i]);
            for (int j = 0; j < beans.length; ++j) {
                this.addChild((StandardDDImpl)beans[j]);
            }
        }
    }

    void fireEvent(String relPath, XpathEvent xe) throws ConfigurationException {
        int i;
        String[] xpaths = this.bean.getXpaths();
        if (xpaths == null) {
            return;
        }
        StandardDDImpl eventDD = (StandardDDImpl)xe.getBean();
        StandardDDImpl[] targetDDs = null;
        for (int i2 = 0; i2 < xpaths.length; ++i2) {
            if (!xpaths[i2].equals(relPath) && !xpaths[i2].equals(xe.getBean().getXpath())) continue;
            targetDDs = new StandardDDImpl[]{eventDD};
            break;
        }
        HashSet<DDBean> targetSet = new HashSet<DDBean>();
        for (i = 0; targetDDs == null && i < xpaths.length; ++i) {
            String targetPath;
            DDBean[] dds;
            if (!xpaths[i].startsWith(relPath) || xpaths[i].length() != relPath.length() && xpaths[i].charAt(relPath.length()) != '/' || (dds = eventDD.getChildBean(targetPath = DDCommon.getRelativePath(xpaths[i], relPath))) == null) continue;
            for (int j = 0; j < dds.length; ++j) {
                if (!(dds[j] instanceof StandardDDImpl)) continue;
                targetSet.add(dds[j]);
            }
            if (targetSet.size() <= 0) continue;
            targetDDs = targetSet.toArray(new StandardDDImpl[targetSet.size()]);
        }
        if (targetDDs != null) {
            for (i = 0; i < targetDDs.length; ++i) {
                if (xe.isAddEvent()) {
                    this.addChild(targetDDs[i]);
                    continue;
                }
                this.removeChild(targetDDs[i]);
            }
        }
    }

    private void addChild(StandardDDImpl dd) throws ConfigurationException {
        DeploymentConfiguration dc;
        DConfigBean cb = this.bean.getDConfigBean((DDBean)dd);
        if (cb == null) {
            return;
        }
        if (RESOURCE_REF.equals(dd.proxy.dtdname) && (dc = this.storage.getDeploymentConfiguration()) instanceof SunONEDeploymentConfiguration) {
            SunONEDeploymentConfiguration config = (SunONEDeploymentConfiguration)dc;
            config.ensureResourceDefined(dd);
        }
        ConfigBeanStorage cbs = new ConfigBeanStorage(cb, this, this.storage);
        TreeSet<ConfigBeanStorage> c = (TreeSet<ConfigBeanStorage>)this.childMap.get(dd.getXpath());
        if (c == null) {
            c = new TreeSet<ConfigBeanStorage>();
            this.childMap.put(dd.getXpath(), c);
        }
        c.add(cbs);
        this.fireChildBeanAddedEvent(cbs);
    }

    private void removeChild(DDBean remBean) {
        Collection c = (Collection)this.childMap.get(remBean.getXpath());
        if (c == null) {
            return;
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            ConfigBeanStorage cbs = (ConfigBeanStorage)i.next();
            if (!cbs.bean.getDDBean().equals(remBean)) continue;
            cbs.remove();
            i.remove();
            this.fireChildBeanRemovedEvent(cbs);
        }
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new NullPointerException("Null argument passed to ConfigBeanStorage.compareTo()");
        }
        ConfigBeanStorage target = (ConfigBeanStorage)o;
        int result = -1;
        if (this == o) {
            result = 0;
        } else if (this.bean instanceof Base && target.bean instanceof Base) {
            Base sourceBean = (Base)this.bean;
            Base targetBean = (Base)target.bean;
            result = sourceBean.getDisplayName().compareTo(targetBean.getDisplayName());
            if (result == 0) {
                result = sourceBean.getIdentity().compareTo(targetBean.getIdentity());
            }
        } else {
            throw new IllegalStateException("Source or target bean is null or not derived from Base.");
        }
        return result;
    }

    public DConfigBean getConfigBean() {
        return this.bean;
    }

    public void addChildrenChangeListener(ChildrenChangeListener l) {
        this.childrenChangeListeners.add(l);
    }

    public void removeChildrenChangeListener(ChildrenChangeListener l) {
        this.childrenChangeListeners.remove(l);
    }

    private void fireChildBeanAddedEvent(ConfigBeanStorage childBeanStorage) {
        Iterator i = this.childrenChangeListeners.iterator();
        while (i.hasNext()) {
            ChildrenChangeListener l = (ChildrenChangeListener)i.next();
            l.childBeanAdded(childBeanStorage);
        }
    }

    private void fireChildBeanRemovedEvent(ConfigBeanStorage childBeanStorage) {
        Iterator i = this.childrenChangeListeners.iterator();
        while (i.hasNext()) {
            ChildrenChangeListener l = (ChildrenChangeListener)i.next();
            l.childBeanRemoved(childBeanStorage);
        }
    }

    public static interface ChildrenChangeListener {
        public void childBeanAdded(ConfigBeanStorage var1);

        public void childBeanRemoved(ConfigBeanStorage var1);
    }
}

