/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabListPopupAction;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.WinXPEditorTabCellRenderer;
import org.openide.util.Utilities;

public final class WinXPEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private static final Rectangle scratch5 = new Rectangle();
    private static final String[] iconNames = new String[]{"org/netbeans/swing/tabcontrol/resources/xp-right-enabled.gif", "org/netbeans/swing/tabcontrol/resources/xp-right-disabled.gif", "org/netbeans/swing/tabcontrol/resources/xp-right-enabled-selected.gif", "org/netbeans/swing/tabcontrol/resources/xp-left-enabled.gif", "org/netbeans/swing/tabcontrol/resources/xp-left-disabled.gif", "org/netbeans/swing/tabcontrol/resources/xp-left-enabled-selected.gif", "org/netbeans/swing/tabcontrol/resources/xp-down-enabled.gif", "org/netbeans/swing/tabcontrol/resources/xp-down-disabled.gif", "org/netbeans/swing/tabcontrol/resources/xp-down-enabled-selected.gif"};

    public WinXPEditorTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
    }

    public static ComponentUI createUI(JComponent c) {
        return new WinXPEditorTabDisplayerUI((TabDisplayer)c);
    }

    protected AbstractButton[] createControlButtons() {
        AbstractButton[] result = new JButton[]{new BasicScrollingTabDisplayerUI.TimerButton(this.scroll().getBackwardAction()), new BasicScrollingTabDisplayerUI.TimerButton(this.scroll().getForwardAction()), new BasicScrollingTabDisplayerUI.OnPressButton(new TabListPopupAction(this.displayer))};
        WinXPEditorTabDisplayerUI.configureButton(result[0], 0);
        WinXPEditorTabDisplayerUI.configureButton(result[2], 1);
        WinXPEditorTabDisplayerUI.configureButton(result[1], 2);
        result[0].setPreferredSize(new Dimension(15, 14));
        result[2].setPreferredSize(new Dimension(16, 14));
        result[1].setPreferredSize(new Dimension(15, 14));
        this.scroll().getBackwardAction().putValue("control", this.displayer);
        this.scroll().getForwardAction().putValue("control", this.displayer);
        return result;
    }

    public Dimension getPreferredSize(JComponent c) {
        int prefHeight = 24;
        Graphics2D g = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (g != null) {
            FontMetrics fm = g.getFontMetrics(this.displayer.getFont());
            Insets ins = this.getTabAreaInsets();
            prefHeight = fm.getHeight() + ins.top + ins.bottom + 8;
        }
        return new Dimension(this.displayer.getWidth(), prefHeight);
    }

    private static final Icon createIcon(int i) {
        return new ImageIcon(Utilities.loadImage((String)iconNames[i]));
    }

    private static final Dimension controlButtonSize(int index) {
        Dimension result = new Dimension(index == 1 ? 13 : 14, 15);
        return result;
    }

    private static void configureButton(JButton button, int idx) {
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        Icon normal = WinXPEditorTabDisplayerUI.createIcon(idx * 3);
        Icon disabled = WinXPEditorTabDisplayerUI.createIcon(idx * 3 + 1);
        Icon rollover = WinXPEditorTabDisplayerUI.createIcon(idx * 3 + 2);
        button.setIcon(normal);
        button.setRolloverEnabled(true);
        button.setRolloverIcon(rollover);
        button.setDisabledIcon(disabled);
        button.setPreferredSize(new Dimension(normal.getIconWidth() + 1, normal.getIconHeight() + 1));
        button.setMargin(null);
        button.setText(null);
        button.putClientProperty("hideActionText", Boolean.TRUE);
        button.setFocusable(false);
    }

    public void paintBackground(Graphics g) {
        g.setColor(this.displayer.getBackground());
        g.fillRect(0, 0, this.displayer.getWidth(), this.displayer.getHeight());
    }

    protected void paintAfterTabs(Graphics g) {
        Rectangle r = new Rectangle();
        this.getTabsVisibleArea(r);
        r.width = this.displayer.getWidth();
        Insets ins = this.getTabAreaInsets();
        int y = this.displayer.getHeight() - 3;
        int selEnd = 0;
        int i = this.selectionModel.getSelectedIndex();
        g.setColor(WinXPEditorTabCellRenderer.getSelectedTabBottomLineColor());
        g.drawLine(0, y + 1, this.displayer.getWidth(), y + 1);
        int tabsWidth = this.getTabsAreaWidth();
        boolean needSplitLine = i != -1 && (i < this.scroll().getLastVisibleTab(tabsWidth) || i <= this.scroll().getLastVisibleTab(tabsWidth) && !this.scroll().isLastTabClipped()) && i >= this.scroll().getFirstVisibleTab(tabsWidth);
        g.setColor(UIManager.getColor("controlLtHighlight"));
        if (needSplitLine) {
            this.getTabRect(i, scratch5);
            if (WinXPEditorTabDisplayerUI.scratch5.width != 0) {
                if (r.x < WinXPEditorTabDisplayerUI.scratch5.x) {
                    g.drawLine(r.x, y, WinXPEditorTabDisplayerUI.scratch5.x + 1, y);
                }
                if (WinXPEditorTabDisplayerUI.scratch5.x + WinXPEditorTabDisplayerUI.scratch5.width < r.x + r.width) {
                    selEnd = WinXPEditorTabDisplayerUI.scratch5.x + WinXPEditorTabDisplayerUI.scratch5.width;
                    if (!this.scroll().isLastTabClipped()) {
                        --selEnd;
                    }
                    g.drawLine(selEnd, y, r.x + r.width, y);
                }
            }
        } else {
            g.drawLine(r.x, y, r.x + r.width, y);
        }
        g.setColor(WinXPEditorTabCellRenderer.getBorderColor());
        g.drawLine(0, y - 1, 0, this.displayer.getHeight());
        g.drawLine(this.displayer.getWidth() - 1, y - 1, this.displayer.getWidth() - 1, this.displayer.getHeight());
        int last = this.scroll().getLastVisibleTab(tabsWidth);
        boolean l = false;
        if (last >= 0) {
            this.getTabRect(last, scratch5);
            last = WinXPEditorTabDisplayerUI.scratch5.x + WinXPEditorTabDisplayerUI.scratch5.width;
        }
        g.drawLine(last, y - 1, this.displayer.getWidth(), y - 1);
    }

    protected TabCellRenderer createDefaultRenderer() {
        return new WinXPEditorTabCellRenderer();
    }

    protected LayoutManager createLayout() {
        return new WCLayout();
    }

    public Insets getTabAreaInsets() {
        return new Insets(0, 0, 0, 55);
    }

    private class WCLayout
    implements LayoutManager {
        private WCLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            Insets in = WinXPEditorTabDisplayerUI.this.getTabAreaInsets();
            Component[] c = parent.getComponents();
            int x = parent.getWidth() - 49;
            int y = 0;
            for (int i = 0; i < c.length; ++i) {
                y = in.top;
                if (!(c[i] instanceof JButton)) continue;
                int w = Math.min(((JButton)c[i]).getIcon().getIconWidth(), parent.getWidth() - x);
                c[i].setBounds(x, y, w, Math.min(((JButton)c[i]).getIcon().getIconHeight(), parent.getHeight()));
                x += ((JButton)c[i]).getIcon().getIconWidth();
                if (i != 1) continue;
                x += 3;
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return WinXPEditorTabDisplayerUI.this.getPreferredSize((JComponent)parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            return WinXPEditorTabDisplayerUI.this.getPreferredSize((JComponent)parent);
        }

        public void removeLayoutComponent(Component comp) {
        }
    }
}

