/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabListPopupAction;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.WinVistaEditorTabCellRenderer;
import org.openide.util.Utilities;

public final class WinVistaEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private static final Rectangle scratch5 = new Rectangle();
    private static final String[] iconNames = new String[]{"org/netbeans/swing/tabcontrol/resources/vista_left_enabled.png", "org/netbeans/swing/tabcontrol/resources/vista_left_disabled.png", "org/netbeans/swing/tabcontrol/resources/vista_left_over.png", "org/netbeans/swing/tabcontrol/resources/vista_left_pressed.png", "org/netbeans/swing/tabcontrol/resources/vista_right_enabled.png", "org/netbeans/swing/tabcontrol/resources/vista_right_disabled.png", "org/netbeans/swing/tabcontrol/resources/vista_right_over.png", "org/netbeans/swing/tabcontrol/resources/vista_right_pressed.png", "org/netbeans/swing/tabcontrol/resources/vista_popup_enabled.png", "org/netbeans/swing/tabcontrol/resources/vista_popup_enabled.png", "org/netbeans/swing/tabcontrol/resources/vista_popup_over.png", "org/netbeans/swing/tabcontrol/resources/vista_popup_pressed.png"};

    public WinVistaEditorTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
    }

    public static ComponentUI createUI(JComponent c) {
        return new WinVistaEditorTabDisplayerUI((TabDisplayer)c);
    }

    protected AbstractButton[] createControlButtons() {
        AbstractButton[] result = new JButton[]{new BasicScrollingTabDisplayerUI.TimerButton(this.scroll().getBackwardAction(), false), new BasicScrollingTabDisplayerUI.TimerButton(this.scroll().getForwardAction(), false), new BasicScrollingTabDisplayerUI.OnPressButton(new TabListPopupAction(this.displayer))};
        WinVistaEditorTabDisplayerUI.configureButton(result[0], 0);
        WinVistaEditorTabDisplayerUI.configureButton(result[1], 1);
        WinVistaEditorTabDisplayerUI.configureButton(result[2], 2);
        result[0].setPreferredSize(new Dimension(15, 15));
        result[2].setPreferredSize(new Dimension(16, 15));
        result[1].setPreferredSize(new Dimension(15, 15));
        this.scroll().getBackwardAction().putValue("control", this.displayer);
        this.scroll().getForwardAction().putValue("control", this.displayer);
        return result;
    }

    public Dimension getPreferredSize(JComponent c) {
        int prefHeight = 22;
        Graphics2D g = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (g != null) {
            FontMetrics fm = g.getFontMetrics(this.displayer.getFont());
            Insets ins = this.getTabAreaInsets();
            prefHeight = fm.getHeight() + ins.top + ins.bottom + 6;
        }
        return new Dimension(this.displayer.getWidth(), prefHeight);
    }

    private static final Icon createIcon(int i) {
        return new ImageIcon(Utilities.loadImage((String)iconNames[i]));
    }

    private static void configureButton(JButton button, int idx) {
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setBorder(BorderFactory.createEmptyBorder());
        Icon normal = WinVistaEditorTabDisplayerUI.createIcon(idx * 4);
        Icon disabled = WinVistaEditorTabDisplayerUI.createIcon(idx * 4 + 1);
        Icon rollover = WinVistaEditorTabDisplayerUI.createIcon(idx * 4 + 2);
        Icon pressed = WinVistaEditorTabDisplayerUI.createIcon(idx * 4 + 3);
        button.setIcon(normal);
        button.setRolloverEnabled(true);
        button.setRolloverIcon(rollover);
        button.setDisabledIcon(disabled);
        button.setPressedIcon(pressed);
        button.setMargin(null);
        button.setText(null);
        button.putClientProperty("hideActionText", Boolean.TRUE);
        button.setFocusable(false);
    }

    public void paintBackground(Graphics g) {
        g.setColor(this.displayer.getBackground());
        g.fillRect(0, 0, this.displayer.getWidth(), this.displayer.getHeight());
    }

    protected void paintAfterTabs(Graphics g) {
        Rectangle r = new Rectangle();
        this.getTabsVisibleArea(r);
        r.width = this.displayer.getWidth();
        Insets ins = this.getTabAreaInsets();
        int y = this.displayer.getHeight() - 0;
        int tabsWidth = this.getTabsAreaWidth();
        g.setColor(WinVistaEditorTabCellRenderer.getBorderColor());
        int last = this.scroll().getLastVisibleTab(tabsWidth);
        boolean l = false;
        if (last >= 0) {
            this.getTabRect(last, scratch5);
            last = WinVistaEditorTabDisplayerUI.scratch5.x + WinVistaEditorTabDisplayerUI.scratch5.width;
        }
        g.drawLine(last, y - 1, this.displayer.getWidth(), y - 1);
    }

    protected TabCellRenderer createDefaultRenderer() {
        return new WinVistaEditorTabCellRenderer();
    }

    protected LayoutManager createLayout() {
        return new WCLayout();
    }

    public Insets getTabAreaInsets() {
        return new Insets(0, 0, 0, 57);
    }

    protected Rectangle getTabRectForRepaint(int tab, Rectangle rect) {
        Rectangle res = super.getTabRectForRepaint(tab, rect);
        --res.x;
        res.width += 2;
        return res;
    }

    private class WCLayout
    implements LayoutManager {
        private WCLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            Insets in = WinVistaEditorTabDisplayerUI.this.getTabAreaInsets();
            Component[] c = parent.getComponents();
            int x = parent.getWidth() - 49;
            int y = 0;
            for (int i = 0; i < c.length; ++i) {
                y = in.top;
                if (!(c[i] instanceof JButton)) continue;
                int w = Math.min(((JButton)c[i]).getIcon().getIconWidth(), parent.getWidth() - x);
                c[i].setBounds(x, y, w, Math.min(((JButton)c[i]).getIcon().getIconHeight(), parent.getHeight()));
                x += ((JButton)c[i]).getIcon().getIconWidth();
                if (i != 1) continue;
                x += 3;
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return WinVistaEditorTabDisplayerUI.this.getPreferredSize((JComponent)parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            return WinVistaEditorTabDisplayerUI.this.getPreferredSize((JComponent)parent);
        }

        public void removeLayoutComponent(Component comp) {
        }
    }
}

