/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties.syntax;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContext;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.modules.properties.syntax.PropertiesKit;
import org.netbeans.modules.properties.syntax.PropertiesTokenContext;

public class PropertiesSettingsInitializer
extends Settings.AbstractInitializer {
    public static final String NAME = "properties-settings-initializer";

    public PropertiesSettingsInitializer() {
        super(NAME);
    }

    public void updateSettingsMap(Class kitClass, Map settingsMap) {
        if (kitClass == BaseKit.class) {
            new PropertiesTokenColoringInitializer().updateSettingsMap(kitClass, settingsMap);
        } else if (kitClass == PropertiesKit.class) {
            settingsMap.put("shadowTableCell", new Color(SystemColor.controlHighlight.getRGB()));
            settingsMap.put("abbrev-map", new TreeMap());
            settingsMap.put("identifier-acceptor", AcceptorFactory.JAVA_IDENTIFIER);
            SettingsUtil.updateListSetting((Map)settingsMap, (String)"token-context-list", (Object[])new TokenContext[]{PropertiesTokenContext.context});
        }
    }

    private static class PropertiesTokenColoringInitializer
    extends SettingsUtil.TokenColoringInitializer {
        private static final Font boldFont = SettingsDefaults.defaultFont.deriveFont(1);
        private static final Font italicFont = SettingsDefaults.defaultFont.deriveFont(2);
        private static final Coloring keyColoring = new Coloring(boldFont, 2, Color.blue, null);
        private static final Coloring valueColoring = new Coloring(null, Color.magenta, null);
        private static final Coloring commentColoring = new Coloring(null, Color.gray, null);
        private static final Coloring emptyColoring = new Coloring(null, null, null);

        public PropertiesTokenColoringInitializer() {
            super((TokenContext)PropertiesTokenContext.context);
        }

        public Object getTokenColoring(TokenContextPath tokenContextPath, TokenCategory tokenIDOrCategory, boolean printingSet) {
            if (!printingSet) {
                int tokenID = tokenIDOrCategory.getNumericID();
                if (tokenID == 3) {
                    return keyColoring;
                }
                if (tokenID == 5) {
                    return valueColoring;
                }
                if (tokenID == 2) {
                    return commentColoring;
                }
                if (tokenID == 4 || tokenID == 1) {
                    return emptyColoring;
                }
            } else {
                return SettingsUtil.defaultPrintColoringEvaluator;
            }
            return null;
        }
    }
}

