/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.wizards;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.modules.versioning.system.cvss.settings.HistorySettings;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.BranchSelector;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ModuleSelector;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ProxyDescriptor;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.AbstractStep;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.ModulePanel;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.RepositoryStep;
import org.netbeans.modules.versioning.system.cvss.util.AccessibleJFileChooser;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class CheckoutWizard
implements ChangeListener {
    private WizardDescriptor wizard;
    private String errorMessage;
    private WizardDescriptor.Iterator wizardIterator;
    private ModulePanel modulePanel;
    private RepositoryStep repositoryStep;
    private String initialCvsRoot;
    private String initialModule;
    static /* synthetic */ Class class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard$ModuleStep;

    public CheckoutWizard() {
    }

    public CheckoutWizard(String cvsRoot, String module) {
        this.initialCvsRoot = cvsRoot;
        this.initialModule = module;
    }

    public boolean show() {
        this.wizardIterator = this.panelIterator();
        this.wizard = new WizardDescriptor(this.wizardIterator);
        this.wizard.putProperty("WizardPanel_contentData", (Object)new String[]{NbBundle.getMessage((Class)CheckoutWizard.class, (String)"BK0006"), NbBundle.getMessage((Class)CheckoutWizard.class, (String)"BK2009")});
        this.wizard.putProperty("WizardPanel_contentDisplayed", (Object)Boolean.TRUE);
        this.wizard.putProperty("WizardPanel_autoWizardStyle", (Object)Boolean.TRUE);
        this.wizard.putProperty("WizardPanel_contentNumbered", (Object)Boolean.TRUE);
        this.wizard.setTitleFormat(new MessageFormat("{0}"));
        this.wizard.setTitle(NbBundle.getMessage((Class)CheckoutWizard.class, (String)"BK0007"));
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)this.wizard);
        boolean finished = NotifyDescriptor.OK_OPTION.equals(result);
        if (finished) {
            this.onFinished();
        }
        return finished;
    }

    private void onFinished() {
        String checkout = this.modulePanel.workTextField.getText();
        HistorySettings.addRecent("checkoutDirectory", (Serializable)((Object)checkout));
    }

    String getErrorMessage() {
        String value = this.wizard != null ? (String)this.wizard.getProperty("WizardPanel_errorMessage") : this.errorMessage;
        if (value == null) {
            value = "";
        }
        return value;
    }

    private void setErrorMessage(String msg) {
        this.errorMessage = msg;
        if (this.wizard != null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)msg);
        }
    }

    public void stateChanged(ChangeEvent e) {
        AbstractStep step = (AbstractStep)this.wizardIterator.current();
        this.setErrorMessage(step.getErrorMessage());
    }

    private WizardDescriptor.Iterator panelIterator() {
        this.repositoryStep = new RepositoryStep(this.initialCvsRoot);
        this.repositoryStep.addChangeListener(this);
        ModuleStep modulePanel = new ModuleStep();
        modulePanel.addChangeListener(this);
        final WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{this.repositoryStep, modulePanel};
        WizardDescriptor.ArrayIterator ret = new WizardDescriptor.ArrayIterator(panels){

            public WizardDescriptor.Panel current() {
                WizardDescriptor.Panel ret = super.current();
                for (int i = 0; i < panels.length; ++i) {
                    if (panels[i] != ret) continue;
                    CheckoutWizard.this.wizard.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(i));
                }
                return ret;
            }
        };
        return ret;
    }

    public String getModules() {
        return this.modulePanel.moduleTextField.getText().trim();
    }

    public String getTag() {
        return this.modulePanel.tagTextField.getText().trim();
    }

    public String getWorkingDir() {
        String path = this.modulePanel.workTextField.getText();
        return FileUtil.normalizeFile((File)new File(path)).getAbsolutePath();
    }

    public String getScrambledPassword() {
        return this.repositoryStep.getScrambledPassword();
    }

    public String getCvsRoot() {
        return this.repositoryStep.getCvsRoot();
    }

    public ProxyDescriptor getProxyDescriptor() {
        return this.repositoryStep.getProxyDescriptor();
    }

    private class ModuleStep
    extends AbstractStep
    implements DocumentListener,
    FocusListener,
    ActionListener {
        private ModuleStep() {
        }

        protected JComponent createComponent() {
            CheckoutWizard.this.modulePanel = new ModulePanel();
            if (CheckoutWizard.this.initialModule != null) {
                ((CheckoutWizard)CheckoutWizard.this).modulePanel.moduleTextField.setText(CheckoutWizard.this.initialModule);
            }
            String path = this.defaultWorkingDirectory().getPath();
            ((CheckoutWizard)CheckoutWizard.this).modulePanel.workTextField.setText(path);
            ((CheckoutWizard)CheckoutWizard.this).modulePanel.workTextField.getDocument().addDocumentListener(this);
            ((CheckoutWizard)CheckoutWizard.this).modulePanel.workTextField.addFocusListener(this);
            ((CheckoutWizard)CheckoutWizard.this).modulePanel.workTextField.addActionListener(this);
            this.validateUserInput(true);
            ((CheckoutWizard)CheckoutWizard.this).modulePanel.moduleButton.addActionListener(this);
            ((CheckoutWizard)CheckoutWizard.this).modulePanel.tagButton.addActionListener(this);
            ((CheckoutWizard)CheckoutWizard.this).modulePanel.workButton.addActionListener(this);
            return CheckoutWizard.this.modulePanel;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard$ModuleStep == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard$ModuleStep = CheckoutWizard.class$("org.netbeans.modules.versioning.system.cvss.ui.wizards.CheckoutWizard$ModuleStep")) : class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard$ModuleStep);
        }

        protected void validateBeforeNext() {
            boolean done;
            String text;
            File file;
            if (this.validateUserInput(true) && !(file = new File(text = ((CheckoutWizard)CheckoutWizard.this).modulePanel.workTextField.getText())).exists() && !(done = file.mkdirs())) {
                this.invalid(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard = CheckoutWizard.class$("org.netbeans.modules.versioning.system.cvss.ui.wizards.CheckoutWizard")) : class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard), (String)"BK2013") + file.getPath());
            }
        }

        private boolean validateUserInput(boolean full) {
            String text = ((CheckoutWizard)CheckoutWizard.this).modulePanel.workTextField.getText();
            if (text == null || text.length() == 0) {
                this.invalid(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard = CheckoutWizard.class$("org.netbeans.modules.versioning.system.cvss.ui.wizards.CheckoutWizard")) : class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard), (String)"BK2014"));
                return false;
            }
            String errorMessage = null;
            if (full) {
                File file = new File(text);
                if (!file.exists()) {
                    for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
                        if (!parent.exists()) continue;
                        if (!parent.canWrite()) {
                            errorMessage = NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard = CheckoutWizard.class$("org.netbeans.modules.versioning.system.cvss.ui.wizards.CheckoutWizard")) : class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard), (String)"BK2016") + parent.getPath();
                        }
                        break;
                    }
                } else if (file.isFile()) {
                    errorMessage = NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard = CheckoutWizard.class$("org.netbeans.modules.versioning.system.cvss.ui.wizards.CheckoutWizard")) : class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard), (String)"BK2017");
                }
            }
            if (errorMessage == null) {
                this.valid();
            } else {
                this.invalid(errorMessage);
            }
            return errorMessage == null;
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            this.validateUserInput(false);
        }

        public void removeUpdate(DocumentEvent e) {
            this.validateUserInput(false);
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            this.validateUserInput(true);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ((CheckoutWizard)CheckoutWizard.this).modulePanel.moduleButton) {
                ModuleSelector selector = new ModuleSelector();
                String rootString = CheckoutWizard.this.repositoryStep.getCvsRoot();
                CVSRoot root = CVSRoot.parse((String)rootString);
                Set modules = selector.selectModules(root, CheckoutWizard.this.getProxyDescriptor());
                StringBuffer buf = new StringBuffer();
                String separator = "";
                Iterator it = modules.iterator();
                while (it.hasNext()) {
                    String module = (String)it.next();
                    buf.append(separator).append(module);
                    separator = ",";
                }
                ((CheckoutWizard)CheckoutWizard.this).modulePanel.moduleTextField.setText(buf.toString());
            } else if (e.getSource() == ((CheckoutWizard)CheckoutWizard.this).modulePanel.tagButton) {
                String module;
                String tag;
                BranchSelector selector = new BranchSelector();
                String rootString = CheckoutWizard.this.repositoryStep.getCvsRoot();
                CVSRoot root = CVSRoot.parse((String)rootString);
                String s = ((CheckoutWizard)CheckoutWizard.this).modulePanel.moduleTextField.getText();
                if (s.trim().length() == 0) {
                    s = ".";
                }
                if ((tag = selector.selectTag(root, module = new StringTokenizer(s, ", ").nextToken(), CheckoutWizard.this.getProxyDescriptor())) != null) {
                    ((CheckoutWizard)CheckoutWizard.this).modulePanel.tagTextField.setText(tag);
                }
            } else if (e.getSource() == ((CheckoutWizard)CheckoutWizard.this).modulePanel.workButton) {
                File defaultDir = this.defaultWorkingDirectory();
                AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard = CheckoutWizard.class$("org.netbeans.modules.versioning.system.cvss.ui.wizards.CheckoutWizard")) : class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard), (String)"ACSD_BrowseFolder"), defaultDir);
                fileChooser.setDialogTitle(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard = CheckoutWizard.class$("org.netbeans.modules.versioning.system.cvss.ui.wizards.CheckoutWizard")) : class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard), (String)"BK0010"));
                fileChooser.setMultiSelectionEnabled(false);
                FileFilter[] old = fileChooser.getChoosableFileFilters();
                for (int i = 0; i < old.length; ++i) {
                    FileFilter fileFilter = old[i];
                    fileChooser.removeChoosableFileFilter(fileFilter);
                }
                fileChooser.addChoosableFileFilter(new FileFilter(){

                    public boolean accept(File f) {
                        return f.isDirectory();
                    }

                    public String getDescription() {
                        return NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard = CheckoutWizard.class$("org.netbeans.modules.versioning.system.cvss.ui.wizards.CheckoutWizard")) : class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard), (String)"BK0008");
                    }
                });
                fileChooser.setFileSelectionMode(1);
                fileChooser.showDialog(CheckoutWizard.this.modulePanel, NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard = CheckoutWizard.class$("org.netbeans.modules.versioning.system.cvss.ui.wizards.CheckoutWizard")) : class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard), (String)"BK0009"));
                File f = fileChooser.getSelectedFile();
                if (f != null) {
                    ((CheckoutWizard)CheckoutWizard.this).modulePanel.workTextField.setText(f.getAbsolutePath());
                }
            } else {
                this.validateUserInput(true);
            }
        }

        private File defaultWorkingDirectory() {
            File projectFolder;
            File defaultDir = null;
            String current = ((CheckoutWizard)CheckoutWizard.this).modulePanel.workTextField.getText();
            if (current != null && !current.trim().equals("")) {
                File currentFile;
                for (currentFile = new File(current); currentFile != null && !currentFile.exists(); currentFile = currentFile.getParentFile()) {
                }
                if (currentFile != null) {
                    defaultDir = currentFile.isFile() ? currentFile.getParentFile() : currentFile;
                }
            }
            if (defaultDir == null) {
                List recent = HistorySettings.getRecent("checkoutDirectory");
                Iterator it = recent.iterator();
                while (it.hasNext()) {
                    String path = (String)it.next();
                    File file = new File(path);
                    File parent = file.getParentFile();
                    if (parent == null || !parent.exists() || !parent.isDirectory()) continue;
                    defaultDir = file;
                    break;
                }
            }
            if (defaultDir == null && (projectFolder = ProjectChooser.getProjectsFolder()).exists() && projectFolder.isDirectory()) {
                defaultDir = projectFolder;
            }
            if (defaultDir == null) {
                defaultDir = new File(System.getProperty("user.home"));
            }
            return defaultDir;
        }
    }
}

