/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.ignore;

import java.io.File;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.nodes.Node;

public class IgnoreAction
extends AbstractSystemAction {
    public static final int UNDEFINED = 0;
    public static final int IGNORING = 1;
    public static final int UNIGNORING = 2;

    protected String getBaseName(Node[] activatedNodes) {
        int actionStatus = this.getActionStatus(activatedNodes);
        switch (actionStatus) {
            case 0: 
            case 1: {
                return "CTL_MenuItem_Ignore";
            }
            case 2: {
                return "CTL_MenuItem_Unignore";
            }
        }
        throw new RuntimeException("Invalid action status: " + actionStatus);
    }

    public int getActionStatus(Node[] nodes) {
        return this.getActionStatus(Utils.getCurrentContext(nodes).getFiles());
    }

    public int getActionStatus(File[] files) {
        int actionStatus = -1;
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getName().equals(".cvsignore")) {
                actionStatus = 0;
                break;
            }
            FileInformation info = cache.getStatus(files[i]);
            if (info.getStatus() == 4) {
                actionStatus = actionStatus == -1 || actionStatus == 1 ? 1 : 0;
                continue;
            }
            if (info.getStatus() == 2) {
                actionStatus = (actionStatus == -1 || actionStatus == 2) && this.canBeUnignored(files[i]) ? 2 : 0;
                continue;
            }
            actionStatus = 0;
            break;
        }
        return actionStatus == -1 ? 0 : actionStatus;
    }

    private boolean canBeUnignored(File file) {
        return CvsVersioningSystem.getInstance().isInCvsIgnore(file);
    }

    protected boolean enable(Node[] nodes) {
        return this.getActionStatus(nodes) != 0;
    }

    public void performCvsAction(Node[] nodes) {
        int actionStatus = this.getActionStatus(nodes);
        if (actionStatus == 1) {
            CvsVersioningSystem.getInstance().setIgnored(Utils.getCurrentContext(nodes).getFiles());
        } else if (actionStatus == 2) {
            CvsVersioningSystem.getInstance().setNotignored(Utils.getCurrentContext(nodes).getFiles());
        } else {
            throw new RuntimeException("Invalid action status: " + actionStatus);
        }
    }

    protected boolean asynchronous() {
        return false;
    }
}

