/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.ChangeListener;
import javax.swing.text.Position;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicVisualPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public abstract class BasicWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int position = 0;
    private PrivateWizardPanel[] wizardPanels;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected BasicWizardIterator() {
    }

    protected abstract Panel[] createPanels(WizardDescriptor var1);

    public void initialize(WizardDescriptor wiz) {
        String[] beforeSteps = null;
        Object prop = wiz.getProperty("WizardPanel_contentData");
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        this.position = 0;
        Panel[] panels = this.createPanels(wiz);
        String[] steps = BasicWizardIterator.createSteps(beforeSteps, panels);
        this.wizardPanels = new PrivateWizardPanel[panels.length];
        for (int i = 0; i < panels.length; ++i) {
            this.wizardPanels[i] = new PrivateWizardPanel(panels[i], steps, i);
        }
    }

    private static String[] createSteps(String[] before, Panel[] panels) {
        if (!$assertionsDisabled && panels == null) {
            throw new AssertionError();
        }
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getPanelName();
        }
        return res;
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wizardPanels = null;
    }

    public String name() {
        return ((PrivateWizardPanel)this.current()).getPanel().getPanelName();
    }

    public boolean hasNext() {
        return this.position < this.wizardPanels.length - 1;
    }

    public boolean hasPrevious() {
        return this.position > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.position;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.position;
    }

    public WizardDescriptor.Panel current() {
        return this.wizardPanels[this.position];
    }

    protected final String getMessage(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    protected Set getCreatedFiles(CreatedModifiedFiles cmf, Project project) throws IOException {
        HashSet<DataObject> toBeShown = new HashSet<DataObject>();
        String[] paths = cmf.getCreatedPaths();
        HashSet<FileObject> set = new HashSet<FileObject>();
        for (int i = 0; i < paths.length; ++i) {
            FileObject fo = project.getProjectDirectory().getFileObject(paths[i]);
            BasicWizardIterator.formatFile(fo);
            DataObject dObj = DataObject.find((FileObject)fo);
            if (dObj == null || toBeShown.size() >= 10 || !toBeShown.add(dObj)) continue;
            set.add(fo);
        }
        return set;
    }

    private static BaseDocument getDocument(FileObject fo) throws DataObjectNotFoundException, IOException {
        EditorCookie editor;
        BaseDocument doc = null;
        DataObject dObj = DataObject.find((FileObject)fo);
        if (dObj != null && (editor = (EditorCookie)dObj.getCookie(EditorCookie.class)) != null) {
            doc = (BaseDocument)editor.openDocument();
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void formatFile(FileObject fo) {
        boolean saved;
        BaseDocument doc;
        block17: {
            if (!$assertionsDisabled && fo == null) {
                throw new AssertionError();
            }
            doc = null;
            saved = false;
            doc = BasicWizardIterator.getDocument(fo);
            if (doc != null) break block17;
            if (doc == null) return;
            doc.atomicUnlock();
            if (!saved) return;
            try {
                ((EditorCookie)DataObject.find((FileObject)fo).getCookie(EditorCookie.class)).saveDocument();
                return;
            }
            catch (IOException e) {
                Util.err.notify(1, (Throwable)e);
            }
            return;
        }
        GuardedDocument gdoc = doc instanceof GuardedDocument ? (GuardedDocument)doc : null;
        doc.atomicLock();
        int startPos = 0;
        Position endPosition = doc.createPosition(doc.getLength());
        int pos = startPos;
        if (gdoc != null) {
            pos = gdoc.getGuardedBlockChain().adjustToBlockEnd(pos);
        }
        while (pos < endPosition.getOffset()) {
            int stopPos = endPosition.getOffset();
            if (gdoc != null && (stopPos = gdoc.getGuardedBlockChain().adjustToNextBlockStart(pos)) == -1) {
                stopPos = endPosition.getOffset();
            }
            int reformattedLen = doc.getFormatter().reformat(doc, pos, stopPos);
            pos += reformattedLen;
            if (gdoc == null) continue;
            pos = gdoc.getGuardedBlockChain().adjustToBlockEnd(pos);
        }
        saved = true;
        if (doc == null) return;
        doc.atomicUnlock();
        if (!saved) return;
        try {
            ((EditorCookie)DataObject.find((FileObject)fo).getCookie(EditorCookie.class)).saveDocument();
            return;
        }
        catch (IOException e) {
            Util.err.notify(1, (Throwable)e);
        }
        return;
        catch (Exception ex) {
            try {
                ErrorManager.getDefault().log(16, "Cannot reformat the file: " + fo.getPath());
                if (doc == null) return;
            }
            catch (Throwable throwable) {
                if (doc == null) throw throwable;
                doc.atomicUnlock();
                if (!saved) throw throwable;
                try {
                    ((EditorCookie)DataObject.find((FileObject)fo).getCookie(EditorCookie.class)).saveDocument();
                    throw throwable;
                }
                catch (IOException e) {
                    Util.err.notify(1, (Throwable)e);
                }
                throw throwable;
            }
            doc.atomicUnlock();
            if (!saved) return;
            try {
                ((EditorCookie)DataObject.find((FileObject)fo).getCookie(EditorCookie.class)).saveDocument();
                return;
            }
            catch (IOException e) {
                Util.err.notify(1, (Throwable)e);
            }
            return;
        }
    }

    static {
        $assertionsDisabled = !BasicWizardIterator.class.desiredAssertionStatus();
    }

    private static final class PrivateWizardPanel
    extends BasicWizardPanel {
        private Panel panel;

        PrivateWizardPanel(Panel panel, String[] allSteps, int stepIndex) {
            super(panel.getSettings());
            panel.addPropertyChangeListener(this);
            panel.setName(panel.getPanelName());
            this.panel = panel;
            panel.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(stepIndex));
            panel.putClientProperty("WizardPanel_contentData", allSteps);
        }

        private Panel getPanel() {
            return this.panel;
        }

        public Component getComponent() {
            return this.getPanel();
        }

        public void storeSettings(Object settings) {
            WizardDescriptor wiz = (WizardDescriptor)settings;
            if (WizardDescriptor.NEXT_OPTION.equals(wiz.getValue()) || WizardDescriptor.FINISH_OPTION.equals(wiz.getValue())) {
                this.panel.storeToDataModel();
            }
            ((WizardDescriptor)settings).putProperty("NewFileWizard_Title", null);
        }

        public void readSettings(Object settings) {
            WizardDescriptor wiz = (WizardDescriptor)settings;
            Object substitute = this.getPanel().getClientProperty("NewFileWizard_Title");
            if (substitute != null) {
                wiz.putProperty("NewFileWizard_Title", substitute);
            }
            if (WizardDescriptor.NEXT_OPTION.equals(wiz.getValue()) || wiz.getValue() == null) {
                this.panel.readFromDataModel();
            }
        }

        public HelpCtx getHelp() {
            return this.getPanel().getHelp();
        }
    }

    public static class BasicDataModel {
        private NbModuleProject project;
        private SourceGroup sourceRootGroup;
        private String packageName;
        static final /* synthetic */ boolean $assertionsDisabled;

        public BasicDataModel(WizardDescriptor wiz) {
            Project tmpProject = Templates.getProject((WizardDescriptor)wiz);
            if (tmpProject == null) {
                throw new IllegalArgumentException();
            }
            if (!(tmpProject instanceof NbModuleProject)) {
                throw new IllegalArgumentException(tmpProject.getClass().toString());
            }
            this.project = (NbModuleProject)tmpProject;
            FileObject fo = Templates.getTargetFolder((WizardDescriptor)wiz);
            if (fo != null) {
                Sources srcs = ProjectUtils.getSources((Project)this.project);
                SourceGroup[] grps = srcs.getSourceGroups("java");
                for (int i = 0; i < grps.length; ++i) {
                    if (!FileUtil.isParentOf((FileObject)grps[i].getRootFolder(), (FileObject)fo)) continue;
                    String relPath = FileUtil.getRelativePath((FileObject)grps[i].getRootFolder(), (FileObject)fo);
                    relPath = relPath.replace('/', '.');
                    this.setPackageName(relPath);
                    break;
                }
            }
        }

        public NbModuleProject getProject() {
            return this.project;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public SourceGroup getSourceRootGroup() {
            if (this.sourceRootGroup == null) {
                FileObject tempSrcRoot = this.getProject().getSourceDirectory();
                if (!$assertionsDisabled && tempSrcRoot == null) {
                    throw new AssertionError();
                }
                Sources sources = ProjectUtils.getSources((Project)this.project);
                SourceGroup[] groups = sources.getSourceGroups("java");
                for (int i = 0; this.sourceRootGroup == null && i < groups.length; ++i) {
                    if (!groups[i].getRootFolder().equals(tempSrcRoot)) continue;
                    this.sourceRootGroup = groups[i];
                }
            }
            return this.sourceRootGroup;
        }

        public String getDefaultPackagePath(String fileName) {
            return this.getProject().getSourceDirectoryPath() + '/' + this.getPackageName().replace('.', '/') + '/' + fileName;
        }

        public String addCreateIconOperation(CreatedModifiedFiles cmf, String origIconPath) {
            FileObject origIconFO = FileUtil.toFileObject((File)new File(origIconPath));
            String relativeIconPath = null;
            if (!FileUtil.isParentOf((FileObject)this.getProject().getSourceDirectory(), (FileObject)origIconFO)) {
                String iconPath = this.getDefaultPackagePath(origIconFO.getNameExt());
                try {
                    cmf.add(cmf.createFile(iconPath, origIconFO.getURL()));
                    relativeIconPath = this.getPackageName().replace('.', '/') + '/' + origIconFO.getNameExt();
                }
                catch (FileStateInvalidException exc) {
                    Util.err.notify((Throwable)exc);
                }
            } else {
                relativeIconPath = FileUtil.getRelativePath((FileObject)this.getProject().getSourceDirectory(), (FileObject)origIconFO);
            }
            return relativeIconPath;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$ui$wizard$BasicWizardIterator == null ? (class$org$netbeans$modules$apisupport$project$ui$wizard$BasicWizardIterator = BasicWizardIterator.class$("org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator")) : class$org$netbeans$modules$apisupport$project$ui$wizard$BasicWizardIterator).desiredAssertionStatus();
        }
    }

    public static abstract class Panel
    extends BasicVisualPanel {
        protected Panel(WizardDescriptor wiz) {
            super(wiz);
        }

        protected abstract String getPanelName();

        protected abstract void storeToDataModel();

        protected abstract void readFromDataModel();

        protected abstract HelpCtx getHelp();
    }
}

