/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

class HarnessUpgrader {
    private HarnessUpgrader() {
    }

    public static void checkForUpgrade() {
        if (ModuleUISettings.getDefault().getHarnessesUpgraded()) {
            return;
        }
        ModuleUISettings.getDefault().setHarnessesUpgraded(true);
        final HashSet<NbPlatform> toUpgrade = new HashSet<NbPlatform>();
        Iterator it = NbPlatform.getPlatforms().iterator();
        while (it.hasNext()) {
            NbPlatform p = (NbPlatform)it.next();
            if (p.isDefault() && !p.isValid() || p.getHarnessVersion() >= 2 || !p.getHarnessLocation().equals(p.getBundledHarnessLocation())) continue;
            toUpgrade.add(p);
        }
        if (!toUpgrade.isEmpty()) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    HarnessUpgrader.promptForUpgrade(toUpgrade);
                }
            });
        }
    }

    private static void promptForUpgrade(Set platforms) {
        if (UIUtil.showAcceptCancelDialog(NbBundle.getMessage((Class)HarnessUpgrader.class, (String)"HarnessUpgrader.title"), NbBundle.getMessage((Class)HarnessUpgrader.class, (String)"HarnessUpgrader.text"), NbBundle.getMessage((Class)HarnessUpgrader.class, (String)"HarnessUpgrader.upgrade"), NbBundle.getMessage((Class)HarnessUpgrader.class, (String)"HarnessUpgrader.skip"), 3)) {
            try {
                HarnessUpgrader.doUpgrade(platforms);
            }
            catch (IOException e) {
                Util.err.notify((Throwable)e);
            }
        }
    }

    private static void doUpgrade(Set platforms) throws IOException {
        File defaultHarness = NbPlatform.getDefaultPlatform().getHarnessLocation();
        Iterator it = platforms.iterator();
        while (it.hasNext()) {
            NbPlatform p = (NbPlatform)it.next();
            p.setHarnessLocation(defaultHarness);
        }
    }
}

