/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerDisplay;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class SuiteCustomizerSources
extends NbPropertyPanel.Suite {
    private JButton addModuleButton;
    private JPanel buttonPanel;
    private JLabel moduleLabel;
    private JList moduleList;
    private JScrollPane modulesSP;
    private JLabel prjFolder;
    private JPanel prjFolderPanel;
    private JTextField prjFolderValue;
    private JButton removeModuleButton;

    SuiteCustomizerSources(SuiteProperties suiteProps) {
        super(suiteProps, SuiteCustomizerSources.class);
        this.initComponents();
        this.initAccesibility();
        this.prjFolderValue.setText(suiteProps.getProjectDirectory());
        this.refresh();
        this.moduleList.setCellRenderer(CustomizerComponentFactory.getModuleCellRenderer());
        this.moduleList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SuiteCustomizerSources.this.updateEnabled();
                }
            }
        });
    }

    void refresh() {
        this.moduleList.setModel(this.getProperties().getModulesListModel());
    }

    private void updateEnabled() {
        boolean enabled = this.moduleList.getSelectedIndex() != -1;
        this.removeModuleButton.setEnabled(enabled);
    }

    private CustomizerComponentFactory.SuiteSubModulesListModel getModuleListModel() {
        return (CustomizerComponentFactory.SuiteSubModulesListModel)this.moduleList.getModel();
    }

    private void initComponents() {
        this.prjFolderPanel = new JPanel();
        this.prjFolder = new JLabel();
        this.prjFolderValue = new JTextField();
        this.moduleLabel = new JLabel();
        this.modulesSP = new JScrollPane();
        this.moduleList = new JList();
        this.buttonPanel = new JPanel();
        this.addModuleButton = new JButton();
        this.removeModuleButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.prjFolderPanel.setLayout(new GridBagLayout());
        this.prjFolder.setLabelFor(this.prjFolderValue);
        Mnemonics.setLocalizedText((JLabel)this.prjFolder, (String)NbBundle.getMessage((Class)SuiteCustomizerSources.class, (String)"LBL_ProjectFolder"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.prjFolderPanel.add((Component)this.prjFolder, gridBagConstraints);
        this.prjFolderValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.prjFolderPanel.add((Component)this.prjFolderValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.prjFolderPanel, gridBagConstraints);
        this.moduleLabel.setLabelFor(this.moduleList);
        Mnemonics.setLocalizedText((JLabel)this.moduleLabel, (String)NbBundle.getMessage((Class)SuiteCustomizerSources.class, (String)"LBL_SuiteModules"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 2, 0);
        this.add((Component)this.moduleLabel, gridBagConstraints);
        this.modulesSP.setViewportView(this.moduleList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.modulesSP, gridBagConstraints);
        this.buttonPanel.setLayout(new GridLayout(2, 1, 0, 6));
        Mnemonics.setLocalizedText((AbstractButton)this.addModuleButton, (String)NbBundle.getMessage((Class)SuiteCustomizerSources.class, (String)"CTL_AddButton"));
        this.addModuleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SuiteCustomizerSources.this.addModule(evt);
            }
        });
        this.buttonPanel.add(this.addModuleButton);
        Mnemonics.setLocalizedText((AbstractButton)this.removeModuleButton, (String)NbBundle.getMessage((Class)SuiteCustomizerSources.class, (String)"CTL_RemoveButton"));
        this.removeModuleButton.setEnabled(false);
        this.removeModuleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SuiteCustomizerSources.this.removeModule(evt);
            }
        });
        this.buttonPanel.add(this.removeModuleButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void removeModule(ActionEvent evt) {
        this.getModuleListModel().removeModules(Arrays.asList(this.moduleList.getSelectedValues()));
        if (this.moduleList.getModel().getSize() > 0) {
            this.moduleList.setSelectedIndex(0);
        }
        this.moduleList.requestFocus();
    }

    private void addModule(ActionEvent evt) {
        NbModuleProject project = UIUtil.chooseSuiteComponent(this, this.getProperties().getProject());
        if (project != null) {
            if (this.getModuleListModel().contains(project)) {
                this.moduleList.setSelectedValue(project, true);
            } else {
                this.getModuleListModel().addModule(project);
            }
        }
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage((Class)CustomizerDisplay.class, (String)key);
    }

    private void initAccesibility() {
        this.addModuleButton.getAccessibleContext().setAccessibleDescription(SuiteCustomizerSources.getMessage("ACSD_AddModuleButton"));
        this.moduleList.getAccessibleContext().setAccessibleDescription(SuiteCustomizerSources.getMessage("ACSD_ModuleList"));
        this.prjFolderValue.getAccessibleContext().setAccessibleDescription(SuiteCustomizerSources.getMessage("ACSD_PrjFolderValue"));
        this.removeModuleButton.getAccessibleContext().setAccessibleDescription(SuiteCustomizerSources.getMessage("ACSD_RemoveModuleButton"));
    }
}

