/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.AddModulePanel;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.EditDependencyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.JavaPlatformComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerLibraries
extends NbPropertyPanel.Single {
    private static Rectangle lastSize;
    private JButton addDepButton;
    private JButton addLibrary;
    private JButton addTokenButton;
    private JPanel depButtonPanel;
    private JList dependencyList;
    private JScrollPane dependencySP;
    private JButton editDepButton;
    private JButton javaPlatformButton;
    private JComboBox javaPlatformCombo;
    private JLabel javaPlatformLabel;
    private JButton managePlafsButton;
    private JLabel modDepLabel;
    private JLabel platform;
    private JComboBox platformValue;
    private JPanel platformsPanel;
    private JButton removeDepButton;
    private JButton removeTokenButton;
    private JList reqTokenList;
    private JScrollPane reqTokenSP;
    private JLabel reqTokens;
    private JLabel space1;
    private JPanel tokenButtonPanel;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CustomizerLibraries(SingleModuleProperties props) {
        super(props, CustomizerLibraries.class);
        this.initComponents();
        this.initAccessibility();
        if (!this.getProperties().isSuiteComponent()) {
            this.addLibrary.setVisible(false);
            Mnemonics.setLocalizedText((AbstractButton)this.addDepButton, (String)this.getMessage("CTL_AddButton"));
        }
        this.refresh();
        this.dependencyList.setCellRenderer(CustomizerComponentFactory.getDependencyCellRenderer(false));
        this.javaPlatformCombo.setRenderer(JavaPlatformComponentFactory.javaPlatformListCellRenderer());
        this.removeTokenButton.setEnabled(false);
        this.attachListeners();
    }

    void refresh() {
        this.refreshJavaPlatforms();
        this.refreshPlatforms();
        this.platformValue.setEnabled(this.getProperties().isStandalone());
        this.managePlafsButton.setEnabled(this.getProperties().isStandalone());
        this.updateEnabled();
        this.reqTokenList.setModel(this.getProperties().getRequiredTokenListModel());
        this.dependencyList.setModel(this.getProperties().getDependenciesListModel());
        this.dependencyList.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                CustomizerLibraries.this.updateEnabled();
            }

            public void intervalAdded(ListDataEvent e) {
                CustomizerLibraries.this.updateEnabled();
            }

            public void intervalRemoved(ListDataEvent e) {
                CustomizerLibraries.this.updateEnabled();
            }
        });
    }

    private void attachListeners() {
        this.platformValue.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CustomizerLibraries.this.getProperties().setActivePlatform((NbPlatform)CustomizerLibraries.this.platformValue.getSelectedItem());
                    CustomizerLibraries.this.dependencyList.setModel(CustomizerLibraries.this.getProperties().getDependenciesListModel());
                    CustomizerLibraries.this.updateEnabled();
                }
            }
        });
        this.dependencyList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    CustomizerLibraries.this.updateEnabled();
                }
            }
        });
        this.javaPlatformCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CustomizerLibraries.this.getProperties().setActiveJavaPlatform((JavaPlatform)CustomizerLibraries.this.javaPlatformCombo.getSelectedItem());
                }
            }
        });
        this.reqTokenList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    CustomizerLibraries.this.removeTokenButton.setEnabled(CustomizerLibraries.this.reqTokenList.getSelectedIndex() != -1);
                }
            }
        });
    }

    private void refreshJavaPlatforms() {
        this.javaPlatformCombo.setModel(JavaPlatformComponentFactory.javaPlatformListModel());
        this.javaPlatformCombo.setSelectedItem(this.getProperties().getActiveJavaPlatform());
    }

    private void refreshPlatforms() {
        this.platformValue.setModel(new PlatformComponentFactory.NbPlatformListModel());
        this.platformValue.setSelectedItem(this.getProperties().getActivePlatform());
        this.platformValue.requestFocusInWindow();
    }

    private void updateEnabled() {
        boolean enabled = this.dependencyList.getModel().getSize() > 0 && this.getProperties().isActivePlatformValid() && this.dependencyList.getSelectedIndex() != -1;
        this.editDepButton.setEnabled(enabled);
        this.removeDepButton.setEnabled(enabled);
        this.addDepButton.setEnabled(this.getProperties().isActivePlatformValid());
        boolean javaEnabled = this.getProperties().isNetBeansOrg() || this.getProperties().isStandalone() && ((NbPlatform)this.platformValue.getSelectedItem()).getHarnessVersion() >= 2;
        this.javaPlatformCombo.setEnabled(javaEnabled);
        this.javaPlatformButton.setEnabled(javaEnabled);
    }

    private CustomizerComponentFactory.DependencyListModel getDepListModel() {
        return (CustomizerComponentFactory.DependencyListModel)this.dependencyList.getModel();
    }

    private String getMessage(String key) {
        return NbBundle.getMessage((Class)CustomizerLibraries.class, (String)key);
    }

    private void initComponents() {
        this.modDepLabel = new JLabel();
        this.depButtonPanel = new JPanel();
        this.addDepButton = new JButton();
        this.addLibrary = new JButton();
        this.removeDepButton = new JButton();
        this.space1 = new JLabel();
        this.editDepButton = new JButton();
        this.dependencySP = new JScrollPane();
        this.dependencyList = new JList();
        this.platformsPanel = new JPanel();
        this.platformValue = PlatformComponentFactory.getNbPlatformsComboxBox();
        this.platform = new JLabel();
        this.managePlafsButton = new JButton();
        this.javaPlatformLabel = new JLabel();
        this.javaPlatformCombo = new JComboBox();
        this.javaPlatformButton = new JButton();
        this.reqTokens = new JLabel();
        this.reqTokenSP = new JScrollPane();
        this.reqTokenList = new JList();
        this.tokenButtonPanel = new JPanel();
        this.addTokenButton = new JButton();
        this.removeTokenButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.modDepLabel.setLabelFor(this.dependencyList);
        Mnemonics.setLocalizedText((JLabel)this.modDepLabel, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"LBL_ModuleDependencies"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 2, 0);
        this.add((Component)this.modDepLabel, gridBagConstraints);
        this.depButtonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addDepButton, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"CTL_AddDependency"));
        this.addDepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomizerLibraries.this.addModuleDependency(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.depButtonPanel.add((Component)this.addDepButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addLibrary, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"CTL_AddNewLibrary"));
        this.addLibrary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomizerLibraries.this.addLibraryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.depButtonPanel.add((Component)this.addLibrary, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeDepButton, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"CTL_RemoveButton"));
        this.removeDepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomizerLibraries.this.removeModuleDependency(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.depButtonPanel.add((Component)this.removeDepButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        this.depButtonPanel.add((Component)this.space1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.editDepButton, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"CTL_EditButton"));
        this.editDepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomizerLibraries.this.editModuleDependency(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.depButtonPanel.add((Component)this.editDepButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.depButtonPanel, gridBagConstraints);
        this.dependencySP.setViewportView(this.dependencyList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.dependencySP, gridBagConstraints);
        this.platformsPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.platformsPanel.add((Component)this.platformValue, gridBagConstraints);
        this.platform.setLabelFor(this.platformValue);
        Mnemonics.setLocalizedText((JLabel)this.platform, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"LBL_NetBeansPlatform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.platformsPanel.add((Component)this.platform, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.managePlafsButton, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"CTL_ManagePlatform"));
        this.managePlafsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomizerLibraries.this.managePlatforms(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.platformsPanel.add((Component)this.managePlafsButton, gridBagConstraints);
        this.javaPlatformLabel.setLabelFor(this.javaPlatformCombo);
        Mnemonics.setLocalizedText((JLabel)this.javaPlatformLabel, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"LBL_Java_Platform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.platformsPanel.add((Component)this.javaPlatformLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.platformsPanel.add((Component)this.javaPlatformCombo, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.javaPlatformButton, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"LBL_Manage_Java_Platforms"));
        this.javaPlatformButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomizerLibraries.this.javaPlatformButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.platformsPanel.add((Component)this.javaPlatformButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.platformsPanel, gridBagConstraints);
        this.reqTokens.setLabelFor(this.reqTokenList);
        Mnemonics.setLocalizedText((JLabel)this.reqTokens, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"LBL_RequiredTokens"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 12);
        this.add((Component)this.reqTokens, gridBagConstraints);
        this.reqTokenSP.setViewportView(this.reqTokenList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.reqTokenSP, gridBagConstraints);
        this.tokenButtonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addTokenButton, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"CTL_AddButton_d"));
        this.addTokenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomizerLibraries.this.addToken(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.tokenButtonPanel.add((Component)this.addTokenButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeTokenButton, (String)NbBundle.getMessage((Class)CustomizerLibraries.class, (String)"CTL_RemoveButton_v"));
        this.removeTokenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomizerLibraries.this.removeToken(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.tokenButtonPanel.add((Component)this.removeTokenButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.tokenButtonPanel, gridBagConstraints);
    }

    private void addLibraryActionPerformed(ActionEvent evt) {
        block3: {
            NbModuleProject project = UIUtil.runLibraryWrapperWizard(this.getProperties().getProject());
            if (project != null) {
                try {
                    this.getProperties().libraryWrapperAdded();
                    ModuleDependency dep = new ModuleDependency(this.getProperties().getModuleList().getEntry(project.getCodeNameBase()));
                    this.getDepListModel().addDependency(dep);
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)e);
                }
            }
        }
    }

    private void javaPlatformButtonActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)((JavaPlatform)this.javaPlatformCombo.getSelectedItem()));
        this.refreshJavaPlatforms();
    }

    private void removeToken(ActionEvent evt) {
        CustomizerComponentFactory.RequiredTokenListModel model = (CustomizerComponentFactory.RequiredTokenListModel)this.reqTokenList.getModel();
        Object[] selected = this.reqTokenList.getSelectedValues();
        for (int i = 0; i < selected.length; ++i) {
            model.removeToken((String)selected[i]);
        }
        if (model.getSize() > 0) {
            this.reqTokenList.setSelectedIndex(0);
        }
        this.reqTokenList.requestFocusInWindow();
    }

    private void addToken(ActionEvent evt) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        panel.setLayout(new BorderLayout(0, 2));
        JList<String> tokenList = new JList<String>(this.getProperties().getAllTokens());
        JScrollPane tokenListSP = new JScrollPane(tokenList);
        JLabel provTokensTxt = new JLabel();
        provTokensTxt.setLabelFor(tokenList);
        Mnemonics.setLocalizedText((JLabel)provTokensTxt, (String)this.getMessage("LBL_ProvidedTokens_T"));
        panel.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_ProvidedTokensTitle"));
        tokenList.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_LBL_ProvidedTokens"));
        tokenListSP.getVerticalScrollBar().getAccessibleContext().setAccessibleName(this.getMessage("ACS_CTL_ProvidedTokensVerticalScroll"));
        tokenListSP.getVerticalScrollBar().getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_CTL_ProvidedTokensVerticalScroll"));
        tokenListSP.getHorizontalScrollBar().getAccessibleContext().setAccessibleName(this.getMessage("ACS_CTL_ProvidedTokensHorizontalScroll"));
        tokenListSP.getHorizontalScrollBar().getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_CTL_ProvidedTokensHorizontalScroll"));
        panel.add((Component)provTokensTxt, "North");
        panel.add((Component)tokenListSP, "Center");
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, this.getMessage("LBL_ProvidedTokens_NoMnem"));
        Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
        d.setVisible(true);
        d.dispose();
        if (descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            Object[] selected = tokenList.getSelectedValues();
            CustomizerComponentFactory.RequiredTokenListModel model = (CustomizerComponentFactory.RequiredTokenListModel)this.reqTokenList.getModel();
            for (int i = 0; i < selected.length; ++i) {
                model.addToken((String)selected[i]);
            }
            if (selected.length > 0) {
                this.reqTokenList.clearSelection();
                this.reqTokenList.setSelectedValue(selected[0], true);
            }
        }
        this.reqTokenList.requestFocusInWindow();
    }

    private void managePlatforms(ActionEvent evt) {
        NbPlatformCustomizer.showCustomizer();
        this.refreshPlatforms();
    }

    private void editModuleDependency(ActionEvent evt) {
        ModuleDependency origDep = this.getDepListModel().getDependency(this.dependencyList.getSelectedIndex());
        ModuleDependency editedDep = this.getDepListModel().findEdited(origDep);
        EditDependencyPanel editPanel = new EditDependencyPanel(editedDep == null ? origDep : editedDep, this.getProperties().getActivePlatform());
        DialogDescriptor descriptor = new DialogDescriptor((Object)editPanel, this.getMessage("CTL_EditModuleDependencyTitle"));
        descriptor.setHelpCtx(new HelpCtx(EditDependencyPanel.class));
        Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
        d.setVisible(true);
        if (descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            this.getDepListModel().editDependency(origDep, editPanel.getEditedDependency());
        }
        d.dispose();
        this.dependencyList.requestFocusInWindow();
    }

    private void removeModuleDependency(ActionEvent evt) {
        this.getDepListModel().removeDependencies(Arrays.asList(this.dependencyList.getSelectedValues()));
        if (this.dependencyList.getModel().getSize() > 0) {
            this.dependencyList.setSelectedIndex(0);
        }
        this.dependencyList.requestFocusInWindow();
    }

    private void addModuleDependency(ActionEvent evt) {
        final AddModulePanel addPanel = new AddModulePanel(this.getProperties());
        DialogDescriptor descriptor = new DialogDescriptor((Object)addPanel, this.getMessage("CTL_AddModuleDependencyTitle"));
        descriptor.setHelpCtx(new HelpCtx(AddModulePanel.class));
        descriptor.setClosingOptions(new Object[0]);
        final Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
        descriptor.setButtonListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DialogDescriptor.OK_OPTION.equals(e.getSource()) && addPanel.getSelectedDependencies().length == 0) {
                    return;
                }
                d.setVisible(false);
                d.dispose();
            }
        });
        if (lastSize != null) {
            d.setBounds(lastSize);
        }
        d.setVisible(true);
        lastSize = d.getBounds();
        d.dispose();
        if (descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            ModuleDependency[] newDeps = addPanel.getSelectedDependencies();
            for (int i = 0; i < newDeps.length; ++i) {
                ModuleDependency dep = newDeps[i];
                if ("0".equals(dep.getReleaseVersion())) {
                    this.getDepListModel().addDependency(new ModuleDependency(dep.getModuleEntry(), "0-1", dep.getSpecificationVersion(), dep.hasCompileDependency(), dep.hasImplementationDepedendency()));
                } else {
                    this.getDepListModel().addDependency(dep);
                }
                this.dependencyList.setSelectedValue(dep, true);
            }
        }
        this.dependencyList.requestFocusInWindow();
    }

    private void initAccessibility() {
        this.addTokenButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_SrcLevelValue"));
        this.dependencyList.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_DependencyList"));
        this.editDepButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_EditDepButton"));
        this.removeDepButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_RemoveDepButton"));
        this.removeTokenButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_RemoveTokenButton"));
        this.addDepButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_AddDepButton"));
        this.reqTokenList.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_ReqTokenList"));
    }

    static {
        $assertionsDisabled = !CustomizerLibraries.class.desiredAssertionStatus();
    }
}

