/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.swing.JFileChooser;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;
import org.openide.windows.WindowManager;

public class PickIconAction
extends CookieAction {
    static final /* synthetic */ boolean $assertionsDisabled;

    protected void performAction(Node[] activatedNodes) {
        FileObject f = ((DataObject)activatedNodes[0].getCookie(DataObject.class)).getPrimaryFile();
        URL location = (URL)f.getAttribute("WritableXMLFileSystem.location");
        if (!$assertionsDisabled && location == null) {
            throw new AssertionError(f);
        }
        NbModuleProject p = (NbModuleProject)FileOwnerQuery.getOwner((URI)URI.create(location.toExternalForm()));
        if (!$assertionsDisabled && p == null) {
            throw new AssertionError(location);
        }
        FileObject src = p.getSourceDirectory();
        JFileChooser chooser = UIUtil.getIconFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, (File)FileUtil.toFile((FileObject)src));
        if (chooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) != 0) {
            return;
        }
        FileObject icon = FileUtil.toFileObject((File)chooser.getSelectedFile());
        String iconPath = FileUtil.getRelativePath((FileObject)src, (FileObject)icon);
        try {
            if (iconPath == null) {
                String layerPath = ManifestManager.getInstance(p.getManifest(), false).getLayer();
                String folderPath = layerPath != null ? layerPath.substring(0, layerPath.lastIndexOf(47)) : p.getCodeNameBase().replace('.', '/') + "/resources";
                FileObject folder = FileUtil.createFolder((FileObject)src, (String)folderPath);
                FileUtil.copyFile((FileObject)icon, (FileObject)folder, (String)icon.getName(), (String)icon.getExt());
                iconPath = folderPath + '/' + icon.getNameExt();
            }
            f.setAttribute("SystemFileSystem.icon", (Object)new URL("nbresloc:/" + iconPath));
        }
        catch (IOException e) {
            Util.err.notify(1, (Throwable)e);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (!super.enable(activatedNodes)) {
            return false;
        }
        FileObject f = ((DataObject)activatedNodes[0].getCookie(DataObject.class)).getPrimaryFile();
        URL location = (URL)f.getAttribute("WritableXMLFileSystem.location");
        return location != null;
    }

    public String getName() {
        return NbBundle.getMessage((Class)PickIconAction.class, (String)"LBL_pick_icon");
    }

    protected Class[] cookieClasses() {
        return new Class[]{DataObject.class};
    }

    protected int mode() {
        return 8;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    static {
        $assertionsDisabled = !PickIconAction.class.desiredAssertionStatus();
    }
}

