/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.EditableManifest;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.SpecificationVersion;

public final class CreatedModifiedFilesFactory {
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$project$CreatedModifiedFilesFactory;

    static CreatedModifiedFiles.Operation addLoaderSection(NbModuleProject project, String dataLoaderClass, String installBefore) {
        return new AddLoaderSection(project, dataLoaderClass, installBefore);
    }

    static CreatedModifiedFiles.Operation addLookupRegistration(NbModuleProject project, String interfaceClass, String implClass) {
        return new AddLookupRegistration(project, interfaceClass, implClass);
    }

    static CreatedModifiedFiles.Operation addModuleDependency(NbModuleProject project, String codeNameBase, String releaseVersion, SpecificationVersion version, boolean useInCompiler) {
        return new AddModuleDependency(project, codeNameBase, releaseVersion, version, useInCompiler);
    }

    static CreatedModifiedFiles.Operation bundleKey(NbModuleProject project, String key, String value, String bundlePath) {
        return new BundleKey(project, key, value, bundlePath);
    }

    static CreatedModifiedFiles.Operation bundleKeyDefaultBundle(NbModuleProject project, String key, String value) {
        return new BundleKey(project, key, value);
    }

    static CreatedModifiedFiles.Operation createFile(NbModuleProject project, String path, URL content) {
        return new CreateFile(project, path, content);
    }

    static CreatedModifiedFiles.Operation createFileWithSubstitutions(NbModuleProject project, String path, URL content, Map tokens) {
        return new CreateFile(project, path, content, tokens);
    }

    static CreatedModifiedFiles.Operation layerModifications(NbModuleProject project, CreatedModifiedFiles.LayerOperation op, Set externalFiles, CreatedModifiedFiles cmf) {
        return new LayerModifications(project, op, externalFiles, cmf);
    }

    static CreatedModifiedFiles.Operation createLayerEntry(CreatedModifiedFiles cmf, NbModuleProject project, String layerPath, URL content, Map substitutionTokens, String localizedDisplayName, Map attrs) {
        return new CreateLayerEntry(cmf, project, layerPath, content, substitutionTokens, localizedDisplayName, attrs);
    }

    static CreatedModifiedFiles.Operation manifestModification(NbModuleProject project, String section, Map attributes) {
        ModifyManifest retval = new ModifyManifest(project);
        Iterator it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            retval.setAttribute(name, value, section);
        }
        return retval;
    }

    static CreatedModifiedFiles.Operation propertiesModification(NbModuleProject project, String propertyPath, Map properties) {
        ModifyProperties retval = new ModifyProperties(project, propertyPath);
        Iterator it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            retval.setProperty(name, value);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyByteAfterByte(URL content, FileLock lock, FileObject targetFO) throws IOException {
        OutputStream os = targetFO.getOutputStream(lock);
        InputStream is = content.openStream();
        try {
            FileUtil.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            is.close();
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyAndSubstituteTokens(URL content, FileLock lock, FileObject targetFO, Map tokens) throws IOException {
        boolean useUTF8 = targetFO.hasExt("xml");
        OutputStream os = targetFO.getOutputStream(lock);
        try {
            PrintWriter pw = useUTF8 ? new PrintWriter(new OutputStreamWriter(os, "UTF-8")) : new PrintWriter(os);
            try {
                InputStream is = content.openStream();
                try {
                    String line;
                    InputStreamReader r = useUTF8 ? new InputStreamReader(is, "UTF-8") : new InputStreamReader(is);
                    BufferedReader br = new BufferedReader(r);
                    while ((line = br.readLine()) != null) {
                        pw.println(tokens == null ? line : CreatedModifiedFilesFactory.replaceTokens(tokens, line));
                    }
                }
                finally {
                    is.close();
                }
            }
            finally {
                pw.close();
            }
        }
        finally {
            os.close();
        }
    }

    private static String replaceTokens(Map tokens, String line) {
        Iterator it = tokens.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            line = line.replaceAll((String)entry.getKey(), (String)entry.getValue());
        }
        return line;
    }

    private static class ModifyProperties
    extends OperationBase {
        private Map properties;
        private final String propertyPath;
        private EditableProperties ep;
        private FileObject propertiesFile;

        private ModifyProperties(NbModuleProject project, String propertyPath) {
            super(project);
            this.propertyPath = propertyPath;
            this.addCreatedOrModifiedPath(propertyPath, true);
        }

        public void run() throws IOException {
            EditableProperties ep = this.getEditableProperties();
            ep.putAll(this.getProperties());
            Util.storeProperties(this.getPropertyFile(), ep);
        }

        public final void setProperty(String name, String value) {
            this.getProperties().put(name, value);
        }

        protected final FileObject getPropertyFile() throws IOException {
            if (this.propertiesFile == null) {
                FileObject projectDirectory = this.getProject().getProjectDirectory();
                this.propertiesFile = FileUtil.createData((FileObject)projectDirectory, (String)this.propertyPath);
            }
            return this.propertiesFile;
        }

        protected final EditableProperties getEditableProperties() throws IOException {
            if (this.ep == null) {
                this.ep = Util.loadProperties(this.getPropertyFile());
            }
            return this.ep;
        }

        protected final Map getProperties() {
            if (this.properties == null) {
                this.properties = new HashMap();
            }
            return this.properties;
        }
    }

    public static class ModifyManifest
    extends OperationBase {
        private FileObject manifestFile;
        private Map attributesToAdd = new HashMap();
        static final /* synthetic */ boolean $assertionsDisabled;

        public ModifyManifest(NbModuleProject project) {
            super(project);
            this.addModifiedFileObject(this.getManifestFile());
        }

        public final void setAttribute(String name, String value) {
            this.setAttribute(name, value, "null");
        }

        public final void setAttribute(String name, String value, String section) {
            HashMap<String, String> attribs = this.getAttributes(section);
            if (attribs == null) {
                attribs = new HashMap<String, String>();
                this.attributesToAdd.put(section, attribs);
            }
            attribs.put(name, value);
        }

        protected void performModification(EditableManifest em, String name, String value, String section) {
            if (section != null && em.getSectionNames().contains(section)) {
                em.addSection(section);
            }
            em.setAttribute(name, value, section);
        }

        public final void run() throws IOException {
            this.ensureSavingFirst();
            EditableManifest em = Util.loadManifest(this.getManifestFile());
            Iterator sectionsIterator = this.attributesToAdd.keySet().iterator();
            while (sectionsIterator.hasNext()) {
                String section = (String)sectionsIterator.next();
                Map attributes = this.getAttributes(section);
                if (!$assertionsDisabled && attributes == null) {
                    throw new AssertionError();
                }
                Iterator attrsIterator = attributes.entrySet().iterator();
                while (attrsIterator.hasNext()) {
                    Map.Entry entry = attrsIterator.next();
                    String name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    this.performModification(em, name, value, "null".equals(section) ? null : section);
                }
            }
            Util.storeManifest(this.getManifestFile(), em);
        }

        private FileObject getManifestFile() {
            if (this.manifestFile == null) {
                this.manifestFile = this.getProject().getManifestFile();
            }
            return this.manifestFile;
        }

        private Map getAttributes(String sectionName) {
            Map attribs = (Map)this.attributesToAdd.get(sectionName);
            return attribs;
        }

        private void ensureSavingFirst() throws IOException {
            try {
                DataObject dobj = DataObject.find((FileObject)this.getManifestFile());
                SaveCookie safe = (SaveCookie)dobj.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = CreatedModifiedFilesFactory.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
                if (safe != null) {
                    safe.save();
                }
            }
            catch (DataObjectNotFoundException ex) {
                ex.printStackTrace();
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$CreatedModifiedFilesFactory == null ? (class$org$netbeans$modules$apisupport$project$CreatedModifiedFilesFactory = CreatedModifiedFilesFactory.class$("org.netbeans.modules.apisupport.project.CreatedModifiedFilesFactory")) : class$org$netbeans$modules$apisupport$project$CreatedModifiedFilesFactory).desiredAssertionStatus();
        }
    }

    private static final class LayerModifications
    implements CreatedModifiedFiles.Operation {
        private final NbModuleProject project;
        private final CreatedModifiedFiles.LayerOperation op;
        private final Set externalFiles;
        private final CreatedModifiedFiles cmf;

        public LayerModifications(NbModuleProject project, CreatedModifiedFiles.LayerOperation op, Set externalFiles, CreatedModifiedFiles cmf) {
            this.project = project;
            this.op = op;
            this.externalFiles = externalFiles;
            this.cmf = cmf;
        }

        public void run() throws IOException {
            this.op.run(this.cmf.getLayerHandle().layer(true));
        }

        private String layerPrefix() {
            FileObject layer = this.cmf.getLayerHandle().getLayerFile();
            if (layer == null) {
                return null;
            }
            return FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)layer);
        }

        public String[] getModifiedPaths() {
            String layerPath = this.layerPrefix();
            if (layerPath == null) {
                return new String[0];
            }
            return new String[]{layerPath};
        }

        public String[] getCreatedPaths() {
            String layerPath = this.layerPrefix();
            if (layerPath == null) {
                return new String[0];
            }
            int slash = layerPath.lastIndexOf(47);
            String prefix = layerPath.substring(0, slash + 1);
            TreeSet<String> s = new TreeSet<String>();
            Iterator it = this.externalFiles.iterator();
            while (it.hasNext()) {
                s.add(prefix + (String)it.next());
            }
            return s.toArray(new String[s.size()]);
        }

        public String[] getInvalidPaths() {
            return new String[0];
        }
    }

    private static final class CreateLayerEntry
    extends OperationBase {
        private CreatedModifiedFiles.Operation createBundleKey;
        private CreatedModifiedFiles.Operation layerOp;

        public CreateLayerEntry(CreatedModifiedFiles cmf, NbModuleProject project, final String layerPath, final URL content, final Map tokens, final String localizedDisplayName, final Map attrs) {
            super(project);
            Set<String> externalFiles;
            CreatedModifiedFiles.LayerOperation op = new CreatedModifiedFiles.LayerOperation(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(FileSystem layer) throws IOException {
                    FileObject targetFO = FileUtil.createData((FileObject)layer.getRoot(), (String)layerPath);
                    if (content != null) {
                        FileLock lock = targetFO.lock();
                        try {
                            if (tokens == null) {
                                CreatedModifiedFilesFactory.copyByteAfterByte(content, lock, targetFO);
                            } else {
                                CreatedModifiedFilesFactory.copyAndSubstituteTokens(content, lock, targetFO, tokens);
                            }
                        }
                        finally {
                            lock.releaseLock();
                        }
                    }
                    if (localizedDisplayName != null) {
                        String bundlePath = ManifestManager.getInstance(CreateLayerEntry.this.getProject().getManifest(), false).getLocalizingBundle();
                        String suffix = ".properties";
                        if (bundlePath != null && bundlePath.endsWith(suffix)) {
                            String name = bundlePath.substring(0, bundlePath.length() - suffix.length()).replace('/', '.');
                            targetFO.setAttribute("SystemFileSystem.localizingBundle", (Object)name);
                        }
                    }
                    if (attrs != null) {
                        Iterator it = attrs.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            targetFO.setAttribute((String)entry.getKey(), entry.getValue());
                        }
                    }
                }
            };
            if (content != null) {
                FileObject xml = LayerUtils.layerForProject(project).getLayerFile();
                FileObject parent = xml != null ? xml.getParent() : null;
                externalFiles = Collections.singleton(LayerUtils.findGeneratedName(parent, layerPath));
            } else {
                externalFiles = Collections.EMPTY_SET;
            }
            this.layerOp = new LayerModifications(project, op, externalFiles, cmf);
            this.addPaths(this.layerOp);
            if (localizedDisplayName != null) {
                this.createBundleKey = new BundleKey(this.getProject(), layerPath, localizedDisplayName);
                this.addPaths(this.createBundleKey);
            }
        }

        public void run() throws IOException {
            this.layerOp.run();
            if (this.createBundleKey != null) {
                this.createBundleKey.run();
            }
        }
    }

    private static final class AddLookupRegistration
    extends OperationBase {
        private String interfaceClassPath;
        private String implClass;

        public AddLookupRegistration(NbModuleProject project, String interfaceClass, String implClass) {
            super(project);
            this.implClass = implClass;
            this.interfaceClassPath = this.getProject().getSourceDirectoryPath() + "/META-INF/services/" + interfaceClass;
            this.addCreatedOrModifiedPath(this.interfaceClassPath, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            FileObject service = FileUtil.createData((FileObject)this.getProject().getProjectDirectory(), (String)this.interfaceClassPath);
            String line = null;
            ArrayList<String> lines = new ArrayList<String>();
            InputStream serviceIS = service.getInputStream();
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(serviceIS, "UTF-8"));
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
            }
            finally {
                serviceIS.close();
            }
            FileLock lock = service.lock();
            try {
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(service.getOutputStream(lock), "UTF-8"));
                try {
                    for (int i = 0; i < lines.size(); ++i) {
                        line = (String)lines.get(i);
                        if (i == lines.size() - 1 && line.trim().equals("")) continue;
                        pw.println(line);
                    }
                    pw.println(this.implClass);
                    pw.println();
                }
                finally {
                    pw.close();
                }
            }
            finally {
                lock.releaseLock();
            }
        }
    }

    private static final class AddModuleDependency
    extends OperationBase {
        private String codeNameBase;
        private String releaseVersion;
        private SpecificationVersion specVersion;
        private boolean useInCompiler;

        public AddModuleDependency(NbModuleProject project, String codeNameBase, String releaseVersion, SpecificationVersion specVersion, boolean useInCompiler) {
            super(project);
            this.codeNameBase = codeNameBase;
            this.releaseVersion = releaseVersion;
            this.specVersion = specVersion;
            this.useInCompiler = useInCompiler;
            this.getModifiedPathsSet().add("nbproject/project.xml");
        }

        public void run() throws IOException {
            Util.addDependency(this.getProject(), this.codeNameBase, this.releaseVersion, this.specVersion, this.useInCompiler);
            ProjectManager.getDefault().saveProject((Project)this.getProject());
        }
    }

    private static final class AddLoaderSection
    extends OperationBase {
        private FileObject mfFO;
        private String dataLoaderClass;
        private String installBefore;

        public AddLoaderSection(NbModuleProject project, String dataLoaderClass, String installBefore) {
            super(project);
            this.dataLoaderClass = dataLoaderClass + ".class";
            this.installBefore = installBefore;
            this.mfFO = this.getProject().getManifestFile();
            this.addModifiedFileObject(this.mfFO);
        }

        public void run() throws IOException {
            try {
                DataObject dobj = DataObject.find((FileObject)this.mfFO);
                SaveCookie safe = (SaveCookie)dobj.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = CreatedModifiedFilesFactory.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
                if (safe != null) {
                    safe.save();
                }
            }
            catch (DataObjectNotFoundException ex) {
                ex.printStackTrace();
            }
            EditableManifest em = Util.loadManifest(this.mfFO);
            em.addSection(this.dataLoaderClass);
            em.setAttribute("OpenIDE-Module-Class", "Loader", this.dataLoaderClass);
            if (this.installBefore != null) {
                em.setAttribute("Install-Before", this.installBefore, this.dataLoaderClass);
            }
            Util.storeManifest(this.mfFO, em);
        }
    }

    private static final class BundleKey
    extends OperationBase {
        private final String bundlePath;
        private final String key;
        private final String value;

        public BundleKey(NbModuleProject project, String key, String value) {
            this(project, key, value, null);
        }

        public BundleKey(NbModuleProject project, String key, String value, String bundlePath) {
            super(project);
            this.key = key;
            this.value = value;
            if (bundlePath == null) {
                ManifestManager mm = ManifestManager.getInstance(this.getProject().getManifest(), false);
                String srcDir = this.getProject().getSourceDirectoryPath();
                this.bundlePath = srcDir + "/" + mm.getLocalizingBundle();
            } else {
                this.bundlePath = bundlePath;
            }
            this.addCreatedOrModifiedPath(this.bundlePath, true);
        }

        public void run() throws IOException {
            FileObject prjDir = this.getProject().getProjectDirectory();
            FileObject bundleFO = FileUtil.createData((FileObject)prjDir, (String)this.bundlePath);
            EditableProperties ep = Util.loadProperties(bundleFO);
            ep.setProperty(this.key, this.value);
            Util.storeProperties(bundleFO, ep);
        }
    }

    private static final class CreateFile
    extends OperationBase {
        private String path;
        private URL content;
        private Map tokens;

        public CreateFile(NbModuleProject project, String path, URL content) {
            this(project, path, content, null);
        }

        public CreateFile(NbModuleProject project, String path, URL content, Map tokens) {
            super(project);
            this.path = path;
            this.content = content;
            this.tokens = tokens;
            this.addCreatedOrModifiedPath(path, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            FileObject targetFO = FileUtil.createData((FileObject)this.getProject().getProjectDirectory(), (String)this.path);
            FileLock lock = targetFO.lock();
            try {
                if (this.tokens == null) {
                    CreatedModifiedFilesFactory.copyByteAfterByte(this.content, lock, targetFO);
                } else {
                    CreatedModifiedFilesFactory.copyAndSubstituteTokens(this.content, lock, targetFO, this.tokens);
                }
            }
            finally {
                lock.releaseLock();
            }
        }
    }

    public static abstract class OperationBase
    implements CreatedModifiedFiles.Operation {
        private NbModuleProject project;
        private SortedSet createdPaths;
        private SortedSet modifiedPaths;
        private SortedSet invalidPaths;

        protected OperationBase(NbModuleProject project) {
            this.project = project;
        }

        protected NbModuleProject getProject() {
            return this.project;
        }

        public String[] getModifiedPaths() {
            String[] s = new String[this.getModifiedPathsSet().size()];
            return this.getModifiedPathsSet().toArray(s);
        }

        public String[] getCreatedPaths() {
            String[] s = new String[this.getCreatedPathsSet().size()];
            return this.getCreatedPathsSet().toArray(s);
        }

        public String[] getInvalidPaths() {
            String[] s = new String[this.getInvalidPathsSet().size()];
            return this.getInvalidPathsSet().toArray(s);
        }

        protected void addCreatedOrModifiedPath(String relPath, boolean allowFileModification) {
            if (this.getProject().getProjectDirectory().getFileObject(relPath) == null) {
                this.getCreatedPathsSet().add(relPath);
            } else if (allowFileModification) {
                this.getModifiedPathsSet().add(relPath);
            } else {
                this.getInvalidPathsSet().add(relPath);
            }
        }

        protected void addPaths(CreatedModifiedFiles.Operation o) {
            this.getCreatedPathsSet().addAll(Arrays.asList(o.getCreatedPaths()));
            this.getModifiedPathsSet().addAll(Arrays.asList(o.getModifiedPaths()));
            this.getInvalidPathsSet().addAll(Arrays.asList(o.getInvalidPaths()));
        }

        protected SortedSet getCreatedPathsSet() {
            if (this.createdPaths == null) {
                this.createdPaths = new TreeSet();
            }
            return this.createdPaths;
        }

        protected SortedSet getInvalidPathsSet() {
            if (this.invalidPaths == null) {
                this.invalidPaths = new TreeSet();
            }
            return this.invalidPaths;
        }

        protected SortedSet getModifiedPathsSet() {
            if (this.modifiedPaths == null) {
                this.modifiedPaths = new TreeSet();
            }
            return this.modifiedPaths;
        }

        protected boolean addCreatedFileObject(FileObject fo) {
            return this.getCreatedPathsSet().add(this.getProjectPath(fo));
        }

        protected boolean addModifiedFileObject(FileObject fo) {
            return this.getModifiedPathsSet().add(this.getProjectPath(fo));
        }

        private String getProjectPath(FileObject file) {
            return PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)this.getProject().getProjectDirectory()), (File)FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)file)));
        }
    }
}

