/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.web.FormLoginConfig;
import org.netbeans.modules.j2ee.dd.api.web.LoginConfig;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.BrowseFolders;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.DDUtils;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.filesystems.FileObject;

public class LoginConfigPanel
extends SectionInnerPanel {
    private static String NONE = "NONE";
    private static String BASIC = "BASIC";
    private static String DIGEST = "DIGEST";
    private static String FORM = "FORM";
    private static String CLIENT_CERT = "CLIENT-CERT";
    private WebApp webApp;
    private LoginConfig loginConfig;
    private SectionView view;
    private DDDataObject dObj;
    private JRadioButton basicRB;
    private ButtonGroup buttonGroup1;
    private JRadioButton clientCertRB;
    private JRadioButton digestRB;
    private JButton errorPageBrowseButton;
    private JLabel errorPageLabel;
    private JTextField errorPageTF;
    private JRadioButton formRB;
    private JButton loginPageBrowseButton;
    private JLabel loginPageLabel;
    private JTextField loginPageTF;
    private JRadioButton noneRB;
    private JLabel realmNameLabel;
    private JTextField realmNameTF;

    public LoginConfigPanel(SectionView view, DDDataObject dObj) {
        super(view);
        this.initComponents();
        this.view = view;
        this.dObj = dObj;
        this.webApp = dObj.getWebApp();
        this.loginConfig = this.webApp.getSingleLoginConfig();
        this.initPanel();
    }

    private void initPanel() {
        if (this.loginConfig == null) {
            this.updateVisualState(NONE);
        } else {
            String authMethod = this.loginConfig.getAuthMethod();
            this.updateVisualState(authMethod);
            if (authMethod.equals(BASIC)) {
                this.realmNameTF.setText(this.loginConfig.getRealmName());
            } else if (authMethod.equals(FORM)) {
                FormLoginConfig formLoginConfig = this.loginConfig.getFormLoginConfig();
                this.loginPageTF.setText(formLoginConfig.getFormLoginPage());
                this.errorPageTF.setText(formLoginConfig.getFormErrorPage());
                this.realmNameTF.setText(this.loginConfig.getRealmName());
            }
        }
        this.addModifier(this.noneRB);
        this.addModifier(this.digestRB);
        this.addModifier(this.clientCertRB);
        this.addModifier(this.basicRB);
        this.addModifier(this.formRB);
        this.addValidatee(this.realmNameTF);
        this.addValidatee(this.loginPageTF);
        this.addValidatee(this.errorPageTF);
    }

    private void updateVisualState(String state) {
        if (state.equals(BASIC)) {
            this.basicRB.setSelected(true);
            this.realmNameLabel.setEnabled(true);
            this.realmNameTF.setEnabled(true);
            this.loginPageLabel.setEnabled(false);
            this.loginPageTF.setEnabled(false);
            this.loginPageBrowseButton.setEnabled(false);
            this.errorPageLabel.setEnabled(false);
            this.errorPageTF.setEnabled(false);
            this.errorPageBrowseButton.setEnabled(false);
        } else if (state.equals(FORM)) {
            this.formRB.setSelected(true);
            this.realmNameLabel.setEnabled(true);
            this.realmNameTF.setEnabled(true);
            this.loginPageLabel.setEnabled(true);
            this.loginPageTF.setEnabled(true);
            this.loginPageBrowseButton.setEnabled(true);
            this.errorPageLabel.setEnabled(true);
            this.errorPageTF.setEnabled(true);
            this.errorPageBrowseButton.setEnabled(true);
        } else {
            if (state.equals(NONE)) {
                this.noneRB.setSelected(true);
            } else if (state.equals(DIGEST)) {
                this.digestRB.setSelected(true);
            } else if (state.equals(CLIENT_CERT)) {
                this.clientCertRB.setSelected(true);
            }
            this.realmNameLabel.setEnabled(false);
            this.realmNameTF.setEnabled(false);
            this.loginPageLabel.setEnabled(false);
            this.loginPageTF.setEnabled(false);
            this.loginPageBrowseButton.setEnabled(false);
            this.errorPageLabel.setEnabled(false);
            this.errorPageTF.setEnabled(false);
            this.errorPageBrowseButton.setEnabled(false);
        }
    }

    public void linkButtonPressed(Object obj, String id) {
    }

    public JComponent getErrorComponent(String name) {
        return null;
    }

    public void documentChanged(JTextComponent comp, String value) {
    }

    private void setLoginConfig(LoginConfig config) {
        this.webApp.setLoginConfig(config);
        this.loginConfig = config;
    }

    private LoginConfig getLoginConfig() {
        if (this.loginConfig == null) {
            try {
                this.loginConfig = (LoginConfig)this.webApp.createBean("LoginConfig");
                this.webApp.setLoginConfig(this.loginConfig);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.loginConfig;
    }

    private FormLoginConfig getFormLoginConfig() {
        LoginConfig loginConfig = this.getLoginConfig();
        FormLoginConfig formLoginConfig = loginConfig.getFormLoginConfig();
        if (formLoginConfig == null) {
            try {
                formLoginConfig = (FormLoginConfig)this.webApp.createBean("FormLoginConfig");
                loginConfig.setFormLoginConfig(formLoginConfig);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return formLoginConfig;
    }

    public void setValue(JComponent source, Object value) {
        if (source instanceof JRadioButton) {
            String authMethod = null;
            if (source == this.noneRB) {
                authMethod = NONE;
            } else if (source == this.digestRB) {
                authMethod = DIGEST;
            } else if (source == this.clientCertRB) {
                authMethod = CLIENT_CERT;
            } else if (source == this.basicRB) {
                authMethod = BASIC;
            } else if (source == this.formRB) {
                authMethod = FORM;
            }
            this.setLoginConfig(null);
            if (!authMethod.equals(NONE)) {
                LoginConfig loginConfig = this.getLoginConfig();
                loginConfig.setAuthMethod(authMethod);
                if (authMethod.equals(BASIC)) {
                    loginConfig.setRealmName(this.realmNameTF.getText());
                } else if (authMethod.equals(FORM)) {
                    loginConfig.setRealmName(this.realmNameTF.getText());
                    FormLoginConfig formLoginConfig = this.getFormLoginConfig();
                    formLoginConfig.setFormLoginPage(this.loginPageTF.getText());
                    formLoginConfig.setFormErrorPage(this.errorPageTF.getText());
                }
            }
            this.updateVisualState(authMethod);
        } else if (source == this.realmNameTF) {
            this.getLoginConfig().setRealmName((String)value);
        } else if (source == this.loginPageTF) {
            this.getFormLoginConfig().setFormLoginPage((String)value);
        } else if (source == this.errorPageTF) {
            this.getFormLoginConfig().setFormErrorPage((String)value);
        }
    }

    public void rollbackValue(JTextComponent source) {
    }

    protected void startUIChange() {
        this.dObj.setChangedFromUI(true);
    }

    protected void endUIChange() {
        this.dObj.modelUpdatedFromUI();
        this.dObj.setChangedFromUI(false);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.realmNameLabel = new JLabel();
        this.loginPageLabel = new JLabel();
        this.errorPageLabel = new JLabel();
        this.realmNameTF = new JTextField();
        this.loginPageTF = new JTextField();
        this.errorPageTF = new JTextField();
        this.loginPageBrowseButton = new JButton();
        this.errorPageBrowseButton = new JButton();
        this.noneRB = new JRadioButton();
        this.digestRB = new JRadioButton();
        this.clientCertRB = new JRadioButton();
        this.basicRB = new JRadioButton();
        this.formRB = new JRadioButton();
        this.realmNameLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_realmName_mnem").charAt(0));
        this.realmNameLabel.setLabelFor(this.realmNameTF);
        this.realmNameLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_RealmName"));
        this.realmNameLabel.setEnabled(false);
        this.loginPageLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_loginPage_mnem").charAt(0));
        this.loginPageLabel.setLabelFor(this.loginPageTF);
        this.loginPageLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_FormLoginPage"));
        this.loginPageLabel.setEnabled(false);
        this.errorPageLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_errorPage_mnem").charAt(0));
        this.errorPageLabel.setLabelFor(this.loginPageTF);
        this.errorPageLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_FormErrorPage"));
        this.errorPageLabel.setEnabled(false);
        this.realmNameTF.setEnabled(false);
        this.loginPageTF.setEnabled(false);
        this.errorPageTF.setEnabled(false);
        this.loginPageBrowseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_browse_mnem3").charAt(0));
        this.loginPageBrowseButton.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_browse"));
        this.loginPageBrowseButton.setEnabled(false);
        this.loginPageBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoginConfigPanel.this.loginPageBrowseButtonActionPerformed(evt);
            }
        });
        this.errorPageBrowseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_browse_mnem2").charAt(0));
        this.errorPageBrowseButton.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_browse"));
        this.errorPageBrowseButton.setEnabled(false);
        this.errorPageBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoginConfigPanel.this.errorPageBrowseButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.noneRB);
        this.noneRB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_none_mnem").charAt(0));
        this.noneRB.setSelected(true);
        this.noneRB.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_NoneAuthMethod"));
        this.noneRB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noneRB.setMargin(new Insets(0, 0, 0, 0));
        this.noneRB.setOpaque(false);
        this.noneRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoginConfigPanel.this.noneRBActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.digestRB);
        this.digestRB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_digest_mnem").charAt(0));
        this.digestRB.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_DigestAuthMethod"));
        this.digestRB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.digestRB.setMargin(new Insets(0, 0, 0, 0));
        this.digestRB.setOpaque(false);
        this.digestRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoginConfigPanel.this.digestRBActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.clientCertRB);
        this.clientCertRB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_clientCert_mnem").charAt(0));
        this.clientCertRB.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_ClientCertAuthMethod"));
        this.clientCertRB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.clientCertRB.setMargin(new Insets(0, 0, 0, 0));
        this.clientCertRB.setOpaque(false);
        this.clientCertRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoginConfigPanel.this.clientCertRBActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.basicRB);
        this.basicRB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_basic_mnem").charAt(0));
        this.basicRB.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_BasicAuthMethod"));
        this.basicRB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.basicRB.setMargin(new Insets(0, 0, 0, 0));
        this.basicRB.setOpaque(false);
        this.basicRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoginConfigPanel.this.basicRBActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.formRB);
        this.formRB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_form_mnem").charAt(0));
        this.formRB.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle").getString("LBL_FormAuthMethod"));
        this.formRB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.formRB.setMargin(new Insets(0, 0, 0, 0));
        this.formRB.setOpaque(false);
        this.formRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoginConfigPanel.this.formRBActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.noneRB).add((Component)this.digestRB).add((Component)this.clientCertRB).add((Component)this.basicRB).add((GroupLayout.Group)layout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.realmNameLabel).add((Component)this.loginPageLabel).add((Component)this.errorPageLabel)).add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.errorPageTF, -1, 193, Short.MAX_VALUE).add(1, (Component)this.realmNameTF, -1, 193, Short.MAX_VALUE).add(1, (Component)this.loginPageTF, -1, 193, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.errorPageBrowseButton).add((Component)this.loginPageBrowseButton))).add((Component)this.formRB)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.noneRB).addPreferredGap(0).add((Component)this.digestRB).addPreferredGap(0).add((Component)this.clientCertRB).addPreferredGap(0).add((Component)this.basicRB).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.realmNameLabel).add((Component)this.realmNameTF, -2, -1, -2)).addPreferredGap(0).add((Component)this.formRB).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.loginPageBrowseButton).add((Component)this.loginPageLabel).add((Component)this.loginPageTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.errorPageBrowseButton).add((Component)this.errorPageLabel).add((Component)this.errorPageTF, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void formRBActionPerformed(ActionEvent evt) {
        this.updateVisualState(FORM);
    }

    private void basicRBActionPerformed(ActionEvent evt) {
        this.updateVisualState(BASIC);
    }

    private void clientCertRBActionPerformed(ActionEvent evt) {
        this.updateVisualState(CLIENT_CERT);
    }

    private void digestRBActionPerformed(ActionEvent evt) {
        this.updateVisualState(DIGEST);
    }

    private void noneRBActionPerformed(ActionEvent evt) {
        this.updateVisualState(NONE);
    }

    private void errorPageBrowseButtonActionPerformed(ActionEvent evt) {
        try {
            String res;
            SourceGroup[] groups = DDUtils.getDocBaseGroups(this.dObj);
            FileObject fo = BrowseFolders.showDialog(groups);
            if (fo != null && !(res = "/" + DDUtils.getResourcePath(groups, fo, '/', true)).equals(this.errorPageTF.getText())) {
                this.dObj.modelUpdatedFromUI();
                this.errorPageTF.setText(res);
                this.dObj.setChangedFromUI(true);
                this.getFormLoginConfig().setFormErrorPage(res);
                this.dObj.setChangedFromUI(false);
                this.getSectionView().checkValidity();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loginPageBrowseButtonActionPerformed(ActionEvent evt) {
        try {
            String res;
            SourceGroup[] groups = DDUtils.getDocBaseGroups(this.dObj);
            FileObject fo = BrowseFolders.showDialog(groups);
            if (fo != null && !(res = "/" + DDUtils.getResourcePath(groups, fo, '/', true)).equals(this.loginPageTF.getText())) {
                this.dObj.modelUpdatedFromUI();
                this.loginPageTF.setText(res);
                this.dObj.setChangedFromUI(true);
                this.getFormLoginConfig().setFormLoginPage(res);
                this.dObj.setChangedFromUI(false);
                this.getSectionView().checkValidity();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

