/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign.support;

import java.awt.Dimension;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.support.SwingLayoutUtils;

public class SwingLayoutCodeGenerator {
    private static final String LAYOUT_VAR_NAME = "layout";
    private LayoutModel layoutModel;
    private String layoutVarName;
    private boolean useLayoutLibrary;
    private Map componentIDMap = new HashMap();

    public SwingLayoutCodeGenerator(LayoutModel layoutModel) {
        this.layoutModel = layoutModel;
    }

    public void generateContainerLayout(Writer writer, LayoutComponent container, String contExprStr, String contVarName, ComponentInfo[] infos, boolean useLibrary) throws IOException {
        this.useLayoutLibrary = useLibrary;
        this.layoutVarName = contVarName == null ? LAYOUT_VAR_NAME : contVarName + Character.toUpperCase(LAYOUT_VAR_NAME.charAt(0)) + LAYOUT_VAR_NAME.substring(1);
        this.fillMap(infos);
        this.generateInstantiation(writer, contExprStr);
        StringBuffer sb = new StringBuffer();
        LayoutInterval horizontalInterval = container.getLayoutRoot(0);
        this.composeGroup(sb, horizontalInterval, true, true);
        String horizontalGroup = sb.toString();
        writer.write(this.layoutVarName + ".setHorizontalGroup(\n" + horizontalGroup + "\n);\n");
        sb = new StringBuffer();
        this.composeLinks(sb, container, this.layoutVarName, 0);
        String horizontalLinks = sb.toString();
        writer.write(horizontalLinks);
        sb = new StringBuffer();
        LayoutInterval verticalInterval = container.getLayoutRoot(1);
        this.composeGroup(sb, verticalInterval, true, true);
        String verticalGroup = sb.toString();
        writer.write(this.layoutVarName + ".setVerticalGroup(\n" + verticalGroup + "\n);\n");
        sb = new StringBuffer();
        this.composeLinks(sb, container, this.layoutVarName, 1);
        String verticalLinks = sb.toString();
        writer.write(verticalLinks);
    }

    private void fillMap(ComponentInfo[] infos) {
        for (int counter = 0; counter < infos.length; ++counter) {
            this.componentIDMap.put(infos[counter].id, infos[counter]);
        }
    }

    private void generateInstantiation(Writer writer, String contExprStr) throws IOException {
        writer.write(this.getLayoutName() + " " + this.layoutVarName + " ");
        writer.write("= new " + this.getLayoutName() + "(" + contExprStr + ");\n");
        writer.write(contExprStr + ".setLayout(" + this.layoutVarName + ");\n");
    }

    private void composeGroup(StringBuffer layout, LayoutInterval interval, boolean first, boolean last) throws IOException {
        if (interval.isGroup()) {
            int groupAlignment = interval.getGroupAlignment();
            if (interval.isParallel()) {
                boolean notResizable = interval.getMaximumSize(false) == -2;
                String alignmentStr = this.convertAlignment(groupAlignment);
                layout.append(this.layoutVarName).append(".createParallelGroup(");
                layout.append(alignmentStr);
                if (notResizable) {
                    layout.append(", false");
                }
                layout.append(")");
            } else if (interval.isSequential()) {
                layout.append(this.layoutVarName).append(".createSequentialGroup()");
            } else assert (false);
            if (interval.getSubIntervalCount() > 0) {
                layout.append("\n");
            }
            Iterator subIntervals = interval.getSubIntervals();
            while (subIntervals.hasNext()) {
                LayoutInterval subInterval = (LayoutInterval)subIntervals.next();
                this.fillGroup(layout, subInterval, first, last && (!interval.isSequential() || !subIntervals.hasNext()), groupAlignment);
                if (first && interval.isSequential()) {
                    first = false;
                }
                if (!subIntervals.hasNext()) continue;
                layout.append("\n");
            }
        } else {
            layout.append(this.layoutVarName).append(".createSequentialGroup()\n");
            this.fillGroup(layout, interval, true, true, -1);
        }
    }

    private void fillGroup(StringBuffer layout, LayoutInterval interval, boolean first, boolean last, int groupAlignment) throws IOException {
        if (interval.isGroup()) {
            layout.append(this.getAddGroupStr());
            int alignment = interval.getAlignment();
            if (alignment != -1 && interval.getParent().isParallel() && alignment != groupAlignment && alignment != 3 && groupAlignment != 3) {
                String alignmentStr = this.convertAlignment(alignment);
                layout.append(alignmentStr).append(", ");
            }
            this.composeGroup(layout, interval, first, last);
        } else {
            int min = interval.getMinimumSize(false);
            int pref = interval.getPreferredSize(false);
            int max = interval.getMaximumSize(false);
            if (interval.isComponent()) {
                layout.append(this.getAddComponentStr());
                int alignment = interval.getAlignment();
                LayoutComponent layoutComp = interval.getComponent();
                ComponentInfo info = (ComponentInfo)this.componentIDMap.get(layoutComp.getId());
                if (min == -1) {
                    boolean dimension;
                    boolean bl = dimension = layoutComp.getLayoutInterval(0) != interval;
                    if (!dimension && info.clazz.getName().equals("javax.swing.JComboBox")) {
                        min = 0;
                    } else if (pref >= 0) {
                        int compMin;
                        int n = compMin = !dimension ? info.minSize.width : info.minSize.height;
                        if (compMin > pref) {
                            min = -2;
                        }
                    }
                }
                assert (info.variableName != null);
                if (interval.getParent().isSequential() || alignment == -1 || alignment == groupAlignment || alignment == 3 || groupAlignment == 3) {
                    layout.append(info.variableName);
                } else {
                    String alignmentStr = this.convertAlignment(alignment);
                    if (this.useLayoutLibrary()) {
                        layout.append(alignmentStr).append(", ").append(info.variableName);
                    } else {
                        layout.append(info.variableName).append(", ").append(alignmentStr);
                    }
                }
                int status = SwingLayoutUtils.getResizableStatus(info.clazz);
                if (pref != -1 || min != -1 && (min != -2 || info.sizingChanged || status != 0) || max != -1 && (max != -2 || info.sizingChanged || status != 0) && (max != Short.MAX_VALUE || info.sizingChanged || status != 1)) {
                    layout.append(", ");
                    this.generateSizeParams(layout, min, pref, max);
                }
            } else if (interval.isEmptySpace()) {
                if (interval.isDefaultPadding(false)) {
                    if (first || last) {
                        layout.append(this.getAddContainerGapStr());
                    } else {
                        layout.append(this.getAddPreferredGapStr());
                        layout.append(this.getLayoutStyleName());
                        if (!this.useLayoutLibrary()) {
                            layout.append(".ComponentPlacement");
                        }
                        layout.append(".RELATED");
                    }
                    if (pref != -1 || max != -1 && max != -2) {
                        if (!first && !last) {
                            layout.append(',').append(' ');
                        }
                        layout.append(this.convertSize(pref)).append(", ");
                        layout.append(this.convertSize(max));
                    }
                } else {
                    if (min == -2) {
                        min = pref;
                    }
                    if (max == -2) {
                        max = pref;
                    }
                    layout.append(this.getAddGapStr());
                    if (min < 0) {
                        min = pref;
                    }
                    min = Math.min(pref, min);
                    max = Math.max(pref, max);
                    this.generateSizeParams(layout, min, pref, max);
                }
            } else assert (false);
        }
        layout.append(")");
    }

    private void generateSizeParams(StringBuffer layout, int min, int pref, int max) {
        layout.append(this.convertSize(min)).append(", ");
        layout.append(this.convertSize(pref)).append(", ");
        layout.append(this.convertSize(max));
    }

    private String convertAlignment(int alignment) {
        String groupAlignment = null;
        switch (alignment) {
            case 0: {
                groupAlignment = "LEADING";
                break;
            }
            case 1: {
                groupAlignment = "TRAILING";
                break;
            }
            case 2: {
                groupAlignment = "CENTER";
                break;
            }
            case 3: {
                groupAlignment = "BASELINE";
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return this.useLayoutLibrary() ? this.getLayoutName() + "." + groupAlignment : this.getLayoutName() + ".Alignment." + groupAlignment;
    }

    private String convertSize(int size) {
        String convertedSize;
        switch (size) {
            case -1: {
                convertedSize = this.getLayoutName() + ".DEFAULT_SIZE";
                break;
            }
            case -2: {
                convertedSize = this.getLayoutName() + ".PREFERRED_SIZE";
                break;
            }
            case 32767: {
                convertedSize = "Short.MAX_VALUE";
                break;
            }
            default: {
                assert (size >= 0);
                convertedSize = Integer.toString(size);
            }
        }
        return convertedSize;
    }

    private void composeLinks(StringBuffer layout, LayoutComponent containerLC, String layoutVarName, int dimension) throws IOException {
        Map linkSizeGroups = SwingLayoutUtils.createLinkSizeGroups(containerLC, dimension);
        Collection linkGroups = linkSizeGroups.values();
        for (List l : linkGroups) {
            Collections.sort(l, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String id1 = (String)o1;
                    String id2 = (String)o2;
                    ComponentInfo info1 = (ComponentInfo)SwingLayoutCodeGenerator.this.componentIDMap.get(id1);
                    ComponentInfo info2 = (ComponentInfo)SwingLayoutCodeGenerator.this.componentIDMap.get(id2);
                    return info1.variableName.compareTo(info2.variableName);
                }
            });
            if (l.size() <= 1) continue;
            layout.append("\n\n" + layoutVarName + ".linkSize(");
            if (!this.useLayoutLibrary()) {
                layout.append("javax.swing.SwingConstants");
                layout.append(dimension == 0 ? ".HORIZONTAL, " : ".VERTICAL, ");
            }
            layout.append("new java.awt.Component[] {");
            Iterator i = l.iterator();
            boolean first = true;
            while (i.hasNext()) {
                String cid = (String)i.next();
                ComponentInfo info = (ComponentInfo)this.componentIDMap.get(cid);
                if (first) {
                    first = false;
                    layout.append(info.variableName);
                    continue;
                }
                layout.append(", " + info.variableName);
            }
            layout.append("}");
            if (this.useLayoutLibrary()) {
                layout.append(", ");
                layout.append(this.getLayoutName());
                layout.append(dimension == 0 ? ".HORIZONTAL" : ".VERTICAL");
            }
            layout.append(");\n\n");
        }
    }

    boolean useLayoutLibrary() {
        return this.useLayoutLibrary;
    }

    private String getLayoutName() {
        return this.useLayoutLibrary() ? "org.jdesktop.layout.GroupLayout" : "javax.swing.GroupLayout";
    }

    private String getLayoutStyleName() {
        return this.useLayoutLibrary() ? "org.jdesktop.layout.LayoutStyle" : "javax.swing.LayoutStyle";
    }

    private String getAddComponentStr() {
        return this.useLayoutLibrary() ? ".add(" : ".addComponent(";
    }

    private String getAddGapStr() {
        return this.useLayoutLibrary() ? ".add(" : ".addGap(";
    }

    private String getAddPreferredGapStr() {
        return ".addPreferredGap(";
    }

    private String getAddContainerGapStr() {
        return ".addContainerGap(";
    }

    private String getAddGroupStr() {
        return this.useLayoutLibrary() ? ".add(" : ".addGroup(";
    }

    public static class ComponentInfo {
        public String id;
        public String variableName;
        public Class clazz;
        public Dimension minSize;
        public boolean sizingChanged;
    }
}

