/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.beans.PropertyEditor;
import org.netbeans.modules.viewmodel.TreeTable;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.openide.nodes.PropertySupport;

public class Column
extends PropertySupport.ReadWrite {
    private PropertyEditor propertyEditor;
    private ColumnModel columnModel;
    private TreeTable treeTable;

    Column(ColumnModel columnModel, TreeTable treeTable) {
        Class clazz = columnModel.getType() == null ? String.class : columnModel.getType();
        super(columnModel.getID(), clazz, columnModel.getDisplayName(), columnModel.getShortDescription());
        this.columnModel = columnModel;
        this.treeTable = treeTable;
        this.setValue("ComparableColumnTTV", columnModel.isSortable());
        if (columnModel.getType() == null) {
            this.setValue("TreeColumnTTV", Boolean.TRUE);
        }
        this.propertyEditor = columnModel.getPropertyEditor();
    }

    int getColumnWidth() {
        return this.columnModel.getColumnWidth();
    }

    void setColumnWidth(int width) {
        this.columnModel.setColumnWidth(width);
    }

    int getOrderNumber() {
        Object o = this.getValue("OrderNumberTTV");
        if (o == null) {
            return -1;
        }
        return (Integer)o;
    }

    boolean isDefault() {
        return this.columnModel.getType() == null;
    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object obj) {
    }

    public Object getValue(String propertyName) {
        if ("OrderNumberTTV".equals(propertyName) && this.columnModel.getCurrentOrderNumber() != -1) {
            return new Integer(this.columnModel.getCurrentOrderNumber());
        }
        if ("InvisibleInTreeTableView".equals(propertyName)) {
            return !this.columnModel.isVisible();
        }
        if ("SortingColumnTTV".equals(propertyName)) {
            return this.columnModel.isSorted();
        }
        if ("DescendingOrderTTV".equals(propertyName)) {
            return this.columnModel.isSortedDescending();
        }
        return super.getValue(propertyName);
    }

    public void setValue(String propertyName, Object newValue) {
        if ("OrderNumberTTV".equals(propertyName)) {
            this.columnModel.setCurrentOrderNumber((Integer)newValue);
        } else if ("InvisibleInTreeTableView".equals(propertyName)) {
            this.columnModel.setVisible((Boolean)newValue == false);
            this.treeTable.updateColumnWidths();
        } else if ("SortingColumnTTV".equals(propertyName)) {
            this.columnModel.setSorted((Boolean)newValue);
        } else if ("DescendingOrderTTV".equals(propertyName)) {
            this.columnModel.setSortedDescending((Boolean)newValue);
        } else {
            super.setValue(propertyName, newValue);
        }
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }
}

