/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.java.project.PackageDisplayUtils;
import org.netbeans.spi.java.project.support.ui.PackageRenameHandler;
import org.netbeans.spi.java.project.support.ui.PackageRootNode;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.support.FileSensitiveActions;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.FileSystemAction;
import org.openide.actions.PropertiesAction;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfoFactory;

final class PackageViewChildren
extends Children.Keys
implements FileChangeListener,
ChangeListener,
Runnable {
    private static final String NODE_NOT_CREATED = "NNC";
    private static final String NODE_NOT_CREATED_EMPTY = "NNC_E";
    private static final MessageFormat PACKAGE_FLAVOR;
    static final String PRIMARY_TYPE = "application";
    static final String SUBTYPE = "x-java-org-netbeans-modules-java-project-packagenodednd";
    static final String MASK = "mask";
    private Map names2nodes;
    private final FileObject root;
    private FileChangeListener wfcl;
    private ChangeListener wvqcl;
    RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)this);
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$netbeans$spi$java$project$support$ui$PackageRenameHandler;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$org$netbeans$spi$java$project$support$ui$PackageViewChildren$PackageNode;

    public PackageViewChildren(FileObject root) {
        if (root == null) {
            throw new NullPointerException();
        }
        this.root = root;
    }

    FileObject getRoot() {
        return this.root;
    }

    protected Node[] createNodes(Object obj) {
        FileObject fo = this.root.getFileObject((String)obj);
        if (fo != null && fo.isValid()) {
            Object o = this.names2nodes.get(obj);
            PackageNode n = o == NODE_NOT_CREATED ? new PackageNode(this.root, DataFolder.findFolder((FileObject)fo), false) : (o == NODE_NOT_CREATED_EMPTY ? new PackageNode(this.root, DataFolder.findFolder((FileObject)fo), true) : new PackageNode(this.root, DataFolder.findFolder((FileObject)fo)));
            this.names2nodes.put(obj, n);
            return new Node[]{n};
        }
        return new Node[0];
    }

    protected void addNotify() {
        super.addNotify();
        this.task.schedule(0);
    }

    public Node[] getNodes(boolean optimal) {
        if (optimal) {
            Node[] garbage = super.getNodes(false);
            this.task.waitFinished();
        }
        return super.getNodes(false);
    }

    public Node findChild(String name) {
        this.getNodes(true);
        return super.findChild(name);
    }

    public void run() {
        this.computeKeys();
        this.refreshKeys();
        try {
            FileSystem fs = this.root.getFileSystem();
            this.wfcl = (FileChangeListener)WeakListeners.create((Class)FileChangeListener.class, (EventListener)this, (Object)fs);
            fs.addFileChangeListener(this.wfcl);
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        this.wvqcl = WeakListeners.change((ChangeListener)this, (Object)VisibilityQuery.getDefault());
        VisibilityQuery.getDefault().addChangeListener(this.wvqcl);
    }

    protected void removeNotify() {
        VisibilityQuery.getDefault().removeChangeListener(this.wvqcl);
        try {
            this.root.getFileSystem().removeFileChangeListener(this.wfcl);
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        this.setKeys(Collections.EMPTY_SET);
        this.names2nodes.clear();
        super.removeNotify();
    }

    private void refreshKeys() {
        this.setKeys(this.names2nodes.keySet());
    }

    private void refreshKeysAsync() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PackageViewChildren.this.refreshKeys();
            }
        });
    }

    private void computeKeys() {
        this.names2nodes = new TreeMap();
        this.findNonExcludedPackages(this.root);
    }

    private void findNonExcludedPackages(FileObject fo) {
        PackageView.findNonExcludedPackages(this, fo);
    }

    private void cleanEmptyKeys(FileObject fo) {
        FileObject parent = fo.getParent();
        if (this.root.equals(parent)) {
            PackageNode n = this.get(parent);
            if (n != null && PackageDisplayUtils.isEmpty(this.root, false)) {
                this.remove(this.root);
            }
            return;
        }
        while (FileUtil.isParentOf((FileObject)this.root, (FileObject)parent)) {
            PackageNode n = this.get(parent);
            if (n != null && n.isLeaf()) {
                this.remove(parent);
            }
            parent = parent.getParent();
        }
    }

    void add(FileObject fo, boolean empty) {
        String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo);
        if (!$assertionsDisabled && path == null) {
            throw new AssertionError((Object)("Adding wrong folder " + fo + "(valid=" + fo.isValid() + ")" + "under root" + this.root + "(valid=" + this.root.isValid() + ")"));
        }
        if (this.get(fo) == null) {
            this.names2nodes.put(path, empty ? NODE_NOT_CREATED_EMPTY : NODE_NOT_CREATED);
        }
    }

    private void remove(FileObject fo) {
        String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo);
        if (!$assertionsDisabled && path == null) {
            throw new AssertionError((Object)("Removing wrong folder" + fo));
        }
        this.names2nodes.remove(path);
    }

    private void removeSubTree(FileObject fo) {
        String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo);
        if (!$assertionsDisabled && path == null) {
            throw new AssertionError((Object)("Removing wrong folder" + fo));
        }
        HashSet keys = new HashSet(this.names2nodes.keySet());
        this.names2nodes.remove(path);
        path = path + '/';
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(path)) continue;
            this.names2nodes.remove(key);
        }
    }

    private PackageNode get(FileObject fo) {
        String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo);
        if (!$assertionsDisabled && path == null) {
            throw new AssertionError((Object)("Asking for wrong folder" + fo));
        }
        Object o = this.names2nodes.get(path);
        return !this.isNodeCreated(o) ? null : (PackageNode)((Object)o);
    }

    private boolean contains(FileObject fo) {
        String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo);
        if (!$assertionsDisabled && path == null) {
            throw new AssertionError((Object)("Asking for wrong folder" + fo));
        }
        Object o = this.names2nodes.get(path);
        return o != null;
    }

    private boolean exists(FileObject fo) {
        String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo);
        return this.names2nodes.get(path) != null;
    }

    private boolean isNodeCreated(Object o) {
        return o instanceof Node;
    }

    private PackageNode updatePath(String oldPath, String newPath) {
        Object o = this.names2nodes.get(oldPath);
        if (o == null) {
            return null;
        }
        this.names2nodes.remove(oldPath);
        this.names2nodes.put(newPath, o);
        return !this.isNodeCreated(o) ? null : (PackageNode)((Object)o);
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
    }

    public void fileFolderCreated(FileEvent fe) {
        FileObject fo = fe.getFile();
        if (FileUtil.isParentOf((FileObject)this.root, (FileObject)fo) && this.isVisible(this.root, fo)) {
            this.cleanEmptyKeys(fo);
            this.findNonExcludedPackages(fo);
            this.refreshKeys();
        }
    }

    public void fileDataCreated(FileEvent fe) {
        FileObject fo = fe.getFile();
        if (FileUtil.isParentOf((FileObject)this.root, (FileObject)fo) && this.isVisible(this.root, fo)) {
            FileObject parent = fo.getParent();
            if (!VisibilityQuery.getDefault().isVisible(parent)) {
                return;
            }
            PackageNode n = this.get(parent);
            if (n == null && !this.contains(parent)) {
                this.add(parent, false);
                this.refreshKeys();
            } else if (n != null) {
                n.updateChildren();
            }
        }
    }

    public void fileDeleted(FileEvent fe) {
        FileObject fo = fe.getFile();
        if (FileUtil.isParentOf((FileObject)this.root, (FileObject)fo) && this.isVisible(this.root, fo)) {
            if (fo.isFolder() || this.get(fo) != null) {
                this.removeSubTree(fo);
                FileObject parent = fo.getParent();
                if ((FileUtil.isParentOf((FileObject)this.root, (FileObject)parent) || this.root.equals(parent)) && this.get(parent) == null && parent.isValid() && !this.toBeRemoved(parent)) {
                    this.add(parent, true);
                }
                this.refreshKeysAsync();
            } else {
                FileObject parent = fo.getParent();
                final PackageNode n = this.get(parent);
                if (n != null) {
                    boolean leaf = n.isLeaf();
                    DataFolder df = n.getDataFolder();
                    boolean empty = PackageNode.isEmpty(df);
                    if (leaf != empty) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                n.updateChildren();
                            }
                        });
                    } else {
                        n.updateChildren();
                    }
                }
                if (this.toBeRemoved(parent)) {
                    this.remove(parent);
                    this.refreshKeysAsync();
                }
            }
        }
    }

    private boolean toBeRemoved(FileObject folder) {
        boolean ignoredOnly = true;
        boolean foldersOnly = true;
        FileObject[] kids = folder.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            if (!VisibilityQuery.getDefault().isVisible(kids[i])) continue;
            ignoredOnly = false;
            if (kids[i].isFolder()) continue;
            foldersOnly = false;
            break;
        }
        if (ignoredOnly) {
            return false;
        }
        return foldersOnly;
    }

    public void fileRenamed(FileRenameEvent fe) {
        FileObject fo = fe.getFile();
        if (FileUtil.isParentOf((FileObject)this.root, (FileObject)fo) && fo.isFolder()) {
            String rp = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo.getParent());
            String oldPath = rp + (rp.length() == 0 ? "" : "/") + fe.getName() + fe.getExt();
            boolean visible = VisibilityQuery.getDefault().isVisible(fo);
            boolean doUpdate = false;
            ArrayList<String> needsUpdate = new ArrayList<String>();
            Iterator it = this.names2nodes.keySet().iterator();
            while (it.hasNext()) {
                String p = (String)it.next();
                if (!p.startsWith(oldPath)) continue;
                if (visible) {
                    needsUpdate.add(p);
                    continue;
                }
                this.names2nodes.remove(p);
                doUpdate = true;
            }
            if (this.get(fo) == null && visible) {
                this.cleanEmptyKeys(fo);
                this.findNonExcludedPackages(fo);
                doUpdate = true;
            }
            int oldPathLen = oldPath.length();
            String newPath = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fo);
            Iterator it2 = needsUpdate.iterator();
            while (it2.hasNext()) {
                String p = (String)it2.next();
                StringBuffer np = new StringBuffer(p);
                np.replace(0, oldPathLen, newPath);
                PackageNode n = this.updatePath(p, np.toString());
                if (n == null) continue;
                n.updateDisplayName();
            }
            if (needsUpdate.size() > 1 || doUpdate) {
                this.refreshKeys();
            }
        }
    }

    private boolean isVisible(FileObject parent, FileObject file) {
        do {
            if (VisibilityQuery.getDefault().isVisible(file)) continue;
            return false;
        } while ((file = file.getParent()) != null && file != parent);
        return true;
    }

    public void stateChanged(ChangeEvent e) {
        this.computeKeys();
        this.refreshKeys();
    }

    static {
        $assertionsDisabled = !PackageViewChildren.class.desiredAssertionStatus();
        PACKAGE_FLAVOR = new MessageFormat("application/x-java-org-netbeans-modules-java-project-packagenodednd; class=org.netbeans.spi.java.project.support.ui.PackageViewChildren$PackageNode; mask={0}");
    }

    private static class NonResursiveFolderSet
    extends HashSet
    implements NonRecursiveFolder {
        private final FileObject folder;

        public NonResursiveFolderSet(FileObject folder) {
            this.folder = folder;
            this.add(folder);
        }

        public FileObject getFolder() {
            return this.folder;
        }
    }

    static class PackagePasteType
    extends PasteType {
        private int op;
        private PackageNode[] nodes;
        private FileObject srcRoot;
        static final /* synthetic */ boolean $assertionsDisabled;

        public PackagePasteType(FileObject srcRoot, PackageNode[] node, int op) {
            if (!$assertionsDisabled && op != 1 && op != 2 && op != 0) {
                throw new AssertionError((Object)"Invalid DnD operation");
            }
            this.nodes = node;
            this.op = op;
            this.srcRoot = srcRoot;
        }

        public void setOperation(int op) {
            this.op = op;
        }

        public Transferable paste() throws IOException {
            if (!$assertionsDisabled && this.op == 0) {
                throw new AssertionError();
            }
            for (int ni = 0; ni < this.nodes.length; ++ni) {
                FileObject fo = this.srcRoot;
                if (!this.nodes[ni].isDefaultPackage) {
                    String pkgName = this.nodes[ni].getName();
                    StringTokenizer tk = new StringTokenizer(pkgName, ".");
                    while (tk.hasMoreTokens()) {
                        String name = tk.nextToken();
                        FileObject tmp = fo.getFileObject(name, null);
                        if (tmp == null) {
                            tmp = fo.createFolder(name);
                        }
                        fo = tmp;
                    }
                }
                DataFolder dest = DataFolder.findFolder((FileObject)fo);
                DataObject[] children = this.nodes[ni].dataFolder.getChildren();
                boolean cantDelete = false;
                for (int i = 0; i < children.length; ++i) {
                    if (children[i].getPrimaryFile().isData() && VisibilityQuery.getDefault().isVisible(children[i].getPrimaryFile())) {
                        children[i].copy(dest);
                        if (this.op != 2) continue;
                        try {
                            children[i].delete();
                        }
                        catch (IOException ioe) {
                            cantDelete = true;
                        }
                        continue;
                    }
                    cantDelete = true;
                }
                if (this.op != 2 || cantDelete) continue;
                try {
                    FileObject tmpFo = this.nodes[ni].dataFolder.getPrimaryFile();
                    FileObject originalRoot = this.nodes[ni].root;
                    if (!($assertionsDisabled || tmpFo != null && originalRoot != null)) {
                        throw new AssertionError();
                    }
                    while (!tmpFo.equals(originalRoot) && tmpFo.getChildren().length == 0) {
                        FileObject tmpFoParent = tmpFo.getParent();
                        tmpFo.delete();
                        tmpFo = tmpFoParent;
                    }
                    continue;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            return ExTransferable.EMPTY;
        }

        public String getName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$spi$java$project$support$ui$PackageViewChildren == null ? (class$org$netbeans$spi$java$project$support$ui$PackageViewChildren = PackageViewChildren.class$("org.netbeans.spi.java.project.support.ui.PackageViewChildren")) : class$org$netbeans$spi$java$project$support$ui$PackageViewChildren), (String)"TXT_PastePackage");
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$spi$java$project$support$ui$PackageViewChildren == null ? (class$org$netbeans$spi$java$project$support$ui$PackageViewChildren = PackageViewChildren.class$("org.netbeans.spi.java.project.support.ui.PackageViewChildren")) : class$org$netbeans$spi$java$project$support$ui$PackageViewChildren).desiredAssertionStatus();
        }
    }

    static class PackageTransferable
    extends ExTransferable.Single {
        private PackageNode node;

        public PackageTransferable(PackageNode node, int operation) throws ClassNotFoundException {
            super(new DataFlavor(PACKAGE_FLAVOR.format(new Object[]{new Integer(operation)}), null, (class$org$netbeans$spi$java$project$support$ui$PackageViewChildren$PackageNode == null ? (class$org$netbeans$spi$java$project$support$ui$PackageViewChildren$PackageNode = PackageViewChildren.class$("org.netbeans.spi.java.project.support.ui.PackageViewChildren$PackageNode")) : class$org$netbeans$spi$java$project$support$ui$PackageViewChildren$PackageNode).getClassLoader()));
            this.node = node;
        }

        protected Object getData() throws IOException, UnsupportedFlavorException {
            return this.node;
        }
    }

    static final class NoFoldersDataFilter
    implements ChangeListener,
    ChangeableDataFilter {
        EventListenerList ell = new EventListenerList();

        public NoFoldersDataFilter() {
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptDataObject(DataObject obj) {
            FileObject fo = obj.getPrimaryFile();
            return VisibilityQuery.getDefault().isVisible(fo) && !(obj instanceof DataFolder);
        }

        public void stateChanged(ChangeEvent e) {
            Object[] listeners = this.ell.getListenerList();
            ChangeEvent event = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$ChangeListener == null ? PackageViewChildren.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
                if (event == null) {
                    event = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(event);
            }
        }

        public void addChangeListener(ChangeListener listener) {
            this.ell.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = PackageViewChildren.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.ell.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = PackageViewChildren.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, listener);
        }
    }

    private static final class NoFoldersContainer
    implements DataObject.Container,
    PropertyChangeListener,
    NonRecursiveFolder {
        private DataFolder folder;
        private PropertyChangeSupport prop = new PropertyChangeSupport(this);

        public NoFoldersContainer(DataFolder folder) {
            this.folder = folder;
        }

        public FileObject getFolder() {
            return this.folder.getPrimaryFile();
        }

        public DataObject[] getChildren() {
            DataObject[] arr = this.folder.getChildren();
            ArrayList<DataObject> list = new ArrayList<DataObject>(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] instanceof DataFolder) continue;
                list.add(arr[i]);
            }
            return list.size() == arr.length ? arr : list.toArray(new DataObject[0]);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.prop.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.prop.removePropertyChangeListener(l);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("children".equals(evt.getPropertyName())) {
                this.prop.firePropertyChange("children", null, null);
            }
        }
    }

    static final class PackageNode
    extends FilterNode {
        private static final DataFilter NO_FOLDERS_FILTER = new NoFoldersDataFilter();
        private final FileObject root;
        private DataFolder dataFolder;
        private boolean isDefaultPackage;
        private static Action[] actions;

        public PackageNode(FileObject root, DataFolder dataFolder) {
            this(root, dataFolder, PackageNode.isEmpty(dataFolder));
        }

        public PackageNode(FileObject root, DataFolder dataFolder, boolean empty) {
            super(dataFolder.getNodeDelegate(), empty ? FilterNode.Children.LEAF : dataFolder.createNodeChildren(NO_FOLDERS_FILTER), (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)new NoFoldersContainer(dataFolder)), dataFolder.getNodeDelegate().getLookup(), Lookups.singleton((Object)PackageRootNode.alwaysSearchableSearchInfo(SearchInfoFactory.createSearchInfo((FileObject)dataFolder.getPrimaryFile(), (boolean)false, (FileObjectFilter[])new FileObjectFilter[]{SearchInfoFactory.VISIBILITY_FILTER})))}));
            this.root = root;
            this.dataFolder = dataFolder;
            this.isDefaultPackage = root.equals(dataFolder.getPrimaryFile());
        }

        FileObject getRoot() {
            return this.root;
        }

        public String getName() {
            String relativePath = FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.dataFolder.getPrimaryFile());
            return relativePath == null ? null : relativePath.replace('/', '.');
        }

        public Action[] getActions(boolean context) {
            if (!context) {
                if (actions == null) {
                    Action[] superActions = super.getActions(context);
                    ArrayList<Action> actionList = new ArrayList<Action>(superActions.length);
                    for (int i = 0; i < superActions.length; ++i) {
                        if (superActions[i] == null && superActions[i + 1] instanceof PropertiesAction) {
                            ++i;
                            continue;
                        }
                        if (superActions[i] instanceof PropertiesAction) continue;
                        if (superActions[i] instanceof FileSystemAction) {
                            actionList.add(null);
                            actionList.add(FileSensitiveActions.fileCommandAction((String)"compile.single", (String)NbBundle.getMessage((Class)(class$org$netbeans$spi$java$project$support$ui$PackageViewChildren == null ? PackageViewChildren.class$("org.netbeans.spi.java.project.support.ui.PackageViewChildren") : class$org$netbeans$spi$java$project$support$ui$PackageViewChildren), (String)"LBL_CompilePackage_Action"), null));
                        }
                        actionList.add(superActions[i]);
                    }
                    actions = new Action[actionList.size()];
                    actionList.toArray(actions);
                }
                return actions;
            }
            return super.getActions(context);
        }

        public boolean canRename() {
            return !this.isDefaultPackage;
        }

        public boolean canCut() {
            return !this.isDefaultPackage;
        }

        public Transferable clipboardCopy() throws IOException {
            try {
                return new PackageTransferable(this, 1);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }

        public Transferable clipboardCut() throws IOException {
            try {
                return new PackageTransferable(this, 2);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }

        public Transferable drag() throws IOException {
            try {
                return new PackageTransferable(this, 0);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }

        public PasteType[] getPasteTypes(Transferable t) {
            if (t.isDataFlavorSupported(ExTransferable.multiFlavor)) {
                try {
                    MultiTransferObject mto = (MultiTransferObject)t.getTransferData(ExTransferable.multiFlavor);
                    boolean hasPackageFlavor = false;
                    for (int i = 0; i < mto.getCount(); ++i) {
                        DataFlavor[] flavors = mto.getTransferDataFlavors(i);
                        if (!this.isPackageFlavor(flavors)) continue;
                        hasPackageFlavor = true;
                    }
                    return hasPackageFlavor ? new PasteType[]{} : super.getPasteTypes(t);
                }
                catch (UnsupportedFlavorException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    return new PasteType[0];
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    return new PasteType[0];
                }
            }
            DataFlavor[] flavors = t.getTransferDataFlavors();
            if (this.isPackageFlavor(flavors)) {
                return new PasteType[0];
            }
            return super.getPasteTypes(t);
        }

        public PasteType getDropType(Transferable t, int action, int index) {
            if (t.isDataFlavorSupported(ExTransferable.multiFlavor)) {
                try {
                    MultiTransferObject mto = (MultiTransferObject)t.getTransferData(ExTransferable.multiFlavor);
                    boolean hasPackageFlavor = false;
                    for (int i = 0; i < mto.getCount(); ++i) {
                        DataFlavor[] flavors = mto.getTransferDataFlavors(i);
                        if (!this.isPackageFlavor(flavors)) continue;
                        hasPackageFlavor = true;
                    }
                    return hasPackageFlavor ? null : super.getDropType(t, action, index);
                }
                catch (UnsupportedFlavorException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    return null;
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    return null;
                }
            }
            DataFlavor[] flavors = t.getTransferDataFlavors();
            if (this.isPackageFlavor(flavors)) {
                return null;
            }
            return super.getDropType(t, action, index);
        }

        private boolean isPackageFlavor(DataFlavor[] flavors) {
            for (int i = 0; i < flavors.length; ++i) {
                if (!PackageViewChildren.SUBTYPE.equals(flavors[i].getSubType()) || !PackageViewChildren.PRIMARY_TYPE.equals(flavors[i].getPrimaryType())) continue;
                return true;
            }
            return false;
        }

        private static synchronized PackageRenameHandler getRenameHandler() {
            Lookup.Result renameImplementations = Lookup.getDefault().lookup(new Lookup.Template(class$org$netbeans$spi$java$project$support$ui$PackageRenameHandler == null ? (class$org$netbeans$spi$java$project$support$ui$PackageRenameHandler = PackageViewChildren.class$("org.netbeans.spi.java.project.support.ui.PackageRenameHandler")) : class$org$netbeans$spi$java$project$support$ui$PackageRenameHandler));
            List handlers = (List)renameImplementations.allInstances();
            if (handlers.size() == 0) {
                return null;
            }
            if (handlers.size() > 1) {
                ErrorManager.getDefault().log(16, "Multiple instances of PackageRenameHandler found in Lookup; only using first one: " + handlers);
            }
            return (PackageRenameHandler)handlers.get(0);
        }

        public void setName(String name) {
            int index;
            int i;
            PackageRenameHandler handler = PackageNode.getRenameHandler();
            if (handler != null) {
                handler.handleRename((Node)this, name);
                return;
            }
            if (this.isDefaultPackage) {
                return;
            }
            String oldName = this.getName();
            if (oldName.equals(name)) {
                return;
            }
            if (!PackageNode.isValidPackageName(name)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$spi$java$project$support$ui$PackageViewChildren == null ? (class$org$netbeans$spi$java$project$support$ui$PackageViewChildren = PackageViewChildren.class$("org.netbeans.spi.java.project.support.ui.PackageViewChildren")) : class$org$netbeans$spi$java$project$support$ui$PackageViewChildren), (String)"MSG_InvalidPackageName"), 1));
                return;
            }
            name = name.replace('.', '/') + '/';
            oldName = oldName.replace('.', '/') + '/';
            for (i = 0; i < oldName.length() && i < name.length() && oldName.charAt(i) == name.charAt(i); ++i) {
            }
            String commonPrefix = (index = oldName.lastIndexOf(47, --i)) == -1 ? null : oldName.substring(0, index);
            String toCreate = index + 1 == name.length() ? "" : name.substring(index + 1);
            try {
                FileObject commonFolder;
                FileObject destination = commonFolder = commonPrefix == null ? this.root : this.root.getFileObject(commonPrefix);
                StringTokenizer dtk = new StringTokenizer(toCreate, "/");
                while (dtk.hasMoreTokens()) {
                    String pathElement = dtk.nextToken();
                    FileObject tmp = destination.getFileObject(pathElement);
                    if (tmp == null) {
                        tmp = destination.createFolder(pathElement);
                    }
                    destination = tmp;
                }
                FileObject source = this.dataFolder.getPrimaryFile();
                DataFolder sourceFolder = DataFolder.findFolder((FileObject)source);
                DataFolder destinationFolder = DataFolder.findFolder((FileObject)destination);
                DataObject[] children = sourceFolder.getChildren();
                for (int j = 0; j < children.length; ++j) {
                    if (!children[j].getPrimaryFile().isData()) continue;
                    children[j].move(destinationFolder);
                }
                while (!commonFolder.equals(source) && source.getChildren().length == 0) {
                    FileObject tmp = source;
                    source = source.getParent();
                    tmp.delete();
                }
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }

        public boolean canDestroy() {
            return !this.isDefaultPackage;
        }

        public void destroy() throws IOException {
            FileObject parent = this.dataFolder.getPrimaryFile().getParent();
            DataObject[] ch = this.dataFolder.getChildren();
            boolean empty = true;
            for (int i = 0; ch != null && i < ch.length; ++i) {
                if (!ch[i].getPrimaryFile().isFolder()) {
                    ch[i].delete();
                    continue;
                }
                empty = false;
            }
            if (empty) {
                super.destroy();
            }
            while (!parent.equals(this.root) && parent.getChildren().length == 0) {
                FileObject newParent = parent.getParent();
                parent.delete();
                parent = newParent;
            }
        }

        public String getHtmlDisplayName() {
            String name = this.getDisplayName();
            try {
                FileObject fo = this.dataFolder.getPrimaryFile();
                NonResursiveFolderSet set = new NonResursiveFolderSet(fo);
                FileSystem.Status status = fo.getFileSystem().getStatus();
                name = status instanceof FileSystem.HtmlStatus ? ((FileSystem.HtmlStatus)status).annotateNameHtml(name, (Set)set) : status.annotateName(name, (Set)set);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            return name;
        }

        public String getDisplayName() {
            FileObject folder = this.dataFolder.getPrimaryFile();
            String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)folder);
            if (path == null) {
                return "";
            }
            return PackageDisplayUtils.getDisplayLabel(path.replace('/', '.'));
        }

        public String getShortDescription() {
            FileObject folder = this.dataFolder.getPrimaryFile();
            String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)folder);
            if (path == null) {
                return "";
            }
            return PackageDisplayUtils.getToolTip(folder, path.replace('/', '.'));
        }

        public Image getIcon(int type) {
            Image img = this.getMyIcon(type);
            try {
                FileObject fo = this.dataFolder.getPrimaryFile();
                NonResursiveFolderSet set = new NonResursiveFolderSet(fo);
                img = fo.getFileSystem().getStatus().annotateIcon(img, type, (Set)set);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            return img;
        }

        public Image getOpenedIcon(int type) {
            Image img = this.getMyOpenedIcon(type);
            try {
                FileObject fo = this.dataFolder.getPrimaryFile();
                NonResursiveFolderSet set = new NonResursiveFolderSet(fo);
                img = fo.getFileSystem().getStatus().annotateIcon(img, type, (Set)set);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            return img;
        }

        private Image getMyIcon(int type) {
            FileObject folder = this.dataFolder.getPrimaryFile();
            String path = FileUtil.getRelativePath((FileObject)this.root, (FileObject)folder);
            if (path == null) {
                return null;
            }
            return PackageDisplayUtils.getIcon(folder, path.replace('/', '.'), this.isLeaf());
        }

        private Image getMyOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public void update() {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }

        public void updateDisplayName() {
            this.fireNameChange(null, null);
            this.fireDisplayNameChange(null, null);
            this.fireShortDescriptionChange(null, null);
        }

        public void updateChildren() {
            DataFolder df;
            boolean empty;
            boolean leaf = this.isLeaf();
            if (leaf != (empty = PackageNode.isEmpty(df = this.getDataFolder()))) {
                this.setChildren(empty ? FilterNode.Children.LEAF : df.createNodeChildren(NO_FOLDERS_FILTER));
                this.update();
            }
        }

        public Node.PropertySet[] getPropertySets() {
            Node.PropertySet[] properties = super.getPropertySets();
            for (int i = 0; i < properties.length; ++i) {
                if (!"properties".equals(properties[i].getName())) continue;
                properties[i] = Sheet.createPropertiesSet();
                ((Sheet.Set)properties[i]).put((Node.Property)new PropertySupport.ReadWrite("name", class$java$lang$String == null ? PackageViewChildren.class$("java.lang.String") : class$java$lang$String, NbBundle.getMessage((Class)(class$org$netbeans$spi$java$project$support$ui$PackageViewChildren == null ? PackageViewChildren.class$("org.netbeans.spi.java.project.support.ui.PackageViewChildren") : class$org$netbeans$spi$java$project$support$ui$PackageViewChildren), (String)"PROP_name"), NbBundle.getMessage((Class)(class$org$netbeans$spi$java$project$support$ui$PackageViewChildren == null ? PackageViewChildren.class$("org.netbeans.spi.java.project.support.ui.PackageViewChildren") : class$org$netbeans$spi$java$project$support$ui$PackageViewChildren), (String)"HINT_name")){

                    public Object getValue() {
                        return PackageNode.this.getName();
                    }

                    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                        if (!PackageNode.this.canRename()) {
                            throw new IllegalAccessException();
                        }
                        if (!(val instanceof String)) {
                            throw new IllegalArgumentException();
                        }
                        PackageNode.this.setName((String)val);
                    }

                    public boolean canWrite() {
                        return PackageNode.this.canRename();
                    }
                });
            }
            return properties;
        }

        private DataFolder getDataFolder() {
            return (DataFolder)this.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = PackageViewChildren.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
        }

        private static boolean isEmpty(DataFolder dataFolder) {
            if (dataFolder == null) {
                return true;
            }
            return PackageDisplayUtils.isEmpty(dataFolder.getPrimaryFile());
        }

        private static boolean isValidPackageName(String name) {
            if (name.length() == 0) {
                return true;
            }
            StringTokenizer tk = new StringTokenizer(name, ".", true);
            boolean delimExpected = false;
            while (tk.hasMoreTokens()) {
                String namePart = tk.nextToken();
                if (!delimExpected) {
                    if (namePart.equals(".")) {
                        return false;
                    }
                    for (int i = 0; i < namePart.length(); ++i) {
                        char c = namePart.charAt(i);
                        if (!(i == 0 ? !Character.isJavaIdentifierStart(c) : !Character.isJavaIdentifierPart(c))) continue;
                        return false;
                    }
                } else if (!namePart.equals(".")) {
                    return false;
                }
                delimExpected = !delimExpected;
            }
            return delimExpected;
        }
    }
}

