/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.java.project.PackageDisplayUtils;
import org.netbeans.modules.java.project.PackageViewSettings;
import org.netbeans.spi.java.project.support.ui.PackageRootNode;
import org.netbeans.spi.java.project.support.ui.PackageViewChildren;
import org.netbeans.spi.java.project.support.ui.TreeRootNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public class PackageView {
    static final /* synthetic */ boolean $assertionsDisabled;

    private PackageView() {
    }

    public static Node createPackageView(SourceGroup group) {
        return new RootNode(group);
    }

    public static Node findPath(Node rootNode, Object object) {
        PackageRootNode.PathFinder pf = (PackageRootNode.PathFinder)rootNode.getLookup().lookup(PackageRootNode.PathFinder.class);
        if (pf != null) {
            return pf.findPath(rootNode, object);
        }
        TreeRootNode.PathFinder pf2 = (TreeRootNode.PathFinder)rootNode.getLookup().lookup(TreeRootNode.PathFinder.class);
        if (pf2 != null) {
            return pf2.findPath(rootNode, object);
        }
        return null;
    }

    public static ComboBoxModel createListView(SourceGroup group) {
        TreeSet data = new TreeSet();
        PackageView.findNonExcludedPackages(data, group.getRootFolder(), group);
        return new DefaultComboBoxModel(new Vector(data));
    }

    static void findNonExcludedPackages(PackageViewChildren children, FileObject fo) {
        PackageView.findNonExcludedPackages(children, null, fo, null);
    }

    static void findNonExcludedPackages(Collection target, FileObject fo, SourceGroup group) {
        PackageView.findNonExcludedPackages(null, target, fo, group);
    }

    private static void findNonExcludedPackages(PackageViewChildren children, Collection target, FileObject fo, SourceGroup group) {
        if (!$assertionsDisabled && !fo.isFolder()) {
            throw new AssertionError((Object)"Package view only accepts folders");
        }
        if (!VisibilityQuery.getDefault().isVisible(fo)) {
            return;
        }
        FileObject[] kids = fo.getChildren();
        boolean hasSubfolders = false;
        boolean hasFiles = false;
        for (int i = 0; i < kids.length; ++i) {
            if (!VisibilityQuery.getDefault().isVisible(kids[i])) continue;
            if (kids[i].isFolder()) {
                PackageView.findNonExcludedPackages(children, target, kids[i], group);
                hasSubfolders = true;
                continue;
            }
            hasFiles = true;
        }
        if (hasFiles || !hasSubfolders) {
            if (group != null) {
                target.add(new PackageItem(group, fo, !hasFiles));
            } else {
                children.add(fo, !hasFiles);
            }
        }
    }

    public static ListCellRenderer listRenderer() {
        return new PackageListCellRenderer();
    }

    static {
        $assertionsDisabled = !PackageView.class.desiredAssertionStatus();
    }

    private static final class PackageListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof PackageItem) {
                PackageItem pkgitem = (PackageItem)value;
                super.getListCellRendererComponent((JList<?>)list, pkgitem.getLabel(), index, isSelected, cellHasFocus);
                this.setIcon(pkgitem.getIcon());
            } else {
                String pkgitem = (String)value;
                super.getListCellRendererComponent((JList<?>)list, pkgitem, index, isSelected, cellHasFocus);
            }
            return this;
        }
    }

    static final class PackageItem
    implements Comparable {
        private static IdentityHashMap image2icon;
        private final boolean empty;
        private final FileObject pkg;
        private final String pkgname;
        private Icon icon;
        static final /* synthetic */ boolean $assertionsDisabled;

        public PackageItem(SourceGroup group, FileObject pkg, boolean empty) {
            this.pkg = pkg;
            this.empty = empty;
            String path = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)pkg);
            if (!$assertionsDisabled && path == null) {
                throw new AssertionError((Object)("No " + pkg + " in " + group));
            }
            this.pkgname = path.replace('/', '.');
        }

        public String toString() {
            return this.pkgname;
        }

        public String getLabel() {
            return PackageDisplayUtils.getDisplayLabel(this.pkgname);
        }

        public Icon getIcon() {
            if (this.icon == null) {
                Image image = PackageDisplayUtils.getIcon(this.pkg, this.pkgname, this.empty);
                this.icon = (Icon)image2icon.get(image);
                if (this.icon == null) {
                    this.icon = new ImageIcon(image);
                    image2icon.put(image, this.icon);
                }
            }
            return this.icon;
        }

        public int compareTo(Object obj) {
            return this.pkgname.compareTo(((PackageItem)obj).pkgname);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$spi$java$project$support$ui$PackageView == null ? (class$org$netbeans$spi$java$project$support$ui$PackageView = PackageView.class$("org.netbeans.spi.java.project.support.ui.PackageView")) : class$org$netbeans$spi$java$project$support$ui$PackageView).desiredAssertionStatus();
            image2icon = new IdentityHashMap();
        }
    }

    private static final class RootNode
    extends FilterNode
    implements PropertyChangeListener {
        private SourceGroup sourceGroup;
        private PackageViewSettings settings;
        static final /* synthetic */ boolean $assertionsDisabled;

        private RootNode(SourceGroup group) {
            super(RootNode.getOriginalNode(group, PackageViewSettings.getDefault()));
            this.sourceGroup = group;
            this.settings = PackageViewSettings.getDefault();
            this.settings.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)((Object)this.settings)));
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("packageViewType".equals(event.getPropertyName())) {
                this.changeOriginal(RootNode.getOriginalNode(this.sourceGroup, this.settings), true);
            }
        }

        private static Node getOriginalNode(SourceGroup group, PackageViewSettings settings) {
            if (!$assertionsDisabled && settings == null) {
                throw new AssertionError((Object)"PackageViewSettings can't be null");
            }
            FileObject root = group.getRootFolder();
            if (root == null || !root.isValid()) {
                return new AbstractNode(FilterNode.Children.LEAF);
            }
            switch (settings.getPackageViewType()) {
                case 0: {
                    return new PackageRootNode(group);
                }
                case 1: {
                    return new TreeRootNode(group);
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Unknown PackageView Type");
            }
            return new PackageRootNode(group);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$spi$java$project$support$ui$PackageView == null ? (class$org$netbeans$spi$java$project$support$ui$PackageView = PackageView.class$("org.netbeans.spi.java.project.support.ui.PackageView")) : class$org$netbeans$spi$java$project$support$ui$PackageView).desiredAssertionStatus();
        }
    }
}

