/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.filesystems;

import java.io.IOException;
import java.io.InputStream;
import org.netbeans.core.filesystems.DefaultParser;
import org.netbeans.core.filesystems.MIMEComponent;
import org.netbeans.core.filesystems.Util;
import org.netbeans.core.filesystems.XMLEnvironmentProvider;
import org.netbeans.core.filesystems.XMLMIMEComponent;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.nodes.Children;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class MIMEResolverImpl
extends XMLEnvironmentProvider
implements Environment.Provider {
    private static final long serialVersionUID = 18975L;
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(MIMEResolverImpl.class.getName());
    private static final boolean DEBUG = ERR.isLoggable(1);
    private static final boolean CASE_INSENSITIVE = Utilities.isWindows() || Utilities.getOperatingSystem() == 16384;
    static /* synthetic */ Class class$org$netbeans$core$filesystems$MIMEResolverImpl$FileTypeNode;

    protected InstanceContent createInstanceContent(DataObject obj) {
        FileObject fo = obj.getPrimaryFile();
        InstanceContent ic = new InstanceContent();
        ic.add((Object)new Impl(fo));
        FileTypeNode n = new FileTypeNode(obj, Children.LEAF);
        ic.add((Object)n);
        return ic;
    }

    private static class Type {
        private String[] exts;
        private String[] mimes;
        private String[] fatts;
        private String[] vals;
        private byte[] magic;
        private byte[] mask;

        Type() {
        }

        public String toString() {
            int i = 0;
            StringBuffer buf = new StringBuffer();
            buf.append("fast-check(");
            if (this.exts != null) {
                buf.append("exts:");
                for (i = 0; i < this.exts.length; ++i) {
                    buf.append(this.exts[i] + ", ");
                }
            }
            if (this.mimes != null) {
                buf.append("mimes:");
                for (i = 0; i < this.mimes.length; ++i) {
                    buf.append(this.mimes[i] + ", ");
                }
            }
            if (this.fatts != null) {
                buf.append("file-attributes:");
                for (i = 0; i < this.fatts.length; ++i) {
                    buf.append(this.fatts[i] + "='" + this.vals[i] + "', ");
                }
            }
            if (this.magic != null) {
                buf.append("magic:" + XMLUtil.toHex((byte[])this.magic, (int)0, (int)this.magic.length));
            }
            if (this.mask != null) {
                buf.append("mask:" + XMLUtil.toHex((byte[])this.mask, (int)0, (int)this.mask.length));
            }
            buf.append(")");
            return buf.toString();
        }

        private void addExt(String ext) {
            this.exts = Util.addString(this.exts, ext);
        }

        private void addMIME(String mime) {
            this.mimes = Util.addString(this.mimes, mime.toLowerCase());
        }

        private void addAttr(String name, String value) {
            this.fatts = Util.addString(this.fatts, name);
            this.vals = Util.addString(this.vals, value);
        }

        private boolean setMagic(byte[] magic, byte[] mask) {
            if (magic == null) {
                return true;
            }
            if (mask != null && magic.length != mask.length) {
                return false;
            }
            this.magic = magic;
            if (mask != null) {
                this.mask = mask;
                for (int i = 0; i < mask.length; ++i) {
                    int n = i;
                    this.magic[n] = (byte)(this.magic[n] & mask[i]);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean accept(FileObject fo) throws IOException {
            int i;
            if (this.exts != null && fo.getExt() != null && Util.contains(this.exts, fo.getExt(), CASE_INSENSITIVE)) {
                return true;
            }
            if (this.mimes != null) {
                for (i = this.mimes.length - 1; i >= 0; --i) {
                    String s = FileUtil.getMIMEType((String)fo.getExt());
                    if (s == null) continue;
                    int l = s.indexOf(59);
                    if (l >= 0) {
                        s = s.substring(0, l - 1);
                    }
                    if ((s = s.toLowerCase()).equals(this.mimes[i])) {
                        return true;
                    }
                    if (this.mimes[i].length() <= 0 || this.mimes[i].charAt(0) != '+' || !s.endsWith(this.mimes[i])) continue;
                    return true;
                }
            }
            if (this.magic != null) {
                byte[] header = new byte[this.magic.length];
                InputStream in = null;
                boolean unexpectedEnd = false;
                try {
                    int read;
                    in = fo.getInputStream();
                    for (int i2 = 0; i2 < this.magic.length; i2 += read) {
                        try {
                            read = in.read(header, i2, this.magic.length - i2);
                            if (read >= 0) continue;
                            unexpectedEnd = true;
                            continue;
                        }
                        catch (IOException ex) {
                            unexpectedEnd = true;
                            break;
                        }
                    }
                }
                catch (IOException openex) {
                    unexpectedEnd = true;
                    if (fo.canRead()) {
                        throw openex;
                    }
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ioe) {}
                }
                if (!unexpectedEnd) {
                    boolean diff = false;
                    for (int i3 = 0; i3 < this.magic.length; ++i3) {
                        if (this.mask != null) {
                            int n = i3;
                            header[n] = (byte)(header[n] & this.mask[i3]);
                        }
                        if (this.magic[i3] == header[i3]) continue;
                        diff = true;
                        break;
                    }
                    if (!diff) {
                        return true;
                    }
                }
            }
            if (this.fatts != null) {
                for (i = this.fatts.length - 1; i >= 0; --i) {
                    Object attr = fo.getAttribute(this.fatts[i]);
                    if (attr == null) continue;
                    if (this.vals[i] == null) {
                        return true;
                    }
                    if (!this.vals[i].equals(attr.toString())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class FileElement {
        private Type fileCheck = new Type();
        private String mime = null;
        private MIMEComponent rule = null;

        FileElement() {
        }

        private void setMIME(String mime) {
            if ("null".equals(mime)) {
                return;
            }
            this.mime = mime;
        }

        private String resolve(FileObject file) {
            try {
                if (this.fileCheck.accept(file)) {
                    if (this.mime == null) {
                        return null;
                    }
                    if (this.rule == null) {
                        return this.mime;
                    }
                    if (this.rule.acceptFileObject(file)) {
                        return this.mime;
                    }
                }
            }
            catch (IOException io) {
                ErrorManager.getDefault().notify(1, (Throwable)io);
            }
            return null;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("FileElement(");
            buf.append(this.fileCheck + " ");
            buf.append(this.rule + " ");
            buf.append("Result:" + this.mime);
            return buf.toString();
        }
    }

    private static class DescParser
    extends DefaultParser {
        private FileElement[] template = null;
        private short file_state = 0;
        private MIMEComponent component = null;
        private String componentDelimiter = null;
        private static final short IN_ROOT = 1;
        private static final short IN_FILE = 2;
        private static final short IN_RESOLVER = 3;
        private static final short IN_COMPONENT = 4;
        private static final short IN_EXIT = 1;
        private static final String ROOT = "MIME-resolver";
        private static final String FILE = "file";
        private static final String MIME = "mime";
        private static final String EXT = "ext";
        private static final String RESOLVER = "resolver";
        private static final String FATTR = "fattr";
        private static final String NAME = "name";
        private static final String MAGIC = "magic";
        private static final String HEX = "hex";
        private static final String MASK = "mask";
        private static final String VALUE = "text";
        private static final String EXIT = "exit";
        private static final String XML_RULE_COMPONENT = "xml-rule";

        DescParser(FileObject fo) {
            super(fo);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            switch (this.state) {
                case 0: {
                    if (!ROOT.equals(qName)) {
                        this.error();
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    if (!FILE.equals(qName)) {
                        this.error();
                    }
                    if (this.template == null) {
                        this.template = new FileElement[]{new FileElement()};
                    } else {
                        FileElement[] n = new FileElement[this.template.length + 1];
                        System.arraycopy(this.template, 0, n, 1, this.template.length);
                        n[0] = new FileElement();
                        this.template = n;
                    }
                    this.state = (short)2;
                    break;
                }
                case 2: {
                    if (this.file_state == 1) {
                        this.error();
                    }
                    if (EXT.equals(qName)) {
                        String s = atts.getValue(NAME);
                        if (s == null) {
                            this.error();
                        }
                        this.template[0].fileCheck.addExt(s);
                        break;
                    }
                    if (MAGIC.equals(qName)) {
                        String s = atts.getValue(HEX);
                        if (s == null) {
                            this.error();
                        }
                        String mask = atts.getValue(MASK);
                        char[] chars = s.toCharArray();
                        byte[] mask_bytes = null;
                        try {
                            if (mask != null) {
                                char[] mask_chars = mask.toCharArray();
                                mask_bytes = XMLUtil.fromHex((char[])mask_chars, (int)0, (int)mask_chars.length);
                            }
                            byte[] magic = XMLUtil.fromHex((char[])chars, (int)0, (int)chars.length);
                            if (this.template[0].fileCheck.setMagic(magic, mask_bytes)) break;
                            this.error();
                        }
                        catch (IOException ioex) {
                            this.error();
                        }
                        break;
                    }
                    if (MIME.equals(qName)) {
                        String s = atts.getValue(NAME);
                        if (s == null) {
                            this.error();
                        }
                        this.template[0].fileCheck.addMIME(s);
                        break;
                    }
                    if (FATTR.equals(qName)) {
                        String s = atts.getValue(NAME);
                        if (s == null) {
                            this.error();
                        }
                        String val = atts.getValue(VALUE);
                        this.template[0].fileCheck.addAttr(s, val);
                        break;
                    }
                    if (RESOLVER.equals(qName)) {
                        String s;
                        if (this.template[0].fileCheck.exts == null && this.template[0].fileCheck.mimes == null && this.template[0].fileCheck.fatts == null && this.template[0].fileCheck.magic == null) {
                            this.error();
                        }
                        if ((s = atts.getValue(MIME)) == null) {
                            this.error();
                        }
                        this.template[0].setMIME(s);
                        this.state = (short)3;
                        break;
                    }
                    if (EXIT.equals(qName)) {
                        this.file_state = 1;
                        break;
                    }
                    String reason = "Unexpected element:  " + qName;
                    this.error(reason);
                    break;
                }
                case 3: {
                    if (!XML_RULE_COMPONENT.equals(qName)) break;
                    this.enterComponent(XML_RULE_COMPONENT, new XMLMIMEComponent());
                    this.component.startElement(namespaceURI, localName, qName, atts);
                    break;
                }
                case 4: {
                    this.component.startElement(namespaceURI, localName, qName, atts);
                    break;
                }
            }
        }

        private void enterComponent(String name, MIMEComponent component) {
            this.component = component;
            this.componentDelimiter = name;
            component.setDocumentLocator(this.getLocator());
            this.template[0].rule = component;
            this.state = (short)4;
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            switch (this.state) {
                case 2: {
                    if (!FILE.equals(qName)) break;
                    this.state = 1;
                    this.file_state = 0;
                    break;
                }
                case 3: {
                    if (!RESOLVER.equals(qName)) break;
                    this.state = (short)2;
                    break;
                }
                case 4: {
                    this.component.endElement(namespaceURI, localName, qName);
                    if (!this.componentDelimiter.equals(qName)) break;
                    this.state = (short)3;
                }
            }
        }

        public void characters(char[] data, int offset, int len) throws SAXException {
            if (this.state == 4) {
                this.component.characters(data, offset, len);
            }
        }
    }

    static class Impl
    extends MIMEResolver
    implements InstanceCookie {
        private final FileObject data;
        private FileElement[] smell = null;
        private short state = 0;

        Impl(FileObject obj) {
            if (DEBUG) {
                ERR.log("MIMEResolverImpl.Impl.<init>(" + obj + ")");
            }
            this.data = obj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String findMIMEType(FileObject fo) {
            Impl impl = this;
            synchronized (impl) {
                if (this.state == 0) {
                    this.state = this.parseDesc();
                }
                if (this.state == -1) {
                    return null;
                }
            }
            for (int i = this.smell.length - 1; i >= 0; --i) {
                String s = this.smell[i].resolve(fo);
                if (s == null) continue;
                if (DEBUG) {
                    ERR.log("MIMEResolverImpl.findMIMEType(" + fo + ")=" + s);
                }
                return s;
            }
            return null;
        }

        private short parseDesc() {
            this.smell = new FileElement[0];
            DescParser parser = new DescParser(this.data);
            parser.parse();
            this.smell = parser.template;
            if (DEBUG) {
                if (parser.state == -1) {
                    ERR.log("MIMEResolverImpl.Impl parsing error!");
                } else {
                    StringBuffer buf = new StringBuffer();
                    buf.append("Parse: ");
                    for (int i = 0; i < this.smell.length; ++i) {
                        buf.append("\n" + this.smell[i]);
                    }
                    ERR.log(buf.toString());
                }
            }
            return parser.state;
        }

        public Object instanceCreate() {
            return this;
        }

        public Class instanceClass() {
            return ((Object)((Object)this)).getClass();
        }

        public String instanceName() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public String toString() {
            return "MIMEResolverImpl.Impl[" + this.data + ", " + this.smell + "]";
        }
    }

    static class FileTypeNode
    extends DataNode {
        public FileTypeNode(DataObject obj, Children ch) {
            super(obj, ch);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$core$filesystems$MIMEResolverImpl$FileTypeNode == null ? (class$org$netbeans$core$filesystems$MIMEResolverImpl$FileTypeNode = MIMEResolverImpl.class$("org.netbeans.core.filesystems.MIMEResolverImpl$FileTypeNode")) : class$org$netbeans$core$filesystems$MIMEResolverImpl$FileTypeNode);
        }
    }
}

