/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import org.netbeans.core.FlashingIcon;
import org.netbeans.core.NbErrorManager;
import org.netbeans.core.startup.CLIOptions;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class NotifyException
extends JPanel
implements ActionListener {
    static final long serialVersionUID = 3680397500573480127L;
    private static NotifyException INSTANCE;
    private static final int MAXIMUM_TEXT_WIDTH = 40;
    private static final int SIZE_PREFERRED_WIDTH = 550;
    private static final int SIZE_PREFERRED_HEIGHT = 250;
    private static ArrayListPos exceptions;
    private NbErrorManager.Exc current;
    private DialogDescriptor descriptor;
    Dialog dialog;
    private JButton next;
    private JButton previous;
    private JButton details;
    private JTextPane output;
    private static boolean showDetails;
    private static Rectangle lastBounds;
    private static ExceptionFlasher flasher;
    static final /* synthetic */ boolean $assertionsDisabled;

    private NotifyException() {
        this.setPreferredSize(new Dimension(550, 250));
        ResourceBundle bundle = NbBundle.getBundle((Class)NotifyException.class);
        this.next = new JButton(bundle.getString("CTL_NextException"));
        this.next.setDefaultCapable(false);
        this.previous = new JButton(bundle.getString("CTL_PreviousException"));
        this.previous.setDefaultCapable(false);
        this.details = new JButton();
        this.details.setDefaultCapable(false);
        this.output = new JTextPane(){

            public boolean getScrollableTracksViewportWidth() {
                return false;
            }
        };
        this.output.setEditable(false);
        this.output.setFont(new Font("Monospaced", 0, this.output.getFont().getSize() + 1));
        this.output.setForeground(UIManager.getColor("Label.foreground"));
        this.output.setBackground(UIManager.getColor("Label.background"));
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.output));
        this.setBorder(new BevelBorder(1));
        this.next.setMnemonic(bundle.getString("CTL_NextException_Mnemonic").charAt(0));
        this.previous.setMnemonic(bundle.getString("CTL_PreviousException_Mnemonic").charAt(0));
        this.next.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_NextException"));
        this.previous.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_PreviousException"));
        this.output.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ExceptionStackTrace"));
        this.output.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ExceptionStackTrace"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_NotifyExceptionPanel"));
        this.descriptor = new DialogDescriptor((Object)"", "");
        this.descriptor.setMessageType(0);
        this.descriptor.setOptions(new Object[]{this.previous, this.next, DialogDescriptor.OK_OPTION});
        this.descriptor.setAdditionalOptions(new Object[]{this.details});
        this.descriptor.setClosingOptions(new Object[0]);
        this.descriptor.setButtonListener((ActionListener)this);
        this.descriptor.setModal(NotifyException.isModalDialogPresent() && WindowManager.getDefault().getMainWindow().isVisible());
        this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        if (null != lastBounds) {
            this.dialog.setBounds(lastBounds);
        }
    }

    private static boolean isModalDialogPresent() {
        return NotifyException.hasModalDialog(WindowManager.getDefault().getMainWindow()) || NotifyException.hasModalDialog(new JDialog().getOwner());
    }

    private static boolean hasModalDialog(Window w) {
        if (w == null) {
            return false;
        }
        Window[] ws = w.getOwnedWindows();
        for (int i = 0; i < ws.length; ++i) {
            if (ws[i] instanceof Dialog && ((Dialog)ws[i]).isModal() && ws[i].isVisible()) {
                return true;
            }
            if (!NotifyException.hasModalDialog(ws[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssertionsEnabled() {
        boolean assertsionAreOn = false;
        if (!$assertionsDisabled) {
            assertsionAreOn = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return assertsionAreOn;
    }

    static NotifyException newInstance() {
        return new NotifyException();
    }

    public static void notify(final NbErrorManager.Exc t) {
        if ("java.awt.HeadlessException".equals(t.getClassName()) && GraphicsEnvironment.isHeadless()) {
            t.printStackTrace(System.err);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String glm = t.getLocalizedMessage();
                int gs = t.getSeverity();
                boolean loc = t.isLocalized();
                if (gs == 16 && loc) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)glm, 2));
                } else if (gs == 256 && loc) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)glm, 1));
                } else if (gs == 65536 && loc) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)glm, 0));
                } else {
                    if (null == exceptions) {
                        exceptions = new ArrayListPos();
                    }
                    exceptions.add(t);
                    exceptions.position = exceptions.size() - 1;
                    if (NotifyException.isAssertionsEnabled()) {
                        if (INSTANCE == null) {
                            INSTANCE = new NotifyException();
                        }
                        INSTANCE.updateState(t);
                    } else if (null != flasher && null == INSTANCE) {
                        flasher.setToolTipText(NotifyException.getExceptionSummary(t));
                        flasher.startFlashing();
                    } else {
                        if (INSTANCE == null) {
                            INSTANCE = new NotifyException();
                        }
                        INSTANCE.updateState(t);
                    }
                }
            }
        });
    }

    private static String getExceptionSummary(NbErrorManager.Exc t) {
        String glm = t.getLocalizedMessage();
        String plainmsg = glm != null ? glm : (t.getMessage() != null ? t.getMessage() : t.getClassName());
        if (!$assertionsDisabled && plainmsg == null) {
            throw new AssertionError();
        }
        return plainmsg;
    }

    private void updateState(NbErrorManager.Exc t) {
        if (!exceptions.existsNextElement()) {
            this.current = t;
            this.update();
        } else {
            this.next.setVisible(true);
        }
        try {
            this.ensurePreferredSize();
            this.dialog.show();
        }
        catch (Exception e) {
            exceptions.add(new NbErrorManager().createExc(e, 4096));
            this.next.setVisible(true);
        }
    }

    private void ensurePreferredSize() {
        if (null != lastBounds) {
            return;
        }
        Dimension sz = this.dialog.getSize();
        Dimension pref = this.dialog.getPreferredSize();
        if (pref.height == 0) {
            pref.height = 250;
        }
        if (pref.width == 0) {
            pref.width = 550;
        }
        if (!sz.equals(pref)) {
            this.dialog.setSize(pref.width, pref.height);
            this.dialog.validate();
            this.dialog.repaint();
        }
    }

    private void update() {
        boolean isLocalized = this.current.isLocalized();
        this.next.setVisible(exceptions.existsNextElement());
        this.previous.setVisible(exceptions.existsPreviousElement());
        if (showDetails) {
            this.details.setText(NbBundle.getBundle((Class)NotifyException.class).getString("CTL_Exception_Hide_Details"));
            this.details.setMnemonic(NbBundle.getBundle((Class)NotifyException.class).getString("CTL_Exception_Hide_Details_Mnemonic").charAt(0));
            this.details.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)NotifyException.class).getString("ACSD_Exception_Hide_Details"));
        } else {
            this.details.setText(NbBundle.getBundle((Class)NotifyException.class).getString("CTL_Exception_Show_Details"));
            this.details.setMnemonic(NbBundle.getBundle((Class)NotifyException.class).getString("CTL_Exception_Show_Details_Mnemonic").charAt(0));
            this.details.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)NotifyException.class).getString("ACSD_Exception_Show_Details"));
        }
        String title = NbBundle.getBundle((Class)NotifyException.class).getString("CTL_Title_Exception");
        if (showDetails) {
            this.descriptor.setMessage((Object)this);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StringWriter wr = new StringWriter();
                    NotifyException.this.current.printStackTrace(new PrintWriter((Writer)wr, true));
                    NotifyException.this.output.setText(wr.toString());
                    NotifyException.this.output.getCaret().setDot(0);
                    NotifyException.this.output.requestFocus();
                }
            });
        } else if (isLocalized) {
            String msg = this.current.getLocalizedMessage();
            if (msg != null) {
                this.descriptor.setMessage((Object)msg);
            }
        } else {
            ResourceBundle curBundle = NbBundle.getBundle((Class)NotifyException.class);
            if (this.current.getSeverity() == 16) {
                this.descriptor.setMessage((Object)MessageFormat.format(curBundle.getString("NTF_ExceptionWarning"), this.current.getClassName()));
                title = curBundle.getString("NTF_ExceptionWarningTitle");
            } else {
                this.descriptor.setMessage((Object)MessageFormat.format(curBundle.getString("NTF_ExceptionalException"), this.current.getClassName(), CLIOptions.getLogDir()));
                title = curBundle.getString("NTF_ExceptionalExceptionTitle");
            }
        }
        this.descriptor.setTitle(title);
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.next && exceptions.setNextElement() || ev.getSource() == this.previous && exceptions.setPreviousElement()) {
            this.current = (NbErrorManager.Exc)exceptions.get();
            this.update();
            return;
        }
        if (ev.getSource() == this.details) {
            showDetails = !showDetails;
            lastBounds = null;
            try {
                this.update();
                this.ensurePreferredSize();
            }
            catch (Exception e) {
                exceptions.add(new NbErrorManager().createExc(e, 4096));
                this.next.setVisible(true);
            }
            return;
        }
        if (ev.getSource() == DialogDescriptor.OK_OPTION || ev.getSource() == DialogDescriptor.CLOSED_OPTION) {
            try {
                exceptions.removeAll();
                lastBounds = this.dialog.getBounds();
                this.dialog.dispose();
                exceptions = null;
                INSTANCE = null;
            }
            catch (RuntimeException e) {
                throw e;
            }
            finally {
                exceptions = null;
                INSTANCE = null;
            }
        }
    }

    public static Component getNotificationVisualizer() {
        if (NotifyException.isAssertionsEnabled()) {
            return null;
        }
        if (null == flasher) {
            ImageIcon img1 = new ImageIcon(Utilities.loadImage((String)"org/netbeans/core/resources/exception.gif", (boolean)true));
            flasher = new ExceptionFlasher(img1);
        }
        return flasher;
    }

    static {
        $assertionsDisabled = !NotifyException.class.desiredAssertionStatus();
        INSTANCE = null;
        flasher = null;
    }

    protected static class ArrayListPos
    extends ArrayList {
        protected int position = 0;

        protected ArrayListPos() {
        }

        protected boolean existsElement() {
            return this.size() > 0;
        }

        protected boolean existsNextElement() {
            return this.position + 1 < this.size();
        }

        protected boolean existsPreviousElement() {
            return this.position > 0 && this.size() > 0;
        }

        protected boolean setNextElement() {
            if (!this.existsNextElement()) {
                return false;
            }
            ++this.position;
            return true;
        }

        protected boolean setPreviousElement() {
            if (!this.existsPreviousElement()) {
                return false;
            }
            --this.position;
            return true;
        }

        protected Object get() {
            return this.existsElement() ? this.get(this.position) : null;
        }

        protected void removeAll() {
            this.clear();
            this.position = 0;
        }
    }

    private static class ExceptionFlasher
    extends FlashingIcon {
        public ExceptionFlasher(Icon img1) {
            super(img1);
        }

        protected void onMouseClick() {
            if (null != exceptions && exceptions.size() > 0) {
                if (INSTANCE == null) {
                    INSTANCE = new NotifyException();
                }
                INSTANCE.updateState((NbErrorManager.Exc)exceptions.get(exceptions.size() - 1));
            }
        }

        protected void timeout() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (null != INSTANCE) {
                        return;
                    }
                    if (null != exceptions) {
                        exceptions.clear();
                    }
                    exceptions = null;
                }
            });
        }
    }
}

